/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.workload.mt.generators;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CyclicBarrier;
import org.apache.phoenix.pherf.configuration.DataModel;
import org.apache.phoenix.pherf.configuration.ExecutionType;
import org.apache.phoenix.pherf.configuration.LoadProfile;
import org.apache.phoenix.pherf.configuration.Scenario;
import org.apache.phoenix.pherf.configuration.TenantGroup;
import org.apache.phoenix.pherf.util.PhoenixUtil;
import org.apache.phoenix.pherf.workload.mt.generators.BaseLoadEventGenerator;
import org.apache.phoenix.pherf.workload.mt.generators.TenantOperationInfo;
import org.apache.phoenix.pherf.workload.mt.handlers.PherfWorkHandler;
import org.apache.phoenix.pherf.workload.mt.handlers.RendezvousingWorkHandler;
import org.apache.phoenix.pherf.workload.mt.operations.Operation;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.thirdparty.com.google.common.base.Strings;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;

public class SequentialLoadEventGenerator
extends BaseLoadEventGenerator {
    protected static final int DEFAULT_NUM_ITERATIONS = 1;
    protected static final ExecutionType DEFAULT_EXECUTION_TYPE = ExecutionType.SERIAL;
    private final SequentialSampler sampler;
    private int numHandlers;
    private int numIterations = 1;
    private ExecutionType executionType = DEFAULT_EXECUTION_TYPE;

    public SequentialLoadEventGenerator(PhoenixUtil phoenixUtil, DataModel model, Scenario scenario, Properties properties) {
        super(phoenixUtil, model, scenario, properties);
        this.sampler = new SequentialSampler(this.operationFactory.getOperations(), model, scenario, properties);
        this.sampler.setNumHandlers(this.numHandlers);
    }

    public SequentialLoadEventGenerator(PhoenixUtil phoenixUtil, DataModel model, Scenario scenario, List<PherfWorkHandler> workHandlers, Properties properties) {
        super(phoenixUtil, model, scenario, workHandlers, properties);
        this.sampler = new SequentialSampler(this.operationFactory.getOperations(), model, scenario, properties);
        this.sampler.setNumHandlers(this.numHandlers);
    }

    @Override
    public List<PherfWorkHandler> getWorkHandlers(Properties properties) {
        String handlerName = "";
        try {
            handlerName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        this.numHandlers = 4;
        if (properties.containsKey("pherf.mt.handlers_per_scenario")) {
            this.numHandlers = Integer.parseInt((String)properties.get("pherf.mt.handlers_per_scenario"));
        }
        if (properties.containsKey("pherf.mt.sequential.iterations")) {
            this.numIterations = Integer.parseInt((String)properties.get("pherf.mt.sequential.iterations"));
        }
        if (properties.containsKey("pherf.mt.sequential.type")) {
            this.executionType = ExecutionType.valueOf((String)properties.get("pherf.mt.sequential.type"));
            switch (this.executionType) {
                case SERIAL: {
                    this.numHandlers = 1;
                    break;
                }
                case PARALLEL: {
                    this.numHandlers = this.numIterations;
                    break;
                }
            }
        }
        HashMap<String, CyclicBarrier> rendezvousPoints = Maps.newHashMap();
        CyclicBarrier startBarrier = new CyclicBarrier(this.numHandlers, new Runnable(){

            @Override
            public void run() {
                BaseLoadEventGenerator.LOGGER.info("Rendezvoused for start of operation execution");
            }
        });
        rendezvousPoints.put("pherf.mt.handlers_start_rendezvous", startBarrier);
        ArrayList<PherfWorkHandler> workers = Lists.newArrayListWithCapacity(this.numHandlers);
        for (int i = 0; i < this.numHandlers; ++i) {
            String handlerId = String.format("%s.%d", handlerName, i + 1);
            workers.add(new RendezvousingWorkHandler(this.operationFactory, handlerId, rendezvousPoints));
        }
        return workers;
    }

    @Override
    public TenantOperationInfo next() {
        return this.sampler.nextSample();
    }

    private static class SequentialSampler {
        private final LoadProfile loadProfile;
        private final String modelName;
        private final String scenarioName;
        private final String tableName;
        private long iteration;
        private int opIndex;
        private int numHandlers;
        private final TenantGroup tenantGroup;
        private final List<Operation> operationList;

        public SequentialSampler(List<Operation> operationList, DataModel model, Scenario scenario, Properties properties) {
            this.modelName = model.getName();
            this.scenarioName = scenario.getName();
            this.tableName = scenario.getTableName();
            this.loadProfile = scenario.getLoadProfile();
            this.operationList = operationList;
            Preconditions.checkArgument(this.loadProfile.getTenantDistribution() != null, "Tenant distribution cannot be null");
            Preconditions.checkArgument(!this.loadProfile.getTenantDistribution().isEmpty(), "Tenant group cannot be empty");
            Preconditions.checkArgument(this.loadProfile.getTenantDistribution().size() == 1, "Tenant group cannot be more than 1");
            this.tenantGroup = this.loadProfile.getTenantDistribution().get(0);
        }

        public TenantOperationInfo nextSample() {
            Operation op = this.operationList.get(this.opIndex % this.operationList.size());
            String tenantGroupId = this.tenantGroup.getId();
            String tenantIdPrefix = Strings.padStart(tenantGroupId, this.loadProfile.getGroupIdLength(), 'x');
            String formattedTenantId = String.format(this.loadProfile.getTenantIdFormat(), tenantIdPrefix.substring(0, this.loadProfile.getGroupIdLength()), 1);
            String paddedTenantId = Strings.padStart(formattedTenantId, this.loadProfile.getTenantIdLength(), 'x');
            String tenantId = paddedTenantId.substring(0, this.loadProfile.getTenantIdLength());
            TenantOperationInfo sample = new TenantOperationInfo(this.modelName, this.scenarioName, this.tableName, tenantGroupId, op.getId(), tenantId, op);
            ++this.iteration;
            if (this.iteration % (long)this.numHandlers == 0L) {
                ++this.opIndex;
            }
            return sample;
        }

        public int getNumHandlers() {
            return this.numHandlers;
        }

        public void setNumHandlers(int handlers) {
            this.numHandlers = handlers;
        }
    }
}

