/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.utilint.Timestamp;

public abstract class TxnEnd
implements Loggable {
    long id;
    Timestamp time;
    long lastLsn;
    int repMasterNodeId;
    long dtvlsn;

    TxnEnd(long id, long lastLsn, int repMasterNodeId, long dtvlsn) {
        this.id = id;
        this.time = new Timestamp(System.currentTimeMillis());
        this.lastLsn = lastLsn;
        this.repMasterNodeId = repMasterNodeId;
        this.dtvlsn = dtvlsn;
    }

    public TxnEnd() {
        this.lastLsn = -1L;
    }

    public long getId() {
        return this.id;
    }

    public Timestamp getTime() {
        return this.time;
    }

    long getLastLsn() {
        return this.lastLsn;
    }

    public int getMasterNodeId() {
        return this.repMasterNodeId;
    }

    @Override
    public long getTransactionId() {
        return this.id;
    }

    public long getDTVLSN() {
        return this.dtvlsn;
    }

    public void setDTVLSN(long dtvlsn) {
        this.dtvlsn = dtvlsn;
    }

    public boolean hasLoggedEntries() {
        return this.lastLsn != -1L;
    }

    protected abstract String getTagName();
}

