/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.message;

import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.server.message.AMQMessageHeader;
import org.apache.qpid.server.message.MessageInfo;
import org.apache.qpid.server.message.MessageInstance;
import org.apache.qpid.server.message.MessageInstanceConsumer;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.model.Consumer;

public class MessageInfoImpl
implements MessageInfo {
    private final String _deliveredTo;
    private final Date _arrivalTime;
    private final boolean _persistent;
    private final String _messageId;
    private final Date _expirationTime;
    private final String _applicationId;
    private final String _correlationId;
    private final String _encoding;
    private final String _mimeType;
    private final byte _priority;
    private final String _replyTo;
    private final Date _timestamp;
    private final String _type;
    private final String _userId;
    private final String _state;
    private final int _deliveryCount;
    private final long _size;
    private final long _headerSize;
    private final long _id;
    private final Map<String, Object> _headers;
    private final String _initialRoutingAddress;
    private final String _to;
    private final Date _notValidBefore;
    private final String _messageType;
    private final String _groupId;
    private final String _deliveredToConsumerId;

    public MessageInfoImpl(MessageInstance instance, boolean includeHeaders) {
        ServerMessage message = instance.getMessage();
        AMQMessageHeader messageHeader = message.getMessageHeader();
        MessageInstanceConsumer<?> acquiringConsumer = instance.getAcquiringConsumer();
        this._deliveredTo = acquiringConsumer == null ? null : String.valueOf(acquiringConsumer.getIdentifier());
        this._deliveredToConsumerId = acquiringConsumer instanceof Consumer ? String.valueOf(((Consumer)acquiringConsumer).getId()) : null;
        this._arrivalTime = message.getArrivalTime() == 0L ? null : new Date(message.getArrivalTime());
        this._messageType = message.getMessageType();
        this._persistent = message.isPersistent();
        this._messageId = messageHeader.getMessageId();
        this._expirationTime = messageHeader.getExpiration() == 0L ? null : new Date(messageHeader.getExpiration());
        this._applicationId = messageHeader.getAppId();
        this._correlationId = messageHeader.getCorrelationId();
        this._encoding = messageHeader.getEncoding();
        this._mimeType = messageHeader.getMimeType();
        this._priority = messageHeader.getPriority();
        this._replyTo = messageHeader.getReplyTo();
        this._timestamp = messageHeader.getTimestamp() == 0L ? null : new Date(messageHeader.getTimestamp());
        this._type = messageHeader.getType();
        this._userId = messageHeader.getUserId();
        this._groupId = messageHeader.getGroupId();
        this._state = instance.isAvailable() ? (instance.isHeld() ? "Held" : "Available") : (instance.isAcquired() ? "Acquired" : "");
        this._deliveryCount = instance.getDeliveryCount();
        this._size = message.getSize();
        this._headerSize = message.getSizeIncludingHeader() - message.getSize();
        this._id = message.getMessageNumber();
        this._initialRoutingAddress = message.getInitialRoutingAddress();
        this._to = message.getTo();
        Date date = this._notValidBefore = messageHeader.getNotValidBefore() == 0L ? null : new Date(messageHeader.getNotValidBefore());
        if (includeHeaders) {
            LinkedHashMap<String, Object> headers = new LinkedHashMap<String, Object>();
            for (String headerName : messageHeader.getHeaderNames()) {
                headers.put(headerName, messageHeader.getHeader(headerName));
            }
            this._headers = Collections.unmodifiableMap(headers);
        } else {
            this._headers = null;
        }
    }

    @Override
    public long getId() {
        return this._id;
    }

    @Override
    public long getSize() {
        return this._size;
    }

    @Override
    public long getHeaderSize() {
        return this._headerSize;
    }

    @Override
    public String getMessageType() {
        return this._messageType;
    }

    @Override
    public int getDeliveryCount() {
        return this._deliveryCount;
    }

    @Override
    public String getState() {
        return this._state;
    }

    @Override
    public String getDeliveredTo() {
        return this._deliveredTo;
    }

    @Override
    public String getDeliveredToConsumerId() {
        return this._deliveredToConsumerId;
    }

    @Override
    public Date getArrivalTime() {
        return this._arrivalTime == null ? null : new Date(this._arrivalTime.getTime());
    }

    @Override
    public boolean isPersistent() {
        return this._persistent;
    }

    @Override
    public String getMessageId() {
        return this._messageId;
    }

    @Override
    public Date getExpirationTime() {
        return this._expirationTime == null ? null : new Date(this._expirationTime.getTime());
    }

    @Override
    public String getApplicationId() {
        return this._applicationId;
    }

    @Override
    public String getCorrelationId() {
        return this._correlationId;
    }

    @Override
    public String getEncoding() {
        return this._encoding;
    }

    @Override
    public String getMimeType() {
        return this._mimeType;
    }

    @Override
    public int getPriority() {
        return this._priority;
    }

    @Override
    public String getReplyTo() {
        return this._replyTo;
    }

    @Override
    public Date getTimestamp() {
        return this._timestamp == null ? null : new Date(this._timestamp.getTime());
    }

    @Override
    public String getType() {
        return this._type;
    }

    @Override
    public String getUserId() {
        return this._userId;
    }

    @Override
    public String getGroupId() {
        return this._groupId;
    }

    @Override
    public Map<String, Object> getHeaders() {
        return this._headers;
    }

    @Override
    public Date getNotValidBefore() {
        return this._notValidBefore == null ? null : new Date(this._notValidBefore.getTime());
    }

    @Override
    public String getInitialRoutingAddress() {
        return this._initialRoutingAddress;
    }

    @Override
    public String getTo() {
        return this._to;
    }
}

