/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.contextenricher;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.ranger.plugin.contextenricher.RangerAbstractContextEnricher;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerSampleCountryProvider
extends RangerAbstractContextEnricher {
    private static final Logger LOG = LoggerFactory.getLogger(RangerSampleCountryProvider.class);
    private String contextName = "COUNTRY";
    private Properties userCountryMap = null;

    public void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerSampleCountryProvider.init(" + this.enricherDef + ")");
        }
        super.init();
        this.contextName = this.getOption("contextName", "COUNTRY");
        String dataFile = this.getOption("dataFile", "/etc/ranger/data/userCountry.txt");
        this.userCountryMap = this.readProperties(dataFile);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerSampleCountryProvider.init(" + this.enricherDef + ")");
        }
    }

    public void enrich(RangerAccessRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerSampleCountryProvider.enrich(" + request + ")");
        }
        if (request != null && this.userCountryMap != null) {
            Map context = request.getContext();
            String country = this.userCountryMap.getProperty(request.getUser());
            if (context != null && !StringUtils.isEmpty((CharSequence)country)) {
                request.getContext().put(this.contextName, country);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("RangerSampleCountryProvider.enrich(): skipping due to unavailable context or country. context=" + context + "; country=" + country);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerSampleCountryProvider.enrich(" + request + ")");
        }
    }
}

