/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authz.embedded;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.apache.ranger.plugin.audit.RangerDefaultAuditHandler;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.service.RangerBasePlugin;

public class RangerAuthzAuditHandler
extends RangerDefaultAuditHandler
implements AutoCloseable {
    private final RangerBasePlugin plugin;
    private final Collection<AuthzAuditEvent> auditEvents = new ArrayList<AuthzAuditEvent>();
    private boolean deniedExists;

    public RangerAuthzAuditHandler(RangerBasePlugin plugin) {
        this.plugin = plugin;
    }

    public void processResult(RangerAccessResult result) {
        AuthzAuditEvent auditEvent;
        if (!this.deniedExists && (auditEvent = this.getAuthzEvents(result)) != null) {
            auditEvent.setAgentId(this.plugin.getAppId());
            if (result.getIsAccessDetermined() && !result.getIsAllowed()) {
                this.deniedExists = true;
                this.auditEvents.clear();
            }
            this.auditEvents.add(auditEvent);
        }
    }

    public void processResults(Collection<RangerAccessResult> results) {
        results.forEach(this::processResult);
    }

    @Override
    public void close() {
        this.auditEvents.forEach(x$0 -> super.logAuthzAudit(x$0));
    }
}

