/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authz.embedded;

import org.apache.ranger.authz.api.RangerAuthzErrorCode;

public enum RangerEmbeddedAuthzErrorCode implements RangerAuthzErrorCode
{
    NO_SERVICE_TYPE_FOR_SERVICE(400, "00-001", "No service type found for service {0}"),
    NO_DEFAULT_SERVICE_FOR_SERVICE_TYPE(400, "00-002", "No default service found for service type {0}"),
    FAILED_TO_CONTACT_AUTHZ_SERVICE(404, "00-001", "Failed to contact authorization service"),
    FAILED_TO_GET_SERVICE_POLICIES(404, "00-002", "Failed to retrieve policies for service {0}");

    private static final String ERROR_CODE_MODULE_PREFIX = "E_AUTHZ-";
    private final int httpStatusCode;
    private final String code;
    private final String message;

    private RangerEmbeddedAuthzErrorCode(int httpStatusCode, String code, String message) {
        this.httpStatusCode = httpStatusCode;
        this.code = String.format("%s-%3d-%s", ERROR_CODE_MODULE_PREFIX, httpStatusCode, code);
        this.message = message;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return "RangerEmbeddedAuthzErrorCode{httpStatusCode=" + this.httpStatusCode + ", code='" + this.code + '\'' + ", message='" + this.message + '\'' + '}';
    }
}

