/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.StringUtils;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RangerPrincipal
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String PREFIX_USER = "u:";
    public static final String PREFIX_GROUP = "g:";
    public static final String PREFIX_ROLE = "r:";
    private PrincipalType type;
    private String name;

    public RangerPrincipal() {
        this(null, null);
    }

    public RangerPrincipal(PrincipalType type, String name) {
        this.setType(type);
        this.setName(name);
    }

    public PrincipalType getType() {
        return this.type;
    }

    public void setType(PrincipalType type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.name});
    }

    public boolean equals(Object obj) {
        boolean ret;
        if (this == obj) {
            ret = true;
        } else if (obj == null) {
            ret = false;
        } else if (this.getClass() != obj.getClass()) {
            ret = false;
        } else {
            RangerPrincipal other = (RangerPrincipal)obj;
            ret = Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.name, other.name);
        }
        return ret;
    }

    public String toString() {
        return "{type=" + (Object)((Object)this.type) + ", name=" + this.name + "}";
    }

    public static RangerPrincipal toPrincipal(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        if (name.startsWith(PREFIX_USER)) {
            return new RangerPrincipal(PrincipalType.USER, name.substring(PREFIX_USER.length()));
        }
        if (name.startsWith(PREFIX_GROUP)) {
            return new RangerPrincipal(PrincipalType.GROUP, name.substring(PREFIX_GROUP.length()));
        }
        if (name.startsWith(PREFIX_ROLE)) {
            return new RangerPrincipal(PrincipalType.ROLE, name.substring(PREFIX_ROLE.length()));
        }
        return new RangerPrincipal(PrincipalType.USER, name);
    }

    public static enum PrincipalType {
        USER,
        GROUP,
        ROLE;

    }
}

