/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import com.google.protobuf.MessageLite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.CopyObject;
import org.apache.hadoop.hdds.utils.db.DelegatedCodec;
import org.apache.hadoop.hdds.utils.db.Proto2Codec;
import org.apache.hadoop.ozone.om.helpers.WithObjectID;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public final class OmMultipartKeyInfo
extends WithObjectID
implements CopyObject<OmMultipartKeyInfo> {
    private static final Codec<OmMultipartKeyInfo> CODEC = new DelegatedCodec(Proto2Codec.get((MessageLite)OzoneManagerProtocolProtos.MultipartKeyInfo.getDefaultInstance()), OmMultipartKeyInfo::getFromProto, OmMultipartKeyInfo::getProto, OmMultipartKeyInfo.class);
    private final String uploadID;
    private final long creationTime;
    private final ReplicationConfig replicationConfig;
    private PartKeyInfoMap partKeyInfoMap;
    private final long parentID;

    public static Codec<OmMultipartKeyInfo> getCodec() {
        return CODEC;
    }

    private OmMultipartKeyInfo(Builder b) {
        super(b);
        this.uploadID = b.uploadID;
        this.creationTime = b.creationTime;
        this.replicationConfig = b.replicationConfig;
        this.partKeyInfoMap = new PartKeyInfoMap(b.partKeyInfoList);
        this.parentID = b.parentID;
    }

    private OmMultipartKeyInfo(OmMultipartKeyInfo b) {
        super(b);
        this.uploadID = b.uploadID;
        this.creationTime = b.creationTime;
        this.replicationConfig = b.replicationConfig;
        this.partKeyInfoMap = b.partKeyInfoMap;
        this.parentID = b.parentID;
    }

    public long getParentID() {
        return this.parentID;
    }

    public String getUploadID() {
        return this.uploadID;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public PartKeyInfoMap getPartKeyInfoMap() {
        return this.partKeyInfoMap;
    }

    public void addPartKeyInfo(OzoneManagerProtocolProtos.PartKeyInfo partKeyInfo) {
        this.partKeyInfoMap = PartKeyInfoMap.put(partKeyInfo, this.partKeyInfoMap);
    }

    public OzoneManagerProtocolProtos.PartKeyInfo getPartKeyInfo(int partNumber) {
        return this.partKeyInfoMap.get(partNumber);
    }

    public ReplicationConfig getReplicationConfig() {
        return this.replicationConfig;
    }

    public static OmMultipartKeyInfo getFromProto(OzoneManagerProtocolProtos.MultipartKeyInfo multipartKeyInfo) {
        TreeMap<Integer, OzoneManagerProtocolProtos.PartKeyInfo> list = new TreeMap<Integer, OzoneManagerProtocolProtos.PartKeyInfo>();
        multipartKeyInfo.getPartKeyInfoListList().forEach(partKeyInfo -> list.put(partKeyInfo.getPartNumber(), (OzoneManagerProtocolProtos.PartKeyInfo)partKeyInfo));
        ReplicationConfig replicationConfig = ReplicationConfig.fromProto((HddsProtos.ReplicationType)multipartKeyInfo.getType(), (HddsProtos.ReplicationFactor)multipartKeyInfo.getFactor(), (HddsProtos.ECReplicationConfig)multipartKeyInfo.getEcReplicationConfig());
        return new Builder().setUploadID(multipartKeyInfo.getUploadID()).setCreationTime(multipartKeyInfo.getCreationTime()).setReplicationConfig(replicationConfig).setPartKeyInfoList(list).setObjectID(multipartKeyInfo.getObjectID()).setUpdateID(multipartKeyInfo.getUpdateID()).setParentID(multipartKeyInfo.getParentID()).build();
    }

    public OzoneManagerProtocolProtos.MultipartKeyInfo getProto() {
        OzoneManagerProtocolProtos.MultipartKeyInfo.Builder builder = OzoneManagerProtocolProtos.MultipartKeyInfo.newBuilder().setUploadID(this.uploadID).setCreationTime(this.creationTime).setType(this.replicationConfig.getReplicationType()).setObjectID(this.getObjectID()).setUpdateID(this.getUpdateID()).setParentID(this.parentID);
        if (this.replicationConfig instanceof ECReplicationConfig) {
            ECReplicationConfig ecConf = (ECReplicationConfig)this.replicationConfig;
            builder.setEcReplicationConfig(ecConf.toProto());
        } else {
            builder.setFactor(ReplicationConfig.getLegacyFactor((ReplicationConfig)this.replicationConfig));
        }
        builder.addAllPartKeyInfoList((Iterable)this.partKeyInfoMap);
        return builder.build();
    }

    @Override
    public String getObjectInfo() {
        return this.getProto().toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof OmMultipartKeyInfo && this.uploadID.equals(((OmMultipartKeyInfo)other).getUploadID());
    }

    public int hashCode() {
        return this.uploadID.hashCode();
    }

    public OmMultipartKeyInfo copyObject() {
        return new OmMultipartKeyInfo(this);
    }

    public static class Builder
    extends WithObjectID.Builder {
        private String uploadID;
        private long creationTime;
        private ReplicationConfig replicationConfig;
        private final TreeMap<Integer, OzoneManagerProtocolProtos.PartKeyInfo> partKeyInfoList = new TreeMap();
        private long parentID;

        public Builder setUploadID(String uploadId) {
            this.uploadID = uploadId;
            return this;
        }

        public Builder setCreationTime(long crTime) {
            this.creationTime = crTime;
            return this;
        }

        public Builder setReplicationConfig(ReplicationConfig replConfig) {
            this.replicationConfig = replConfig;
            return this;
        }

        public Builder setPartKeyInfoList(Map<Integer, OzoneManagerProtocolProtos.PartKeyInfo> partKeyInfos) {
            if (partKeyInfos != null) {
                this.partKeyInfoList.putAll(partKeyInfos);
            }
            return this;
        }

        public Builder addPartKeyInfoList(int partNum, OzoneManagerProtocolProtos.PartKeyInfo partKeyInfo) {
            if (partKeyInfo != null) {
                this.partKeyInfoList.put(partNum, partKeyInfo);
            }
            return this;
        }

        @Override
        public Builder setObjectID(long obId) {
            super.setObjectID(obId);
            return this;
        }

        @Override
        public Builder setUpdateID(long id) {
            super.setUpdateID(id);
            return this;
        }

        public Builder setParentID(long parentObjId) {
            this.parentID = parentObjId;
            return this;
        }

        public OmMultipartKeyInfo build() {
            return new OmMultipartKeyInfo(this);
        }
    }

    public static class PartKeyInfoMap
    implements Iterable<OzoneManagerProtocolProtos.PartKeyInfo> {
        static final Comparator<Object> PART_NUMBER_COMPARATOR = (o1, o2) -> {
            int partNumber1 = o1 instanceof OzoneManagerProtocolProtos.PartKeyInfo ? ((OzoneManagerProtocolProtos.PartKeyInfo)o1).getPartNumber() : ((Integer)o1).intValue();
            int partNumber2 = o2 instanceof OzoneManagerProtocolProtos.PartKeyInfo ? ((OzoneManagerProtocolProtos.PartKeyInfo)o2).getPartNumber() : ((Integer)o2).intValue();
            return Integer.compare(partNumber1, partNumber2);
        };
        private final List<OzoneManagerProtocolProtos.PartKeyInfo> sorted;

        static void put(OzoneManagerProtocolProtos.PartKeyInfo partKeyInfo, List<OzoneManagerProtocolProtos.PartKeyInfo> sortedList) {
            if (partKeyInfo == null) {
                return;
            }
            int i = Collections.binarySearch(sortedList, partKeyInfo, Comparator.comparingInt(OzoneManagerProtocolProtos.PartKeyInfo::getPartNumber));
            if (i >= 0) {
                sortedList.set(i, partKeyInfo);
            } else {
                sortedList.add(-(i + 1), partKeyInfo);
            }
        }

        static PartKeyInfoMap put(OzoneManagerProtocolProtos.PartKeyInfo partKeyInfo, PartKeyInfoMap sortedMap) {
            if (partKeyInfo == null) {
                return sortedMap;
            }
            ArrayList<OzoneManagerProtocolProtos.PartKeyInfo> list = new ArrayList<OzoneManagerProtocolProtos.PartKeyInfo>(sortedMap.sorted);
            PartKeyInfoMap.put(partKeyInfo, list);
            return new PartKeyInfoMap(list);
        }

        PartKeyInfoMap(List<OzoneManagerProtocolProtos.PartKeyInfo> sorted) {
            this.sorted = Collections.unmodifiableList(sorted);
        }

        PartKeyInfoMap(SortedMap<Integer, OzoneManagerProtocolProtos.PartKeyInfo> sorted) {
            this(new ArrayList<OzoneManagerProtocolProtos.PartKeyInfo>(sorted.values()));
        }

        public OzoneManagerProtocolProtos.PartKeyInfo get(int partNumber) {
            int i = Collections.binarySearch(this.sorted, partNumber, PART_NUMBER_COMPARATOR);
            return i >= 0 ? this.sorted.get(i) : null;
        }

        public int size() {
            return this.sorted.size();
        }

        @Override
        public Iterator<OzoneManagerProtocolProtos.PartKeyInfo> iterator() {
            return this.sorted.iterator();
        }

        public OzoneManagerProtocolProtos.PartKeyInfo lastEntry() {
            return this.sorted.get(this.size() - 1);
        }
    }
}

