/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.trino.client;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.ranger.plugin.util.TimedEventUtil;
import org.apache.ranger.services.trino.client.TrinoClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrinoConnectionManager {
    private static final Logger LOG = LoggerFactory.getLogger(TrinoConnectionManager.class);
    protected ConcurrentMap<String, TrinoClient> trinoConnectionCache = new ConcurrentHashMap<String, TrinoClient>();
    protected ConcurrentMap<String, Boolean> repoConnectStatusMap = new ConcurrentHashMap<String, Boolean>();

    public TrinoClient getTrinoConnection(final String serviceName, String serviceType, final Map<String, String> configs) {
        TrinoClient trinoClient = null;
        if (serviceType != null) {
            trinoClient = (TrinoClient)this.trinoConnectionCache.get(serviceName);
            if (trinoClient == null) {
                if (configs != null) {
                    Callable<TrinoClient> connectTrino = new Callable<TrinoClient>(){

                        @Override
                        public TrinoClient call() throws Exception {
                            return new TrinoClient(serviceName, configs);
                        }
                    };
                    try {
                        trinoClient = (TrinoClient)TimedEventUtil.timedTask((Callable)connectTrino, (long)5L, (TimeUnit)TimeUnit.SECONDS);
                    }
                    catch (Exception e) {
                        LOG.error("Error connecting to Trino repository: " + serviceName + " using config: " + configs, (Throwable)e);
                    }
                    TrinoClient oldClient = null;
                    oldClient = trinoClient != null ? this.trinoConnectionCache.putIfAbsent(serviceName, trinoClient) : (TrinoClient)this.trinoConnectionCache.get(serviceName);
                    if (oldClient != null) {
                        if (trinoClient != null) {
                            trinoClient.close();
                        }
                        trinoClient = oldClient;
                    }
                    this.repoConnectStatusMap.put(serviceName, true);
                } else {
                    LOG.error("Connection Config not defined for asset :" + serviceName, new Throwable());
                }
            } else {
                try {
                    trinoClient.getCatalogList("*", null);
                }
                catch (Exception e) {
                    this.trinoConnectionCache.remove(serviceName);
                    trinoClient.close();
                    trinoClient = this.getTrinoConnection(serviceName, serviceType, configs);
                }
            }
        } else {
            LOG.error("Asset not found with name " + serviceName, new Throwable());
        }
        return trinoClient;
    }
}

