/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.type;

import io.airlift.slice.Slice;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractType
implements Type {
    private final TypeSignature signature;
    private final Class<?> javaType;

    protected AbstractType(TypeSignature signature, Class<?> javaType) {
        this.signature = signature;
        this.javaType = javaType;
    }

    @Override
    public final TypeSignature getTypeSignature() {
        return this.signature;
    }

    @Override
    public String getDisplayName() {
        return this.signature.toString();
    }

    @Override
    public final Class<?> getJavaType() {
        return this.javaType;
    }

    @Override
    public List<Type> getTypeParameters() {
        return Collections.unmodifiableList(new ArrayList());
    }

    @Override
    public boolean isComparable() {
        return false;
    }

    @Override
    public boolean isOrderable() {
        return false;
    }

    @Override
    public long hash(Block block, int position) {
        throw new UnsupportedOperationException(this.getTypeSignature() + " type is not comparable");
    }

    @Override
    public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        throw new UnsupportedOperationException(this.getTypeSignature() + " type is not comparable");
    }

    @Override
    public int compareTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        throw new UnsupportedOperationException(this.getTypeSignature() + " type is not orderable");
    }

    @Override
    public boolean getBoolean(Block block, int position) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void writeBoolean(BlockBuilder blockBuilder, boolean value) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public long getLong(Block block, int position) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void writeLong(BlockBuilder blockBuilder, long value) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public double getDouble(Block block, int position) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void writeDouble(BlockBuilder blockBuilder, double value) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public Slice getSlice(Block block, int position) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void writeSlice(BlockBuilder blockBuilder, Slice value) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void writeSlice(BlockBuilder blockBuilder, Slice value, int offset, int length) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public Object getObject(Block block, int position) {
        return this.getSlice(block, position);
    }

    @Override
    public void writeObject(BlockBuilder blockBuilder, Object value) {
        this.writeSlice(blockBuilder, (Slice)value);
    }

    public String toString() {
        return this.getDisplayName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.getTypeSignature().equals(((Type)o).getTypeSignature());
    }

    public int hashCode() {
        return this.signature.hashCode();
    }
}

