/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.expression;

import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.FunctionName;
import io.trino.spi.type.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

public final class Call
extends ConnectorExpression {
    private final FunctionName functionName;
    private final List<ConnectorExpression> arguments;

    public Call(Type type, FunctionName functionName, List<ConnectorExpression> arguments) {
        super(type);
        this.functionName = Objects.requireNonNull(functionName, "functionName is null");
        this.arguments = List.copyOf((Collection)Objects.requireNonNull(arguments, "arguments is null"));
    }

    public FunctionName getFunctionName() {
        return this.functionName;
    }

    public List<ConnectorExpression> getArguments() {
        return this.arguments;
    }

    @Override
    public List<? extends ConnectorExpression> getChildren() {
        return this.arguments;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Call call = (Call)o;
        return Objects.equals(this.functionName, call.functionName) && Objects.equals(this.arguments, call.arguments) && Objects.equals(this.getType(), call.getType());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.functionName, this.arguments, this.getType());
    }

    @Override
    public String toString() {
        StringJoiner stringJoiner = new StringJoiner(", ", Call.class.getSimpleName() + "[", "]");
        return stringJoiner.add("functionName=" + String.valueOf(this.functionName)).add("arguments=" + String.valueOf(this.arguments)).toString();
    }
}

