/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.IPAllocationMethod;
import com.microsoft.azure.management.network.NetworkSecurityGroup;
import com.microsoft.azure.management.network.VirtualMachineScaleSetNetworkInterface;
import com.microsoft.azure.management.network.VirtualMachineScaleSetNicIPConfiguration;
import com.microsoft.azure.management.network.implementation.NetworkInterfaceIPConfigurationInner;
import com.microsoft.azure.management.network.implementation.NetworkInterfaceInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.network.implementation.VirtualMachineScaleSetNicIPConfigurationImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import rx.Observable;

@LangDefinition
class VirtualMachineScaleSetNetworkInterfaceImpl
extends ResourceImpl<VirtualMachineScaleSetNetworkInterface, NetworkInterfaceInner, VirtualMachineScaleSetNetworkInterfaceImpl>
implements VirtualMachineScaleSetNetworkInterface {
    private final NetworkManager networkManager;
    private final String scaleSetName;
    private final String resourceGroupName;

    VirtualMachineScaleSetNetworkInterfaceImpl(String name, String scaleSetName, String resourceGroupName, NetworkInterfaceInner innerObject, NetworkManager networkManager) {
        super(name, (Resource)innerObject);
        this.scaleSetName = scaleSetName;
        this.resourceGroupName = resourceGroupName;
        this.networkManager = networkManager;
    }

    @Override
    public boolean isIPForwardingEnabled() {
        return Utils.toPrimitiveBoolean((Boolean)((NetworkInterfaceInner)((Object)this.inner())).enableIPForwarding());
    }

    @Override
    public String macAddress() {
        return ((NetworkInterfaceInner)((Object)this.inner())).macAddress();
    }

    @Override
    public String internalDnsNameLabel() {
        if (((NetworkInterfaceInner)((Object)this.inner())).dnsSettings() == null) {
            return null;
        }
        return ((NetworkInterfaceInner)((Object)this.inner())).dnsSettings().internalDnsNameLabel();
    }

    @Override
    public String internalFqdn() {
        if (((NetworkInterfaceInner)((Object)this.inner())).dnsSettings() == null) {
            return null;
        }
        return ((NetworkInterfaceInner)((Object)this.inner())).dnsSettings().internalFqdn();
    }

    @Override
    public String internalDomainNameSuffix() {
        if (((NetworkInterfaceInner)((Object)this.inner())).dnsSettings() == null) {
            return null;
        }
        return ((NetworkInterfaceInner)((Object)this.inner())).dnsSettings().internalDomainNameSuffix();
    }

    @Override
    public List<String> dnsServers() {
        if (((NetworkInterfaceInner)((Object)this.inner())).dnsSettings() == null || ((NetworkInterfaceInner)((Object)this.inner())).dnsSettings().dnsServers() == null) {
            return Collections.unmodifiableList(new ArrayList());
        }
        return Collections.unmodifiableList(((NetworkInterfaceInner)((Object)this.inner())).dnsSettings().dnsServers());
    }

    @Override
    public List<String> appliedDnsServers() {
        ArrayList dnsServers = new ArrayList();
        if (((NetworkInterfaceInner)((Object)this.inner())).dnsSettings() == null || ((NetworkInterfaceInner)((Object)this.inner())).dnsSettings().appliedDnsServers() == null) {
            return Collections.unmodifiableList(dnsServers);
        }
        return Collections.unmodifiableList(((NetworkInterfaceInner)((Object)this.inner())).dnsSettings().appliedDnsServers());
    }

    @Override
    public String primaryPrivateIP() {
        VirtualMachineScaleSetNicIPConfiguration primaryIPConfig = this.primaryIPConfiguration();
        if (primaryIPConfig == null) {
            return null;
        }
        return primaryIPConfig.privateIPAddress();
    }

    @Override
    public IPAllocationMethod primaryPrivateIPAllocationMethod() {
        VirtualMachineScaleSetNicIPConfiguration primaryIPConfig = this.primaryIPConfiguration();
        if (primaryIPConfig == null) {
            return null;
        }
        return primaryIPConfig.privateIPAllocationMethod();
    }

    @Override
    public Map<String, VirtualMachineScaleSetNicIPConfiguration> ipConfigurations() {
        List<NetworkInterfaceIPConfigurationInner> inners = ((NetworkInterfaceInner)((Object)this.inner())).ipConfigurations();
        if (inners == null || inners.size() == 0) {
            return Collections.unmodifiableMap(new TreeMap());
        }
        TreeMap<String, VirtualMachineScaleSetNicIPConfigurationImpl> nicIPConfigurations = new TreeMap<String, VirtualMachineScaleSetNicIPConfigurationImpl>();
        for (NetworkInterfaceIPConfigurationInner inner : inners) {
            VirtualMachineScaleSetNicIPConfigurationImpl nicIPConfiguration = new VirtualMachineScaleSetNicIPConfigurationImpl(inner, this, this.networkManager);
            nicIPConfigurations.put(nicIPConfiguration.name(), nicIPConfiguration);
        }
        return Collections.unmodifiableMap(nicIPConfigurations);
    }

    @Override
    public VirtualMachineScaleSetNicIPConfiguration primaryIPConfiguration() {
        for (VirtualMachineScaleSetNicIPConfiguration ipConfiguration : this.ipConfigurations().values()) {
            if (!ipConfiguration.isPrimary()) continue;
            return ipConfiguration;
        }
        return null;
    }

    @Override
    public String networkSecurityGroupId() {
        if (((NetworkInterfaceInner)((Object)this.inner())).networkSecurityGroup() == null) {
            return null;
        }
        return ((NetworkInterfaceInner)((Object)this.inner())).networkSecurityGroup().id();
    }

    @Override
    public NetworkSecurityGroup getNetworkSecurityGroup() {
        String nsgId = this.networkSecurityGroupId();
        if (nsgId == null) {
            return null;
        }
        return (NetworkSecurityGroup)this.manager().networkSecurityGroups().getByResourceGroup(ResourceUtils.groupFromResourceId((String)nsgId), ResourceUtils.nameFromResourceId((String)nsgId));
    }

    @Override
    public String virtualMachineId() {
        if (((NetworkInterfaceInner)((Object)this.inner())).virtualMachine() == null) {
            return null;
        }
        return ((NetworkInterfaceInner)((Object)this.inner())).virtualMachine().id();
    }

    public Observable<VirtualMachineScaleSetNetworkInterface> createResourceAsync() {
        throw new UnsupportedOperationException();
    }

    protected Observable<NetworkInterfaceInner> getInnerAsync() {
        return ((NetworkManagementClientImpl)((Object)this.manager().inner())).networkInterfaces().getVirtualMachineScaleSetNetworkInterfaceAsync(this.resourceGroupName, this.scaleSetName, ResourceUtils.nameFromResourceId((String)this.virtualMachineId()), this.name());
    }

    public NetworkManager manager() {
        return this.networkManager;
    }

    @Override
    public boolean isAcceleratedNetworkingEnabled() {
        return Utils.toPrimitiveBoolean((Boolean)((NetworkInterfaceInner)((Object)this.inner())).enableAcceleratedNetworking());
    }
}

