/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.monitor.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.management.monitor.ErrorResponseException;
import com.microsoft.azure.management.monitor.implementation.MetricAlertStatusCollectionInner;
import com.microsoft.azure.management.monitor.implementation.MonitorManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class MetricAlertsStatusInner {
    private MetricAlertsStatusService service;
    private MonitorManagementClientImpl client;

    public MetricAlertsStatusInner(Retrofit retrofit, MonitorManagementClientImpl client) {
        this.service = (MetricAlertsStatusService)retrofit.create(MetricAlertsStatusService.class);
        this.client = client;
    }

    public MetricAlertStatusCollectionInner list(String resourceGroupName, String ruleName) {
        return (MetricAlertStatusCollectionInner)((ServiceResponse)this.listWithServiceResponseAsync(resourceGroupName, ruleName).toBlocking().single()).body();
    }

    public ServiceFuture<MetricAlertStatusCollectionInner> listAsync(String resourceGroupName, String ruleName, ServiceCallback<MetricAlertStatusCollectionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(resourceGroupName, ruleName), serviceCallback);
    }

    public Observable<MetricAlertStatusCollectionInner> listAsync(String resourceGroupName, String ruleName) {
        return this.listWithServiceResponseAsync(resourceGroupName, ruleName).map((Func1)new Func1<ServiceResponse<MetricAlertStatusCollectionInner>, MetricAlertStatusCollectionInner>(){

            public MetricAlertStatusCollectionInner call(ServiceResponse<MetricAlertStatusCollectionInner> response) {
                return (MetricAlertStatusCollectionInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<MetricAlertStatusCollectionInner>> listWithServiceResponseAsync(String resourceGroupName, String ruleName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ruleName == null) {
            throw new IllegalArgumentException("Parameter ruleName is required and cannot be null.");
        }
        String apiVersion = "2018-03-01";
        return this.service.list(this.client.subscriptionId(), resourceGroupName, ruleName, "2018-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<MetricAlertStatusCollectionInner>>>(){

            public Observable<ServiceResponse<MetricAlertStatusCollectionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = MetricAlertsStatusInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<MetricAlertStatusCollectionInner> listDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<MetricAlertStatusCollectionInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public MetricAlertStatusCollectionInner listByName(String resourceGroupName, String ruleName, String statusName) {
        return (MetricAlertStatusCollectionInner)((ServiceResponse)this.listByNameWithServiceResponseAsync(resourceGroupName, ruleName, statusName).toBlocking().single()).body();
    }

    public ServiceFuture<MetricAlertStatusCollectionInner> listByNameAsync(String resourceGroupName, String ruleName, String statusName, ServiceCallback<MetricAlertStatusCollectionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listByNameWithServiceResponseAsync(resourceGroupName, ruleName, statusName), serviceCallback);
    }

    public Observable<MetricAlertStatusCollectionInner> listByNameAsync(String resourceGroupName, String ruleName, String statusName) {
        return this.listByNameWithServiceResponseAsync(resourceGroupName, ruleName, statusName).map((Func1)new Func1<ServiceResponse<MetricAlertStatusCollectionInner>, MetricAlertStatusCollectionInner>(){

            public MetricAlertStatusCollectionInner call(ServiceResponse<MetricAlertStatusCollectionInner> response) {
                return (MetricAlertStatusCollectionInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<MetricAlertStatusCollectionInner>> listByNameWithServiceResponseAsync(String resourceGroupName, String ruleName, String statusName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (ruleName == null) {
            throw new IllegalArgumentException("Parameter ruleName is required and cannot be null.");
        }
        if (statusName == null) {
            throw new IllegalArgumentException("Parameter statusName is required and cannot be null.");
        }
        String apiVersion = "2018-03-01";
        return this.service.listByName(this.client.subscriptionId(), resourceGroupName, ruleName, statusName, "2018-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<MetricAlertStatusCollectionInner>>>(){

            public Observable<ServiceResponse<MetricAlertStatusCollectionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = MetricAlertsStatusInner.this.listByNameDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<MetricAlertStatusCollectionInner> listByNameDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<MetricAlertStatusCollectionInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    static interface MetricAlertsStatusService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.MetricAlertsStatus list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/metricAlerts/{ruleName}/status")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="ruleName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.MetricAlertsStatus listByName"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/metricAlerts/{ruleName}/status/{statusName}")
        public Observable<Response<ResponseBody>> listByName(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="ruleName") String var3, @Path(value="statusName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);
    }
}

