/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.monitor.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.management.monitor.ErrorResponseException;
import com.microsoft.azure.management.monitor.ResultType;
import com.microsoft.azure.management.monitor.TimeSeriesInformation;
import com.microsoft.azure.management.monitor.implementation.BaselineResponseInner;
import com.microsoft.azure.management.monitor.implementation.CalculateBaselineResponseInner;
import com.microsoft.azure.management.monitor.implementation.MonitorManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import okhttp3.ResponseBody;
import org.joda.time.Period;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class MetricBaselinesInner {
    private MetricBaselinesService service;
    private MonitorManagementClientImpl client;

    public MetricBaselinesInner(Retrofit retrofit, MonitorManagementClientImpl client) {
        this.service = (MetricBaselinesService)retrofit.create(MetricBaselinesService.class);
        this.client = client;
    }

    public BaselineResponseInner get(String resourceUri, String metricName) {
        return (BaselineResponseInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceUri, metricName).toBlocking().single()).body();
    }

    public ServiceFuture<BaselineResponseInner> getAsync(String resourceUri, String metricName, ServiceCallback<BaselineResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceUri, metricName), serviceCallback);
    }

    public Observable<BaselineResponseInner> getAsync(String resourceUri, String metricName) {
        return this.getWithServiceResponseAsync(resourceUri, metricName).map((Func1)new Func1<ServiceResponse<BaselineResponseInner>, BaselineResponseInner>(){

            public BaselineResponseInner call(ServiceResponse<BaselineResponseInner> response) {
                return (BaselineResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<BaselineResponseInner>> getWithServiceResponseAsync(String resourceUri, String metricName) {
        if (resourceUri == null) {
            throw new IllegalArgumentException("Parameter resourceUri is required and cannot be null.");
        }
        if (metricName == null) {
            throw new IllegalArgumentException("Parameter metricName is required and cannot be null.");
        }
        String apiVersion = "2017-11-01-preview";
        String timespan = null;
        Period interval = null;
        String aggregation = null;
        String sensitivities = null;
        ResultType resultType = null;
        return this.service.get(resourceUri, metricName, timespan, interval, aggregation, sensitivities, resultType, "2017-11-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<BaselineResponseInner>>>(){

            public Observable<ServiceResponse<BaselineResponseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = MetricBaselinesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public BaselineResponseInner get(String resourceUri, String metricName, String timespan, Period interval, String aggregation, String sensitivities, ResultType resultType) {
        return (BaselineResponseInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceUri, metricName, timespan, interval, aggregation, sensitivities, resultType).toBlocking().single()).body();
    }

    public ServiceFuture<BaselineResponseInner> getAsync(String resourceUri, String metricName, String timespan, Period interval, String aggregation, String sensitivities, ResultType resultType, ServiceCallback<BaselineResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceUri, metricName, timespan, interval, aggregation, sensitivities, resultType), serviceCallback);
    }

    public Observable<BaselineResponseInner> getAsync(String resourceUri, String metricName, String timespan, Period interval, String aggregation, String sensitivities, ResultType resultType) {
        return this.getWithServiceResponseAsync(resourceUri, metricName, timespan, interval, aggregation, sensitivities, resultType).map((Func1)new Func1<ServiceResponse<BaselineResponseInner>, BaselineResponseInner>(){

            public BaselineResponseInner call(ServiceResponse<BaselineResponseInner> response) {
                return (BaselineResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<BaselineResponseInner>> getWithServiceResponseAsync(String resourceUri, String metricName, String timespan, Period interval, String aggregation, String sensitivities, ResultType resultType) {
        if (resourceUri == null) {
            throw new IllegalArgumentException("Parameter resourceUri is required and cannot be null.");
        }
        if (metricName == null) {
            throw new IllegalArgumentException("Parameter metricName is required and cannot be null.");
        }
        String apiVersion = "2017-11-01-preview";
        return this.service.get(resourceUri, metricName, timespan, interval, aggregation, sensitivities, resultType, "2017-11-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<BaselineResponseInner>>>(){

            public Observable<ServiceResponse<BaselineResponseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = MetricBaselinesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<BaselineResponseInner> getDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<BaselineResponseInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public CalculateBaselineResponseInner calculateBaseline(String resourceUri, TimeSeriesInformation timeSeriesInformation) {
        return (CalculateBaselineResponseInner)((ServiceResponse)this.calculateBaselineWithServiceResponseAsync(resourceUri, timeSeriesInformation).toBlocking().single()).body();
    }

    public ServiceFuture<CalculateBaselineResponseInner> calculateBaselineAsync(String resourceUri, TimeSeriesInformation timeSeriesInformation, ServiceCallback<CalculateBaselineResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.calculateBaselineWithServiceResponseAsync(resourceUri, timeSeriesInformation), serviceCallback);
    }

    public Observable<CalculateBaselineResponseInner> calculateBaselineAsync(String resourceUri, TimeSeriesInformation timeSeriesInformation) {
        return this.calculateBaselineWithServiceResponseAsync(resourceUri, timeSeriesInformation).map((Func1)new Func1<ServiceResponse<CalculateBaselineResponseInner>, CalculateBaselineResponseInner>(){

            public CalculateBaselineResponseInner call(ServiceResponse<CalculateBaselineResponseInner> response) {
                return (CalculateBaselineResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<CalculateBaselineResponseInner>> calculateBaselineWithServiceResponseAsync(String resourceUri, TimeSeriesInformation timeSeriesInformation) {
        if (resourceUri == null) {
            throw new IllegalArgumentException("Parameter resourceUri is required and cannot be null.");
        }
        if (timeSeriesInformation == null) {
            throw new IllegalArgumentException("Parameter timeSeriesInformation is required and cannot be null.");
        }
        Validator.validate((Object)timeSeriesInformation);
        String apiVersion = "2017-11-01-preview";
        return this.service.calculateBaseline(resourceUri, "2017-11-01-preview", timeSeriesInformation, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CalculateBaselineResponseInner>>>(){

            public Observable<ServiceResponse<CalculateBaselineResponseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = MetricBaselinesInner.this.calculateBaselineDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CalculateBaselineResponseInner> calculateBaselineDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<CalculateBaselineResponseInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    static interface MetricBaselinesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.MetricBaselines get"})
        @GET(value="{resourceUri}/providers/microsoft.insights/baseline/{metricName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceUri", encoded=true) String var1, @Path(value="metricName") String var2, @Query(value="timespan") String var3, @Query(value="interval") Period var4, @Query(value="aggregation") String var5, @Query(value="sensitivities") String var6, @Query(value="resultType") ResultType var7, @Query(value="api-version") String var8, @Header(value="accept-language") String var9, @Header(value="User-Agent") String var10);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.monitor.MetricBaselines calculateBaseline"})
        @POST(value="{resourceUri}/providers/microsoft.insights/calculatebaseline")
        public Observable<Response<ResponseBody>> calculateBaseline(@Path(value="resourceUri", encoded=true) String var1, @Query(value="api-version") String var2, @Body TimeSeriesInformation var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);
    }
}

