/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.cdn.implementation;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.cdn.CdnEndpoint;
import com.microsoft.azure.management.cdn.CdnProfile;
import com.microsoft.azure.management.cdn.CustomDomainValidationResult;
import com.microsoft.azure.management.cdn.DeepCreatedOrigin;
import com.microsoft.azure.management.cdn.EndpointResourceState;
import com.microsoft.azure.management.cdn.GeoFilter;
import com.microsoft.azure.management.cdn.GeoFilterActions;
import com.microsoft.azure.management.cdn.QueryStringCachingBehavior;
import com.microsoft.azure.management.cdn.ResourceUsage;
import com.microsoft.azure.management.cdn.implementation.CdnManagementClientImpl;
import com.microsoft.azure.management.cdn.implementation.CdnManager;
import com.microsoft.azure.management.cdn.implementation.CdnProfileImpl;
import com.microsoft.azure.management.cdn.implementation.CustomDomainInner;
import com.microsoft.azure.management.cdn.implementation.EndpointInner;
import com.microsoft.azure.management.cdn.implementation.EndpointUpdateParametersInner;
import com.microsoft.azure.management.cdn.implementation.OriginInner;
import com.microsoft.azure.management.cdn.implementation.OriginUpdateParametersInner;
import com.microsoft.azure.management.cdn.implementation.ResourceUsageInner;
import com.microsoft.azure.management.resources.fluentcore.arm.CountryIsoCode;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import com.microsoft.azure.management.resources.fluentcore.utils.SdkContext;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import rx.Completable;
import rx.Observable;
import rx.functions.Action1;
import rx.functions.Func1;
import rx.functions.Func3;
import rx.functions.FuncN;

@LangDefinition
class CdnEndpointImpl
extends ExternalChildResourceImpl<CdnEndpoint, EndpointInner, CdnProfileImpl, CdnProfile>
implements CdnEndpoint,
CdnEndpoint.DefinitionStages.Blank.StandardEndpoint<CdnProfile.DefinitionStages.WithStandardCreate>,
CdnEndpoint.DefinitionStages.Blank.PremiumEndpoint<CdnProfile.DefinitionStages.WithPremiumVerizonCreate>,
CdnEndpoint.DefinitionStages.WithStandardAttach<CdnProfile.DefinitionStages.WithStandardCreate>,
CdnEndpoint.DefinitionStages.WithPremiumAttach<CdnProfile.DefinitionStages.WithPremiumVerizonCreate>,
CdnEndpoint.UpdateDefinitionStages.Blank.StandardEndpoint<CdnProfile.Update>,
CdnEndpoint.UpdateDefinitionStages.Blank.PremiumEndpoint<CdnProfile.Update>,
CdnEndpoint.UpdateDefinitionStages.WithStandardAttach<CdnProfile.Update>,
CdnEndpoint.UpdateDefinitionStages.WithPremiumAttach<CdnProfile.Update>,
CdnEndpoint.UpdateStandardEndpoint,
CdnEndpoint.UpdatePremiumEndpoint {
    private List<CustomDomainInner> customDomainList = new ArrayList<CustomDomainInner>();
    private List<CustomDomainInner> deletedCustomDomainList = new ArrayList<CustomDomainInner>();

    CdnEndpointImpl(String name, CdnProfileImpl parent, EndpointInner inner) {
        super(name, (Object)parent, (Object)inner);
    }

    public String id() {
        return ((EndpointInner)((Object)this.inner())).id();
    }

    public Observable<CdnEndpoint> createResourceAsync() {
        final CdnEndpointImpl self = this;
        return ((CdnManagementClientImpl)((Object)((CdnManager)((CdnProfileImpl)this.parent()).manager()).inner())).endpoints().createAsync(((CdnProfileImpl)this.parent()).resourceGroupName(), ((CdnProfileImpl)this.parent()).name(), this.name(), (EndpointInner)((Object)this.inner())).map((Func1)new Func1<EndpointInner, CdnEndpoint>(){

            public CdnEndpoint call(EndpointInner inner) {
                self.setInner((Object)inner);
                for (CustomDomainInner itemToCreate : self.customDomainList) {
                    ((CdnManagementClientImpl)((Object)((CdnManager)((CdnProfileImpl)self.parent()).manager()).inner())).customDomains().create(((CdnProfileImpl)self.parent()).resourceGroupName(), ((CdnProfileImpl)self.parent()).name(), self.name(), SdkContext.randomResourceName((String)"CustomDomain", (int)50), itemToCreate.hostName());
                }
                self.customDomainList.clear();
                self.customDomainList.addAll(((CdnManagementClientImpl)((Object)((CdnManager)((CdnProfileImpl)self.parent()).manager()).inner())).customDomains().listByEndpoint(((CdnProfileImpl)self.parent()).resourceGroupName(), ((CdnProfileImpl)self.parent()).name(), self.name()));
                return self;
            }
        });
    }

    public Observable<CdnEndpoint> updateResourceAsync() {
        final CdnEndpointImpl self = this;
        EndpointUpdateParametersInner updateInner = new EndpointUpdateParametersInner();
        updateInner.withIsHttpAllowed(((EndpointInner)((Object)this.inner())).isHttpAllowed()).withIsHttpsAllowed(((EndpointInner)((Object)this.inner())).isHttpsAllowed()).withOriginPath(((EndpointInner)((Object)this.inner())).originPath()).withOriginHostHeader(((EndpointInner)((Object)this.inner())).originHostHeader()).withIsCompressionEnabled(((EndpointInner)((Object)this.inner())).isCompressionEnabled()).withContentTypesToCompress(((EndpointInner)((Object)this.inner())).contentTypesToCompress()).withGeoFilters(((EndpointInner)((Object)this.inner())).geoFilters()).withOptimizationType(((EndpointInner)((Object)this.inner())).optimizationType()).withQueryStringCachingBehavior(((EndpointInner)((Object)this.inner())).queryStringCachingBehavior()).withTags(((EndpointInner)((Object)this.inner())).getTags());
        DeepCreatedOrigin originInner = ((EndpointInner)((Object)this.inner())).origins().get(0);
        OriginUpdateParametersInner originParameters = new OriginUpdateParametersInner().withHostName(originInner.hostName()).withHttpPort(originInner.httpPort()).withHttpsPort(originInner.httpsPort());
        Observable<OriginInner> originObservable = ((CdnManagementClientImpl)((Object)((CdnManager)((CdnProfileImpl)this.parent()).manager()).inner())).origins().updateAsync(((CdnProfileImpl)this.parent()).resourceGroupName(), ((CdnProfileImpl)this.parent()).name(), this.name(), originInner.name(), originParameters);
        Observable endpointObservable = ((CdnManagementClientImpl)((Object)((CdnManager)((CdnProfileImpl)this.parent()).manager()).inner())).endpoints().updateAsync(((CdnProfileImpl)this.parent()).resourceGroupName(), ((CdnProfileImpl)this.parent()).name(), this.name(), updateInner).map((Func1)new Func1<EndpointInner, CdnEndpoint>(){

            public CdnEndpoint call(EndpointInner inner) {
                self.setInner((Object)inner);
                return self;
            }
        });
        ArrayList<Observable<CustomDomainInner>> customDomainDeleteObservables = new ArrayList<Observable<CustomDomainInner>>();
        for (CustomDomainInner itemToDelete : this.deletedCustomDomainList) {
            customDomainDeleteObservables.add(((CdnManagementClientImpl)((Object)((CdnManager)((CdnProfileImpl)this.parent()).manager()).inner())).customDomains().deleteAsync(((CdnProfileImpl)this.parent()).resourceGroupName(), ((CdnProfileImpl)this.parent()).name(), this.name(), itemToDelete.name()));
        }
        Observable deleteObservable = Observable.zip(customDomainDeleteObservables, (FuncN)new FuncN<CustomDomainInner>(){

            public CustomDomainInner call(Object ... objects) {
                return null;
            }
        });
        return Observable.zip(originObservable, (Observable)endpointObservable, (Observable)deleteObservable, (Func3)new Func3<OriginInner, CdnEndpoint, CustomDomainInner, CdnEndpoint>(){

            public CdnEndpoint call(OriginInner originInner, CdnEndpoint cdnEndpoint, CustomDomainInner customDomain) {
                return cdnEndpoint;
            }
        }).doOnNext((Action1)new Action1<CdnEndpoint>(){

            public void call(CdnEndpoint cdnEndpoint) {
                self.deletedCustomDomainList.clear();
            }
        });
    }

    public Observable<Void> deleteResourceAsync() {
        return ((CdnManagementClientImpl)((Object)((CdnManager)((CdnProfileImpl)this.parent()).manager()).inner())).endpoints().deleteAsync(((CdnProfileImpl)this.parent()).resourceGroupName(), ((CdnProfileImpl)this.parent()).name(), this.name());
    }

    public Observable<CdnEndpoint> refreshAsync() {
        final CdnEndpointImpl self = this;
        return super.refreshAsync().flatMap((Func1)new Func1<CdnEndpoint, Observable<CdnEndpoint>>(){

            public Observable<CdnEndpoint> call(CdnEndpoint cdnEndpoint) {
                self.customDomainList.clear();
                self.deletedCustomDomainList.clear();
                return ((CdnManagementClientImpl)((Object)((CdnManager)((CdnProfileImpl)self.parent()).manager()).inner())).customDomains().listByEndpointAsync(((CdnProfileImpl)self.parent()).resourceGroupName(), ((CdnProfileImpl)self.parent()).name(), self.name()).flatMap((Func1)new Func1<Page<CustomDomainInner>, Observable<CdnEndpoint>>(){

                    public Observable<CdnEndpoint> call(Page<CustomDomainInner> customDomainInnerPage) {
                        self.customDomainList.addAll(customDomainInnerPage.items());
                        return Observable.just((Object)self);
                    }
                });
            }
        });
    }

    protected Observable<EndpointInner> getInnerAsync() {
        return ((CdnManagementClientImpl)((Object)((CdnManager)((CdnProfileImpl)this.parent()).manager()).inner())).endpoints().getAsync(((CdnProfileImpl)this.parent()).resourceGroupName(), ((CdnProfileImpl)this.parent()).name(), this.name());
    }

    @Override
    public PagedList<ResourceUsage> listResourceUsage() {
        return new PagedListConverter<ResourceUsageInner, ResourceUsage>(){

            public Observable<ResourceUsage> typeConvertAsync(ResourceUsageInner inner) {
                return Observable.just((Object)new ResourceUsage(inner));
            }
        }.convert(((CdnManagementClientImpl)((Object)((CdnManager)((CdnProfileImpl)this.parent()).manager()).inner())).endpoints().listResourceUsage(((CdnProfileImpl)this.parent()).resourceGroupName(), ((CdnProfileImpl)this.parent()).name(), this.name()));
    }

    @Override
    public CdnProfileImpl attach() {
        return ((CdnProfileImpl)this.parent()).withEndpoint(this);
    }

    @Override
    public String originHostHeader() {
        return ((EndpointInner)((Object)this.inner())).originHostHeader();
    }

    @Override
    public String originPath() {
        return ((EndpointInner)((Object)this.inner())).originPath();
    }

    @Override
    public Set<String> contentTypesToCompress() {
        List<String> contentTypes = ((EndpointInner)((Object)this.inner())).contentTypesToCompress();
        HashSet<String> set = new HashSet<String>();
        if (contentTypes != null) {
            set.addAll(contentTypes);
        }
        return Collections.unmodifiableSet(set);
    }

    @Override
    public boolean isCompressionEnabled() {
        return ((EndpointInner)((Object)this.inner())).isCompressionEnabled();
    }

    @Override
    public boolean isHttpAllowed() {
        return ((EndpointInner)((Object)this.inner())).isHttpAllowed();
    }

    @Override
    public boolean isHttpsAllowed() {
        return ((EndpointInner)((Object)this.inner())).isHttpsAllowed();
    }

    @Override
    public QueryStringCachingBehavior queryStringCachingBehavior() {
        return ((EndpointInner)((Object)this.inner())).queryStringCachingBehavior();
    }

    @Override
    public String optimizationType() {
        if (((EndpointInner)((Object)this.inner())).optimizationType() == null) {
            return null;
        }
        return ((EndpointInner)((Object)this.inner())).optimizationType().toString();
    }

    @Override
    public List<GeoFilter> geoFilters() {
        return ((EndpointInner)((Object)this.inner())).geoFilters();
    }

    @Override
    public String hostName() {
        return ((EndpointInner)((Object)this.inner())).hostName();
    }

    @Override
    public EndpointResourceState resourceState() {
        return ((EndpointInner)((Object)this.inner())).resourceState();
    }

    @Override
    public String provisioningState() {
        return ((EndpointInner)((Object)this.inner())).provisioningState();
    }

    @Override
    public String originHostName() {
        if (((EndpointInner)((Object)this.inner())).origins() != null && !((EndpointInner)((Object)this.inner())).origins().isEmpty()) {
            return ((EndpointInner)((Object)this.inner())).origins().get(0).hostName();
        }
        return null;
    }

    @Override
    public int httpPort() {
        if (((EndpointInner)((Object)this.inner())).origins() != null && !((EndpointInner)((Object)this.inner())).origins().isEmpty()) {
            Integer httpPort = ((EndpointInner)((Object)this.inner())).origins().get(0).httpPort();
            return httpPort != null ? httpPort : 0;
        }
        return 0;
    }

    @Override
    public int httpsPort() {
        if (((EndpointInner)((Object)this.inner())).origins() != null && !((EndpointInner)((Object)this.inner())).origins().isEmpty()) {
            Integer httpsPort = ((EndpointInner)((Object)this.inner())).origins().get(0).httpsPort();
            return httpsPort != null ? httpsPort : 0;
        }
        return 0;
    }

    @Override
    public Set<String> customDomains() {
        List customDomains = Lists.transform(this.customDomainList, (Function)new Function<CustomDomainInner, String>(){

            public String apply(CustomDomainInner customDomain) {
                return customDomain.hostName();
            }
        });
        HashSet set = new HashSet();
        if (customDomains != null) {
            set.addAll(customDomains);
        }
        return Collections.unmodifiableSet(set);
    }

    @Override
    public void start() {
        ((CdnProfileImpl)this.parent()).startEndpoint(this.name());
    }

    @Override
    public Completable startAsync() {
        return ((CdnProfileImpl)this.parent()).startEndpointAsync(this.name());
    }

    @Override
    public ServiceFuture<Void> startAsync(ServiceCallback<Void> callback) {
        return ServiceFuture.fromBody((Completable)this.startAsync(), callback);
    }

    @Override
    public void stop() {
        this.stopAsync().await();
    }

    @Override
    public Completable stopAsync() {
        return ((CdnProfileImpl)this.parent()).stopEndpointAsync(this.name());
    }

    @Override
    public ServiceFuture<Void> stopAsync(ServiceCallback<Void> callback) {
        return ServiceFuture.fromBody((Completable)this.stopAsync(), callback);
    }

    @Override
    public void purgeContent(Set<String> contentPaths) {
        if (contentPaths != null) {
            this.purgeContentAsync(contentPaths).await();
        }
    }

    @Override
    public Completable purgeContentAsync(Set<String> contentPaths) {
        return ((CdnProfileImpl)this.parent()).purgeEndpointContentAsync(this.name(), contentPaths);
    }

    @Override
    public ServiceFuture<Void> purgeContentAsync(Set<String> contentPaths, ServiceCallback<Void> callback) {
        return ServiceFuture.fromBody((Completable)this.purgeContentAsync(contentPaths), callback);
    }

    @Override
    public void loadContent(Set<String> contentPaths) {
        this.loadContentAsync(contentPaths).await();
    }

    @Override
    public Completable loadContentAsync(Set<String> contentPaths) {
        return ((CdnProfileImpl)this.parent()).loadEndpointContentAsync(this.name(), contentPaths);
    }

    @Override
    public ServiceFuture<Void> loadContentAsync(Set<String> contentPaths, ServiceCallback<Void> callback) {
        return ServiceFuture.fromBody((Completable)this.loadContentAsync(contentPaths), callback);
    }

    @Override
    public CustomDomainValidationResult validateCustomDomain(String hostName) {
        return (CustomDomainValidationResult)this.validateCustomDomainAsync(hostName).toBlocking().last();
    }

    @Override
    public Observable<CustomDomainValidationResult> validateCustomDomainAsync(String hostName) {
        return ((CdnProfileImpl)this.parent()).validateEndpointCustomDomainAsync(this.name(), hostName);
    }

    @Override
    public ServiceFuture<CustomDomainValidationResult> validateCustomDomainAsync(String hostName, ServiceCallback<CustomDomainValidationResult> callback) {
        return ServiceFuture.fromBody(this.validateCustomDomainAsync(hostName), callback);
    }

    public CdnEndpointImpl withOrigin(String originName, String hostname) {
        ((EndpointInner)((Object)this.inner())).origins().add(new DeepCreatedOrigin().withName(originName).withHostName(hostname));
        return this;
    }

    public CdnEndpointImpl withOrigin(String hostname) {
        return this.withOrigin("origin", hostname);
    }

    public CdnEndpointImpl withPremiumOrigin(String originName, String hostname) {
        return this.withOrigin(originName, hostname);
    }

    public CdnEndpointImpl withPremiumOrigin(String hostname) {
        return this.withOrigin(hostname);
    }

    @Override
    public CdnEndpointImpl withOriginPath(String originPath) {
        ((EndpointInner)((Object)this.inner())).withOriginPath(originPath);
        return this;
    }

    @Override
    public CdnEndpointImpl withHttpAllowed(boolean httpAllowed) {
        ((EndpointInner)((Object)this.inner())).withIsHttpAllowed(httpAllowed);
        return this;
    }

    @Override
    public CdnEndpointImpl withHttpsAllowed(boolean httpsAllowed) {
        ((EndpointInner)((Object)this.inner())).withIsHttpsAllowed(httpsAllowed);
        return this;
    }

    @Override
    public CdnEndpointImpl withHttpPort(int httpPort) {
        if (((EndpointInner)((Object)this.inner())).origins() != null && !((EndpointInner)((Object)this.inner())).origins().isEmpty()) {
            ((EndpointInner)((Object)this.inner())).origins().get(0).withHttpPort(httpPort);
        }
        return this;
    }

    @Override
    public CdnEndpointImpl withHttpsPort(int httpsPort) {
        if (((EndpointInner)((Object)this.inner())).origins() != null && !((EndpointInner)((Object)this.inner())).origins().isEmpty()) {
            ((EndpointInner)((Object)this.inner())).origins().get(0).withHttpsPort(httpsPort);
        }
        return this;
    }

    @Override
    public CdnEndpointImpl withHostHeader(String hostHeader) {
        ((EndpointInner)((Object)this.inner())).withOriginHostHeader(hostHeader);
        return this;
    }

    @Override
    public CdnEndpointImpl withContentTypesToCompress(Set<String> contentTypesToCompress) {
        ArrayList<String> list = null;
        if (contentTypesToCompress != null) {
            list = new ArrayList<String>(contentTypesToCompress);
        }
        ((EndpointInner)((Object)this.inner())).withContentTypesToCompress(list);
        return this;
    }

    @Override
    public CdnEndpointImpl withoutContentTypesToCompress() {
        if (((EndpointInner)((Object)this.inner())).contentTypesToCompress() != null) {
            ((EndpointInner)((Object)this.inner())).contentTypesToCompress().clear();
        }
        return this;
    }

    @Override
    public CdnEndpointImpl withContentTypeToCompress(String contentTypeToCompress) {
        if (((EndpointInner)((Object)this.inner())).contentTypesToCompress() == null) {
            ((EndpointInner)((Object)this.inner())).withContentTypesToCompress(new ArrayList<String>());
        }
        ((EndpointInner)((Object)this.inner())).contentTypesToCompress().add(contentTypeToCompress);
        return this;
    }

    @Override
    public CdnEndpointImpl withoutContentTypeToCompress(String contentTypeToCompress) {
        if (((EndpointInner)((Object)this.inner())).contentTypesToCompress() != null) {
            ((EndpointInner)((Object)this.inner())).contentTypesToCompress().remove(contentTypeToCompress);
        }
        return this;
    }

    @Override
    public CdnEndpointImpl withCompressionEnabled(boolean compressionEnabled) {
        ((EndpointInner)((Object)this.inner())).withIsCompressionEnabled(compressionEnabled);
        return this;
    }

    @Override
    public CdnEndpointImpl withQueryStringCachingBehavior(QueryStringCachingBehavior cachingBehavior) {
        ((EndpointInner)((Object)this.inner())).withQueryStringCachingBehavior(cachingBehavior);
        return this;
    }

    @Override
    public CdnEndpointImpl withGeoFilters(Collection<GeoFilter> geoFilters) {
        ArrayList<GeoFilter> list = null;
        if (geoFilters != null) {
            list = new ArrayList<GeoFilter>(geoFilters);
        }
        ((EndpointInner)((Object)this.inner())).withGeoFilters(list);
        return this;
    }

    @Override
    public CdnEndpointImpl withoutGeoFilters() {
        if (((EndpointInner)((Object)this.inner())).geoFilters() != null) {
            ((EndpointInner)((Object)this.inner())).geoFilters().clear();
        }
        return this;
    }

    @Override
    public CdnEndpointImpl withGeoFilter(String relativePath, GeoFilterActions action, CountryIsoCode countryCode) {
        GeoFilter geoFilter = this.createGeoFiltersObject(relativePath, action);
        if (geoFilter.countryCodes() == null) {
            geoFilter.withCountryCodes(new ArrayList<String>());
        }
        geoFilter.countryCodes().add(countryCode.toString());
        ((EndpointInner)((Object)this.inner())).geoFilters().add(geoFilter);
        return this;
    }

    @Override
    public CdnEndpointImpl withGeoFilter(String relativePath, GeoFilterActions action, Collection<CountryIsoCode> countryCodes) {
        GeoFilter geoFilter = this.createGeoFiltersObject(relativePath, action);
        if (geoFilter.countryCodes() == null) {
            geoFilter.withCountryCodes(new ArrayList<String>());
        } else {
            geoFilter.countryCodes().clear();
        }
        for (CountryIsoCode countryCode : countryCodes) {
            geoFilter.countryCodes().add(countryCode.toString());
        }
        ((EndpointInner)((Object)this.inner())).geoFilters().add(geoFilter);
        return this;
    }

    @Override
    public CdnEndpointImpl withoutGeoFilter(String relativePath) {
        ListIterator<GeoFilter> iter = ((EndpointInner)((Object)this.inner())).geoFilters().listIterator();
        while (iter.hasNext()) {
            GeoFilter geoFilter = (GeoFilter)iter.next();
            if (!geoFilter.relativePath().equals(relativePath)) continue;
            iter.remove();
        }
        return this;
    }

    @Override
    public CdnEndpointImpl withCustomDomain(String hostName) {
        if (this.customDomainList == null) {
            this.customDomainList = new ArrayList<CustomDomainInner>();
        }
        this.customDomainList.add(new CustomDomainInner().withHostName(hostName));
        return this;
    }

    @Override
    public CdnEndpointImpl withoutCustomDomain(String hostName) {
        ListIterator<CustomDomainInner> iter = this.customDomainList.listIterator();
        while (iter.hasNext()) {
            CustomDomainInner customDomain = (CustomDomainInner)iter.next();
            if (!hostName.equals(customDomain.hostName())) continue;
            iter.remove();
            this.deletedCustomDomainList.add(customDomain);
        }
        return this;
    }

    private GeoFilter createGeoFiltersObject(String relativePath, GeoFilterActions action) {
        if (((EndpointInner)((Object)this.inner())).geoFilters() == null) {
            ((EndpointInner)((Object)this.inner())).withGeoFilters(new ArrayList<GeoFilter>());
        }
        GeoFilter geoFilter = null;
        for (GeoFilter filter : ((EndpointInner)((Object)this.inner())).geoFilters()) {
            if (!filter.relativePath().equals(relativePath)) continue;
            geoFilter = filter;
            break;
        }
        if (geoFilter == null) {
            geoFilter = new GeoFilter();
        } else {
            ((EndpointInner)((Object)this.inner())).geoFilters().remove(geoFilter);
        }
        geoFilter.withRelativePath(relativePath).withAction(action);
        return geoFilter;
    }
}

