/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerregistry.implementation;

import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.containerregistry.Registries;
import com.microsoft.azure.management.containerregistry.Webhook;
import com.microsoft.azure.management.containerregistry.implementation.ContainerRegistryManagementClientImpl;
import com.microsoft.azure.management.containerregistry.implementation.ContainerRegistryManager;
import com.microsoft.azure.management.containerregistry.implementation.RegistryImpl;
import com.microsoft.azure.management.containerregistry.implementation.WebhookImpl;
import com.microsoft.azure.management.containerregistry.implementation.WebhookInner;
import com.microsoft.azure.management.containerregistry.implementation.WebhooksInner;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
public class WebhooksClientImpl
implements Registries.WebhooksClient {
    private final ContainerRegistryManager containerRegistryManager;
    private final RegistryImpl containerRegistry;

    WebhooksClientImpl(ContainerRegistryManager containerRegistryManager, RegistryImpl containerRegistry) {
        this.containerRegistryManager = containerRegistryManager;
        this.containerRegistry = containerRegistry;
    }

    @Override
    public Webhook get(String resourceGroupName, String registryName, String webhookName) {
        return (Webhook)this.getAsync(resourceGroupName, registryName, webhookName).toBlocking().single();
    }

    @Override
    public Observable<Webhook> getAsync(final String resourceGroupName, final String registryName, final String webhookName) {
        final WebhooksClientImpl self = this;
        WebhooksInner webhooksInner = ((ContainerRegistryManagementClientImpl)((Object)this.containerRegistryManager.inner())).webhooks();
        return webhooksInner.getAsync(resourceGroupName, registryName, webhookName).map((Func1)new Func1<WebhookInner, WebhookImpl>(){

            public WebhookImpl call(WebhookInner webhookInner) {
                if (self.containerRegistry != null) {
                    return new WebhookImpl(webhookName, self.containerRegistry, webhookInner, self.containerRegistryManager);
                }
                return new WebhookImpl(resourceGroupName, registryName, webhookName, webhookInner, self.containerRegistryManager);
            }
        }).flatMap((Func1)new Func1<WebhookImpl, Observable<Webhook>>(){

            public Observable<Webhook> call(WebhookImpl webhook) {
                return webhook.setCallbackConfigAsync();
            }
        });
    }

    @Override
    public void delete(String resourceGroupName, String registryName, String webhookName) {
        ((ContainerRegistryManagementClientImpl)((Object)this.containerRegistryManager.inner())).webhooks().delete(resourceGroupName, registryName, webhookName);
    }

    @Override
    public Completable deleteAsync(String resourceGroupName, String registryName, String webhookName) {
        return ((ContainerRegistryManagementClientImpl)((Object)this.containerRegistryManager.inner())).webhooks().deleteAsync(resourceGroupName, registryName, webhookName).toCompletable();
    }

    @Override
    public PagedList<Webhook> list(final String resourceGroupName, final String registryName) {
        final WebhooksClientImpl self = this;
        PagedListConverter<WebhookInner, Webhook> converter = new PagedListConverter<WebhookInner, Webhook>(){

            public Observable<Webhook> typeConvertAsync(WebhookInner inner) {
                if (self.containerRegistry != null) {
                    return new WebhookImpl(inner.name(), self.containerRegistry, inner, self.containerRegistryManager).setCallbackConfigAsync();
                }
                return Observable.just((Object)new WebhookImpl(resourceGroupName, registryName, inner.name(), inner, self.containerRegistryManager));
            }
        };
        return converter.convert(((ContainerRegistryManagementClientImpl)((Object)this.containerRegistryManager.inner())).webhooks().list(resourceGroupName, registryName));
    }

    @Override
    public Observable<Webhook> listAsync(final String resourceGroupName, final String registryName) {
        final WebhooksClientImpl self = this;
        WebhooksInner webhooksInner = ((ContainerRegistryManagementClientImpl)((Object)this.containerRegistryManager.inner())).webhooks();
        return webhooksInner.listAsync(resourceGroupName, registryName).flatMap((Func1)new Func1<Page<WebhookInner>, Observable<WebhookInner>>(){

            public Observable<WebhookInner> call(Page<WebhookInner> webhookInnerPage) {
                return Observable.from((Iterable)webhookInnerPage.items());
            }
        }).map((Func1)new Func1<WebhookInner, WebhookImpl>(){

            public WebhookImpl call(WebhookInner inner) {
                if (self.containerRegistry != null) {
                    return new WebhookImpl(inner.name(), self.containerRegistry, inner, self.containerRegistryManager);
                }
                return new WebhookImpl(resourceGroupName, registryName, inner.name(), inner, self.containerRegistryManager);
            }
        }).flatMap((Func1)new Func1<WebhookImpl, Observable<Webhook>>(){

            public Observable<Webhook> call(WebhookImpl webhook) {
                return webhook.setCallbackConfigAsync();
            }
        });
    }
}

