/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web.oauth2;

import java.io.IOException;
import java.net.HttpURLConnection;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.web.oauth2.AccessTokenProvider;
import org.apache.hadoop.hdfs.web.oauth2.ConfCredentialBasedAccessTokenProvider;
import org.apache.hadoop.hdfs.web.oauth2.Utils;
import org.apache.hadoop.security.authentication.client.ConnectionConfigurator;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class OAuth2ConnectionConfigurator
implements ConnectionConfigurator {
    public static final String HEADER = "Bearer ";
    private final AccessTokenProvider accessTokenProvider;
    private ConnectionConfigurator sslConfigurator = null;

    public OAuth2ConnectionConfigurator(Configuration conf) {
        this(conf, null);
    }

    public OAuth2ConnectionConfigurator(Configuration conf, ConnectionConfigurator sslConfigurator) {
        this.sslConfigurator = sslConfigurator;
        Utils.notNull(conf, "dfs.webhdfs.oauth2.access.token.provider");
        Class<AccessTokenProvider> accessTokenProviderClass = conf.getClass("dfs.webhdfs.oauth2.access.token.provider", ConfCredentialBasedAccessTokenProvider.class, AccessTokenProvider.class);
        this.accessTokenProvider = ReflectionUtils.newInstance(accessTokenProviderClass, conf);
        this.accessTokenProvider.setConf(conf);
    }

    @Override
    public HttpURLConnection configure(HttpURLConnection conn) throws IOException {
        if (this.sslConfigurator != null) {
            this.sslConfigurator.configure(conn);
        }
        String accessToken = this.accessTokenProvider.getAccessToken();
        conn.setRequestProperty("AUTHORIZATION", HEADER + accessToken);
        return conn;
    }
}

