/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.ha;

import java.nio.charset.Charset;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.hadoop.conf.Configuration;
import org.apache.ranger.ha.CuratorFactory;
import org.apache.ranger.ha.HAConfiguration;
import org.apache.ranger.ha.ZookeeperSecurityProperties;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveInstanceState {
    private final Configuration configuration;
    private final CuratorFactory curatorFactory;
    private static final Logger LOG = LoggerFactory.getLogger(ActiveInstanceState.class);

    public ActiveInstanceState(Configuration configuration, CuratorFactory curatorFactory) {
        this.configuration = configuration;
        this.curatorFactory = curatorFactory;
    }

    public void update(String serverId) throws Exception {
        try {
            Stat serverInfo;
            CuratorFramework client = this.curatorFactory.clientInstance();
            HAConfiguration.ZookeeperProperties zookeeperProperties = HAConfiguration.getZookeeperProperties(this.configuration);
            String rangerServiceServerAddress = HAConfiguration.getBoundAddressForId(this.configuration, serverId);
            LOG.info("rangerServiceServerAddress : " + rangerServiceServerAddress);
            ArrayList<ACL> acls = new ArrayList<ACL>();
            ACL parsedACL = ZookeeperSecurityProperties.parseAcl(zookeeperProperties.getAcl(), (ACL)ZooDefs.Ids.OPEN_ACL_UNSAFE.get(0));
            acls.add(parsedACL);
            if (StringUtils.isNotEmpty((CharSequence)zookeeperProperties.getAcl())) {
                ACL worldReadPermissionACL = new ACL(1, new Id("world", "anyone"));
                acls.add(worldReadPermissionACL);
            }
            if ((serverInfo = (Stat)client.checkExists().forPath(this.getZnodePath(zookeeperProperties))) == null) {
                ((BackgroundPathAndBytesable)((ACLBackgroundPathAndBytesable)client.create().withMode(CreateMode.EPHEMERAL)).withACL(acls)).forPath(this.getZnodePath(zookeeperProperties));
            } else {
                long sessionId = client.getZookeeperClient().getZooKeeper().getSessionId();
                if (sessionId != serverInfo.getEphemeralOwner()) {
                    throw new Exception("Not a leader forces it to rejoin the election ");
                }
            }
            client.setData().forPath(this.getZnodePath(zookeeperProperties), rangerServiceServerAddress.getBytes(Charset.forName("UTF-8")));
        }
        catch (Exception e) {
            throw new Exception("ActiveInstanceState.update resulted in exception. forPath: getZnodePath ", e);
        }
    }

    private String getZnodePath(HAConfiguration.ZookeeperProperties zookeeperProperties) {
        return zookeeperProperties.getZkRoot() + "/active_server_info";
    }

    public String getActiveServerAddress() {
        CuratorFramework client = this.curatorFactory.clientInstance();
        String serverAddress = null;
        try {
            HAConfiguration.ZookeeperProperties zookeeperProperties = HAConfiguration.getZookeeperProperties(this.configuration);
            byte[] bytes = (byte[])client.getData().forPath(this.getZnodePath(zookeeperProperties));
            serverAddress = new String(bytes, Charset.forName("UTF-8"));
        }
        catch (Exception e) {
            LOG.error("Error getting active server address", (Throwable)e);
        }
        return serverAddress;
    }
}

