/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AbstractScope;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.Es6SyntacticScopeCreator;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.ScopeCreator;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class IncrementalScopeCreator
implements ScopeCreator {
    private final AbstractCompiler compiler;
    private final Map<Node, PersistentScope> scopesByScopeRoot = new HashMap<Node, PersistentScope>();
    private final Es6SyntacticScopeCreator delegate;
    private final PersistentScopeFactory factory = new PersistentScopeFactory();
    private boolean frozen;
    private static final ImmutableList<PersistentLocalScope> PRIMORDIAL_LIST = ImmutableList.of();

    private IncrementalScopeCreator(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.delegate = this.createInternalScopeCreator(compiler);
    }

    public static IncrementalScopeCreator getInstance(AbstractCompiler compiler) {
        IncrementalScopeCreator creator = compiler.getScopeCreator();
        if (creator == null) {
            creator = new IncrementalScopeCreator(compiler);
            compiler.putScopeCreator(creator);
        }
        return creator;
    }

    public IncrementalScopeCreator freeze() {
        Preconditions.checkState(!this.frozen, "inconsistent freeze state: already frozen");
        this.frozen = true;
        this.invalidateChangedScopes();
        return this;
    }

    public IncrementalScopeCreator thaw() {
        Preconditions.checkState(this.frozen, "inconsistent freeze state: already thaw'd");
        this.frozen = false;
        return this;
    }

    private void invalidateChangedScopes() {
        List<Node> changedRoots = this.compiler.getChangedScopeNodesForPass("Scopes");
        ArrayList<Node> scripts = new ArrayList<Node>();
        if (changedRoots != null) {
            for (Node root : changedRoots) {
                if (root.isScript()) {
                    scripts.add(root);
                    continue;
                }
                Preconditions.checkState(!root.isRoot());
                this.invalidateRoot(root);
            }
            this.invalidateScripts(scripts);
        }
    }

    private void invalidateScripts(List<Node> invalidatedScripts) {
        Node root;
        PersistentGlobalScope scope;
        if (!invalidatedScripts.isEmpty() && (scope = (PersistentGlobalScope)this.scopesByScopeRoot.get(root = this.compiler.getRoot())) != null) {
            scope.invalidate(invalidatedScripts);
        }
    }

    private void invalidateRoot(Node n) {
        PersistentLocalScope scope = (PersistentLocalScope)this.scopesByScopeRoot.get(n);
        if (scope != null) {
            scope.invalidate();
        }
    }

    public Scope createScope(Node n, AbstractScope<?, ?> parent) {
        Preconditions.checkState(parent == null || parent instanceof PersistentScope);
        Preconditions.checkState(parent == null || ((PersistentScope)parent).isValid(), "parent is not valid");
        Preconditions.checkState(this.frozen, "freeze() must be called before retrieving scopes");
        Preconditions.checkArgument(parent != null || n == this.compiler.getRoot(), "the shared persistent scope must always be root at the tip of the AST");
        PersistentScope scope = this.scopesByScopeRoot.get(n);
        if (scope == null) {
            scope = (PersistentScope)this.delegate.createScope(n, (AbstractScope)parent);
            this.scopesByScopeRoot.put(n, scope);
        } else {
            scope.refresh(this.compiler, (PersistentScope)parent);
        }
        Preconditions.checkState(scope.isValid(), "scope is not valid");
        return scope;
    }

    @Override
    public boolean hasBlockScope() {
        return this.delegate.hasBlockScope();
    }

    Es6SyntacticScopeCreator createInternalScopeCreator(AbstractCompiler compiler) {
        return new Es6SyntacticScopeCreator(compiler, this.factory, this.factory);
    }

    private static class PersistentScopeFactory
    implements Es6SyntacticScopeCreator.ScopeFactory,
    Es6SyntacticScopeCreator.RedeclarationHandler {
        private PersistentScopeFactory() {
        }

        @Override
        public PersistentScope create(Scope parent, Node n) {
            return PersistentScope.create((PersistentScope)parent, n);
        }

        @Override
        public void onRedeclaration(Scope s, String name, Node n, CompilerInput input) {
            if (s.isGlobal()) {
                ((PersistentGlobalScope)s).redeclare(n);
            }
        }
    }

    private static class PersistentLocalScope
    extends PersistentScope {
        List<PersistentLocalScope> validChildren = IncrementalScopeCreator.access$100();

        PersistentLocalScope(PersistentScope parent, Node rootNode) {
            super(parent, rootNode);
            parent.addChildScope(this);
        }

        @Override
        void addChildScope(PersistentLocalScope scope) {
            if (!NodeUtil.isChangeScopeRoot(scope.getRootNode())) {
                if (this.validChildren == PRIMORDIAL_LIST) {
                    this.validChildren = new ArrayList<PersistentLocalScope>();
                }
                this.validChildren.add(scope);
            }
        }

        @Override
        public boolean isValid() {
            return this.valid;
        }

        void invalidate() {
            if (this.valid) {
                this.valid = false;
                for (PersistentLocalScope child : this.validChildren) {
                    Preconditions.checkState(!NodeUtil.isChangeScopeRoot(child.getRootNode()));
                    child.invalidate();
                }
                if (this.validChildren != PRIMORDIAL_LIST) {
                    this.validChildren.clear();
                }
            }
        }

        @Override
        void refresh(AbstractCompiler compiler, PersistentScope newParent) {
            Preconditions.checkArgument(newParent != null && newParent.isValid());
            Preconditions.checkState(this.parent != null);
            this.parent = newParent;
            this.depth = this.parent.getDepth() + 1;
            if (!this.valid) {
                this.clearVarsInternal();
                new Es6SyntacticScopeCreator.ScopeScanner(compiler, this).populate();
                this.valid = true;
                this.getParent().addChildScope(this);
            }
        }
    }

    private static class PersistentGlobalScope
    extends PersistentScope {
        Multimap<Node, PersistentLocalScope> validChildren = ArrayListMultimap.create();
        Set<Node> scriptsToUpdate = new HashSet<Node>();
        Multimap<Node, Var> scriptToVarMap = ArrayListMultimap.create();
        Multimap<Node, Node> scriptDeclarationsPairs = HashMultimap.create();
        PersistentScopeFactory factory = new PersistentScopeFactory();

        protected PersistentGlobalScope(Node rootNode) {
            super(rootNode);
            Preconditions.checkArgument(rootNode.isRoot() && rootNode.getParent() == null);
        }

        @Override
        void addChildScope(PersistentLocalScope scope) {
            if (!NodeUtil.isChangeScopeRoot(scope.getRootNode())) {
                Node script = this.getContainingScript(scope.getRootNode());
                Preconditions.checkState(script.isScript());
                this.validChildren.put(script, scope);
            }
        }

        public void invalidate(List<Node> invalidatedScripts) {
            this.valid = false;
            for (Node script : invalidatedScripts) {
                Preconditions.checkState(script.isScript());
                for (PersistentLocalScope scope : this.validChildren.removeAll(script)) {
                    scope.invalidate();
                }
            }
            this.scriptsToUpdate.addAll(invalidatedScripts);
        }

        @Override
        void refresh(AbstractCompiler compiler, PersistentScope newParent) {
            Preconditions.checkArgument(newParent == null);
            if (!this.valid) {
                Preconditions.checkState(!this.scriptsToUpdate.isEmpty());
                this.expandInvalidatedScriptPairs();
                this.clearPairsForInvalidatedScripts();
                this.undeclareVarsForInvalidatedScripts();
                new Es6SyntacticScopeCreator.ScopeScanner(compiler, this.factory, this, this.scriptsToUpdate).populate();
                this.scriptsToUpdate.clear();
                this.valid = true;
            } else {
                Preconditions.checkState(this.scriptsToUpdate.isEmpty());
            }
        }

        void expandInvalidatedScriptPairs() {
            ArrayList<Node> scripts = new ArrayList<Node>(this.scriptsToUpdate);
            for (Node script : scripts) {
                this.expandInvalidatedScript(script);
            }
        }

        void expandInvalidatedScript(Node script) {
            Collection<Node> pairs = this.scriptDeclarationsPairs.get(script);
            for (Node n : pairs) {
                if (!this.scriptsToUpdate.add(n)) continue;
                this.expandInvalidatedScript(script);
            }
        }

        void clearPairsForInvalidatedScripts() {
            for (Node script : this.scriptsToUpdate) {
                this.scriptDeclarationsPairs.removeAll(script);
            }
        }

        void undeclareVarsForInvalidatedScripts() {
            for (Node script : this.scriptsToUpdate) {
                for (Var var : this.scriptToVarMap.removeAll(script)) {
                    super.undeclareInteral(var);
                }
            }
        }

        Node getContainingScript(Node n) {
            while (!n.isScript()) {
                n = n.getParent();
            }
            return n;
        }

        @Override
        Var declare(String name, Node nameNode, CompilerInput input) {
            Node declareScript = this.getContainingScript(nameNode);
            Var v = super.declare(name, nameNode, input);
            this.scriptToVarMap.put(declareScript, v);
            return v;
        }

        public void redeclare(Node n) {
            Preconditions.checkArgument(n.isName());
            String name = n.getString();
            Preconditions.checkArgument(!"arguments".equals(name));
            Node redeclareScript = this.getContainingScript(n);
            Var v = (Var)this.getOwnSlot(name);
            Node declarationScript = this.getContainingScript(v.getNode());
            if (redeclareScript != declarationScript) {
                this.scriptDeclarationsPairs.put(redeclareScript, declarationScript);
                this.scriptDeclarationsPairs.put(declarationScript, redeclareScript);
            }
        }
    }

    private static abstract class PersistentScope
    extends Scope {
        boolean valid = true;
        PersistentScope parent;
        int depth;

        PersistentScope(PersistentScope parent, Node rootNode) {
            super(rootNode);
            this.checkChildScope(parent);
            this.parent = parent;
            this.depth = parent.depth + 1;
        }

        PersistentScope(Node rootNode) {
            super(rootNode);
            Preconditions.checkArgument(rootNode.isRoot());
            this.parent = null;
            this.depth = 0;
        }

        static PersistentScope create(PersistentScope parent, Node rootNode) {
            if (parent == null) {
                Preconditions.checkArgument(rootNode.isRoot() && rootNode.getParent() == null, rootNode);
                return new PersistentGlobalScope(rootNode);
            }
            return new PersistentLocalScope(parent, rootNode);
        }

        public boolean isValid() {
            return this.valid;
        }

        @Override
        public PersistentScope getParent() {
            Preconditions.checkState(this.parent == null || this.parent.valid, "parent scope is not valid");
            return this.parent;
        }

        @Override
        public int getDepth() {
            return this.depth;
        }

        abstract void refresh(AbstractCompiler var1, PersistentScope var2);

        abstract void addChildScope(PersistentLocalScope var1);
    }
}

