/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js.jx;

import org.apache.royale.abc.ABCConstants;
import org.apache.royale.abc.semantics.Namespace;
import org.apache.royale.compiler.codegen.ISubEmitter;
import org.apache.royale.compiler.codegen.js.IJSEmitter;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.definitions.IAccessorDefinition;
import org.apache.royale.compiler.definitions.IConstantDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IFunctionDefinition;
import org.apache.royale.compiler.definitions.INamespaceDefinition;
import org.apache.royale.compiler.definitions.IPackageDefinition;
import org.apache.royale.compiler.definitions.IParameterDefinition;
import org.apache.royale.compiler.definitions.IVariableDefinition;
import org.apache.royale.compiler.definitions.references.INamespaceResolvedReference;
import org.apache.royale.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSSubEmitter;
import org.apache.royale.compiler.internal.codegen.js.goog.JSGoogEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.utils.EmitterUtils;
import org.apache.royale.compiler.internal.definitions.AccessorDefinition;
import org.apache.royale.compiler.internal.definitions.ClassDefinition;
import org.apache.royale.compiler.internal.definitions.FunctionDefinition;
import org.apache.royale.compiler.internal.definitions.TypeDefinitionBase;
import org.apache.royale.compiler.internal.projects.RoyaleJSProject;
import org.apache.royale.compiler.internal.tree.as.NonResolvingIdentifierNode;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IFunctionCallNode;
import org.apache.royale.compiler.tree.as.IFunctionNode;
import org.apache.royale.compiler.tree.as.IFunctionObjectNode;
import org.apache.royale.compiler.tree.as.IIdentifierNode;
import org.apache.royale.compiler.tree.as.IMemberAccessExpressionNode;
import org.apache.royale.compiler.tree.as.IOperatorNode;
import org.apache.royale.compiler.utils.NativeUtils;

public class IdentifierEmitter
extends JSSubEmitter
implements ISubEmitter<IIdentifierNode> {
    public IdentifierEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    @Override
    public void emit(IIdentifierNode node) {
        IConstantDefinition constDef;
        Object initialValue;
        boolean isStatic;
        if (node instanceof NonResolvingIdentifierNode) {
            this.startMapping((ISourceLocation)node);
            this.write(node.getName());
            this.endMapping((ISourceLocation)node);
            return;
        }
        IDefinition nodeDef = node.resolve(this.getProject());
        IASNode parentNode = node.getParent();
        ASTNodeID parentNodeId = parentNode.getNodeID();
        IASNode grandparentNode = parentNode.getParent();
        boolean identifierIsAccessorFunction = nodeDef instanceof AccessorDefinition;
        boolean identifierIsPlainFunction = nodeDef instanceof FunctionDefinition && !identifierIsAccessorFunction;
        boolean emitName = true;
        boolean wroteMemberAccess = false;
        JSRoyaleEmitter fjs = (JSRoyaleEmitter)this.getEmitter();
        RoyaleJSProject project = (RoyaleJSProject)this.getWalker().getProject();
        boolean isCustomNamespace = false;
        boolean bl = isStatic = nodeDef != null && nodeDef.isStatic();
        if (nodeDef instanceof FunctionDefinition && fjs.isCustomNamespace((FunctionDefinition)nodeDef)) {
            isCustomNamespace = true;
        }
        if (isStatic && nodeDef instanceof IConstantDefinition && project != null && project.config != null && project.config.getInlineConstants() && (initialValue = (constDef = (IConstantDefinition)nodeDef).resolveInitialValue((ICompilerProject)project)) != null) {
            this.emitInitialValue(parentNode, initialValue);
            return;
        }
        if (isStatic) {
            String sname = nodeDef.getParent().getQualifiedName();
            if (sname.length() > 0) {
                if (this.emitStaticConstants(parentNode, nodeDef)) {
                    return;
                }
                this.startMapping((ISourceLocation)node);
                this.write(this.getEmitter().formatQualifiedName(sname));
                if (!isCustomNamespace) {
                    this.write(ASEmitterTokens.MEMBER_ACCESS);
                    wroteMemberAccess = true;
                }
                this.endMapping((ISourceLocation)node);
            }
        } else if (!NativeUtils.isNative(node.getName())) {
            boolean generateClosure;
            boolean bl2 = generateClosure = identifierIsPlainFunction && ((FunctionDefinition)nodeDef).getFunctionClassification() == IFunctionDefinition.FunctionClassification.CLASS_MEMBER && parentNodeId != ASTNodeID.FunctionCallID && parentNodeId != ASTNodeID.MemberAccessExpressionID;
            if (generateClosure) {
                this.getEmitter().emitClosureStart();
            }
            boolean wroteSelf = false;
            if (EmitterUtils.writeThis(this.getProject(), this.getModel(), node)) {
                IFunctionObjectNode functionObjectNode = (IFunctionObjectNode)node.getParent().getAncestorOfType(IFunctionObjectNode.class);
                IFunctionNode functionNode = (IFunctionNode)node.getParent().getAncestorOfType(IFunctionNode.class);
                IFunctionDefinition functionDef = null;
                if (functionNode != null) {
                    functionDef = functionNode.getDefinition();
                }
                this.startMapping((ISourceLocation)node);
                if (functionObjectNode != null) {
                    this.write(JSGoogEmitterTokens.SELF);
                    wroteSelf = true;
                } else if (functionNode != null && functionDef.getFunctionClassification() == IFunctionDefinition.FunctionClassification.LOCAL) {
                    this.write(JSGoogEmitterTokens.SELF);
                    wroteSelf = true;
                } else {
                    this.write(ASEmitterTokens.THIS);
                }
                if (!isCustomNamespace) {
                    this.write(ASEmitterTokens.MEMBER_ACCESS);
                    wroteMemberAccess = true;
                }
                this.endMapping((ISourceLocation)node);
            } else if (EmitterUtils.writeE4xFilterNode(this.getProject(), this.getModel(), (IExpressionNode)node)) {
                this.startMapping((ISourceLocation)node);
                this.write("node.");
                this.endMapping((ISourceLocation)node);
            }
            if (generateClosure) {
                if (isCustomNamespace) {
                    Namespace ns = ((INamespaceResolvedReference)((FunctionDefinition)nodeDef).getNamespaceReference()).resolveAETNamespace(this.getProject());
                    INamespaceDefinition nsDef = ((FunctionDefinition)nodeDef).getNamespaceReference().resolveNamespaceReference(this.getProject());
                    fjs.formatQualifiedName(nsDef.getQualifiedName());
                    String nsName = ns.getName();
                    this.write(JSRoyaleEmitter.formatNamespacedProperty(nsName, node.getName(), true));
                } else {
                    String qname = node.getName();
                    if (nodeDef != null && !isStatic && !(nodeDef instanceof IParameterDefinition) && nodeDef.isPrivate() && this.getProject().getAllowPrivateNameConflicts()) {
                        qname = this.getEmitter().formatPrivateName(nodeDef.getParent().getQualifiedName(), qname);
                    }
                    this.write(qname);
                }
                this.writeToken(ASEmitterTokens.COMMA);
                if (wroteSelf) {
                    this.write(JSGoogEmitterTokens.SELF);
                } else {
                    this.write(ASEmitterTokens.THIS);
                }
                this.getEmitter().emitClosureEnd((IASNode)node, nodeDef);
                emitName = false;
            }
        }
        if (emitName) {
            boolean accessWithNS;
            boolean bl3 = accessWithNS = !wroteMemberAccess;
            if (nodeDef != null) {
                String ns;
                IFunctionDefinition func;
                IVariableDefinition.VariableClassification classification;
                String qname = nodeDef.getQualifiedName();
                boolean isPackageOrFileMember = false;
                if (nodeDef instanceof IVariableDefinition) {
                    String ns2;
                    IVariableDefinition variable = (IVariableDefinition)nodeDef;
                    classification = variable.getVariableClassification();
                    if (classification == IVariableDefinition.VariableClassification.PACKAGE_MEMBER || classification == IVariableDefinition.VariableClassification.FILE_MEMBER) {
                        isPackageOrFileMember = true;
                    }
                    if ((isCustomNamespace = EmitterUtils.isCustomNamespace(ns2 = nodeDef.getNamespaceReference().getBaseName())) && parentNode instanceof IMemberAccessExpressionNode && ((IMemberAccessExpressionNode)parentNode).getRightOperandNode() == node) {
                        accessWithNS = true;
                        boolean wasCustomNamespace = false;
                        if (nodeDef instanceof IAccessorDefinition && ((IMemberAccessExpressionNode)parentNode).getOperator() == IOperatorNode.OperatorType.MEMBER_ACCESS) {
                            wasCustomNamespace = fjs.isCustomNamespace((FunctionDefinition)nodeDef);
                        }
                        if (!wasCustomNamespace) {
                            accessWithNS = false;
                        }
                    }
                } else if (nodeDef instanceof IFunctionDefinition && ((classification = (func = (IFunctionDefinition)nodeDef).getFunctionClassification()) == IFunctionDefinition.FunctionClassification.PACKAGE_MEMBER || classification == IFunctionDefinition.FunctionClassification.FILE_MEMBER)) {
                    isPackageOrFileMember = true;
                }
                boolean needsFormattedName = false;
                if (isPackageOrFileMember && parentNodeId == ASTNodeID.MemberAccessExpressionID) {
                    IMemberAccessExpressionNode parentMemberAccessNode = (IMemberAccessExpressionNode)parentNode;
                    boolean bl4 = needsFormattedName = parentMemberAccessNode.getLeftOperandNode() == node;
                }
                if (parentNodeId == ASTNodeID.MemberAccessExpressionID) {
                    if (needsFormattedName) {
                        this.startMapping((ISourceLocation)node);
                        this.write(this.getEmitter().formatQualifiedName(qname));
                        this.endMapping((ISourceLocation)node);
                    } else if (isCustomNamespace) {
                        ns = ((INamespaceResolvedReference)nodeDef.getNamespaceReference()).resolveAETNamespace(this.getProject()).getName();
                        if (accessWithNS) {
                            this.write(ASEmitterTokens.MEMBER_ACCESS);
                        }
                        this.startMapping((ISourceLocation)node, node.getName());
                        this.write(JSRoyaleEmitter.formatNamespacedProperty(ns, qname, false));
                        this.endMapping((ISourceLocation)node);
                    } else {
                        String originalQname = null;
                        if (!(nodeDef.getParent() instanceof IPackageDefinition)) {
                            qname = node.getName();
                            if (nodeDef != null && !isStatic && nodeDef.getParent() instanceof ClassDefinition && !(nodeDef instanceof IParameterDefinition) && nodeDef.isPrivate() && this.getProject().getAllowPrivateNameConflicts()) {
                                originalQname = qname;
                                qname = this.getEmitter().formatPrivateName(nodeDef.getParent().getQualifiedName(), qname);
                            }
                        }
                        this.startMapping((ISourceLocation)node, originalQname);
                        this.write(qname);
                        this.endMapping((ISourceLocation)node);
                    }
                } else if (isPackageOrFileMember) {
                    this.startMapping((ISourceLocation)node);
                    this.write(this.getEmitter().formatQualifiedName(qname));
                    this.endMapping((ISourceLocation)node);
                } else if (nodeDef instanceof TypeDefinitionBase) {
                    if (NativeUtils.isSyntheticJSType(qname) && !(parentNode instanceof IFunctionCallNode)) {
                        this.getEmitter().getModel().needLanguage = true;
                        this.write(JSRoyaleEmitterTokens.SYNTH_TYPE);
                        this.write(ASEmitterTokens.PAREN_OPEN);
                        this.write(ASEmitterTokens.SINGLE_QUOTE);
                        this.startMapping((ISourceLocation)node);
                        this.write(this.getEmitter().formatQualifiedName(qname));
                        this.endMapping((ISourceLocation)node);
                        this.write(ASEmitterTokens.SINGLE_QUOTE);
                        this.write(ASEmitterTokens.PAREN_CLOSE);
                    } else {
                        this.startMapping((ISourceLocation)node);
                        this.write(this.getEmitter().formatQualifiedName(qname));
                        this.endMapping((ISourceLocation)node);
                    }
                } else if (isCustomNamespace) {
                    ns = ((INamespaceResolvedReference)nodeDef.getNamespaceReference()).resolveAETNamespace(this.getProject()).getName();
                    if (accessWithNS) {
                        this.write(ASEmitterTokens.MEMBER_ACCESS);
                    }
                    this.startMapping((ISourceLocation)node, node.getName());
                    this.write(JSRoyaleEmitter.formatNamespacedProperty(ns, qname, false));
                    this.endMapping((ISourceLocation)node);
                } else {
                    String originalSymbolName = null;
                    if (nodeDef != null && !isStatic && nodeDef.getParent() instanceof ClassDefinition && !(nodeDef instanceof IParameterDefinition) && nodeDef.isPrivate() && this.getProject().getAllowPrivateNameConflicts()) {
                        qname = this.getEmitter().formatPrivateName(nodeDef.getParent().getQualifiedName(), qname);
                        originalSymbolName = node.getName();
                    }
                    this.startMapping((ISourceLocation)node, originalSymbolName, node.getLine(), node.getColumn());
                    this.write(qname);
                    this.endMapping((ISourceLocation)node);
                }
            } else if (this.getModel().inE4xFilter && EmitterUtils.writeE4xFilterNode(this.getProject(), this.getModel(), (IExpressionNode)node) && parentNodeId != ASTNodeID.MemberAccessExpressionID && parentNodeId != ASTNodeID.Op_DescendantsID && parentNodeId != ASTNodeID.FunctionCallID) {
                this.startMapping((ISourceLocation)node);
                this.write("child('");
                this.write(node.getName());
                this.write("')");
                this.endMapping((ISourceLocation)node);
            } else {
                this.startMapping((ISourceLocation)node);
                this.write(node.getName());
                this.endMapping((ISourceLocation)node);
            }
        }
    }

    private void emitInitialValue(IASNode parentNode, Object initialValue) {
        this.startMapping((ISourceLocation)parentNode);
        if (initialValue instanceof String) {
            this.write(ASEmitterTokens.DOUBLE_QUOTE);
            this.write((String)initialValue);
            this.write(ASEmitterTokens.DOUBLE_QUOTE);
        } else if (initialValue == ABCConstants.UNDEFINED_VALUE) {
            this.write("undefined");
        } else if (initialValue == ABCConstants.NULL_VALUE) {
            this.write("null");
        } else {
            this.write(initialValue.toString());
        }
        this.endMapping((ISourceLocation)parentNode);
    }

    private boolean emitStaticConstants(IASNode parentNode, IDefinition nodeDef) {
        String baseName;
        String sname = nodeDef.getParent().getQualifiedName();
        return sname.equals("Array") ? this.emitArrayConstant(parentNode, baseName = nodeDef.getBaseName()) : (sname.equals("int") ? this.emitIntConstant(parentNode, baseName = nodeDef.getBaseName()) : sname.equals("uint") && this.emitUintConstant(parentNode, baseName = nodeDef.getBaseName()));
    }

    private boolean emitArrayConstant(IASNode parentNode, String baseName) {
        if (baseName.equals("CASEINSENSITIVE")) {
            this.startMapping((ISourceLocation)parentNode);
            this.write("1");
            this.endMapping((ISourceLocation)parentNode);
            return true;
        }
        if (baseName.equals("DESCENDING")) {
            this.startMapping((ISourceLocation)parentNode);
            this.write("2");
            this.endMapping((ISourceLocation)parentNode);
            return true;
        }
        if (baseName.equals("UNIQUESORT")) {
            this.startMapping((ISourceLocation)parentNode);
            this.write("4");
            this.endMapping((ISourceLocation)parentNode);
            return true;
        }
        if (baseName.equals("RETURNINDEXEDARRAY")) {
            this.startMapping((ISourceLocation)parentNode);
            this.write("8");
            this.endMapping((ISourceLocation)parentNode);
            return true;
        }
        if (baseName.equals("NUMERIC")) {
            this.startMapping((ISourceLocation)parentNode);
            this.write("16");
            this.endMapping((ISourceLocation)parentNode);
            return true;
        }
        return false;
    }

    private boolean emitIntConstant(IASNode parentNode, String baseName) {
        if (baseName.equals("MAX_VALUE")) {
            this.startMapping((ISourceLocation)parentNode);
            this.write("2147483647");
            this.endMapping((ISourceLocation)parentNode);
            return true;
        }
        if (baseName.equals("MIN_VALUE")) {
            this.startMapping((ISourceLocation)parentNode);
            this.write("-2147483648");
            this.endMapping((ISourceLocation)parentNode);
            return true;
        }
        return false;
    }

    private boolean emitUintConstant(IASNode parentNode, String baseName) {
        if (baseName.equals("MAX_VALUE")) {
            this.startMapping((ISourceLocation)parentNode);
            this.write("4294967295");
            this.endMapping((ISourceLocation)parentNode);
            return true;
        }
        if (baseName.equals("MIN_VALUE")) {
            this.startMapping((ISourceLocation)parentNode);
            this.write("0");
            this.endMapping((ISourceLocation)parentNode);
            return true;
        }
        return false;
    }
}

