/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config;

import com.netflix.config.AbstractPollingScheduler;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class FixedDelayPollingScheduler
extends AbstractPollingScheduler {
    private ScheduledExecutorService executor;
    private int initialDelayMillis = 30000;
    private int delayMillis = 60000;
    public static final String INITIAL_DELAY_PROPERTY = "archaius.fixedDelayPollingScheduler.initialDelayMills";
    public static final String DELAY_PROPERTY = "archaius.fixedDelayPollingScheduler.delayMills";

    public FixedDelayPollingScheduler() {
        String delayProperty;
        String initialDelayProperty = System.getProperty(INITIAL_DELAY_PROPERTY);
        if (initialDelayProperty != null && initialDelayProperty.length() > 0) {
            this.initialDelayMillis = Integer.parseInt(initialDelayProperty);
        }
        if ((delayProperty = System.getProperty(DELAY_PROPERTY)) != null && delayProperty.length() > 0) {
            this.delayMillis = Integer.parseInt(delayProperty);
        }
    }

    public FixedDelayPollingScheduler(int initialDelayMillis, int delayMillis, boolean ignoreDeletesFromSource) {
        super(ignoreDeletesFromSource);
        this.initialDelayMillis = initialDelayMillis;
        this.delayMillis = delayMillis;
    }

    @Override
    protected synchronized void schedule(Runnable runnable) {
        this.executor = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "pollingConfigurationSource");
                t.setDaemon(true);
                return t;
            }
        });
        this.executor.scheduleWithFixedDelay(runnable, this.initialDelayMillis, this.delayMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public void stop() {
        if (this.executor != null) {
            this.executor.shutdown();
            this.executor = null;
        }
    }
}

