/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.command.impl;

import java.util.HashMap;
import java.util.stream.Collectors;
import org.apache.dubbo.common.utils.JsonUtils;
import org.apache.dubbo.qos.api.BaseCommand;
import org.apache.dubbo.qos.api.Cmd;
import org.apache.dubbo.qos.api.CommandContext;
import org.apache.dubbo.qos.command.util.SerializeCheckUtils;
import org.apache.dubbo.rpc.model.FrameworkModel;

@Cmd(name="serializeCheckStatus", summary="get serialize check status")
public class SerializeCheckStatus
implements BaseCommand {
    private final SerializeCheckUtils serializeCheckUtils;

    public SerializeCheckStatus(FrameworkModel frameworkModel) {
        this.serializeCheckUtils = frameworkModel.getBeanFactory().getBean(SerializeCheckUtils.class);
    }

    @Override
    public String execute(CommandContext commandContext, String[] args) {
        if (commandContext.isHttp()) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("checkStatus", (Object)this.serializeCheckUtils.getStatus());
            result.put("checkSerializable", this.serializeCheckUtils.isCheckSerializable());
            result.put("allowedPrefix", this.serializeCheckUtils.getAllowedList());
            result.put("disAllowedPrefix", this.serializeCheckUtils.getDisAllowedList());
            return JsonUtils.toJson(result);
        }
        return "CheckStatus: " + (Object)((Object)this.serializeCheckUtils.getStatus()) + "\n\nCheckSerializable: " + this.serializeCheckUtils.isCheckSerializable() + "\n\nAllowedPrefix:\n" + this.serializeCheckUtils.getAllowedList().stream().sorted().collect(Collectors.joining("\n")) + "\n\nDisAllowedPrefix:\n" + this.serializeCheckUtils.getDisAllowedList().stream().sorted().collect(Collectors.joining("\n")) + "\n\n";
    }
}

