/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ConcurrentHashMapUtils;
import org.apache.dubbo.common.utils.JsonUtils;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.InstanceMetadataChangedListener;
import org.apache.dubbo.metadata.MetadataService;
import org.apache.dubbo.metadata.RevisionResolver;
import org.apache.dubbo.registry.client.AbstractServiceDiscovery;
import org.apache.dubbo.registry.client.DefaultServiceInstance;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.event.ServiceInstancesChangedEvent;
import org.apache.dubbo.registry.client.event.listener.ServiceInstancesChangedListener;
import org.apache.dubbo.registry.client.metadata.MetadataServiceDelegation;
import org.apache.dubbo.registry.client.metadata.MetadataUtils;
import org.apache.dubbo.registry.client.metadata.ServiceInstanceMetadataUtils;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ScopeModelUtil;
import org.apache.dubbo.rpc.service.Destroyable;

public class ReflectionBasedServiceDiscovery
extends AbstractServiceDiscovery {
    private final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(this.getClass());
    private final ScheduledExecutorService echoCheckExecutor = Executors.newScheduledThreadPool(1, new NamedThreadFactory("Dubbo-Registry-EchoCheck-Consumer"));
    private String lastMetadataRevision;
    private final ConcurrentHashMap<String, String> metadataMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, List<ServiceInstance>> cachedServiceInstances = new ConcurrentHashMap();
    private final MetadataServiceDelegation metadataService;
    public ConcurrentMap<String, MetadataService> metadataServiceProxies = new ConcurrentHashMap<String, MetadataService>();
    private final ConcurrentHashMap<String, String> serviceInstanceRevisionMap = new ConcurrentHashMap();

    public ReflectionBasedServiceDiscovery(ApplicationModel applicationModel, URL registryURL) {
        super(applicationModel, registryURL);
        long echoPollingCycle = registryURL.getParameter("echoPollingCycle", 60000);
        this.metadataService = applicationModel.getBeanFactory().getOrRegisterBean(MetadataServiceDelegation.class);
        this.echoCheckExecutor.scheduleAtFixedRate(() -> {
            Map<String, InstanceMetadataChangedListener> listenerMap = this.metadataService.getInstanceMetadataChangedListenerMap();
            Iterator<Map.Entry<String, InstanceMetadataChangedListener>> iterator = listenerMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, InstanceMetadataChangedListener> entry = iterator.next();
                try {
                    entry.getValue().echo("dubbo");
                }
                catch (RpcException e) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Send echo message to consumer error. Possible cause: consumer is offline.");
                    }
                    iterator.remove();
                }
            }
        }, echoPollingCycle, echoPollingCycle, TimeUnit.MILLISECONDS);
    }

    public void doInitialize(URL registryURL) {
    }

    @Override
    public void doDestroy() throws Exception {
        this.metadataMap.clear();
        this.serviceInstanceRevisionMap.clear();
        this.echoCheckExecutor.shutdown();
    }

    private void updateInstanceMetadata(ServiceInstance serviceInstance) {
        String metadataString = JsonUtils.toJson(serviceInstance.getMetadata());
        String metadataRevision = RevisionResolver.calRevision(metadataString);
        if (!metadataRevision.equalsIgnoreCase(this.lastMetadataRevision)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Update Service Instance Metadata of DNS registry. Newer metadata: " + metadataString);
            }
            this.lastMetadataRevision = metadataRevision;
            this.metadataService.exportInstanceMetadata(metadataString);
            Map<String, InstanceMetadataChangedListener> listenerMap = this.metadataService.getInstanceMetadataChangedListenerMap();
            Iterator<Map.Entry<String, InstanceMetadataChangedListener>> iterator = listenerMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, InstanceMetadataChangedListener> entry = iterator.next();
                try {
                    entry.getValue().onEvent(metadataString);
                }
                catch (RpcException e) {
                    this.logger.warn("1-7", "consumer is offline", "", "Notify to consumer error, removing listener.");
                    iterator.remove();
                }
            }
        }
    }

    @Override
    public void doRegister(ServiceInstance serviceInstance) throws RuntimeException {
        this.updateInstanceMetadata(serviceInstance);
    }

    @Override
    public void doUnregister(ServiceInstance serviceInstance) throws RuntimeException {
        this.metadataService.exportInstanceMetadata("");
        this.metadataService.getInstanceMetadataChangedListenerMap().forEach((consumerId, listener) -> listener.onEvent(""));
        this.metadataService.getInstanceMetadataChangedListenerMap().clear();
    }

    public final void fillServiceInstance(DefaultServiceInstance serviceInstance) {
        String hostId = serviceInstance.getAddress();
        if (this.metadataMap.containsKey(hostId)) {
            String metadataString2 = this.metadataMap.get(hostId);
            serviceInstance.setMetadata((Map)JsonUtils.toJavaObject(metadataString2, Map.class));
        } else {
            MetadataService metadataService = this.getMetadataServiceProxy(serviceInstance);
            String consumerId = ScopeModelUtil.getApplicationModel(this.registryURL.getScopeModel()).getApplicationName() + NetUtils.getLocalHost();
            String metadata = metadataService.getAndListenInstanceMetadata(consumerId, metadataString -> {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Receive callback: " + metadataString + serviceInstance);
                }
                if (StringUtils.isEmpty(metadataString)) {
                    this.metadataMap.remove(hostId);
                } else {
                    this.metadataMap.put(hostId, metadataString);
                }
            });
            this.metadataMap.put(hostId, metadata);
            serviceInstance.setMetadata((Map)JsonUtils.toJavaObject(metadata, Map.class));
        }
    }

    public final void notifyListener(String serviceName, ServiceInstancesChangedListener listener, List<ServiceInstance> instances) {
        boolean changed;
        String serviceInstanceRevision = RevisionResolver.calRevision(JsonUtils.toJson(instances));
        boolean bl = changed = !serviceInstanceRevision.equalsIgnoreCase(this.serviceInstanceRevisionMap.put(serviceName, serviceInstanceRevision));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Service changed event received (possibly because of DNS polling). Service Instance changed: " + changed + " Service Name: " + serviceName);
        }
        if (changed) {
            List oldServiceInstances = this.cachedServiceInstances.getOrDefault(serviceName, new LinkedList());
            HashSet<ServiceInstance> allServiceInstances = new HashSet<ServiceInstance>(oldServiceInstances.size() + instances.size());
            allServiceInstances.addAll(oldServiceInstances);
            allServiceInstances.addAll(instances);
            oldServiceInstances.forEach(allServiceInstances::remove);
            allServiceInstances.forEach(this::destroyMetadataServiceProxy);
            this.cachedServiceInstances.put(serviceName, instances);
            listener.onEvent(new ServiceInstancesChangedEvent(serviceName, instances));
        }
    }

    @Override
    public Set<String> getServices() {
        return Collections.emptySet();
    }

    @Override
    public List<ServiceInstance> getInstances(String serviceName) throws NullPointerException {
        return Collections.emptyList();
    }

    private String computeKey(ServiceInstance serviceInstance) {
        return serviceInstance.getServiceName() + "##" + serviceInstance.getAddress() + "##" + ServiceInstanceMetadataUtils.getExportedServicesRevision(serviceInstance);
    }

    private synchronized MetadataService getMetadataServiceProxy(ServiceInstance instance) {
        return ConcurrentHashMapUtils.computeIfAbsent(this.metadataServiceProxies, this.computeKey(instance), k -> MetadataUtils.referProxy(instance).getProxy());
    }

    private synchronized void destroyMetadataServiceProxy(ServiceInstance instance) {
        Object metadataServiceProxy;
        String key = this.computeKey(instance);
        if (this.metadataServiceProxies.containsKey(key) && (metadataServiceProxy = this.metadataServiceProxies.remove(key)) instanceof Destroyable) {
            ((Destroyable)metadataServiceProxy).$destroy();
        }
    }

    @Deprecated
    public final ConcurrentHashMap<String, List<ServiceInstance>> getCachedServiceInstances() {
        return this.cachedServiceInstances;
    }
}

