/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.gpx;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.gpx.Metadata;
import org.apache.sis.storage.gpx.WritableStore;
import org.apache.sis.storage.gpx.Writer;
import org.apache.sis.storage.xml.stream.RewriteOnUpdate;
import org.apache.sis.storage.xml.stream.StaxStreamWriter;

final class Updater
extends RewriteOnUpdate {
    private Metadata metadata;

    Updater(WritableStore source, Path location) throws IOException {
        super(source, location);
    }

    @Override
    protected Stream<? extends AbstractFeature> features() throws DataStoreException {
        this.metadata = Metadata.castOrCopy(this.source.getMetadata(), this.getLocale());
        return super.features();
    }

    @Override
    protected Path createTemporaryFile() throws IOException {
        return Files.createTempFile("GPX", ".xml", new FileAttribute[0]);
    }

    @Override
    protected StaxStreamWriter createWriter(OutputStream temporary) throws Exception {
        return new Writer((WritableStore)this.source, this.metadata, temporary);
    }
}

