/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.grizzly.workthreadpool;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.meter.Gauge;
import org.apache.skywalking.apm.agent.core.meter.MeterFactory;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.glassfish.grizzly.threadpool.AbstractThreadPool;
import org.glassfish.grizzly.threadpool.GrizzlyExecutorService;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;

public class TransportInterceptor
implements InstanceMethodsAroundInterceptor {
    private static final String METER_NAME = "thread_pool";
    private static final String METRIC_POOL_NAME_TAG_NAME = "pool_name";
    private static final String THREAD_POOL_NAME = "grizzly_execute_pool";
    private static final String METRIC_TYPE_TAG_NAME = "metric_type";

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        GrizzlyExecutorService executorServices = (GrizzlyExecutorService)allArguments[0];
        Field poolField = GrizzlyExecutorService.class.getDeclaredField("pool");
        poolField.setAccessible(true);
        AbstractThreadPool abstractThreadPool = (AbstractThreadPool)poolField.get(executorServices);
        ThreadPoolConfig threadPoolConfig = abstractThreadPool.getConfig();
        ((Gauge.Builder)((Gauge.Builder)MeterFactory.gauge((String)METER_NAME, () -> threadPoolConfig.getCorePoolSize()).tag(METRIC_POOL_NAME_TAG_NAME, THREAD_POOL_NAME)).tag(METRIC_TYPE_TAG_NAME, "core_pool_size")).build();
        ((Gauge.Builder)((Gauge.Builder)MeterFactory.gauge((String)METER_NAME, () -> threadPoolConfig.getMaxPoolSize()).tag(METRIC_POOL_NAME_TAG_NAME, THREAD_POOL_NAME)).tag(METRIC_TYPE_TAG_NAME, "max_pool_size")).build();
        ((Gauge.Builder)((Gauge.Builder)MeterFactory.gauge((String)METER_NAME, () -> abstractThreadPool.getSize()).tag(METRIC_POOL_NAME_TAG_NAME, THREAD_POOL_NAME)).tag(METRIC_TYPE_TAG_NAME, "pool_size")).build();
        ((Gauge.Builder)((Gauge.Builder)MeterFactory.gauge((String)METER_NAME, () -> abstractThreadPool.getQueue().size()).tag(METRIC_POOL_NAME_TAG_NAME, THREAD_POOL_NAME)).tag(METRIC_TYPE_TAG_NAME, "queue_size")).build();
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
    }
}

