/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.aerospike;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;

public class AerospikeClientMethodInterceptor
implements InstanceMethodsAroundInterceptor {
    private static final Set<String> OPERATION_MAPPING_READ = new HashSet<String>(Arrays.asList("get", "prepend", "exists", "getHeader", "scanAll", "scanNode", "scanPartitions", "getLargeList", "getLargeMap", "getLargeSet", "getLargeStack", "query", "queryNode", "queryPartitions", "queryAggregate", "queryAggregateNode", "info"));
    private static final Set<String> OPERATION_MAPPING_WRITE = new HashSet<String>(Arrays.asList("append", "put", "add", "delete", "touch", "operate", "register", "registerUdfString", "removeUdf", "execute"));

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        String peer = String.valueOf(objInst.getSkyWalkingDynamicField());
        String methodName = method.getName();
        AbstractSpan span = ContextManager.createExitSpan((String)("Aerospike/" + methodName), (String)peer);
        span.setComponent((Component)ComponentsDefine.AEROSPIKE);
        Tags.CACHE_TYPE.set(span, "Aerospike");
        SpanLayer.asCache((AbstractSpan)span);
        this.parseOperation(methodName).ifPresent(op -> Tags.CACHE_OP.set(span, op));
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        AbstractSpan span = ContextManager.activeSpan();
        span.log(t);
    }

    private Optional<String> parseOperation(String cmd) {
        if (OPERATION_MAPPING_READ.contains(cmd)) {
            return Optional.of("read");
        }
        if (OPERATION_MAPPING_WRITE.contains(cmd)) {
            return Optional.of("write");
        }
        return Optional.empty();
    }
}

