/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.customize.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CustomizeUtil {
    private static final Map<String, Class> JAVA_CLASS = new HashMap<String, Class>();

    public static boolean isJavaClass(String className) {
        return JAVA_CLASS.containsKey(className);
    }

    public static Class getJavaClass(String className) {
        return JAVA_CLASS.get(className);
    }

    public static String generateOperationName(String className, String methodName, String[] parameterTypes) {
        StringBuilder operationName = new StringBuilder(className + "." + methodName + "(");
        for (int i = 0; i < parameterTypes.length; ++i) {
            operationName.append(CustomizeUtil.isJavaClass(parameterTypes[i]) ? CustomizeUtil.getJavaClass(parameterTypes[i]).getName() : parameterTypes[i]);
            if (i >= parameterTypes.length - 1) continue;
            operationName.append(",");
        }
        operationName.append(")");
        return operationName.toString();
    }

    public static String generateClassDesc(String className, boolean isStatic) {
        return className + ":" + isStatic;
    }

    public static String[] getClassDesc(String enhanceClass) {
        return enhanceClass.split(":");
    }

    static {
        JAVA_CLASS.put("boolean.class", Boolean.TYPE);
        JAVA_CLASS.put("char.class", Character.TYPE);
        JAVA_CLASS.put("byte.class", Byte.TYPE);
        JAVA_CLASS.put("short.class", Short.TYPE);
        JAVA_CLASS.put("int.class", Integer.TYPE);
        JAVA_CLASS.put("long.class", Long.TYPE);
        JAVA_CLASS.put("float.class", Float.TYPE);
        JAVA_CLASS.put("double.class", Double.TYPE);
        JAVA_CLASS.put("java.util.List", List.class);
        JAVA_CLASS.put("java.util.Map", Map.class);
    }
}

