/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.form.impl;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import javax.jcr.Credentials;
import javax.jcr.SimpleCredentials;
import org.apache.commons.codec.binary.Base64;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.auth.core.AuthUtil;
import org.apache.sling.auth.core.spi.AuthenticationInfo;
import org.apache.sling.auth.core.spi.DefaultJakartaAuthenticationFeedbackHandler;
import org.apache.sling.auth.core.spi.JakartaAuthenticationHandler;
import org.apache.sling.auth.form.FormReason;
import org.apache.sling.auth.form.impl.FormAuthenticationHandlerConfig;
import org.apache.sling.auth.form.impl.FormLoginModulePlugin;
import org.apache.sling.auth.form.impl.TokenStore;
import org.apache.sling.auth.form.impl.jaas.FormCredentials;
import org.apache.sling.auth.form.impl.jaas.JaasHelper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="org.apache.sling.auth.form.FormAuthenticationHandler", property={"authtype=FORM"}, service={JakartaAuthenticationHandler.class}, immediate=true)
@Designate(ocd=FormAuthenticationHandlerConfig.class)
public class FormAuthenticationHandler
extends DefaultJakartaAuthenticationFeedbackHandler
implements JakartaAuthenticationHandler {
    private static final String REQUEST_METHOD = "POST";
    private static final String REQUEST_URL_SUFFIX = "/j_security_check";
    private static final String PAR_J_USERNAME = "j_username";
    private static final String PAR_J_PASSWORD = "j_password";
    private static final String COOKIE_DOMAIN = "cookie.domain";
    private static final long MINUTES = 60000L;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private AuthenticationStorage authStorage;
    private String loginForm;
    private long sessionTimeout;
    private String attrCookieAuthData;
    private TokenStore tokenStore;
    private ServiceRegistration<?> loginModule;
    private boolean includeLoginForm;
    private boolean preferReasonCode;
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    private volatile ResourceResolverFactory resourceResolverFactory;
    private boolean loginAfterExpire;
    private JaasHelper jaasHelper;

    public AuthenticationInfo extractCredentials(HttpServletRequest request, HttpServletResponse response) {
        String authData;
        AuthenticationInfo info = null;
        info = this.extractRequestParameterAuthentication(request);
        if (info == null && (authData = this.authStorage.extractAuthenticationInfo(request)) != null) {
            if (this.tokenStore.isValid(authData)) {
                info = this.createAuthInfo(authData);
            } else {
                this.authStorage.clear(request, response);
                if (this.loginAfterExpire || AuthUtil.isValidateRequest((HttpServletRequest)request)) {
                    request.setAttribute("j_reason", (Object)FormReason.TIMEOUT);
                    info = AuthenticationInfo.FAIL_AUTH;
                }
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestCredentials(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.ignoreRequestCredentials(request)) {
            return false;
        }
        if (!AuthUtil.checkReferer((HttpServletRequest)request, (String)this.loginForm)) {
            return false;
        }
        String resource = AuthUtil.setLoginResourceAttribute((HttpServletRequest)request, (String)request.getRequestURI());
        if (this.includeLoginForm && this.resourceResolverFactory != null) {
            try (ResourceResolver resourceResolver = null;){
                resourceResolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
                Resource loginFormResource = resourceResolver.resolve(this.loginForm);
                Servlet loginFormServlet = (Servlet)loginFormResource.adaptTo(Servlet.class);
                if (loginFormServlet != null) {
                    loginFormServlet.service((ServletRequest)request, (ServletResponse)response);
                    boolean bl = true;
                    return bl;
                }
            }
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("resource", resource);
        if (this.preferReasonCode) {
            if (request.getAttribute("j_reason_code") != null) {
                String string;
                Object jReasonCode = request.getAttribute("j_reason_code");
                if (jReasonCode instanceof Enum) {
                    Enum jReasonCodeEnum = (Enum)jReasonCode;
                    string = jReasonCodeEnum.name();
                } else {
                    string = jReasonCode.toString();
                }
                String reasonCode = string;
                params.put("j_reason_code", reasonCode);
            }
        } else if (request.getAttribute("j_reason") != null) {
            String string;
            Object jReason = request.getAttribute("j_reason");
            if (jReason instanceof Enum) {
                Enum jReasonEnum = (Enum)jReason;
                string = jReasonEnum.name();
            } else {
                string = jReason.toString();
            }
            String reason = string;
            params.put("j_reason", reason);
        }
        try {
            AuthUtil.sendRedirect((HttpServletRequest)request, (HttpServletResponse)response, (String)(request.getContextPath() + this.loginForm), params);
        }
        catch (IOException e) {
            this.log.error("Failed to redirect to the login form " + this.loginForm, (Throwable)e);
        }
        return true;
    }

    public void dropCredentials(HttpServletRequest request, HttpServletResponse response) {
        this.authStorage.clear(request, response);
    }

    public void authenticationFailed(HttpServletRequest request, HttpServletResponse response, AuthenticationInfo authInfo) {
        this.authStorage.clear(request, response);
        request.setAttribute("j_reason", (Object)FormReason.INVALID_CREDENTIALS);
    }

    public boolean authenticationSucceeded(HttpServletRequest request, HttpServletResponse response, AuthenticationInfo authInfo) {
        boolean result;
        this.refreshAuthData(request, response, authInfo);
        if (REQUEST_METHOD.equals(request.getMethod()) && request.getRequestURI().endsWith(REQUEST_URL_SUFFIX)) {
            if (DefaultJakartaAuthenticationFeedbackHandler.handleRedirect((HttpServletRequest)request, (HttpServletResponse)response)) {
                result = false;
            } else {
                String targetResource = AuthUtil.getLoginResource((HttpServletRequest)request, null);
                if (targetResource != null) {
                    try {
                        if (response.isCommitted()) {
                            throw new IllegalStateException("Response is already committed");
                        }
                        response.resetBuffer();
                        StringBuilder b = new StringBuilder();
                        if (AuthUtil.isRedirectValid((HttpServletRequest)request, (String)targetResource)) {
                            b.append(targetResource);
                        } else if (request.getContextPath().length() == 0) {
                            b.append("/");
                        } else {
                            b.append(request.getContextPath());
                        }
                        response.sendRedirect(b.toString());
                    }
                    catch (IOException ioe) {
                        this.log.error("Failed to send redirect to: " + targetResource, (Throwable)ioe);
                    }
                    result = true;
                } else {
                    result = false;
                }
            }
        } else {
            result = false;
        }
        return result;
    }

    public String toString() {
        return "Form Based Authentication Handler";
    }

    private boolean ignoreRequestCredentials(HttpServletRequest request) {
        String requestLogin = request.getParameter("sling:authRequestLogin");
        return requestLogin != null && !"FORM".equals(requestLogin);
    }

    private void refreshAuthData(HttpServletRequest request, HttpServletResponse response, AuthenticationInfo authInfo) {
        String authData = this.getCookieAuthData(authInfo);
        boolean refreshCookie = this.needsRefresh(authData, this.sessionTimeout);
        if (refreshCookie) {
            long expires = System.currentTimeMillis() + this.sessionTimeout;
            try {
                authData = null;
                authData = this.tokenStore.encode(expires, authInfo.getUser());
            }
            catch (IllegalStateException | InvalidKeyException | NoSuchAlgorithmException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
            if (authData != null) {
                this.authStorage.set(request, response, authData, authInfo);
            } else {
                this.authStorage.clear(request, response);
            }
        }
    }

    private AuthenticationInfo extractRequestParameterAuthentication(HttpServletRequest request) {
        AuthenticationInfo info = null;
        if (REQUEST_METHOD.equals(request.getMethod()) && request.getRequestURI().endsWith(REQUEST_URL_SUFFIX)) {
            String user = request.getParameter(PAR_J_USERNAME);
            String pwd = request.getParameter(PAR_J_PASSWORD);
            if (user != null && pwd != null) {
                info = new AuthenticationInfo("FORM", user, pwd.toCharArray());
                info.put("$$auth.info.login$$", new Object());
                if (!AuthUtil.isValidateRequest((HttpServletRequest)request)) {
                    AuthUtil.setLoginResourceAttribute((HttpServletRequest)request, (String)request.getContextPath());
                }
            }
        }
        return info;
    }

    private AuthenticationInfo createAuthInfo(String authData) {
        String userId = this.getUserId(authData);
        if (userId == null) {
            return null;
        }
        AuthenticationInfo info = new AuthenticationInfo("FORM", userId);
        if (this.jaasHelper.enabled()) {
            info.put("user.jcr.credentials", (Object)new FormCredentials(userId, authData));
        } else {
            info.put(this.attrCookieAuthData, (Object)authData);
        }
        return info;
    }

    private String getCookieAuthData(AuthenticationInfo info) {
        String authData = null;
        if (this.jaasHelper.enabled()) {
            Object credentials = info.get((Object)"user.jcr.credentials");
            if (credentials instanceof Credentials) {
                Credentials creds = (Credentials)credentials;
                authData = this.getCookieAuthData(creds);
            }
        } else {
            Object data = info.get((Object)this.attrCookieAuthData);
            if (data instanceof String) {
                String strData;
                authData = strData = (String)data;
            }
        }
        return authData;
    }

    private String getCookieAuthData(Credentials credentials) {
        if (credentials instanceof SimpleCredentials) {
            SimpleCredentials simpleCreds = (SimpleCredentials)credentials;
            Object data = simpleCreds.getAttribute(this.attrCookieAuthData);
            if (data instanceof String) {
                String strData = (String)data;
                return strData;
            }
        } else if (credentials instanceof FormCredentials) {
            FormCredentials creds = (FormCredentials)credentials;
            return creds.getAuthData();
        }
        return null;
    }

    boolean hasAuthData(Credentials credentials) {
        return this.getCookieAuthData(credentials) != null;
    }

    public boolean isValid(Credentials credentials) {
        String authData = this.getCookieAuthData(credentials);
        if (authData != null) {
            return this.tokenStore.isValid(authData);
        }
        return false;
    }

    @Activate
    protected void activate(FormAuthenticationHandlerConfig config, ComponentContext componentContext) throws InvalidKeyException, NoSuchAlgorithmException, IllegalStateException {
        String formAuthStorage;
        this.jaasHelper = new JaasHelper(this, componentContext.getBundleContext(), config);
        this.loginForm = config.form_login_form();
        this.log.info("Login Form URL {}", (Object)this.loginForm);
        String authName = config.form_auth_name();
        String defaultCookieDomain = config.form_default_cookie_domain();
        if (defaultCookieDomain.length() == 0) {
            defaultCookieDomain = null;
        }
        if ("session".equals(formAuthStorage = config.form_auth_storage())) {
            this.authStorage = new SessionStorage(authName);
            this.log.info("Using HTTP Session store with attribute name {}", (Object)authName);
        } else {
            this.authStorage = new CookieStorage(authName, defaultCookieDomain);
            this.log.info("Using Cookie store with name {}", (Object)authName);
        }
        this.attrCookieAuthData = config.form_credentials_name();
        this.log.info("Setting Auth Data attribute name {}", (Object)this.attrCookieAuthData);
        int timeoutMinutes = config.form_auth_timeout();
        if (timeoutMinutes < 1) {
            timeoutMinutes = 30;
        }
        this.log.info("Setting session timeout {} minutes", (Object)timeoutMinutes);
        this.sessionTimeout = 60000L * (long)timeoutMinutes;
        String tokenFileName = config.form_token_file();
        File tokenFile = this.getTokenFile(tokenFileName, componentContext.getBundleContext());
        boolean fastSeed = config.form_token_fastseed();
        this.log.info("Storing tokens in {}", (Object)tokenFile.getAbsolutePath());
        this.tokenStore = new TokenStore(tokenFile, this.sessionTimeout, fastSeed);
        this.loginModule = null;
        if (!this.jaasHelper.enabled()) {
            try {
                this.loginModule = FormLoginModulePlugin.register(this, componentContext.getBundleContext());
            }
            catch (Throwable t) {
                this.log.info("Cannot register FormLoginModulePlugin. This is expected if Sling LoginModulePlugin services are not supported");
                this.log.debug("dump", t);
            }
        }
        this.includeLoginForm = config.useInclude();
        this.loginAfterExpire = config.form_onexpire_login();
        this.preferReasonCode = config.preferReasonCode();
    }

    @Deactivate
    protected void deactivate() {
        if (this.jaasHelper != null) {
            this.jaasHelper.close();
            this.jaasHelper = null;
        }
        if (this.loginModule != null) {
            this.loginModule.unregister();
            this.loginModule = null;
        }
    }

    File getTokenFile(String tokenFileName, BundleContext bundleContext) {
        File tokenFile = new File(tokenFileName);
        if (tokenFile.isAbsolute()) {
            return tokenFile;
        }
        tokenFile = bundleContext.getDataFile(tokenFileName);
        if (tokenFile == null) {
            String slingHome = bundleContext.getProperty("sling.home");
            tokenFile = slingHome != null ? new File(slingHome, tokenFileName) : new File(tokenFileName);
        }
        return tokenFile.getAbsoluteFile();
    }

    String getUserId(String authData) {
        String[] parts;
        if (authData != null && (parts = TokenStore.split(authData)).length == 3) {
            return parts[2];
        }
        return null;
    }

    private boolean needsRefresh(String authData, long sessionTimeout) {
        boolean updateCookie = false;
        if (authData == null) {
            updateCookie = true;
        } else {
            String[] parts = TokenStore.split(authData);
            if (parts.length == 3) {
                long cookieTime = Long.parseLong(parts[1].substring(1));
                if (System.currentTimeMillis() + sessionTimeout / 2L > cookieTime) {
                    updateCookie = true;
                }
            }
        }
        return updateCookie;
    }

    private static interface AuthenticationStorage {
        public String extractAuthenticationInfo(HttpServletRequest var1);

        public void set(HttpServletRequest var1, HttpServletResponse var2, String var3, AuthenticationInfo var4);

        public void clear(HttpServletRequest var1, HttpServletResponse var2);
    }

    private static class SessionStorage
    implements AuthenticationStorage {
        private final String sessionAttributeName;

        SessionStorage(String sessionAttributeName) {
            this.sessionAttributeName = sessionAttributeName;
        }

        @Override
        public String extractAuthenticationInfo(HttpServletRequest request) {
            Object attribute;
            HttpSession session = request.getSession(false);
            if (session != null && (attribute = session.getAttribute(this.sessionAttributeName)) instanceof String) {
                String strAttribute = (String)attribute;
                return strAttribute;
            }
            return null;
        }

        @Override
        public void set(HttpServletRequest request, HttpServletResponse response, String authData, AuthenticationInfo info) {
            HttpSession session = request.getSession();
            session.setAttribute(this.sessionAttributeName, (Object)authData);
        }

        @Override
        public void clear(HttpServletRequest request, HttpServletResponse response) {
            HttpSession session = request.getSession(false);
            if (session != null) {
                session.removeAttribute(this.sessionAttributeName);
            }
        }
    }

    private static class CookieStorage
    implements AuthenticationStorage {
        private final Logger log = LoggerFactory.getLogger(this.getClass());
        private final String cookieName;
        private final String domainCookieName;
        private final String defaultCookieDomain;

        public CookieStorage(String cookieName, String defaultCookieDomain) {
            this.cookieName = cookieName;
            this.domainCookieName = cookieName + ".cookie.domain";
            this.defaultCookieDomain = defaultCookieDomain;
        }

        @Override
        public String extractAuthenticationInfo(HttpServletRequest request) {
            Cookie[] cookies = request.getCookies();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    String value;
                    if (!this.cookieName.equals(cookie.getName()) || (value = cookie.getValue()).length() <= 0) continue;
                    return new String(Base64.decodeBase64(value), StandardCharsets.UTF_8);
                }
            }
            return null;
        }

        @Override
        public void set(HttpServletRequest request, HttpServletResponse response, String authData, AuthenticationInfo info) {
            String cookieValue = Base64.encodeBase64URLSafeString(authData.getBytes(StandardCharsets.UTF_8));
            String cookieDomain = (String)info.get((Object)FormAuthenticationHandler.COOKIE_DOMAIN);
            if (cookieDomain == null || cookieDomain.length() == 0) {
                cookieDomain = this.defaultCookieDomain;
            }
            if (!this.isValidCookieDomain(request, cookieDomain)) {
                this.log.warn("Sending formauth cookies without a cookie domain because the configured value is invalid for the request");
                cookieDomain = null;
            }
            this.setCookie(request, response, this.cookieName, cookieValue, -1, cookieDomain);
            if (cookieDomain != null) {
                this.setCookie(request, response, this.domainCookieName, cookieDomain, -1, cookieDomain);
            }
        }

        @Override
        public void clear(HttpServletRequest request, HttpServletResponse response) {
            Cookie oldCookie = null;
            String oldCookieDomain = null;
            Cookie[] cookies = request.getCookies();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (this.cookieName.equals(cookie.getName())) {
                        oldCookie = cookie;
                        continue;
                    }
                    if (!this.domainCookieName.equals(cookie.getName()) || (oldCookieDomain = cookie.getValue()).length() != 0) continue;
                    oldCookieDomain = null;
                }
            }
            if (!this.isValidCookieDomain(request, oldCookieDomain)) {
                if (!this.isValidCookieDomain(request, this.defaultCookieDomain)) {
                    this.log.warn("The client supplied domain cookie value was invalid and the configured default cookie domain is also invalid. Will try clearing the cookies without a domain instead");
                    oldCookieDomain = null;
                } else {
                    this.log.warn("The client supplied domain cookie value was invalid. Will try clearing the cookies with the default cookie domain instead");
                    oldCookieDomain = this.defaultCookieDomain;
                }
            }
            if (oldCookie != null) {
                this.setCookie(request, response, this.cookieName, "", 0, oldCookieDomain);
                if (oldCookieDomain != null && oldCookieDomain.length() > 0) {
                    this.setCookie(request, response, this.domainCookieName, "", 0, oldCookieDomain);
                }
            }
        }

        private boolean isValidCookieDomain(HttpServletRequest request, String cookieDomain) {
            boolean valid = false;
            if (cookieDomain == null) {
                valid = true;
            } else {
                String host = request.getServerName();
                if (host.endsWith(cookieDomain)) {
                    valid = true;
                }
            }
            return valid;
        }

        private void setCookie(HttpServletRequest request, HttpServletResponse response, String name, String value, int age, String domain) {
            String ctxPath = request.getContextPath();
            String cookiePath = ctxPath == null || ctxPath.length() == 0 ? "/" : ctxPath;
            Cookie c = new Cookie(name, value);
            c.setPath(cookiePath);
            c.setHttpOnly(true);
            if (domain != null) {
                c.setDomain(domain);
            }
            if (age >= 0) {
                c.setMaxAge(age);
            }
            c.setSecure(request.isSecure());
            response.addCookie(c);
        }
    }
}

