/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.catalog;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.runtime.BoxesRunTime;

public final class CatalogUtils$ {
    public static CatalogUtils$ MODULE$;

    static {
        new CatalogUtils$();
    }

    public Seq<String> normalizePartCols(String tableName, Seq<String> tableCols, Seq<String> partCols, Function2<String, String, Object> resolver) {
        return (Seq)partCols.map((Function1 & java.io.Serializable & Serializable)x$6 -> MODULE$.normalizeColumnName(tableName, tableCols, (String)x$6, "partition", resolver), Seq$.MODULE$.canBuildFrom());
    }

    public BucketSpec normalizeBucketSpec(String tableName, Seq<String> tableCols, BucketSpec bucketSpec, Function2<String, String, Object> resolver) {
        BucketSpec bucketSpec2 = bucketSpec;
        if (bucketSpec2 == null) {
            throw new MatchError((Object)bucketSpec2);
        }
        int numBuckets = bucketSpec2.numBuckets();
        Seq<String> bucketColumnNames = bucketSpec2.bucketColumnNames();
        Seq<String> sortColumnNames = bucketSpec2.sortColumnNames();
        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)numBuckets), bucketColumnNames, sortColumnNames);
        int numBuckets2 = BoxesRunTime.unboxToInt((Object)tuple3._1());
        Seq bucketColumnNames2 = (Seq)tuple3._2();
        Seq sortColumnNames2 = (Seq)tuple3._3();
        Seq normalizedBucketCols = (Seq)bucketColumnNames2.map((Function1 & java.io.Serializable & Serializable)colName -> MODULE$.normalizeColumnName(tableName, tableCols, (String)colName, "bucket", resolver), Seq$.MODULE$.canBuildFrom());
        Seq normalizedSortCols = (Seq)sortColumnNames2.map((Function1 & java.io.Serializable & Serializable)colName -> MODULE$.normalizeColumnName(tableName, tableCols, (String)colName, "sort", resolver), Seq$.MODULE$.canBuildFrom());
        return new BucketSpec(numBuckets2, (Seq<String>)normalizedBucketCols, (Seq<String>)normalizedSortCols);
    }

    public String URIToString(URI uri) {
        return new Path(uri).toString();
    }

    public URI stringToURI(String str) {
        return new Path(str).toUri();
    }

    public URI makeQualifiedDBObjectPath(URI locationUri, String warehousePath, Configuration hadoopConf) {
        if (locationUri.isAbsolute()) {
            return locationUri;
        }
        Path fullPath = new Path(warehousePath, this.URIToString(locationUri));
        return this.makeQualifiedPath(fullPath.toUri(), hadoopConf);
    }

    public String makeQualifiedDBObjectPath(String warehouse, String location, Configuration hadoopConf) {
        URI nsPath = this.makeQualifiedDBObjectPath(this.stringToURI(location), warehouse, hadoopConf);
        return this.URIToString(nsPath);
    }

    public URI makeQualifiedPath(URI path, Configuration hadoopConf) {
        Path hadoopPath = new Path(path);
        FileSystem fs = hadoopPath.getFileSystem(hadoopConf);
        return fs.makeQualified(hadoopPath).toUri();
    }

    private String normalizeColumnName(String tableName, Seq<String> tableCols, String colName, String colType, Function2<String, String, Object> resolver) {
        return (String)tableCols.find((Function1 & java.io.Serializable & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)CatalogUtils$.$anonfun$normalizeColumnName$1(resolver, colName, x$8))).getOrElse((Function0 & java.io.Serializable & Serializable)() -> {
            throw QueryCompilationErrors$.MODULE$.columnNotDefinedInTableError(colType, colName, tableName, tableCols);
        });
    }

    public static final /* synthetic */ boolean $anonfun$normalizeColumnName$1(Function2 resolver$3, String colName$1, String x$8) {
        return BoxesRunTime.unboxToBoolean((Object)resolver$3.apply((Object)x$8, (Object)colName$1));
    }

    private CatalogUtils$() {
        MODULE$ = this;
    }
}

