/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.math.BigDecimal;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.Localiser;

public class BigDecimalDoubleConverter
implements TypeConverter<BigDecimal, Double> {
    private static final long serialVersionUID = 9192173072810027540L;

    @Override
    public BigDecimal toMemberType(Double val) {
        if (val == null) {
            return null;
        }
        try {
            return BigDecimal.valueOf(val);
        }
        catch (NumberFormatException nfe) {
            throw new NucleusDataStoreException(Localiser.msg("016002", val, BigDecimal.class.getName()), nfe);
        }
    }

    @Override
    public Double toDatastoreType(BigDecimal bd) {
        return bd.doubleValue();
    }
}

