/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.util;

import java.io.Serializable;
import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.PredictorParams;
import org.apache.spark.ml.classification.ClassifierParams;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.ml.util.MetadataUtils$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class DatasetUtils$
implements Logging {
    public static DatasetUtils$ MODULE$;
    private UserDefinedFunction validateVector;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    static {
        new DatasetUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Column checkNonNanValues(String colName, String displayed) {
        Column casted = functions$.MODULE$.col(colName).cast((DataType)DoubleType$.MODULE$);
        return functions$.MODULE$.when(casted.isNull().$bar$bar((Object)casted.isNaN()), (Object)functions$.MODULE$.raise_error(functions$.MODULE$.lit((Object)new StringBuilder(24).append(displayed).append(" MUST NOT be Null or NaN").toString()))).when(casted.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)Double.NEGATIVE_INFINITY)).$bar$bar((Object)casted.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)Double.POSITIVE_INFINITY))), (Object)functions$.MODULE$.raise_error(functions$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)new StringBuilder(31).append(displayed).append(" MUST NOT be Infinity, but got ").toString()), casted})))).otherwise((Object)casted);
    }

    public Column checkRegressionLabels(String labelCol) {
        return this.checkNonNanValues(labelCol, "Labels");
    }

    public Column checkClassificationLabels(String labelCol, Option<Object> numClasses) {
        Some some;
        int n;
        Column casted = functions$.MODULE$.col(labelCol).cast((DataType)DoubleType$.MODULE$);
        Option<Object> option = numClasses;
        if (option instanceof Some && 2 == (n = BoxesRunTime.unboxToInt((Object)(some = (Some)option).value()))) {
            return functions$.MODULE$.when(casted.isNull().$bar$bar((Object)casted.isNaN()), (Object)functions$.MODULE$.raise_error(functions$.MODULE$.lit((Object)"Labels MUST NOT be Null or NaN"))).when(casted.$eq$bang$eq((Object)BoxesRunTime.boxToInteger((int)0)).$amp$amp((Object)casted.$eq$bang$eq((Object)BoxesRunTime.boxToInteger((int)1))), (Object)functions$.MODULE$.raise_error(functions$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)"Labels MUST be in {0, 1}, but got "), casted})))).otherwise((Object)casted);
        }
        int n2 = BoxesRunTime.unboxToInt((Object)numClasses.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Integer.MAX_VALUE));
        Predef$.MODULE$.require(0 < n2 && n2 <= Integer.MAX_VALUE);
        return functions$.MODULE$.when(casted.isNull().$bar$bar((Object)casted.isNaN()), (Object)functions$.MODULE$.raise_error(functions$.MODULE$.lit((Object)"Labels MUST NOT be Null or NaN"))).when(casted.$less((Object)BoxesRunTime.boxToInteger((int)0)).$bar$bar((Object)casted.$greater$eq((Object)BoxesRunTime.boxToInteger((int)n2))), (Object)functions$.MODULE$.raise_error(functions$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)new StringBuilder(33).append("Labels MUST be in [0, ").append(n2).append("), but got ").toString()), casted})))).when(casted.$eq$bang$eq((Object)casted.cast((DataType)IntegerType$.MODULE$)), (Object)functions$.MODULE$.raise_error(functions$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)"Labels MUST be Integers, but got "), casted})))).otherwise((Object)casted);
    }

    public Column checkNonNegativeWeights(String weightCol) {
        Column casted = functions$.MODULE$.col(weightCol).cast((DataType)DoubleType$.MODULE$);
        return functions$.MODULE$.when(casted.isNull().$bar$bar((Object)casted.isNaN()), (Object)functions$.MODULE$.raise_error(functions$.MODULE$.lit((Object)"Weights MUST NOT be Null or NaN"))).when(casted.$less((Object)BoxesRunTime.boxToInteger((int)0)).$bar$bar((Object)casted.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)Double.POSITIVE_INFINITY))), (Object)functions$.MODULE$.raise_error(functions$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)"Weights MUST NOT be Negative or Infinity, but got "), casted})))).otherwise((Object)casted);
    }

    public Column checkNonNegativeWeights(Option<String> weightCol) {
        Some some;
        String w;
        Option<String> option = weightCol;
        if (option instanceof Some && new StringOps(Predef$.MODULE$.augmentString(w = (String)(some = (Some)option).value())).nonEmpty()) {
            return this.checkNonNegativeWeights(w);
        }
        return functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)1.0));
    }

    public Column checkNonNanVectors(Column vectorCol) {
        return functions$.MODULE$.when(vectorCol.isNull(), (Object)functions$.MODULE$.raise_error(functions$.MODULE$.lit((Object)"Vectors MUST NOT be Null"))).when(this.validateVector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{vectorCol})).unary_$bang(), (Object)functions$.MODULE$.raise_error(functions$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)"Vector values MUST NOT be NaN or Infinity, but got "), vectorCol.cast((DataType)StringType$.MODULE$)})))).otherwise((Object)vectorCol);
    }

    public Column checkNonNanVectors(String vectorCol) {
        return this.checkNonNanVectors(functions$.MODULE$.col(vectorCol));
    }

    private UserDefinedFunction validateVector$lzycompute() {
        DatasetUtils$ datasetUtils$ = this;
        synchronized (datasetUtils$) {
            if (!this.bitmap$0) {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
                public final class Org_apache_spark_ml_util_DatasetUtils$$typecreator1$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_util_DatasetUtils$$typecreator1$1() {
                    }
                }
                this.validateVector = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)vector -> BoxesRunTime.boxToBoolean((boolean)DatasetUtils$.$anonfun$validateVector$1(vector)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Boolean(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_util_DatasetUtils$$typecreator1$1()));
                this.bitmap$0 = true;
            }
        }
        return this.validateVector;
    }

    private UserDefinedFunction validateVector() {
        if (!this.bitmap$0) {
            return this.validateVector$lzycompute();
        }
        return this.validateVector;
    }

    public RDD<Instance> extractInstances(PredictorParams p, Dataset<?> df, Option<Object> numClasses) {
        Column column;
        Column column2;
        PredictorParams predictorParams = p;
        if (predictorParams instanceof ClassifierParams) {
            ClassifierParams classifierParams = (ClassifierParams)predictorParams;
            column2 = this.checkClassificationLabels(classifierParams.getLabelCol(), numClasses);
        } else {
            column2 = this.checkRegressionLabels(p.getLabelCol());
        }
        Column labelCol = column2;
        PredictorParams predictorParams2 = p;
        if (predictorParams2 instanceof HasWeightCol) {
            PredictorParams predictorParams3 = predictorParams2;
            column = this.checkNonNegativeWeights(predictorParams3.get(((HasWeightCol)((Object)predictorParams3)).weightCol()));
        } else {
            column = functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)1.0));
        }
        Column weightCol = column;
        return df.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{labelCol, weightCol, this.checkNonNanVectors(p.getFeaturesCol())})).rdd().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Row row = x0$1;
            Some some = Row$.MODULE$.unapplySeq(row);
            if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(3) == 0) {
                Object l = ((SeqLike)some.get()).apply(0);
                Object w = ((SeqLike)some.get()).apply(1);
                Object v = ((SeqLike)some.get()).apply(2);
                if (l instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble((Object)l);
                    if (w instanceof Double) {
                        double d2 = BoxesRunTime.unboxToDouble((Object)w);
                        if (v instanceof org.apache.spark.ml.linalg.Vector) {
                            org.apache.spark.ml.linalg.Vector vector = (org.apache.spark.ml.linalg.Vector)v;
                            return new Instance(d, d2, vector);
                        }
                    }
                }
            }
            throw new MatchError((Object)row);
        }, ClassTag$.MODULE$.apply(Instance.class));
    }

    public Option<Object> extractInstances$default$3() {
        return None$.MODULE$;
    }

    public Column columnToVector(Dataset<?> dataset, String colName) {
        DataType columnDataType = dataset.schema().apply(colName).dataType();
        DataType dataType = columnDataType;
        if (dataType instanceof VectorUDT) {
            return functions$.MODULE$.col(colName);
        }
        if (dataType instanceof ArrayType) {
            UserDefinedFunction userDefinedFunction;
            ArrayType arrayType = (ArrayType)dataType;
            DataType dataType2 = arrayType.elementType();
            if (dataType2 instanceof FloatType) {
                public final class Org_apache_spark_ml_util_DatasetUtils$$typecreator2$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("scala")), (Symbols.SymbolApi)$m.staticModule("scala.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.package").asModule().moduleClass(), "Seq"), (List)new .colon.colon((Object)$m.staticClass("scala.Float").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                    }

                    public Org_apache_spark_ml_util_DatasetUtils$$typecreator2$1() {
                    }
                }
                public final class Org_apache_spark_ml_util_DatasetUtils$$typecreator1$2
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_util_DatasetUtils$$typecreator1$2() {
                    }
                }
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
                JavaUniverse $u2 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
                userDefinedFunction = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)vector -> {
                    double[] inputArray = (double[])Array$.MODULE$.ofDim(vector.size(), ClassTag$.MODULE$.Double());
                    vector.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> {
                        inputArray$1[idx] = BoxesRunTime.unboxToFloat((Object)vector.apply(idx));
                    });
                    return org.apache.spark.ml.linalg.Vectors$.MODULE$.dense(inputArray);
                }, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_util_DatasetUtils$$typecreator1$2()), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_util_DatasetUtils$$typecreator2$1()));
            } else if (dataType2 instanceof DoubleType) {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
                JavaUniverse $u3 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
                public final class Org_apache_spark_ml_util_DatasetUtils$$typecreator3$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_util_DatasetUtils$$typecreator3$1() {
                    }
                }
                public final class Org_apache_spark_ml_util_DatasetUtils$$typecreator4$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("scala")), (Symbols.SymbolApi)$m.staticModule("scala.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.package").asModule().moduleClass(), "Seq"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                    }

                    public Org_apache_spark_ml_util_DatasetUtils$$typecreator4$1() {
                    }
                }
                userDefinedFunction = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)vector -> org.apache.spark.ml.linalg.Vectors$.MODULE$.dense((double[])vector.toArray(ClassTag$.MODULE$.Double())), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_util_DatasetUtils$$typecreator3$1()), ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_ml_util_DatasetUtils$$typecreator4$1()));
            } else {
                throw new IllegalArgumentException(new StringBuilder(39).append("Array[").append(dataType2).append("] column cannot be cast to Vector").toString());
            }
            UserDefinedFunction transferUDF = userDefinedFunction;
            return transferUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(colName)}));
        }
        throw new IllegalArgumentException(new StringBuilder(32).append(dataType).append(" column cannot be cast to Vector").toString());
    }

    public RDD<Vector> columnToOldVector(Dataset<?> dataset, String colName) {
        return dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.columnToVector(dataset, colName)})).rdd().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object point;
            Row row = x0$1;
            Some some = Row$.MODULE$.unapplySeq(row);
            if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0 && (point = ((SeqLike)some.get()).apply(0)) instanceof org.apache.spark.ml.linalg.Vector) {
                org.apache.spark.ml.linalg.Vector vector = (org.apache.spark.ml.linalg.Vector)point;
                return Vectors$.MODULE$.fromML(vector);
            }
            throw new MatchError((Object)row);
        }, ClassTag$.MODULE$.apply(Vector.class));
    }

    public int getNumClasses(Dataset<?> dataset, String labelCol, int maxNumClasses) {
        Option<Object> option = MetadataUtils$.MODULE$.getNumClasses(dataset.schema().apply(labelCol));
        if (option instanceof Some) {
            int n;
            Some some = (Some)option;
            int n2 = n = BoxesRunTime.unboxToInt((Object)some.value());
            return n2;
        }
        if (None$.MODULE$.equals(option)) {
            Row[] maxLabelRow = (Row[])dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.max(this.checkClassificationLabels(labelCol, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)maxNumClasses))))})).take(1);
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])maxLabelRow)).isEmpty() || maxLabelRow[0].get(0) == null) {
                throw new SparkException("ML algorithm was given empty dataset.");
            }
            double maxDoubleLabel = ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])maxLabelRow)).head()).getDouble(0);
            Predef$.MODULE$.require(RichDouble$.MODULE$.isValidInt$extension(Predef$.MODULE$.doubleWrapper(maxDoubleLabel + 1.0)), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(76).append("Classifier found max label value =").append(" ").append(maxDoubleLabel).append(" but requires integers in range [0, ... ").append(Integer.MAX_VALUE).append(")").toString());
            int numClasses = (int)maxDoubleLabel + 1;
            Predef$.MODULE$.require(numClasses <= maxNumClasses, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(286).append("Classifier inferred ").append(numClasses).append(" from label values").append(" in column ").append(labelCol).append(", but this exceeded the max numClasses (").append(maxNumClasses).append(") allowed").append(" to be inferred from values.  To avoid this error for labels with > ").append(maxNumClasses).append(" classes, specify numClasses explicitly in the metadata; this can be done by applying").append(" StringIndexer to the label column.").toString());
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(91).append(MODULE$.getClass().getCanonicalName()).append(" inferred ").append(numClasses).append(" classes for").append(" labelCol=").append(labelCol).append(" since numClasses was not specified in the column metadata.").toString());
            return numClasses;
        }
        throw new MatchError(option);
    }

    public int getNumClasses$default$3() {
        return 100;
    }

    public int getNumFeatures(Dataset<?> dataset, String vectorCol) {
        return BoxesRunTime.unboxToInt((Object)MetadataUtils$.MODULE$.getNumFeatures(dataset.schema().apply(vectorCol)).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> ((org.apache.spark.ml.linalg.Vector)((Row)dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{MODULE$.columnToVector(dataset, vectorCol)})).head()).getAs(0)).size()));
    }

    public static final /* synthetic */ boolean $anonfun$validateVector$1(org.apache.spark.ml.linalg.Vector vector) {
        org.apache.spark.ml.linalg.Vector vector2 = vector;
        if (vector2 instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vector2;
            return new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(denseVector.values())).forall((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)v -> !Double.isNaN(v) && !RichDouble$.MODULE$.isInfinity$extension(Predef$.MODULE$.doubleWrapper(v)));
        }
        if (vector2 instanceof SparseVector) {
            SparseVector sparseVector = (SparseVector)vector2;
            return new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(sparseVector.values())).forall((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)v -> !Double.isNaN(v) && !RichDouble$.MODULE$.isInfinity$extension(Predef$.MODULE$.doubleWrapper(v)));
        }
        throw new MatchError((Object)vector2);
    }

    private DatasetUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

