/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jpmml.model.visitors;

import java.lang.reflect.Field;
import java.util.List;
import java.util.ListIterator;
import org.sparkproject.dmg.pmml.PMMLObject;
import org.sparkproject.dmg.pmml.VisitorAction;
import org.sparkproject.jpmml.model.ReflectionUtil;
import org.sparkproject.jpmml.model.visitors.AbstractVisitor;

public abstract class Interner<V>
extends AbstractVisitor {
    private Class<? extends V> type = null;

    public Interner(Class<? extends V> type) {
        this.setType(type);
    }

    public abstract V intern(V var1);

    public void internAll(List<V> values) {
        ListIterator<V> it = values.listIterator();
        while (it.hasNext()) {
            it.set(this.intern(it.next()));
        }
    }

    @Override
    public VisitorAction visit(PMMLObject object) {
        Class<V> type = this.getType();
        List<Field> fields = ReflectionUtil.getInstanceFields(object.getClass());
        for (Field field : fields) {
            Object value = ReflectionUtil.getFieldValue(field, object);
            if (!type.isInstance(value)) continue;
            V internedValue = this.intern(type.cast(value));
            ReflectionUtil.setFieldValue(field, object, internedValue);
        }
        return super.visit(object);
    }

    public Class<? extends V> getType() {
        return this.type;
    }

    private void setType(Class<? extends V> type) {
        this.type = type;
    }
}

