/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.plans.logical.HintErrorHandler;
import org.apache.spark.sql.catalyst.plans.logical.HintInfo;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;

public final class HintErrorLogger$
implements HintErrorHandler,
Logging {
    public static final HintErrorLogger$ MODULE$ = new HintErrorLogger$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public void hintNotRecognized(String name, Seq<Object> parameters) {
        this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(19).append("Unrecognized hint: ").append(MODULE$.hintToPrettyString(name, parameters)).toString());
    }

    @Override
    public void hintRelationsNotFound(String name, Seq<Object> parameters, Set<Seq<String>> invalidRelations) {
        invalidRelations.foreach((Function1 & Serializable)ident -> {
            HintErrorLogger$.MODULE$.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(45).append("Count not find relation '").append(CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper((Seq<String>)ident).quoted()).append("' specified in hint ").toString()).append(new StringBuilder(3).append("'").append(HintErrorLogger$.MODULE$.hintToPrettyString(name$2, (Seq<Object>)parameters$2)).append("'.").toString()).toString());
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void joinNotFoundForJoinHint(HintInfo hint) {
        this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(64).append("A join hint ").append(hint).append(" is specified but it is not part of a join relation.").toString());
    }

    @Override
    public void joinHintNotSupported(HintInfo hint, String reason) {
        this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Hint ").append(hint).append(" is not supported in the query: ").append(reason).append(".").toString());
    }

    @Override
    public void hintOverridden(HintInfo hint) {
        this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(61).append("Hint ").append(hint).append(" is overridden by another hint and will not take effect.").toString());
    }

    private String hintToPrettyString(String name, Seq<Object> parameters) {
        Seq prettyParameters = (Seq)parameters.map((Function1 & Serializable)x0$1 -> {
            String string;
            Object object = x0$1;
            if (object instanceof UnresolvedAttribute) {
                UnresolvedAttribute unresolvedAttribute = (UnresolvedAttribute)object;
                string = unresolvedAttribute.nameParts().mkString(".");
            } else if (object instanceof Object) {
                Object object2 = object;
                string = object2.toString();
            } else {
                throw new MatchError(object);
            }
            return string;
        });
        return new StringBuilder(0).append(name).append(prettyParameters.mkString("(", ", ", ")")).toString();
    }

    private HintErrorLogger$() {
    }
}

