/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RegExpExtract$;
import org.apache.spark.sql.catalyst.expressions.RegExpExtractBase;
import org.apache.spark.sql.catalyst.expressions.RegExpExtractBase$;
import org.apache.spark.sql.catalyst.expressions.RegExpUtils$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(str, regexp[, idx]) - Extract the first string in the `str` that match the `regexp`\n    expression and corresponding to the regex group index.\n  ", arguments="\n    Arguments:\n      * str - a string expression.\n      * regexp - a string representing a regular expression. The regex string should be a\n          Java regular expression.<br><br>\n          Since Spark 2.0, string literals (including regex patterns) are unescaped in our SQL\n          parser. For example, to match \"\\abc\", a regular expression for `regexp` can be\n          \"^\\\\abc$\".<br><br>\n          There is a SQL config 'spark.sql.parser.escapedStringLiterals' that can be used to\n          fallback to the Spark 1.6 behavior regarding string literal parsing. For example,\n          if the config is enabled, the `regexp` that can match \"\\abc\" is \"^\\abc$\".\n      * idx - an integer expression that representing the group index. The regex maybe contains\n          multiple groups. `idx` indicates which regex group to extract. The group index should\n          be non-negative. The minimum value of `idx` is 0, which means matching the entire\n          regular expression. If `idx` is not specified, the default group index value is 1. The\n          `idx` parameter is the Java regex Matcher group() method index.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('100-200', '(\\\\d+)-(\\\\d+)', 1);\n       100\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005mh\u0001\u0002\u0011\"\u0001:B\u0001\"\u0012\u0001\u0003\u0016\u0004%\tA\u0012\u0005\t\u0015\u0002\u0011\t\u0012)A\u0005\u000f\"A1\n\u0001BK\u0002\u0013\u0005a\t\u0003\u0005M\u0001\tE\t\u0015!\u0003H\u0011!i\u0005A!f\u0001\n\u00031\u0005\u0002\u0003(\u0001\u0005#\u0005\u000b\u0011B$\t\u000b=\u0003A\u0011\u0001)\t\u000b=\u0003A\u0011A+\t\u000bi\u0003A\u0011I.\t\u000b\r\u0004A\u0011\t3\t\u000b-\u0004A\u0011\t7\t\u000bU\u0004A\u0011\u000b<\t\u000f\u0005%\u0001\u0001\"\u0015\u0002\f!I\u0011\u0011\u0004\u0001\u0002\u0002\u0013\u0005\u00111\u0004\u0005\n\u0003G\u0001\u0011\u0013!C\u0001\u0003KA\u0011\"a\u000f\u0001#\u0003%\t!!\n\t\u0013\u0005u\u0002!%A\u0005\u0002\u0005\u0015\u0002\"CA \u0001\u0005\u0005I\u0011IA!\u0011%\t\t\u0006AA\u0001\n\u0003\t\u0019\u0006C\u0005\u0002\\\u0001\t\t\u0011\"\u0001\u0002^!I\u00111\r\u0001\u0002\u0002\u0013\u0005\u0013Q\r\u0005\n\u0003g\u0002\u0011\u0011!C\u0001\u0003kB\u0011\"a \u0001\u0003\u0003%\t%!!\t\u0013\u0005\u0015\u0005!!A\u0005B\u0005\u001du!CAYC\u0005\u0005\t\u0012AAZ\r!\u0001\u0013%!A\t\u0002\u0005U\u0006BB(\u001b\t\u0003\ti\rC\u0005\u0002Pj\t\t\u0011\"\u0012\u0002R\"I\u00111\u001b\u000e\u0002\u0002\u0013\u0005\u0015Q\u001b\u0005\n\u0003;T\u0012\u0011!CA\u0003?D\u0011\"!=\u001b\u0003\u0003%I!a=\u0003\u001bI+w-\u0012=q\u000bb$(/Y2u\u0015\t\u00113%A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u0013&\u0003!\u0019\u0017\r^1msN$(B\u0001\u0014(\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003Q%\nQa\u001d9be.T!AK\u0016\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0013aA8sO\u000e\u00011\u0003\u0002\u00010ge\u0002\"\u0001M\u0019\u000e\u0003\u0005J!AM\u0011\u0003#I+w-\u0012=q\u000bb$(/Y2u\u0005\u0006\u001cX\r\u0005\u00025o5\tQGC\u00017\u0003\u0015\u00198-\u00197b\u0013\tATGA\u0004Qe>$Wo\u0019;\u0011\u0005i\u0012eBA\u001eA\u001d\tat(D\u0001>\u0015\tqT&\u0001\u0004=e>|GOP\u0005\u0002m%\u0011\u0011)N\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0019EI\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002Bk\u000591/\u001e2kK\u000e$X#A$\u0011\u0005AB\u0015BA%\"\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\tgV\u0014'.Z2uA\u00051!/Z4fqB\fqA]3hKb\u0004\b%A\u0002jIb\fA!\u001b3yA\u00051A(\u001b8jiz\"B!\u0015*T)B\u0011\u0001\u0007\u0001\u0005\u0006\u000b\u001e\u0001\ra\u0012\u0005\u0006\u0017\u001e\u0001\ra\u0012\u0005\u0006\u001b\u001e\u0001\ra\u0012\u000b\u0004#ZC\u0006\"B,\t\u0001\u00049\u0015!A:\t\u000beC\u0001\u0019A$\u0002\u0003I\fAB\\;mYN\u000bg-Z#wC2$B\u0001X0aEB\u0011A'X\u0005\u0003=V\u00121!\u00118z\u0011\u00159\u0016\u00021\u0001]\u0011\u0015\t\u0017\u00021\u0001]\u0003\u0005\u0001\b\"B-\n\u0001\u0004a\u0016\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003\u0015\u0004\"AZ5\u000e\u0003\u001dT!\u0001[\u0013\u0002\u000bQL\b/Z:\n\u0005)<'\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001n!\tq'O\u0004\u0002paB\u0011A(N\u0005\u0003cV\na\u0001\u0015:fI\u00164\u0017BA:u\u0005\u0019\u0019FO]5oO*\u0011\u0011/N\u0001\nI><UM\\\"pI\u0016$Ba^?\u0002\u0006A\u0011\u0001p_\u0007\u0002s*\u0011!0I\u0001\bG>$WmZ3o\u0013\ta\u0018P\u0001\u0005FqB\u00148i\u001c3f\u0011\u0015qH\u00021\u0001\u0000\u0003\r\u0019G\u000f\u001f\t\u0004q\u0006\u0005\u0011bAA\u0002s\nq1i\u001c3fO\u0016t7i\u001c8uKb$\bBBA\u0004\u0019\u0001\u0007q/\u0001\u0002fm\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\b#\u00065\u0011\u0011CA\u000b\u0011\u0019\ty!\u0004a\u0001\u000f\u0006Aa.Z<GSJ\u001cH\u000f\u0003\u0004\u0002\u00145\u0001\raR\u0001\n]\u0016<8+Z2p]\u0012Da!a\u0006\u000e\u0001\u00049\u0015\u0001\u00038foRC\u0017N\u001d3\u0002\t\r|\u0007/\u001f\u000b\b#\u0006u\u0011qDA\u0011\u0011\u001d)e\u0002%AA\u0002\u001dCqa\u0013\b\u0011\u0002\u0003\u0007q\tC\u0004N\u001dA\u0005\t\u0019A$\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u0005\u0016\u0004\u000f\u0006%2FAA\u0016!\u0011\ti#a\u000e\u000e\u0005\u0005=\"\u0002BA\u0019\u0003g\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005UR'\u0001\u0006b]:|G/\u0019;j_:LA!!\u000f\u00020\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002DA!\u0011QIA(\u001b\t\t9E\u0003\u0003\u0002J\u0005-\u0013\u0001\u00027b]\u001eT!!!\u0014\u0002\t)\fg/Y\u0005\u0004g\u0006\u001d\u0013\u0001\u00049s_\u0012,8\r^!sSRLXCAA+!\r!\u0014qK\u0005\u0004\u00033*$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$Hc\u0001/\u0002`!I\u0011\u0011\r\u000b\u0002\u0002\u0003\u0007\u0011QK\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\u001d\u0004#BA5\u0003_bVBAA6\u0015\r\ti'N\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA9\u0003W\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011qOA?!\r!\u0014\u0011P\u0005\u0004\u0003w*$a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003C2\u0012\u0011!a\u00019\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t\u0019%a!\t\u0013\u0005\u0005t#!AA\u0002\u0005U\u0013AB3rk\u0006d7\u000f\u0006\u0003\u0002x\u0005%\u0005\u0002CA11\u0005\u0005\t\u0019\u0001/)/\u0001\ti)a%\u0002\u0016\u0006e\u00151TAP\u0003C\u000b)+a*\u0002,\u00065\u0006c\u0001\u0019\u0002\u0010&\u0019\u0011\u0011S\u0011\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011qS\u0001\u0002<)\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015tiJd\u0003E]3hKb\u00048\f\f\u0011jIbl\u0016\u0006I\u0017!\u000bb$(/Y2uAQDW\r\t4jeN$\be\u001d;sS:<\u0007%\u001b8!i\",\u0007\u0005Y:ue\u0002\u0004C\u000f[1uA5\fGo\u00195!i\",\u0007\u0005\u0019:fO\u0016D\b\u000f\u0019\u0006!A\u0001\u0002S\r\u001f9sKN\u001c\u0018n\u001c8!C:$\u0007eY8se\u0016\u001c\bo\u001c8eS:<\u0007\u0005^8!i\",\u0007E]3hKb\u0004sM]8va\u0002Jg\u000eZ3y])\u0001\u0003%A\u0005be\u001e,X.\u001a8ug\u0006\u0012\u0011QT\u0001\tH*\u0001\u0003\u0005\t\u0011Be\u001e,X.\u001a8ugjR\u0001\u0005\t\u0011!A\u0001R\u0003e\u001d;sA5\u0002\u0013\rI:ue&tw\rI3yaJ,7o]5p]:R\u0001\u0005\t\u0011!A\u0001R\u0003E]3hKb\u0004\b%\f\u0011bAM$(/\u001b8hAI,\u0007O]3tK:$\u0018N\\4!C\u0002\u0012XmZ;mCJ\u0004S\r\u001f9sKN\u001c\u0018n\u001c8/AQCW\r\t:fO\u0016D\be\u001d;sS:<\u0007e\u001d5pk2$\u0007EY3!C*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t&bm\u0006\u0004#/Z4vY\u0006\u0014\b%\u001a=qe\u0016\u001c8/[8o]q\u0012'O\u0010\u001fcezR\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011TS:\u001cW\rI*qCJ\\\u0007E\r\u00181Y\u0001\u001aHO]5oO\u0002b\u0017\u000e^3sC2\u001c\b\u0005K5oG2,H-\u001b8hAI,w-\u001a=!a\u0006$H/\u001a:og&\u0002\u0013M]3!k:,7oY1qK\u0012\u0004\u0013N\u001c\u0011pkJ\u00043+\u0015'\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003/\u0019:tKJt\u0003ER8sA\u0015D\u0018-\u001c9mK2\u0002Co\u001c\u0011nCR\u001c\u0007\u000e\t\u0012]C\n\u001c'\u0005\f\u0011bAI,w-\u001e7be\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0011g_J\u0004\u0003M]3hKb\u0004\b\rI2b]\u0002\u0012WM\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\trF\fX1cG\u0012\u0012c\u0006\u00102s}q\u0012'O\u0010\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\"\u0006.\u001a:fA%\u001c\b%\u0019\u0011T#2\u00033m\u001c8gS\u001e\u0004se\u001d9be.t3/\u001d7/a\u0006\u00148/\u001a:/KN\u001c\u0017\r]3e'R\u0014\u0018N\\4MSR,'/\u00197tO\u0001\"\b.\u0019;!G\u0006t\u0007EY3!kN,G\r\t;p\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003EZ1mY\n\f7m\u001b\u0011u_\u0002\"\b.\u001a\u0011Ta\u0006\u00148\u000eI\u0019/m\u0001\u0012W\r[1wS>\u0014\bE]3hCJ$\u0017N\\4!gR\u0014\u0018N\\4!Y&$XM]1mAA\f'o]5oO:\u0002ci\u001c:!Kb\fW\u000e\u001d7fY)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I5gAQDW\rI2p]\u001aLw\rI5tA\u0015t\u0017M\u00197fI2\u0002C\u000f[3!AJ,w-\u001a=qA\u0002\"\b.\u0019;!G\u0006t\u0007%\\1uG\"\u0004#\u0005X1cG\n\u0002\u0013n\u001d\u0011#=r\u000b'm\u0019\u0013#])\u0001\u0003\u0005\t\u0011!A)\u0002\u0013\u000e\u001a=![\u0001\ng\u000eI5oi\u0016<WM\u001d\u0011fqB\u0014Xm]:j_:\u0004C\u000f[1uAI,\u0007O]3tK:$\u0018N\\4!i\",\u0007e\u001a:pkB\u0004\u0013N\u001c3fq:\u0002C\u000b[3!e\u0016<W\r\u001f\u0011nCf\u0014W\rI2p]R\f\u0017N\\:\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002S.\u001e7uSBdW\rI4s_V\u00048O\f\u0011aS\u0012D\b\rI5oI&\u001c\u0017\r^3tA]D\u0017n\u00195!e\u0016<W\r\u001f\u0011he>,\b\u000f\t;pA\u0015DHO]1di:\u0002C\u000b[3!OJ|W\u000f\u001d\u0011j]\u0012,\u0007\u0010I:i_VdGM\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\t,\u0007E\\8o[9,w-\u0019;jm\u0016t\u0003\u0005\u00165fA5Lg.[7v[\u00022\u0018\r\\;fA=4\u0007\u0005Y5eq\u0002\u0004\u0013n\u001d\u00111Y\u0001:\b.[2iA5,\u0017M\\:![\u0006$8\r[5oO\u0002\"\b.\u001a\u0011f]RL'/\u001a\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0012XmZ;mCJ\u0004S\r\u001f9sKN\u001c\u0018n\u001c8/A%3\u0007\u0005Y5eq\u0002\u0004\u0013n\u001d\u0011o_R\u00043\u000f]3dS\u001aLW\r\u001a\u0017!i\",\u0007\u0005Z3gCVdG\u000fI4s_V\u0004\b%\u001b8eKb\u0004c/\u00197vK\u0002J7\u000fI\u0019/AQCWM\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001LG\r\u001f1!a\u0006\u0014\u0018-\\3uKJ\u0004\u0013n\u001d\u0011uQ\u0016\u0004#*\u0019<bAI,w-\u001a=!\u001b\u0006$8\r[3sA\u001d\u0014x.\u001e9)S\u0001jW\r\u001e5pI\u0002Jg\u000eZ3y])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\t\u0019+\u0001*\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\n\u0004\u0007M\u00173aA:C\u0006I\u0014)9r#7&K\u0017)9r#7&K\u0014-AEJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u00191a)\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002*\u0006)\u0011GL\u001b/a\u0005)qM]8va\u0006\u0012\u0011qV\u0001\rgR\u0014\u0018N\\4`MVt7m]\u0001\u000e%\u0016<W\t\u001f9FqR\u0014\u0018m\u0019;\u0011\u0005AR2#\u0002\u000e\u00028\u0006\r\u0007\u0003CA]\u0003\u007f;uiR)\u000e\u0005\u0005m&bAA_k\u00059!/\u001e8uS6,\u0017\u0002BAa\u0003w\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84!\u0011\t)-a3\u000e\u0005\u0005\u001d'\u0002BAe\u0003\u0017\n!![8\n\u0007\r\u000b9\r\u0006\u0002\u00024\u0006AAo\\*ue&tw\r\u0006\u0002\u0002D\u0005)\u0011\r\u001d9msR9\u0011+a6\u0002Z\u0006m\u0007\"B#\u001e\u0001\u00049\u0005\"B&\u001e\u0001\u00049\u0005\"B'\u001e\u0001\u00049\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003C\fi\u000fE\u00035\u0003G\f9/C\u0002\u0002fV\u0012aa\u00149uS>t\u0007C\u0002\u001b\u0002j\u001e;u)C\u0002\u0002lV\u0012a\u0001V;qY\u0016\u001c\u0004\u0002CAx=\u0005\u0005\t\u0019A)\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002vB!\u0011QIA|\u0013\u0011\tI0a\u0012\u0003\r=\u0013'.Z2u\u0001")
public class RegExpExtract
extends RegExpExtractBase
implements Serializable {
    private final Expression subject;
    private final Expression regexp;
    private final Expression idx;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(RegExpExtract x$0) {
        return RegExpExtract$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, RegExpExtract> tupled() {
        return RegExpExtract$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, RegExpExtract>>> curried() {
        return RegExpExtract$.MODULE$.curried();
    }

    @Override
    public Expression subject() {
        return this.subject;
    }

    @Override
    public Expression regexp() {
        return this.regexp;
    }

    @Override
    public Expression idx() {
        return this.idx;
    }

    @Override
    public Object nullSafeEval(Object s, Object p, Object r) {
        UTF8String uTF8String;
        Matcher m = this.getLastMatcher(s, p);
        if (m.find()) {
            MatchResult mr = m.toMatchResult();
            int index = BoxesRunTime.unboxToInt((Object)r);
            RegExpExtractBase$.MODULE$.checkGroupIndex(this.prettyName(), mr.groupCount(), index);
            String group = mr.group(index);
            uTF8String = group == null ? UTF8String.EMPTY_UTF8 : UTF8String.fromString((String)group);
        } else {
            uTF8String = UTF8String.EMPTY_UTF8;
        }
        return uTF8String;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "regexp_extract";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String classNameRegExpExtractBase = RegExpExtractBase.class.getCanonicalName();
        String matcher = ctx.freshName("matcher");
        String matchResult = ctx.freshName("matchResult");
        String setEvNotNull = this.nullable() ? new StringBuilder(9).append(ev.isNull()).append(" = false;").toString() : "";
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable)(subject, regexp, idx) -> new StringBuilder(348).append("\n      ").append(RegExpUtils$.MODULE$.initLastMatcherCode(ctx, (String)subject, (String)regexp, matcher, this.prettyName())).append("\n      if (").append(matcher).append(".find()) {\n        java.util.regex.MatchResult ").append(matchResult).append(" = ").append(matcher).append(".toMatchResult();\n        ").append(classNameRegExpExtractBase).append(".checkGroupIndex(\"").append(this.prettyName()).append("\", ").append(matchResult).append(".groupCount(), ").append((String)idx).append(");\n        if (").append(matchResult).append(".group(").append((String)idx).append(") == null) {\n          ").append(ev.value()).append(" = UTF8String.EMPTY_UTF8;\n        } else {\n          ").append(ev.value()).append(" = UTF8String.fromString(").append(matchResult).append(".group(").append((String)idx).append("));\n        }\n        ").append(setEvNotNull).append("\n      } else {\n        ").append(ev.value()).append(" = UTF8String.EMPTY_UTF8;\n        ").append(setEvNotNull).append("\n      }").toString());
    }

    @Override
    public RegExpExtract withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public RegExpExtract copy(Expression subject, Expression regexp, Expression idx) {
        return new RegExpExtract(subject, regexp, idx);
    }

    public Expression copy$default$1() {
        return this.subject();
    }

    public Expression copy$default$2() {
        return this.regexp();
    }

    public Expression copy$default$3() {
        return this.idx();
    }

    @Override
    public String productPrefix() {
        return "RegExpExtract";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.subject();
                break;
            }
            case 1: {
                object = this.regexp();
                break;
            }
            case 2: {
                object = this.idx();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RegExpExtract;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "subject";
                break;
            }
            case 1: {
                string = "regexp";
                break;
            }
            case 2: {
                string = "idx";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RegExpExtract)) return false;
        boolean bl = true;
        if (!bl) return false;
        RegExpExtract regExpExtract = (RegExpExtract)x$1;
        Expression expression = this.subject();
        Expression expression2 = regExpExtract.subject();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.regexp();
        Expression expression4 = regExpExtract.regexp();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.idx();
        Expression expression6 = regExpExtract.idx();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!regExpExtract.canEqual(this)) return false;
        return true;
    }

    public RegExpExtract(Expression subject, Expression regexp, Expression idx) {
        this.subject = subject;
        this.regexp = regexp;
        this.idx = idx;
    }

    public RegExpExtract(Expression s, Expression r) {
        this(s, r, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1)));
    }
}

