/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple;

import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.SketchesStateException;
import org.apache.datasketches.tuple.CompactSketch;
import org.apache.datasketches.tuple.HashTables;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.Summary;
import org.apache.datasketches.tuple.SummarySetOperations;
import org.apache.datasketches.tuple.Util;

public class Intersection<S extends Summary> {
    private final SummarySetOperations<S> summarySetOps_;
    private boolean empty_;
    private long thetaLong_;
    private HashTables<S> hashTables_;
    private boolean firstCall_;

    public Intersection(SummarySetOperations<S> summarySetOps) {
        this.summarySetOps_ = summarySetOps;
        this.empty_ = false;
        this.thetaLong_ = Long.MAX_VALUE;
        this.hashTables_ = new HashTables();
        this.firstCall_ = true;
    }

    public CompactSketch<S> intersect(Sketch<S> tupleSketchA, Sketch<S> tupleSketchB) {
        this.reset();
        this.intersect(tupleSketchA);
        this.intersect(tupleSketchB);
        CompactSketch<S> csk = this.getResult();
        this.reset();
        return csk;
    }

    public CompactSketch<S> intersect(Sketch<S> tupleSketch, org.apache.datasketches.theta.Sketch thetaSketch, S summary) {
        this.reset();
        this.intersect(tupleSketch);
        this.intersect(thetaSketch, summary);
        CompactSketch<S> csk = this.getResult();
        this.reset();
        return csk;
    }

    public void intersect(Sketch<S> tupleSketch) {
        if (tupleSketch == null) {
            throw new SketchesArgumentException("Sketch must not be null");
        }
        boolean firstCall = this.firstCall_;
        this.firstCall_ = false;
        boolean emptyIn = tupleSketch.isEmpty();
        if (this.empty_ || emptyIn) {
            this.resetToEmpty();
            return;
        }
        long thetaLongIn = tupleSketch.getThetaLong();
        this.thetaLong_ = Math.min(this.thetaLong_, thetaLongIn);
        if (tupleSketch.getRetainedEntries() == 0) {
            this.hashTables_.clear();
            return;
        }
        if (firstCall) {
            this.hashTables_.fromSketch(tupleSketch);
        } else {
            if (this.hashTables_.numKeys == 0) {
                return;
            }
            this.hashTables_ = this.hashTables_.getIntersectHashTables(tupleSketch, this.thetaLong_, this.summarySetOps_);
        }
    }

    public void intersect(org.apache.datasketches.theta.Sketch thetaSketch, S summary) {
        if (thetaSketch == null) {
            throw new SketchesArgumentException("Sketch must not be null");
        }
        if (summary == null) {
            throw new SketchesArgumentException("Summary cannot be null.");
        }
        boolean firstCall = this.firstCall_;
        this.firstCall_ = false;
        boolean emptyIn = thetaSketch.isEmpty();
        if (this.empty_ || emptyIn) {
            this.resetToEmpty();
            return;
        }
        long thetaLongIn = thetaSketch.getThetaLong();
        this.thetaLong_ = Math.min(this.thetaLong_, thetaLongIn);
        int countIn = thetaSketch.getRetainedEntries();
        if (countIn == 0) {
            this.hashTables_.clear();
            return;
        }
        if (firstCall) {
            org.apache.datasketches.theta.Sketch firstSketch = thetaSketch;
            this.hashTables_.fromSketch(firstSketch, summary);
        } else {
            if (this.hashTables_.numKeys == 0) {
                return;
            }
            this.hashTables_ = this.hashTables_.getIntersectHashTables(thetaSketch, thetaLongIn, this.summarySetOps_, summary);
        }
    }

    public CompactSketch<S> getResult() {
        if (this.firstCall_) {
            throw new SketchesStateException("getResult() with no intervening intersections is not a legal result.");
        }
        int countIn = this.hashTables_.numKeys;
        if (countIn == 0) {
            return new CompactSketch(null, null, this.thetaLong_, this.empty_);
        }
        int tableSize = this.hashTables_.hashTable.length;
        long[] hashArr = new long[countIn];
        Summary[] summaryArr = Util.newSummaryArray(this.hashTables_.summaryTable, (int)countIn);
        int cnt = 0;
        for (int i = 0; i < tableSize; ++i) {
            long hash = this.hashTables_.hashTable[i];
            if (hash == 0L || hash > this.thetaLong_) continue;
            hashArr[cnt] = hash;
            summaryArr[cnt] = this.hashTables_.summaryTable[i].copy();
            ++cnt;
        }
        assert (cnt == countIn);
        return new CompactSketch(hashArr, summaryArr, this.thetaLong_, this.empty_);
    }

    public boolean hasResult() {
        return !this.firstCall_;
    }

    public void reset() {
        this.hardReset();
    }

    private void hardReset() {
        this.empty_ = false;
        this.thetaLong_ = Long.MAX_VALUE;
        this.hashTables_.clear();
        this.firstCall_ = true;
    }

    private void resetToEmpty() {
        this.empty_ = true;
        this.thetaLong_ = Long.MAX_VALUE;
        this.hashTables_.clear();
        this.firstCall_ = false;
    }

    static int getLgTableSize(int count) {
        int tableSize = Math.max(org.apache.datasketches.Util.ceilingPowerOf2((int)Math.ceil((double)count / 0.75)), 16);
        return Integer.numberOfTrailingZeros(tableSize);
    }
}

