/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar.compression;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.types.PhysicalBooleanType;
import org.apache.spark.sql.catalyst.types.PhysicalByteType;
import org.apache.spark.sql.catalyst.types.PhysicalDataType;
import org.apache.spark.sql.catalyst.types.PhysicalIntegerType;
import org.apache.spark.sql.catalyst.types.PhysicalLongType;
import org.apache.spark.sql.catalyst.types.PhysicalShortType;
import org.apache.spark.sql.execution.columnar.ByteBufferHelper$;
import org.apache.spark.sql.execution.columnar.ColumnType;
import org.apache.spark.sql.execution.columnar.NativeColumnType;
import org.apache.spark.sql.execution.columnar.compression.RunLengthEncoding$;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import scala.Function1;
import scala.Function3;
import scala.Predef$;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t5wAB\u001f?\u0011\u0003\u0003EJ\u0002\u0004O}!\u0005\u0005i\u0014\u0005\u0006?\u0006!\t!\u0019\u0005\bE\u0006\u0011\r\u0011\"\u0011d\u0011\u00199\u0017\u0001)A\u0005I\")\u0001.\u0001C!S\"9\u0011\u0011R\u0001\u0005B\u0005-\u0005b\u0002B9\u0003\u0011\u0005#1\u000f\u0004\u0005[\u0006\u0001a\u000e\u0003\u0006\u0002\u0006!\u0011\t\u0011)A\u0005\u0003\u000fAaa\u0018\u0005\u0005\u0002\u0005=\u0001\u0002CA\u000b\u0011\u0001\u0007I\u0011B2\t\u0013\u0005]\u0001\u00021A\u0005\n\u0005e\u0001bBA\u0013\u0011\u0001\u0006K\u0001\u001a\u0005\t\u0003OA\u0001\u0019!C\u0005G\"I\u0011\u0011\u0006\u0005A\u0002\u0013%\u00111\u0006\u0005\b\u0003_A\u0001\u0015)\u0003e\u0011-\t\t\u0004\u0003a\u0001\u0002\u0004%I!a\r\t\u0017\u0005m\u0002\u00021AA\u0002\u0013%\u0011Q\b\u0005\f\u0003\u0003B\u0001\u0019!A!B\u0013\t)\u0004\u0003\u0005\u0002D!\u0001\r\u0011\"\u0003d\u0011%\t)\u0005\u0003a\u0001\n\u0013\t9\u0005C\u0004\u0002L!\u0001\u000b\u0015\u00023\t\r\u00055\u0003\u0002\"\u0011d\u0011\u0019\ty\u0005\u0003C!G\"9\u0011\u0011\u000b\u0005\u0005B\u0005M\u0003bBA3\u0011\u0011\u0005\u0013q\r\u0004\u0007\u0003#\u000b\u0001!a%\t\u0015\u0005}5D!A!\u0002\u0013\tI\u0007\u0003\u0006\u0002\u0006m\u0011\t\u0011)A\u0005\u0003CCaaX\u000e\u0005\u0002\u0005\r\u0006\u0002CAV7\u0001\u0007I\u0011B2\t\u0013\u000556\u00041A\u0005\n\u0005=\u0006bBAZ7\u0001\u0006K\u0001\u001a\u0005\t\u0003k[\u0002\u0019!C\u0005G\"I\u0011qW\u000eA\u0002\u0013%\u0011\u0011\u0018\u0005\b\u0003{[\u0002\u0015)\u0003e\u0011-\tyl\u0007a\u0001\u0002\u0004%I!!1\t\u0017\u0005\u00157\u00041AA\u0002\u0013%\u0011q\u0019\u0005\f\u0003\u0017\\\u0002\u0019!A!B\u0013\t\u0019\rC\u0004\u0002Nn!\t%a4\t\u000f\u0005U7\u0004\"\u0011\u0002X\"9\u0011q\\\u000e\u0005\n\u0005\u0005\bb\u0002B\u00017\u0011%!1\u0001\u0005\b\u0005\u000fYB\u0011\u0002B\u0005\u0011\u001d\u0011\tb\u0007C\u0005\u0005'AqAa\u0006\u001c\t\u0013\u0011I\u0002C\u0004\u0003\"m!IAa\t\t\u000f\t\u001d2\u0004\"\u0003\u0003*!9!\u0011G\u000e\u0005\n\tM\u0002b\u0002B\u001c7\u0011%!\u0011\b\u0005\b\u0005\u0003ZB\u0011\u0002B\"\u0011\u001d\u0011yf\u0007C!\u0005CB\u0011B!$\u0002\u0003\u0003%\tEa$\t\u0011\tu\u0015!!A\u0005\u0002\rD\u0011Ba(\u0002\u0003\u0003%\tA!)\t\u0013\t\u0015\u0016!!A\u0005B\t\u001d\u0006\"\u0003B[\u0003\u0005\u0005I\u0011\u0001B\\\u0011%\u0011Y,AA\u0001\n\u0003\u0012i\fC\u0005\u0003@\u0006\t\t\u0011\"\u0011\u0003B\"I!1Y\u0001\u0002\u0002\u0013%!QY\u0001\u0012%VtG*\u001a8hi\",enY8eS:<'BA A\u0003-\u0019w.\u001c9sKN\u001c\u0018n\u001c8\u000b\u0005\u0005\u0013\u0015\u0001C2pYVlg.\u0019:\u000b\u0005\r#\u0015!C3yK\u000e,H/[8o\u0015\t)e)A\u0002tc2T!a\u0012%\u0002\u000bM\u0004\u0018M]6\u000b\u0005%S\u0015AB1qC\u000eDWMC\u0001L\u0003\ry'o\u001a\t\u0003\u001b\u0006i\u0011A\u0010\u0002\u0012%VtG*\u001a8hi\",enY8eS:<7#B\u0001Q-fc\u0006CA)U\u001b\u0005\u0011&\"A*\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0013&AB!osJ+g\r\u0005\u0002N/&\u0011\u0001L\u0010\u0002\u0012\u0007>l\u0007O]3tg&|gnU2iK6,\u0007CA)[\u0013\tY&KA\u0004Qe>$Wo\u0019;\u0011\u0005Ek\u0016B\u00010S\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0019a\u0014N\\5u}\r\u0001A#\u0001'\u0002\rQL\b/Z%e+\u0005!\u0007CA)f\u0013\t1'KA\u0002J]R\fq\u0001^=qK&#\u0007%A\u0004f]\u000e|G-\u001a:\u0016\u0007)\f\u0019\tF\u0002l\u0003\u000b\u0003B\u0001\u001c\u0005\u0002\u00026\t\u0011AA\u0004F]\u000e|G-\u001a:\u0016\u0005=$8c\u0001\u0005QaB\u0019Q*\u001d:\n\u00055t\u0004CA:u\u0019\u0001!Q!\u001e\u0005C\u0002Y\u0014\u0011\u0001V\t\u0003oj\u0004\"!\u0015=\n\u0005e\u0014&a\u0002(pi\"Lgn\u001a\t\u0004w\u0006\u0005Q\"\u0001?\u000b\u0005ut\u0018!\u0002;za\u0016\u001c(BA@E\u0003!\u0019\u0017\r^1msN$\u0018bAA\u0002y\n\u0001\u0002\u000b[=tS\u000e\fG\u000eR1uCRK\b/Z\u0001\u000bG>dW/\u001c8UsB,\u0007#BA\u0005\u0003\u0017\u0011X\"\u0001!\n\u0007\u00055\u0001I\u0001\tOCRLg/Z\"pYVlg\u000eV=qKR!\u0011\u0011CA\n!\ra\u0007B\u001d\u0005\b\u0003\u000bQ\u0001\u0019AA\u0004\u0003EyVO\\2p[B\u0014Xm]:fINK'0Z\u0001\u0016?Vt7m\\7qe\u0016\u001c8/\u001a3TSj,w\fJ3r)\u0011\tY\"!\t\u0011\u0007E\u000bi\"C\u0002\u0002 I\u0013A!\u00168ji\"A\u00111\u0005\u0007\u0002\u0002\u0003\u0007A-A\u0002yIE\n!cX;oG>l\u0007O]3tg\u0016$7+\u001b>fA\u0005yqlY8naJ,7o]3e'&TX-A\n`G>l\u0007O]3tg\u0016$7+\u001b>f?\u0012*\u0017\u000f\u0006\u0003\u0002\u001c\u00055\u0002\u0002CA\u0012\u001f\u0005\u0005\t\u0019\u00013\u0002!}\u001bw.\u001c9sKN\u001cX\rZ*ju\u0016\u0004\u0013!\u00037bgR4\u0016\r\\;f+\t\t)\u0004E\u0002s\u0003oIA!!\u000f\u0002\u0002\ta\u0011J\u001c;fe:\fG\u000eV=qK\u0006iA.Y:u-\u0006dW/Z0%KF$B!a\u0007\u0002@!I\u00111\u0005\n\u0002\u0002\u0003\u0007\u0011QG\u0001\u000bY\u0006\u001cHOV1mk\u0016\u0004\u0013a\u00027bgR\u0014VO\\\u0001\fY\u0006\u001cHOU;o?\u0012*\u0017\u000f\u0006\u0003\u0002\u001c\u0005%\u0003\u0002CA\u0012+\u0005\u0005\t\u0019\u00013\u0002\u00111\f7\u000f\u001e*v]\u0002\n\u0001#\u001e8d_6\u0004(/Z:tK\u0012\u001c\u0016N_3\u0002\u001d\r|W\u000e\u001d:fgN,GmU5{K\u0006Qr-\u0019;iKJ\u001cu.\u001c9sKN\u001c\u0018NY5mSRL8\u000b^1ugR1\u00111DA+\u0003CBq!a\u0016\u001a\u0001\u0004\tI&A\u0002s_^\u0004B!a\u0017\u0002^5\ta0C\u0002\u0002`y\u00141\"\u00138uKJt\u0017\r\u001c*po\"1\u00111M\rA\u0002\u0011\fqa\u001c:eS:\fG.\u0001\u0005d_6\u0004(/Z:t)\u0019\tI'!\u001f\u0002~A!\u00111NA;\u001b\t\tiG\u0003\u0003\u0002p\u0005E\u0014a\u00018j_*\u0011\u00111O\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002x\u00055$A\u0003\"zi\u0016\u0014UO\u001a4fe\"9\u00111\u0010\u000eA\u0002\u0005%\u0014\u0001\u00024s_6Dq!a \u001b\u0001\u0004\tI'\u0001\u0002u_B\u00191/a!\u0005\u000bU,!\u0019\u0001<\t\u000f\u0005\u0015Q\u00011\u0001\u0002\bB1\u0011\u0011BA\u0006\u0003\u0003\u000bq\u0001Z3d_\u0012,'/\u0006\u0003\u0002\u000e\n%DCBAH\u0005W\u0012i\u0007\u0005\u0003m7\t\u001d$a\u0002#fG>$WM]\u000b\u0005\u0003+\u000bij\u0005\u0003\u001c!\u0006]\u0005#B'\u0002\u001a\u0006m\u0015bAAI}A\u00191/!(\u0005\u000bU\\\"\u0019\u0001<\u0002\r\t,hMZ3s!\u0019\tI!a\u0003\u0002\u001cR1\u0011QUAT\u0003S\u0003B\u0001\\\u000e\u0002\u001c\"9\u0011q\u0014\u0010A\u0002\u0005%\u0004bBA\u0003=\u0001\u0007\u0011\u0011U\u0001\u0004eVt\u0017a\u0002:v]~#S-\u001d\u000b\u0005\u00037\t\t\f\u0003\u0005\u0002$\u0001\n\t\u00111\u0001e\u0003\u0011\u0011XO\u001c\u0011\u0002\u0015Y\fG.^3D_VtG/\u0001\bwC2,XmQ8v]R|F%Z9\u0015\t\u0005m\u00111\u0018\u0005\t\u0003G\u0019\u0013\u0011!a\u0001I\u0006Ya/\u00197vK\u000e{WO\u001c;!\u00031\u0019WO\u001d:f]R4\u0016\r\\;f+\t\t\u0019\r\u0005\u0003\u0002\u001c\u0006]\u0012\u0001E2veJ,g\u000e\u001e,bYV,w\fJ3r)\u0011\tY\"!3\t\u0013\u0005\rb%!AA\u0002\u0005\r\u0017!D2veJ,g\u000e\u001e,bYV,\u0007%\u0001\u0003oKb$HCBA\u000e\u0003#\f\u0019\u000eC\u0004\u0002X!\u0002\r!!\u0017\t\r\u0005\r\u0004\u00061\u0001e\u0003\u001dA\u0017m\u001d(fqR,\"!!7\u0011\u0007E\u000bY.C\u0002\u0002^J\u0013qAQ8pY\u0016\fg.\u0001\u0006qkR\u0014un\u001c7fC:$\u0002\"a\u0007\u0002d\u0006M\u0018q\u001f\u0005\b\u0003KT\u0003\u0019AAt\u00031\u0019w\u000e\\;n]Z+7\r^8s!\u0011\tI/a<\u000e\u0005\u0005-(bAAw\u0005\u0006Qa/Z2u_JL'0\u001a3\n\t\u0005E\u00181\u001e\u0002\u0015/JLG/\u00192mK\u000e{G.^7o-\u0016\u001cGo\u001c:\t\r\u0005U(\u00061\u0001e\u0003\r\u0001xn\u001d\u0005\b\u0003sT\u0003\u0019AA~\u0003\u00151\u0018\r\\;f!\r\t\u0016Q`\u0005\u0004\u0003\u007f\u0014&\u0001\u0002'p]\u001e\fqaZ3u\u0005f$X\r\u0006\u0003\u0002|\n\u0015\u0001bBAPW\u0001\u0007\u0011\u0011N\u0001\baV$()\u001f;f)!\tYBa\u0003\u0003\u000e\t=\u0001bBAsY\u0001\u0007\u0011q\u001d\u0005\u0007\u0003kd\u0003\u0019\u00013\t\u000f\u0005eH\u00061\u0001\u0002|\u0006Aq-\u001a;TQ>\u0014H\u000f\u0006\u0003\u0002|\nU\u0001bBAP[\u0001\u0007\u0011\u0011N\u0001\taV$8\u000b[8siRA\u00111\u0004B\u000e\u0005;\u0011y\u0002C\u0004\u0002f:\u0002\r!a:\t\r\u0005Uh\u00061\u0001e\u0011\u001d\tIP\fa\u0001\u0003w\faaZ3u\u0013:$H\u0003BA~\u0005KAq!a(0\u0001\u0004\tI'\u0001\u0004qkRLe\u000e\u001e\u000b\t\u00037\u0011YC!\f\u00030!9\u0011Q\u001d\u0019A\u0002\u0005\u001d\bBBA{a\u0001\u0007A\rC\u0004\u0002zB\u0002\r!a?\u0002\u000f\u001d,G\u000fT8oOR!\u00111 B\u001b\u0011\u001d\ty*\ra\u0001\u0003S\nq\u0001];u\u0019>tw\r\u0006\u0005\u0002\u001c\tm\"Q\bB \u0011\u001d\t)O\ra\u0001\u0003ODa!!>3\u0001\u0004!\u0007bBA}e\u0001\u0007\u00111`\u0001\fI\u0016\u001cw.\u001c9sKN\u001c\b\u0007\u0006\u0006\u0002\u001c\t\u0015#q\tB&\u0005+Bq!!:4\u0001\u0004\t9\u000f\u0003\u0004\u0003JM\u0002\r\u0001Z\u0001\tG\u0006\u0004\u0018mY5us\"9!QJ\u001aA\u0002\t=\u0013aC4fi\u001a+hn\u0019;j_:\u0004r!\u0015B)\u0003S\nY0C\u0002\u0003TI\u0013\u0011BR;oGRLwN\\\u0019\t\u000f\t]3\u00071\u0001\u0003Z\u0005Y\u0001/\u001e;Gk:\u001cG/[8o!)\t&1LAtI\u0006m\u00181D\u0005\u0004\u0005;\u0012&!\u0003$v]\u000e$\u0018n\u001c84\u0003)!WmY8naJ,7o\u001d\u000b\u0007\u00037\u0011\u0019G!\u001a\t\u000f\u0005\u0015H\u00071\u0001\u0002h\"1!\u0011\n\u001bA\u0002\u0011\u00042a\u001dB5\t\u0015)hA1\u0001w\u0011\u001d\tyJ\u0002a\u0001\u0003SBq!!\u0002\u0007\u0001\u0004\u0011y\u0007\u0005\u0004\u0002\n\u0005-!qM\u0001\tgV\u0004\bo\u001c:ugR!\u0011\u0011\u001cB;\u0011\u001d\t)a\u0002a\u0001\u0005o\u0002DA!\u001f\u0003\u0002B1\u0011\u0011\u0002B>\u0005\u007fJ1A! A\u0005)\u0019u\u000e\\;n]RK\b/\u001a\t\u0004g\n\u0005E\u0001\u0004BB\u0005k\n\t\u0011!A\u0003\u0002\t\u0015%aA0%eE\u0019qOa\"\u0011\u0007E\u0013I)C\u0002\u0003\fJ\u00131!\u00118z\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!\u0011\u0013\t\u0005\u0005'\u0013I*\u0004\u0002\u0003\u0016*!!qSA9\u0003\u0011a\u0017M\\4\n\t\tm%Q\u0013\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!q\u0011BR\u0011!\t\u0019cNA\u0001\u0002\u0004!\u0017a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t%\u0006C\u0002BV\u0005c\u00139)\u0004\u0002\u0003.*\u0019!q\u0016*\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u00034\n5&\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!7\u0003:\"I\u00111E\u001d\u0002\u0002\u0003\u0007!qQ\u0001\tQ\u0006\u001c\bnQ8eKR\tA-\u0001\u0005u_N#(/\u001b8h)\t\u0011\t*A\u0006sK\u0006$'+Z:pYZ,GC\u0001Bd!\u0011\u0011\u0019J!3\n\t\t-'Q\u0013\u0002\u0007\u001f\nTWm\u0019;")
public final class RunLengthEncoding {
    public static String toString() {
        return RunLengthEncoding$.MODULE$.toString();
    }

    public static int hashCode() {
        return RunLengthEncoding$.MODULE$.hashCode();
    }

    public static boolean canEqual(Object object) {
        return RunLengthEncoding$.MODULE$.canEqual(object);
    }

    public static Iterator<Object> productIterator() {
        return RunLengthEncoding$.MODULE$.productIterator();
    }

    public static Object productElement(int n) {
        return RunLengthEncoding$.MODULE$.productElement(n);
    }

    public static int productArity() {
        return RunLengthEncoding$.MODULE$.productArity();
    }

    public static String productPrefix() {
        return RunLengthEncoding$.MODULE$.productPrefix();
    }

    public static boolean supports(ColumnType<?> columnType) {
        return RunLengthEncoding$.MODULE$.supports(columnType);
    }

    public static <T extends PhysicalDataType> Decoder<T> decoder(ByteBuffer byteBuffer, NativeColumnType<T> nativeColumnType) {
        return RunLengthEncoding$.MODULE$.decoder(byteBuffer, (NativeColumnType)nativeColumnType);
    }

    public static <T extends PhysicalDataType> Encoder<T> encoder(NativeColumnType<T> nativeColumnType) {
        return RunLengthEncoding$.MODULE$.encoder((NativeColumnType)nativeColumnType);
    }

    public static int typeId() {
        return RunLengthEncoding$.MODULE$.typeId();
    }

    public static class Decoder<T extends PhysicalDataType>
    implements org.apache.spark.sql.execution.columnar.compression.Decoder<T> {
        private final ByteBuffer buffer;
        private final NativeColumnType<T> columnType;
        private int run;
        private int valueCount;
        private Object currentValue;

        private int run() {
            return this.run;
        }

        private void run_$eq(int x$1) {
            this.run = x$1;
        }

        private int valueCount() {
            return this.valueCount;
        }

        private void valueCount_$eq(int x$1) {
            this.valueCount = x$1;
        }

        private Object currentValue() {
            return this.currentValue;
        }

        private void currentValue_$eq(Object x$1) {
            this.currentValue = x$1;
        }

        @Override
        public void next(InternalRow row, int ordinal) {
            if (this.valueCount() == this.run()) {
                this.currentValue_$eq(this.columnType.extract(this.buffer));
                this.run_$eq(ByteBufferHelper$.MODULE$.getInt(this.buffer));
                this.valueCount_$eq(1);
            } else {
                this.valueCount_$eq(this.valueCount() + 1);
            }
            this.columnType.setField(row, ordinal, this.currentValue());
        }

        @Override
        public boolean hasNext() {
            return this.valueCount() < this.run() || this.buffer.hasRemaining();
        }

        private void putBoolean(WritableColumnVector columnVector, int pos, long value) {
            columnVector.putBoolean(pos, value == 1L);
        }

        private long getByte(ByteBuffer buffer) {
            return buffer.get();
        }

        private void putByte(WritableColumnVector columnVector, int pos, long value) {
            columnVector.putByte(pos, (byte)value);
        }

        private long getShort(ByteBuffer buffer) {
            return buffer.getShort();
        }

        private void putShort(WritableColumnVector columnVector, int pos, long value) {
            columnVector.putShort(pos, (short)value);
        }

        private long getInt(ByteBuffer buffer) {
            return buffer.getInt();
        }

        private void putInt(WritableColumnVector columnVector, int pos, long value) {
            columnVector.putInt(pos, (int)value);
        }

        private long getLong(ByteBuffer buffer) {
            return buffer.getLong();
        }

        private void putLong(WritableColumnVector columnVector, int pos, long value) {
            columnVector.putLong(pos, value);
        }

        private void decompress0(WritableColumnVector columnVector, int capacity, Function1<ByteBuffer, Object> getFunction, Function3<WritableColumnVector, Object, Object, BoxedUnit> putFunction) {
            ByteBuffer nullsBuffer = this.buffer.duplicate().order(ByteOrder.nativeOrder());
            nullsBuffer.rewind();
            int nullCount = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
            int nextNullIndex = nullCount > 0 ? ByteBufferHelper$.MODULE$.getInt(nullsBuffer) : -1;
            int seenNulls = 0;
            int runLocal = 0;
            int valueCountLocal = 0;
            long currentValueLocal = 0L;
            for (int pos = 0; pos < capacity; ++pos) {
                Object object;
                Predef$.MODULE$.assert(valueCountLocal <= runLocal);
                if (pos != nextNullIndex) {
                    if (valueCountLocal == runLocal) {
                        currentValueLocal = BoxesRunTime.unboxToLong((Object)getFunction.apply((Object)this.buffer));
                        runLocal = ByteBufferHelper$.MODULE$.getInt(this.buffer);
                        valueCountLocal = 1;
                    } else {
                        ++valueCountLocal;
                    }
                    object = putFunction.apply((Object)columnVector, (Object)BoxesRunTime.boxToInteger((int)pos), (Object)BoxesRunTime.boxToLong((long)currentValueLocal));
                    continue;
                }
                if (++seenNulls < nullCount) {
                    nextNullIndex = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
                }
                columnVector.putNull(pos);
                object = BoxedUnit.UNIT;
            }
        }

        @Override
        public void decompress(WritableColumnVector columnVector2, int capacity) {
            T t = this.columnType.dataType();
            if (t instanceof PhysicalBooleanType) {
                this.decompress0(columnVector2, capacity, (Function1<ByteBuffer, Object>)(Function1 & Serializable & scala.Serializable)buffer -> BoxesRunTime.boxToLong((long)this.getByte(buffer)), (Function3<WritableColumnVector, Object, Object, BoxedUnit>)(Function3 & Serializable & scala.Serializable)(columnVector, pos, value) -> {
                    this.putBoolean(columnVector, BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToLong((Object)value));
                    return BoxedUnit.UNIT;
                });
                return;
            }
            if (t instanceof PhysicalByteType) {
                this.decompress0(columnVector2, capacity, (Function1<ByteBuffer, Object>)(Function1 & Serializable & scala.Serializable)buffer -> BoxesRunTime.boxToLong((long)this.getByte(buffer)), (Function3<WritableColumnVector, Object, Object, BoxedUnit>)(Function3 & Serializable & scala.Serializable)(columnVector, pos, value) -> {
                    this.putByte(columnVector, BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToLong((Object)value));
                    return BoxedUnit.UNIT;
                });
                return;
            }
            if (t instanceof PhysicalShortType) {
                this.decompress0(columnVector2, capacity, (Function1<ByteBuffer, Object>)(Function1 & Serializable & scala.Serializable)buffer -> BoxesRunTime.boxToLong((long)this.getShort(buffer)), (Function3<WritableColumnVector, Object, Object, BoxedUnit>)(Function3 & Serializable & scala.Serializable)(columnVector, pos, value) -> {
                    this.putShort(columnVector, BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToLong((Object)value));
                    return BoxedUnit.UNIT;
                });
                return;
            }
            if (t instanceof PhysicalIntegerType) {
                this.decompress0(columnVector2, capacity, (Function1<ByteBuffer, Object>)(Function1 & Serializable & scala.Serializable)buffer -> BoxesRunTime.boxToLong((long)this.getInt(buffer)), (Function3<WritableColumnVector, Object, Object, BoxedUnit>)(Function3 & Serializable & scala.Serializable)(columnVector, pos, value) -> {
                    this.putInt(columnVector, BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToLong((Object)value));
                    return BoxedUnit.UNIT;
                });
                return;
            }
            if (t instanceof PhysicalLongType) {
                this.decompress0(columnVector2, capacity, (Function1<ByteBuffer, Object>)(Function1 & Serializable & scala.Serializable)buffer -> BoxesRunTime.boxToLong((long)this.getLong(buffer)), (Function3<WritableColumnVector, Object, Object, BoxedUnit>)(Function3 & Serializable & scala.Serializable)(columnVector, pos, value) -> {
                    this.putLong(columnVector, BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToLong((Object)value));
                    return BoxedUnit.UNIT;
                });
                return;
            }
            throw new IllegalStateException("Not supported type in RunLengthEncoding.");
        }

        public Decoder(ByteBuffer buffer, NativeColumnType<T> columnType) {
            this.buffer = buffer;
            this.columnType = columnType;
            this.run = 0;
            this.valueCount = 0;
        }
    }

    public static class Encoder<T extends PhysicalDataType>
    implements org.apache.spark.sql.execution.columnar.compression.Encoder<T> {
        private final NativeColumnType<T> columnType;
        private int _uncompressedSize;
        private int _compressedSize;
        private Object lastValue;
        private int lastRun;

        @Override
        public double compressionRatio() {
            return org.apache.spark.sql.execution.columnar.compression.Encoder.compressionRatio$(this);
        }

        private int _uncompressedSize() {
            return this._uncompressedSize;
        }

        private void _uncompressedSize_$eq(int x$1) {
            this._uncompressedSize = x$1;
        }

        private int _compressedSize() {
            return this._compressedSize;
        }

        private void _compressedSize_$eq(int x$1) {
            this._compressedSize = x$1;
        }

        private Object lastValue() {
            return this.lastValue;
        }

        private void lastValue_$eq(Object x$1) {
            this.lastValue = x$1;
        }

        private int lastRun() {
            return this.lastRun;
        }

        private void lastRun_$eq(int x$1) {
            this.lastRun = x$1;
        }

        @Override
        public int uncompressedSize() {
            return this._uncompressedSize();
        }

        @Override
        public int compressedSize() {
            return this._compressedSize();
        }

        @Override
        public void gatherCompressibilityStats(InternalRow row, int ordinal) {
            Object value = this.columnType.getField(row, ordinal);
            int actualSize = this.columnType.actualSize(row, ordinal);
            this._uncompressedSize_$eq(this._uncompressedSize() + actualSize);
            if (this.lastValue() == null) {
                this.lastValue_$eq(this.columnType.clone(value));
                this.lastRun_$eq(1);
                this._compressedSize_$eq(this._compressedSize() + (actualSize + 4));
                return;
            }
            if (BoxesRunTime.equals((Object)this.lastValue(), value)) {
                this.lastRun_$eq(this.lastRun() + 1);
                return;
            }
            this._compressedSize_$eq(this._compressedSize() + (actualSize + 4));
            this.lastValue_$eq(this.columnType.clone(value));
            this.lastRun_$eq(1);
        }

        @Override
        public ByteBuffer compress(ByteBuffer from, ByteBuffer to) {
            Object object;
            to.putInt(RunLengthEncoding$.MODULE$.typeId());
            if (from.hasRemaining()) {
                int currentRun = 1;
                Object currentValue = this.columnType.extract(from);
                while (from.hasRemaining()) {
                    Object value = this.columnType.extract(from);
                    if (BoxesRunTime.equals(value, currentValue)) {
                        ++currentRun;
                        continue;
                    }
                    this.columnType.append(currentValue, to);
                    to.putInt(currentRun);
                    currentValue = value;
                    currentRun = 1;
                }
                this.columnType.append(currentValue, to);
                object = to.putInt(currentRun);
            } else {
                object = BoxedUnit.UNIT;
            }
            to.rewind();
            return to;
        }

        public Encoder(NativeColumnType<T> columnType) {
            this.columnType = columnType;
            org.apache.spark.sql.execution.columnar.compression.Encoder.$init$(this);
            this._uncompressedSize = 0;
            this._compressedSize = 0;
            this.lastRun = 0;
        }
    }
}

