/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.LeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.command.CommandUtils$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.LeafRunnableCommand;
import org.apache.spark.sql.execution.command.LoadDataCommand$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.util.PartitioningUtils$;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple5;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\tUa\u0001\u0002\u0011\"\u0001:B\u0001B\u0012\u0001\u0003\u0016\u0004%\ta\u0012\u0005\t\u0019\u0002\u0011\t\u0012)A\u0005\u0011\"AQ\n\u0001BK\u0002\u0013\u0005a\n\u0003\u0005[\u0001\tE\t\u0015!\u0003P\u0011!Y\u0006A!f\u0001\n\u0003a\u0006\u0002\u00031\u0001\u0005#\u0005\u000b\u0011B/\t\u0011\u0005\u0004!Q3A\u0005\u0002qC\u0001B\u0019\u0001\u0003\u0012\u0003\u0006I!\u0018\u0005\tG\u0002\u0011)\u001a!C\u0001I\"AQ\u0010\u0001B\tB\u0003%Q\rC\u0003\u007f\u0001\u0011\u0005q\u0010C\u0004\u0002\u000e\u0001!\t%a\u0004\t\u0013\u0005U\u0002!!A\u0005\u0002\u0005]\u0002\"CA\"\u0001E\u0005I\u0011AA#\u0011%\tY\u0006AI\u0001\n\u0003\ti\u0006C\u0005\u0002b\u0001\t\n\u0011\"\u0001\u0002d!I\u0011q\r\u0001\u0012\u0002\u0013\u0005\u00111\r\u0005\n\u0003S\u0002\u0011\u0013!C\u0001\u0003WB\u0011\"a\u001c\u0001\u0003\u0003%\t%!\u001d\t\u0013\u0005\u0005\u0005!!A\u0005\u0002\u0005\r\u0005\"CAF\u0001\u0005\u0005I\u0011AAG\u0011%\tI\nAA\u0001\n\u0003\nY\nC\u0005\u0002*\u0002\t\t\u0011\"\u0001\u0002,\"I\u0011q\u0016\u0001\u0002\u0002\u0013\u0005\u0013\u0011W\u0004\b\u0003k\u000b\u0003\u0012AA\\\r\u0019\u0001\u0013\u0005#\u0001\u0002:\"1aP\u0007C\u0001\u0003\u0003D\u0001\"a1\u001b\t\u0003)\u0013Q\u0019\u0005\n\u0003[T\u0012\u0011!CA\u0003_D\u0011\"a?\u001b\u0003\u0003%\t)!@\t\u0013\t-!$!A\u0005\n\t5!a\u0004'pC\u0012$\u0015\r^1D_6l\u0017M\u001c3\u000b\u0005\t\u001a\u0013aB2p[6\fg\u000e\u001a\u0006\u0003I\u0015\n\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005\u0019:\u0013aA:rY*\u0011\u0001&K\u0001\u0006gB\f'o\u001b\u0006\u0003U-\na!\u00199bG\",'\"\u0001\u0017\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001y\u0013(P\"\u0011\u0005A:T\"A\u0019\u000b\u0005I\u001a\u0014a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003iU\nQ\u0001\u001d7b]NT!AN\u0013\u0002\u0011\r\fG/\u00197zgRL!\u0001O\u0019\u0003\u00171{w-[2bYBc\u0017M\u001c\t\u0003umj\u0011!I\u0005\u0003y\u0005\u00121\u0003T3bMJ+hN\\1cY\u0016\u001cu.\\7b]\u0012\u0004\"AP!\u000e\u0003}R\u0011\u0001Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0005~\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002?\t&\u0011Qi\u0010\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0006i\u0006\u0014G.Z\u000b\u0002\u0011B\u0011\u0011JS\u0007\u0002k%\u00111*\u000e\u0002\u0010)\u0006\u0014G.Z%eK:$\u0018NZ5fe\u00061A/\u00192mK\u0002\nA\u0001]1uQV\tq\n\u0005\u0002Q/:\u0011\u0011+\u0016\t\u0003%~j\u0011a\u0015\u0006\u0003)6\na\u0001\u0010:p_Rt\u0014B\u0001,@\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001,\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Y{\u0014!\u00029bi\"\u0004\u0013aB5t\u0019>\u001c\u0017\r\\\u000b\u0002;B\u0011aHX\u0005\u0003?~\u0012qAQ8pY\u0016\fg.\u0001\u0005jg2{7-\u00197!\u0003-I7o\u0014<fe^\u0014\u0018\u000e^3\u0002\u0019%\u001cxJ^3soJLG/\u001a\u0011\u0002\u0013A\f'\u000f^5uS>tW#A3\u0011\u0007y2\u0007.\u0003\u0002h\u007f\t1q\n\u001d;j_:\u0004\"!\u001b>\u000f\u0005)<hBA6v\u001d\taGO\u0004\u0002ng:\u0011aN\u001d\b\u0003_Ft!A\u00159\n\u00031J!AK\u0016\n\u0005!J\u0013B\u0001\u0014(\u0013\t1T%\u0003\u0002wk\u000591-\u0019;bY><\u0017B\u0001=z\u00031\u0019\u0015\r^1m_\u001e$\u0016\u0010]3t\u0015\t1X'\u0003\u0002|y\n\u0011B+\u00192mKB\u000b'\u000f^5uS>t7\u000b]3d\u0015\tA\u00180\u0001\u0006qCJ$\u0018\u000e^5p]\u0002\na\u0001P5oSRtD\u0003DA\u0001\u0003\u0007\t)!a\u0002\u0002\n\u0005-\u0001C\u0001\u001e\u0001\u0011\u001515\u00021\u0001I\u0011\u0015i5\u00021\u0001P\u0011\u0015Y6\u00021\u0001^\u0011\u0015\t7\u00021\u0001^\u0011\u0015\u00197\u00021\u0001f\u0003\r\u0011XO\u001c\u000b\u0005\u0003#\tY\u0003\u0005\u0004\u0002\u0014\u0005u\u00111\u0005\b\u0005\u0003+\tIBD\u0002S\u0003/I\u0011\u0001Q\u0005\u0004\u00037y\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003?\t\tCA\u0002TKFT1!a\u0007@!\u0011\t)#a\n\u000e\u0003\u0015J1!!\u000b&\u0005\r\u0011vn\u001e\u0005\b\u0003[a\u0001\u0019AA\u0018\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\u0011\t)#!\r\n\u0007\u0005MRE\u0001\u0007Ta\u0006\u00148nU3tg&|g.\u0001\u0003d_BLH\u0003DA\u0001\u0003s\tY$!\u0010\u0002@\u0005\u0005\u0003b\u0002$\u000e!\u0003\u0005\r\u0001\u0013\u0005\b\u001b6\u0001\n\u00111\u0001P\u0011\u001dYV\u0002%AA\u0002uCq!Y\u0007\u0011\u0002\u0003\u0007Q\fC\u0004d\u001bA\u0005\t\u0019A3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\t\u0016\u0004\u0011\u0006%3FAA&!\u0011\ti%a\u0016\u000e\u0005\u0005=#\u0002BA)\u0003'\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005Us(\u0001\u0006b]:|G/\u0019;j_:LA!!\u0017\u0002P\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011q\f\u0016\u0004\u001f\u0006%\u0013AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003KR3!XA%\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ\nabY8qs\u0012\"WMZ1vYR$S'\u0006\u0002\u0002n)\u001aQ-!\u0013\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\u0019\b\u0005\u0003\u0002v\u0005}TBAA<\u0015\u0011\tI(a\u001f\u0002\t1\fgn\u001a\u0006\u0003\u0003{\nAA[1wC&\u0019\u0001,a\u001e\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\u0015\u0005c\u0001 \u0002\b&\u0019\u0011\u0011R \u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005=\u0015Q\u0013\t\u0004}\u0005E\u0015bAAJ\u007f\t\u0019\u0011I\\=\t\u0013\u0005]U#!AA\u0002\u0005\u0015\u0015a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\u001eB1\u0011qTAS\u0003\u001fk!!!)\u000b\u0007\u0005\rv(\u0001\u0006d_2dWm\u0019;j_:LA!a*\u0002\"\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\ri\u0016Q\u0016\u0005\n\u0003/;\u0012\u0011!a\u0001\u0003\u001f\u000ba!Z9vC2\u001cHcA/\u00024\"I\u0011q\u0013\r\u0002\u0002\u0003\u0007\u0011qR\u0001\u0010\u0019>\fG\rR1uC\u000e{W.\\1oIB\u0011!HG\n\u00055\u0005m6\tE\u0002?\u0003{K1!a0@\u0005\u0019\te.\u001f*fMR\u0011\u0011qW\u0001\u000e[\u0006\\W-U;bY&4\u0017.\u001a3\u0015\u0011\u0005\u001d\u0017q[At\u0003W\u0004B!!3\u0002T6\u0011\u00111\u001a\u0006\u0005\u0003\u001b\fy-\u0001\u0002gg*\u0019\u0011\u0011[\u0015\u0002\r!\fGm\\8q\u0013\u0011\t).a3\u0003\tA\u000bG\u000f\u001b\u0005\b\u00033d\u0002\u0019AAn\u0003)!WMZ1vYR,&/\u001b\t\u0005\u0003;\f\u0019/\u0004\u0002\u0002`*!\u0011\u0011]A>\u0003\rqW\r^\u0005\u0005\u0003K\fyNA\u0002V%&Cq!!;\u001d\u0001\u0004\t9-\u0001\u0006x_J\\\u0017N\\4ESJDa!\u0014\u000fA\u0002\u0005\u001d\u0017!B1qa2LH\u0003DA\u0001\u0003c\f\u00190!>\u0002x\u0006e\b\"\u0002$\u001e\u0001\u0004A\u0005\"B'\u001e\u0001\u0004y\u0005\"B.\u001e\u0001\u0004i\u0006\"B1\u001e\u0001\u0004i\u0006\"B2\u001e\u0001\u0004)\u0017aB;oCB\u0004H.\u001f\u000b\u0005\u0003\u007f\u00149\u0001\u0005\u0003?M\n\u0005\u0001\u0003\u0003 \u0003\u0004!{U,X3\n\u0007\t\u0015qH\u0001\u0004UkBdW-\u000e\u0005\n\u0005\u0013q\u0012\u0011!a\u0001\u0003\u0003\t1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t=\u0001\u0003BA;\u0005#IAAa\u0005\u0002x\t1qJ\u00196fGR\u0004")
public class LoadDataCommand
extends LogicalPlan
implements LeafRunnableCommand,
scala.Serializable {
    private final TableIdentifier table;
    private final String path;
    private final boolean isLocal;
    private final boolean isOverwrite;
    private final Option<Map<String, String>> partition;
    private Map<String, SQLMetric> metrics;
    private final Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<Tuple5<TableIdentifier, String, Object, Object, Option<Map<String, String>>>> unapply(LoadDataCommand loadDataCommand) {
        return LoadDataCommand$.MODULE$.unapply(loadDataCommand);
    }

    @Override
    public final Seq<LogicalPlan> children() {
        return LeafLike.children$((LeafLike)this);
    }

    public final TreeNode mapChildren(Function1 f) {
        return LeafLike.mapChildren$((LeafLike)this, (Function1)f);
    }

    public TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return LeafLike.withNewChildrenInternal$((LeafLike)this, (IndexedSeq)newChildren);
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        LoadDataCommand loadDataCommand = this;
        synchronized (loadDataCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        if (!this.bitmap$0) {
            return this.metrics$lzycompute();
        }
        return this.metrics;
    }

    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    public final void org$apache$spark$sql$catalyst$plans$logical$Command$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public TableIdentifier table() {
        return this.table;
    }

    public String path() {
        return this.path;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public boolean isOverwrite() {
        return this.isOverwrite;
    }

    public Option<Map<String, String>> partition() {
        return this.partition;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        Path path;
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        CatalogTable targetTable = catalog.getTableMetadata(this.table());
        String tableIdentWithDB = targetTable.identifier().quotedString();
        Option normalizedSpec = this.partition().map((Function1 & Serializable & scala.Serializable)spec -> PartitioningUtils$.MODULE$.normalizePartitionSpec(spec, targetTable.partitionSchema(), tableIdentWithDB, sparkSession.sessionState().conf().resolver()));
        if (DDLUtils$.MODULE$.isDatasourceTable(targetTable)) {
            throw QueryCompilationErrors$.MODULE$.loadDataNotSupportedForDatasourceTablesError(tableIdentWithDB);
        }
        if (targetTable.partitionColumnNames().nonEmpty()) {
            if (this.partition().isEmpty()) {
                throw QueryCompilationErrors$.MODULE$.loadDataWithoutPartitionSpecProvidedError(tableIdentWithDB);
            }
            if (targetTable.partitionColumnNames().size() != ((TraversableOnce)this.partition().get()).size()) {
                throw QueryCompilationErrors$.MODULE$.loadDataPartitionSizeNotMatchNumPartitionColumnsError(tableIdentWithDB, ((TraversableOnce)this.partition().get()).size(), targetTable.partitionColumnNames().size());
            }
        } else if (this.partition().nonEmpty()) {
            throw QueryCompilationErrors$.MODULE$.loadDataTargetTableNotPartitionedButPartitionSpecWasProvidedError(tableIdentWithDB);
        }
        if (this.isLocal()) {
            FileContext localFS = FileContext.getLocalFSFileContext();
            path = LoadDataCommand$.MODULE$.makeQualified(FsConstants.LOCAL_FS_URI, localFS.getWorkingDirectory(), new Path(this.path()));
        } else {
            Path loadPath = new Path(this.path());
            String defaultFSConf = sparkSession.sessionState().newHadoopConf().get("fs.defaultFS");
            URI defaultFS = defaultFSConf == null ? new URI("") : new URI(defaultFSConf);
            Path uriPath = new Path(new StringBuilder(7).append("/user/").append(System.getProperty("user.name")).append("/").toString());
            path = LoadDataCommand$.MODULE$.makeQualified(defaultFS, uriPath, loadPath);
        }
        Path loadPath = path;
        FileSystem fs = loadPath.getFileSystem(sparkSession.sessionState().newHadoopConf());
        try {
            FileStatus[] fileStatus = fs.globStatus(loadPath);
            if (fileStatus == null || new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileStatus)).isEmpty()) {
                throw QueryCompilationErrors$.MODULE$.loadDataInputPathNotExistError(this.path());
            }
        }
        catch (IllegalArgumentException e) {
            this.log().warn(new StringBuilder(42).append("Exception while validating the load path ").append(this.path()).append(" ").toString(), (Throwable)e);
            throw QueryCompilationErrors$.MODULE$.loadDataInputPathNotExistError(this.path());
        }
        if (this.partition().nonEmpty()) {
            catalog.loadPartition(targetTable.identifier(), loadPath.toString(), (Map)normalizedSpec.get(), this.isOverwrite(), true, this.isLocal());
        } else {
            catalog.loadTable(targetTable.identifier(), loadPath.toString(), this.isOverwrite(), this.isLocal());
        }
        sparkSession.catalog().refreshTable(tableIdentWithDB);
        CommandUtils$.MODULE$.updateTableStats(sparkSession, targetTable);
        return (Seq)Nil$.MODULE$;
    }

    public LoadDataCommand copy(TableIdentifier table, String path, boolean isLocal, boolean isOverwrite, Option<Map<String, String>> partition) {
        return new LoadDataCommand(table, path, isLocal, isOverwrite, partition);
    }

    public TableIdentifier copy$default$1() {
        return this.table();
    }

    public String copy$default$2() {
        return this.path();
    }

    public boolean copy$default$3() {
        return this.isLocal();
    }

    public boolean copy$default$4() {
        return this.isOverwrite();
    }

    public Option<Map<String, String>> copy$default$5() {
        return this.partition();
    }

    public String productPrefix() {
        return "LoadDataCommand";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.table();
            }
            case 1: {
                return this.path();
            }
            case 2: {
                return BoxesRunTime.boxToBoolean((boolean)this.isLocal());
            }
            case 3: {
                return BoxesRunTime.boxToBoolean((boolean)this.isOverwrite());
            }
            case 4: {
                return this.partition();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof LoadDataCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof LoadDataCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        LoadDataCommand loadDataCommand = (LoadDataCommand)x$1;
        TableIdentifier tableIdentifier = this.table();
        TableIdentifier tableIdentifier2 = loadDataCommand.table();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        String string = this.path();
        String string2 = loadDataCommand.path();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.isLocal() != loadDataCommand.isLocal()) return false;
        if (this.isOverwrite() != loadDataCommand.isOverwrite()) return false;
        Option<Map<String, String>> option = this.partition();
        Option<Map<String, String>> option2 = loadDataCommand.partition();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!loadDataCommand.canEqual(this)) return false;
        return true;
    }

    public LoadDataCommand(TableIdentifier table, String path, boolean isLocal, boolean isOverwrite, Option<Map<String, String>> partition) {
        this.table = table;
        this.path = path;
        this.isLocal = isLocal;
        this.isOverwrite = isOverwrite;
        this.partition = partition;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
        LeafLike.$init$((LeafLike)this);
    }
}

