/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg;

import breeze.linalg.DenseVector;
import java.io.Serializable;
import org.apache.spark.mllib.linalg.DenseVector$;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.VectorUDT;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.sql.types.SQLUserDefinedType;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.JsonAssoc$;
import org.json4s.JsonDSL$;
import org.json4s.jackson.JsonMethods$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@SQLUserDefinedType(udt=VectorUDT.class)
@ScalaSignature(bytes="\u0006\u0001\u0005uf\u0001\u0002\u000e\u001c\u0001\u0019B\u0001\"\r\u0001\u0003\u0006\u0004%\tA\r\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005g!)A\t\u0001C\u0001\u000b\")!\n\u0001C!\u0017\")\u0001\u000b\u0001C!#\")Q\f\u0001C!e!1q\f\u0001C!?\u0001DQa\u001a\u0001\u0005B!DQ\u0001\u001c\u0001\u0005B5DQ!\u001d\u0001\u0005BIDQa\u001f\u0001\u0005BqDQ! \u0001\u0005B-Ca!a\u0001\u0001\t\u0003Z\u0005\u0002CA\u0004\u0001\u0011\u00053$!\u0003\t\r\u0005U\u0001\u0001\"\u0011L\u0011\u001d\ti\u0002\u0001C!\u0003?Aq!a\n\u0001\t\u0003\nI\u0003\u0003\u0005\u0002>\u0001!\teHA \u0011!\tI\u0006\u0001C!?\u0005}raBA=7!\u0005\u00111\u0010\u0004\u00075mA\t!! \t\r\u0011+B\u0011AAC\u0011\u001d\t9)\u0006C\u0001\u0003\u0013Cq!a'\u0016\t\u0003\ti\nC\u0005\u0002&V\t\t\u0011\"\u0003\u0002(\nYA)\u001a8tKZ+7\r^8s\u0015\taR$\u0001\u0004mS:\fGn\u001a\u0006\u0003=}\tQ!\u001c7mS\nT!\u0001I\u0011\u0002\u000bM\u0004\u0018M]6\u000b\u0005\t\u001a\u0013AB1qC\u000eDWMC\u0001%\u0003\ry'oZ\u0002\u0001'\r\u0001q%\f\t\u0003Q-j\u0011!\u000b\u0006\u0002U\u0005)1oY1mC&\u0011A&\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\u00059zS\"A\u000e\n\u0005AZ\"A\u0002,fGR|'/\u0001\u0004wC2,Xm]\u000b\u0002gA\u0019\u0001\u0006\u000e\u001c\n\u0005UJ#!B!se\u0006L\bC\u0001\u00158\u0013\tA\u0014F\u0001\u0004E_V\u0014G.\u001a\u0015\u0004\u0003i\u0002\u0005CA\u001e?\u001b\u0005a$BA\u001f \u0003)\tgN\\8uCRLwN\\\u0005\u0003\u007fq\u0012QaU5oG\u0016\f\u0013!Q\u0001\u0006c9\u0002d\u0006M\u0001\bm\u0006dW/Z:!Q\r\u0011!\bQ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0019;\u0005C\u0001\u0018\u0001\u0011\u0015\t4\u00011\u00014Q\r9%\b\u0011\u0015\u0004\u0007i\u0002\u0015\u0001B:ju\u0016,\u0012\u0001\u0014\t\u0003Q5K!AT\u0015\u0003\u0007%sG\u000fK\u0002\u0005u\u0001\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0002%B\u00111K\u0017\b\u0003)b\u0003\"!V\u0015\u000e\u0003YS!aV\u0013\u0002\rq\u0012xn\u001c;?\u0013\tI\u0016&\u0001\u0004Qe\u0016$WMZ\u0005\u00037r\u0013aa\u0015;sS:<'BA-*\u0003\u001d!x.\u0011:sCfD3A\u0002\u001eA\u0003!\t7O\u0011:fKj,W#A1\u0011\u0007\t4g'D\u0001d\u0015\taBMC\u0001f\u0003\u0019\u0011'/Z3{K&\u0011\u0001gY\u0001\u0006CB\u0004H.\u001f\u000b\u0003m%DQA\u001b\u0005A\u00021\u000b\u0011!\u001b\u0015\u0004\u0011i\u0002\u0015\u0001B2paf,\u0012A\u0012\u0015\u0004\u0013iz\u0017%\u00019\u0002\u000bEr\u0013G\f\u0019\u0002\r\u0015\fX/\u00197t)\t\u0019h\u000f\u0005\u0002)i&\u0011Q/\u000b\u0002\b\u0005>|G.Z1o\u0011\u00159(\u00021\u0001y\u0003\u0015yG\u000f[3s!\tA\u00130\u0003\u0002{S\t\u0019\u0011I\\=\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012\u0001T\u0001\u000b]Vl\u0017i\u0019;jm\u0016\u001c\bf\u0001\u0007;\u007f\u0006\u0012\u0011\u0011A\u0001\u0006c9\"d\u0006M\u0001\f]Vlgj\u001c8{KJ|7\u000fK\u0002\u000eu}\f\u0001\u0003^8Ta\u0006\u00148/Z,ji\"\u001c\u0016N_3\u0015\t\u0005-\u0011\u0011\u0003\t\u0004]\u00055\u0011bAA\b7\ta1\u000b]1sg\u00164Vm\u0019;pe\"1\u00111\u0003\bA\u00021\u000b1A\u001c8{\u0003\u0019\t'oZ7bq\"\"qBOA\rC\t\tY\"A\u00032]Ur\u0003'\u0001\u0004u_*\u001bxN\\\u000b\u0002%\"\"\u0001COA\u0012C\t\t)#A\u00032]Yr\u0003'\u0001\u0003bg6cUCAA\u0016!\u0011\ti#!\u000e\u000e\u0005\u0005=\"b\u0001\u000f\u00022)\u0019\u00111G\u0010\u0002\u00055d\u0017b\u0001\u000e\u00020!\"\u0011COA\u001dC\t\tY$A\u00033]Ar\u0003'\u0001\u0005ji\u0016\u0014\u0018\r^8s+\t\t\t\u0005\u0005\u0004\u0002D\u00055\u00131\u000b\b\u0005\u0003\u000b\nIED\u0002V\u0003\u000fJ\u0011AK\u0005\u0004\u0003\u0017J\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003\u001f\n\tF\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\r\tY%\u000b\t\u0006Q\u0005UCJN\u0005\u0004\u0003/J#A\u0002+va2,''\u0001\bbGRLg/Z%uKJ\fGo\u001c:)\u000f\u0001\ti&!\u001c\u0002pA!\u0011qLA5\u001b\t\t\tG\u0003\u0003\u0002d\u0005\u0015\u0014!\u0002;za\u0016\u001c(bAA4?\u0005\u00191/\u001d7\n\t\u0005-\u0014\u0011\r\u0002\u0013'FcUk]3s\t\u00164\u0017N\\3e)f\u0004X-A\u0002vIR\u001c#!!\u001d\u0011\u00079\n\u0019(C\u0002\u0002vm\u0011\u0011BV3di>\u0014X\u000b\u0012+)\u0007\u0001Q\u0004)A\u0006EK:\u001cXMV3di>\u0014\bC\u0001\u0018\u0016'\u0011)r%a \u0011\u0007!\n\t)C\u0002\u0002\u0004&\u0012AbU3sS\u0006d\u0017N_1cY\u0016$\"!a\u001f\u0002\u000fUt\u0017\r\u001d9msR!\u00111RAI!\u0011A\u0013QR\u001a\n\u0007\u0005=\u0015F\u0001\u0004PaRLwN\u001c\u0005\u0007\u0003';\u0002\u0019\u0001$\u0002\u0005\u00114\b\u0006B\f;\u0003/\u000b#!!'\u0002\u000bEr3G\f\u0019\u0002\r\u0019\u0014x.\\'M)\r1\u0015q\u0014\u0005\b\u0003CC\u0002\u0019AA\u0016\u0003\u00051\b\u0006\u0002\r;\u0003s\t1B]3bIJ+7o\u001c7wKR\u0011\u0011\u0011\u0016\t\u0005\u0003W\u000b),\u0004\u0002\u0002.*!\u0011qVAY\u0003\u0011a\u0017M\\4\u000b\u0005\u0005M\u0016\u0001\u00026bm\u0006LA!a.\u0002.\n1qJ\u00196fGRDC!\u0006\u001e\u0002\u0018\"\"ACOAL\u0001")
public class DenseVector
implements Vector {
    private final double[] values;

    public static DenseVector fromML(org.apache.spark.ml.linalg.DenseVector denseVector) {
        return DenseVector$.MODULE$.fromML(denseVector);
    }

    public static Option<double[]> unapply(DenseVector denseVector) {
        return DenseVector$.MODULE$.unapply(denseVector);
    }

    @Override
    public void foreach(Function2<Object, Object, BoxedUnit> f) {
        Vector.foreach$(this, f);
    }

    @Override
    public void foreachActive(Function2<Object, Object, BoxedUnit> f) {
        Vector.foreachActive$(this, f);
    }

    @Override
    public void foreachNonZero(Function2<Object, Object, BoxedUnit> f) {
        Vector.foreachNonZero$(this, f);
    }

    @Override
    public SparseVector toSparse() {
        return Vector.toSparse$(this);
    }

    @Override
    public DenseVector toDense() {
        return Vector.toDense$(this);
    }

    @Override
    public Vector compressed() {
        return Vector.compressed$(this);
    }

    @Override
    public double dot(Vector v) {
        return Vector.dot$(this, v);
    }

    @Override
    public Iterator<Tuple2<Object, Object>> nonZeroIterator() {
        return Vector.nonZeroIterator$(this);
    }

    @Override
    public double sparsity() {
        return Vector.sparsity$(this);
    }

    public double[] values() {
        return this.values;
    }

    @Override
    public int size() {
        return this.values().length;
    }

    public String toString() {
        return new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.values())).mkString("[", ",", "]");
    }

    @Override
    public double[] toArray() {
        return this.values();
    }

    @Override
    public breeze.linalg.Vector<Object> asBreeze() {
        return new DenseVector.mcD.sp(this.values());
    }

    @Override
    public double apply(int i) {
        return this.values()[i];
    }

    @Override
    public DenseVector copy() {
        return new DenseVector((double[])this.values().clone());
    }

    @Override
    public boolean equals(Object other) {
        return Vector.equals$(this, other);
    }

    @Override
    public int hashCode() {
        int result = 31 + this.size();
        int end = this.values().length;
        int nnz = 0;
        for (int i = 0; i < end && nnz < Vectors$.MODULE$.MAX_HASH_NNZ(); ++i) {
            double v = this.values()[i];
            if (v == 0.0) continue;
            result = 31 * result + i;
            long bits = Double.doubleToLongBits(this.values()[i]);
            result = 31 * result + (int)(bits ^ bits >>> 32);
            ++nnz;
        }
        return result;
    }

    @Override
    public int numActives() {
        return this.size();
    }

    @Override
    public int numNonzeros() {
        IntRef nnz = IntRef.create((int)0);
        new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.values())).foreach((Function1)(JFunction1.mcVD.sp & Serializable & scala.Serializable)v -> {
            if (v != 0.0) {
                ++nnz$2.elem;
                return;
            }
        });
        return nnz.elem;
    }

    @Override
    public SparseVector toSparseWithSize(int nnz) {
        int[] ii = new int[nnz];
        double[] vv = new double[nnz];
        IntRef k = IntRef.create((int)0);
        this.foreachNonZero((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVID.sp & Serializable & scala.Serializable)(i, v) -> {
            ii$1[k$1.elem] = i;
            vv$1[k$1.elem] = v;
            ++k$1.elem;
        });
        return new SparseVector(this.size(), ii, vv);
    }

    @Override
    public int argmax() {
        if (this.size() == 0) {
            return -1;
        }
        int maxIdx = 0;
        double maxValue = this.values()[0];
        for (int i = 1; i < this.size(); ++i) {
            if (!(this.values()[i] > maxValue)) continue;
            maxIdx = i;
            maxValue = this.values()[i];
        }
        return maxIdx;
    }

    @Override
    public String toJson() {
        JsonAST.JObject jValue;
        JsonAST.JObject x$1 = jValue = JsonAssoc$.MODULE$.$tilde$extension0(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)BoxesRunTime.boxToInteger((int)1)), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"values"), (Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.values())).toSeq()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)), (Function1 & Serializable & scala.Serializable)s -> JsonDSL$.MODULE$.seq2jvalue(s, (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.double2jvalue(BoxesRunTime.unboxToDouble((Object)x))));
        Formats x$2 = JsonMethods$.MODULE$.render$default$2((JsonAST.JValue)x$1);
        return JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JsonAST.JValue)x$1, x$2));
    }

    public org.apache.spark.ml.linalg.DenseVector asML() {
        return new org.apache.spark.ml.linalg.DenseVector(this.values());
    }

    @Override
    public Iterator<Tuple2<Object, Object>> iterator() {
        double[] localValues = this.values();
        return package$.MODULE$.Iterator().tabulate(this.size(), (Function1 & Serializable & scala.Serializable)i -> DenseVector.$anonfun$iterator$2(localValues, BoxesRunTime.unboxToInt((Object)i)));
    }

    @Override
    public Iterator<Tuple2<Object, Object>> activeIterator() {
        return this.iterator();
    }

    public static final /* synthetic */ Tuple2 $anonfun$iterator$2(double[] localValues$1, int i) {
        return new Tuple2.mcID.sp(i, localValues$1[i]);
    }

    public DenseVector(double[] values) {
        this.values = values;
        Vector.$init$(this);
    }
}

