/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import io.fabric8.kubernetes.api.model.IntOrStringFluent;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPort;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class NetworkPolicyPortFluent<A extends NetworkPolicyPortFluent<A>>
extends BaseFluent<A> {
    private Integer endPort;
    private IntOrStringBuilder port;
    private String protocol;
    private Map<String, Object> additionalProperties;

    public NetworkPolicyPortFluent() {
    }

    public NetworkPolicyPortFluent(NetworkPolicyPort instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NetworkPolicyPort instance) {
        NetworkPolicyPort networkPolicyPort = instance = instance != null ? instance : new NetworkPolicyPort();
        if (instance != null) {
            this.withEndPort(instance.getEndPort());
            this.withPort(instance.getPort());
            this.withProtocol(instance.getProtocol());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Integer getEndPort() {
        return this.endPort;
    }

    public A withEndPort(Integer endPort) {
        this.endPort = endPort;
        return (A)((Object)this);
    }

    public boolean hasEndPort() {
        return this.endPort != null;
    }

    public IntOrString buildPort() {
        return this.port != null ? this.port.build() : null;
    }

    public A withPort(IntOrString port) {
        this._visitables.remove((Object)"port");
        if (port != null) {
            this.port = new IntOrStringBuilder(port);
            this._visitables.get((Object)"port").add(this.port);
        } else {
            this.port = null;
            this._visitables.get((Object)"port").remove(this.port);
        }
        return (A)((Object)this);
    }

    public boolean hasPort() {
        return this.port != null;
    }

    public A withNewPort(Object value) {
        return this.withPort(new IntOrString(value));
    }

    public PortNested<A> withNewPort() {
        return new PortNested(null);
    }

    public PortNested<A> withNewPortLike(IntOrString item) {
        return new PortNested(item);
    }

    public PortNested<A> editPort() {
        return this.withNewPortLike(Optional.ofNullable(this.buildPort()).orElse(null));
    }

    public PortNested<A> editOrNewPort() {
        return this.withNewPortLike(Optional.ofNullable(this.buildPort()).orElse(new IntOrStringBuilder().build()));
    }

    public PortNested<A> editOrNewPortLike(IntOrString item) {
        return this.withNewPortLike(Optional.ofNullable(this.buildPort()).orElse(item));
    }

    public String getProtocol() {
        return this.protocol;
    }

    public A withProtocol(String protocol) {
        this.protocol = protocol;
        return (A)((Object)this);
    }

    public boolean hasProtocol() {
        return this.protocol != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkPolicyPortFluent that = (NetworkPolicyPortFluent)((Object)o);
        if (!Objects.equals(this.endPort, that.endPort)) {
            return false;
        }
        if (!Objects.equals(this.port, that.port)) {
            return false;
        }
        if (!Objects.equals(this.protocol, that.protocol)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.endPort, this.port, this.protocol, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.endPort != null) {
            sb.append("endPort:");
            sb.append(this.endPort + ",");
        }
        if (this.port != null) {
            sb.append("port:");
            sb.append(String.valueOf(this.port) + ",");
        }
        if (this.protocol != null) {
            sb.append("protocol:");
            sb.append(this.protocol + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PortNested<N>
    extends IntOrStringFluent<PortNested<N>>
    implements Nested<N> {
        IntOrStringBuilder builder;

        PortNested(IntOrString item) {
            this.builder = new IntOrStringBuilder((IntOrStringFluent)this, item);
        }

        public N and() {
            return (N)NetworkPolicyPortFluent.this.withPort(this.builder.build());
        }

        public N endPort() {
            return this.and();
        }
    }
}

