/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.executor;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongArray;
import org.apache.spark.executor.ExecutorMetrics;
import org.apache.spark.executor.ExecutorMetrics$;
import org.apache.spark.executor.ExecutorMetricsPoller$TCMP$;
import org.apache.spark.executor.ExecutorMetricsSource;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.memory.MemoryManager;
import org.apache.spark.metrics.ExecutorMetricType$;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.mutable.HashMap;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t=b!B\u0016-\u00019\"\u0004\u0002C!\u0001\u0005\u0003\u0005\u000b\u0011B\"\t\u0011%\u0003!\u0011!Q\u0001\n)C\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006IA\u0014\u0005\u0006+\u0002!\tAV\u0003\u00057\u0002\u0001ALB\u0003c\u0001\u0001c3\r\u0003\u0005t\r\tU\r\u0011\"\u0001u\u0011!)hA!E!\u0002\u0013Q\u0005\u0002\u0003<\u0007\u0005+\u0007I\u0011A<\t\u0013\u0005%aA!E!\u0002\u0013A\bBB+\u0007\t\u0003\tY\u0001C\u0005\u0002\u0016\u0019\t\t\u0011\"\u0001\u0002\u0018!I\u0011Q\u0004\u0004\u0012\u0002\u0013\u0005\u0011q\u0004\u0005\n\u0003k1\u0011\u0013!C\u0001\u0003oA\u0011\"a\u000f\u0007\u0003\u0003%\t%!\u0010\t\u0013\u0005-c!!A\u0005\u0002\u00055\u0003\"CA(\r\u0005\u0005I\u0011AA)\u0011%\tiFBA\u0001\n\u0003\ny\u0006C\u0005\u0002n\u0019\t\t\u0011\"\u0001\u0002p!I\u0011\u0011\u0010\u0004\u0002\u0002\u0013\u0005\u00131\u0010\u0005\n\u0003\u007f2\u0011\u0011!C!\u0003\u0003C\u0011\"a!\u0007\u0003\u0003%\t%!\"\t\u0013\u0005\u001de!!A\u0005B\u0005%uACAG\u0001\u0005\u0005\t\u0012\u0001\u0017\u0002\u0010\u001aI!\rAA\u0001\u0012\u0003a\u0013\u0011\u0013\u0005\u0007+f!\t!!+\t\u0013\u0005\r\u0015$!A\u0005F\u0005\u0015\u0005\"CAV3\u0005\u0005I\u0011QAW\u0011%\t\u0019,GA\u0001\n\u0003\u000b)\f\u0003\u0006\u0002@\u0002\u0011\r\u0011\"\u0001-\u0003\u0003D\u0001\"!4\u0001A\u0003%\u00111\u0019\u0005\n\u0003\u001f\u0004!\u0019!C\u0005\u0003#D\u0001\"!6\u0001A\u0003%\u00111\u001b\u0005\n\u0003/\u0004!\u0019!C\u0005\u00033D\u0001\"a9\u0001A\u0003%\u00111\u001c\u0005\b\u0003K\u0004A\u0011AAt\u0011\u001d\ty\u000f\u0001C\u0001\u0003ODq!!=\u0001\t\u0003\t\u0019\u0010C\u0004\u0003\u0002\u0001!\tAa\u0001\t\u000f\t-\u0001\u0001\"\u0001\u0003\u000e!9!q\u0003\u0001\u0005\u0002\te\u0001b\u0002B\u0017\u0001\u0011\u0005\u0011q\u001d\u0002\u0016\u000bb,7-\u001e;pe6+GO]5dgB{G\u000e\\3s\u0015\tic&\u0001\u0005fq\u0016\u001cW\u000f^8s\u0015\ty\u0003'A\u0003ta\u0006\u00148N\u0003\u00022e\u00051\u0011\r]1dQ\u0016T\u0011aM\u0001\u0004_J<7c\u0001\u00016wA\u0011a'O\u0007\u0002o)\t\u0001(A\u0003tG\u0006d\u0017-\u0003\u0002;o\t1\u0011I\\=SK\u001a\u0004\"\u0001P \u000e\u0003uR!A\u0010\u0018\u0002\u0011%tG/\u001a:oC2L!\u0001Q\u001f\u0003\u000f1{wmZ5oO\u0006iQ.Z7pefl\u0015M\\1hKJ\u001c\u0001\u0001\u0005\u0002E\u000f6\tQI\u0003\u0002G]\u00051Q.Z7pefL!\u0001S#\u0003\u001b5+Wn\u001c:z\u001b\u0006t\u0017mZ3s\u0003=\u0001x\u000e\u001c7j]\u001eLe\u000e^3sm\u0006d\u0007C\u0001\u001cL\u0013\tauG\u0001\u0003M_:<\u0017!F3yK\u000e,Ho\u001c:NKR\u0014\u0018nY:T_V\u00148-\u001a\t\u0004m=\u000b\u0016B\u0001)8\u0005\u0019y\u0005\u000f^5p]B\u0011!kU\u0007\u0002Y%\u0011A\u000b\f\u0002\u0016\u000bb,7-\u001e;pe6+GO]5dgN{WO]2f\u0003\u0019a\u0014N\\5u}Q!q\u000bW-[!\t\u0011\u0006\u0001C\u0003B\t\u0001\u00071\tC\u0003J\t\u0001\u0007!\nC\u0003N\t\u0001\u0007aJ\u0001\u0005Ti\u0006<WmS3z!\u00111TlX0\n\u0005y;$A\u0002+va2,'\u0007\u0005\u00027A&\u0011\u0011m\u000e\u0002\u0004\u0013:$(\u0001\u0002+D\u001bB\u001bBAB\u001beOB\u0011a'Z\u0005\u0003M^\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002ia:\u0011\u0011N\u001c\b\u0003U6l\u0011a\u001b\u0006\u0003Y\n\u000ba\u0001\u0010:p_Rt\u0014\"\u0001\u001d\n\u0005=<\u0014a\u00029bG.\fw-Z\u0005\u0003cJ\u0014AbU3sS\u0006d\u0017N_1cY\u0016T!a\\\u001c\u0002\u000b\r|WO\u001c;\u0016\u0003)\u000baaY8v]R\u0004\u0013!\u00029fC.\u001cX#\u0001=\u0011\u0007e\f)!D\u0001{\u0015\tYH0\u0001\u0004bi>l\u0017n\u0019\u0006\u0003{z\f!bY8oGV\u0014(/\u001a8u\u0015\ry\u0018\u0011A\u0001\u0005kRLGN\u0003\u0002\u0002\u0004\u0005!!.\u0019<b\u0013\r\t9A\u001f\u0002\u0010\u0003R|W.[2M_:<\u0017I\u001d:bs\u00061\u0001/Z1lg\u0002\"b!!\u0004\u0002\u0012\u0005M\u0001cAA\b\r5\t\u0001\u0001C\u0003t\u0017\u0001\u0007!\nC\u0003w\u0017\u0001\u0007\u00010\u0001\u0003d_BLHCBA\u0007\u00033\tY\u0002C\u0004t\u0019A\u0005\t\u0019\u0001&\t\u000fYd\u0001\u0013!a\u0001q\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u0011U\rQ\u00151E\u0016\u0003\u0003K\u0001B!a\n\u000225\u0011\u0011\u0011\u0006\u0006\u0005\u0003W\ti#A\u0005v]\u000eDWmY6fI*\u0019\u0011qF\u001c\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00024\u0005%\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA\u001dU\rA\u00181E\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005}\u0002\u0003BA!\u0003\u000fj!!a\u0011\u000b\t\u0005\u0015\u0013\u0011A\u0001\u0005Y\u0006tw-\u0003\u0003\u0002J\u0005\r#AB*ue&tw-\u0001\u0007qe>$Wo\u0019;Be&$\u00180F\u0001`\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\u0015\u0002ZA\u0019a'!\u0016\n\u0007\u0005]sGA\u0002B]fD\u0001\"a\u0017\u0012\u0003\u0003\u0005\raX\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\u0005\u0004CBA2\u0003S\n\u0019&\u0004\u0002\u0002f)\u0019\u0011qM\u001c\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002l\u0005\u0015$\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!\u001d\u0002xA\u0019a'a\u001d\n\u0007\u0005UtGA\u0004C_>dW-\u00198\t\u0013\u0005m3#!AA\u0002\u0005M\u0013A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a\u0010\u0002~!A\u00111\f\u000b\u0002\u0002\u0003\u0007q,\u0001\u0005iCND7i\u001c3f)\u0005y\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005}\u0012AB3rk\u0006d7\u000f\u0006\u0003\u0002r\u0005-\u0005\"CA./\u0005\u0005\t\u0019AA*\u0003\u0011!6)\u0014)\u0011\u0007\u0005=\u0011dE\u0003\u001a\u0003'\u000by\n\u0005\u0005\u0002\u0016\u0006m%\n_A\u0007\u001b\t\t9JC\u0002\u0002\u001a^\nqA];oi&lW-\u0003\u0003\u0002\u001e\u0006]%!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeA!\u0011\u0011UAT\u001b\t\t\u0019K\u0003\u0003\u0002&\u0006\u0005\u0011AA5p\u0013\r\t\u00181\u0015\u000b\u0003\u0003\u001f\u000bQ!\u00199qYf$b!!\u0004\u00020\u0006E\u0006\"B:\u001d\u0001\u0004Q\u0005\"\u0002<\u001d\u0001\u0004A\u0018aB;oCB\u0004H.\u001f\u000b\u0005\u0003o\u000bY\f\u0005\u00037\u001f\u0006e\u0006\u0003\u0002\u001c^\u0015bD\u0011\"!0\u001e\u0003\u0003\u0005\r!!\u0004\u0002\u0007a$\u0003'A\u0005ti\u0006<W\rV\"N!V\u0011\u00111\u0019\t\t\u0003\u000b\f9-a3\u0002\u000e5\tA0C\u0002\u0002Jr\u0014\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q!\r\ty!B\u0001\u000bgR\fw-\u001a+D\u001bB\u0003\u0013a\u0004;bg.lU\r\u001e:jGB+\u0017m[:\u0016\u0005\u0005M\u0007CBAc\u0003\u000fT\u00050\u0001\tuCN\\W*\u001a;sS\u000e\u0004V-Y6tA\u00051\u0001o\u001c7mKJ,\"!a7\u0011\tYz\u0015Q\u001c\t\u0005\u0003\u000b\fy.C\u0002\u0002br\u0014\u0001dU2iK\u0012,H.\u001a3Fq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0003\u001d\u0001x\u000e\u001c7fe\u0002\nA\u0001]8mYR\u0011\u0011\u0011\u001e\t\u0004m\u0005-\u0018bAAwo\t!QK\\5u\u0003\u0015\u0019H/\u0019:u\u0003-yg\u000eV1tWN#\u0018M\u001d;\u0015\u0011\u0005%\u0018Q_A}\u0003{Da!a>'\u0001\u0004Q\u0015A\u0002;bg.LE\r\u0003\u0004\u0002|\u001a\u0002\raX\u0001\bgR\fw-Z%e\u0011\u0019\tyP\na\u0001?\u0006q1\u000f^1hK\u0006#H/Z7qi&#\u0017\u0001E8o)\u0006\u001c8nQ8na2,G/[8o)!\tIO!\u0002\u0003\b\t%\u0001BBA|O\u0001\u0007!\n\u0003\u0004\u0002|\u001e\u0002\ra\u0018\u0005\u0007\u0003\u007f<\u0003\u0019A0\u0002%\u001d,G\u000fV1tW6+GO]5d!\u0016\f7n\u001d\u000b\u0005\u0005\u001f\u0011)\u0002\u0005\u00037\u0005#Q\u0015b\u0001B\no\t)\u0011I\u001d:bs\"1\u0011q\u001f\u0015A\u0002)\u000b!cZ3u\u000bb,7-\u001e;peV\u0003H-\u0019;fgR\u0011!1\u0004\t\t\u0005;\u0011\u0019#a3\u0003(5\u0011!q\u0004\u0006\u0005\u0005C\t)'A\u0004nkR\f'\r\\3\n\t\t\u0015\"q\u0004\u0002\b\u0011\u0006\u001c\b.T1q!\r\u0011&\u0011F\u0005\u0004\u0005Wa#aD#yK\u000e,Ho\u001c:NKR\u0014\u0018nY:\u0002\tM$x\u000e\u001d")
public class ExecutorMetricsPoller
implements Logging {
    private volatile ExecutorMetricsPoller$TCMP$ TCMP$module;
    private final MemoryManager memoryManager;
    private final long pollingInterval;
    private final Option<ExecutorMetricsSource> executorMetricsSource;
    private final ConcurrentHashMap<Tuple2<Object, Object>, TCMP> stageTCMP;
    private final ConcurrentHashMap<Object, AtomicLongArray> taskMetricPeaks;
    private final Option<ScheduledExecutorService> poller;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public ExecutorMetricsPoller$TCMP$ TCMP() {
        if (this.TCMP$module == null) {
            this.TCMP$lzycompute$1();
        }
        return this.TCMP$module;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public ConcurrentHashMap<Tuple2<Object, Object>, TCMP> stageTCMP() {
        return this.stageTCMP;
    }

    private ConcurrentHashMap<Object, AtomicLongArray> taskMetricPeaks() {
        return this.taskMetricPeaks;
    }

    private Option<ScheduledExecutorService> poller() {
        return this.poller;
    }

    public void poll() {
        long[] latestMetrics = ExecutorMetrics$.MODULE$.getCurrentMetrics(this.memoryManager);
        this.executorMetricsSource.foreach((Function1 & Serializable)x$1 -> {
            x$1.updateMetricsSnapshot(latestMetrics);
            return BoxedUnit.UNIT;
        });
        this.stageTCMP().forEachValue(Long.MAX_VALUE, v -> ExecutorMetricsPoller.updatePeaks$1(v.peaks(), latestMetrics));
        this.taskMetricPeaks().forEachValue(Long.MAX_VALUE, metrics -> ExecutorMetricsPoller.updatePeaks$1(metrics, latestMetrics));
    }

    public void start() {
        this.poller().foreach((Function1 & Serializable)exec -> {
            Runnable pollingTask = () -> Utils$.MODULE$.logUncaughtExceptions((JFunction0.mcV.sp & Serializable)() -> this.poll());
            return exec.scheduleAtFixedRate(pollingTask, 0L, $this.pollingInterval, TimeUnit.MILLISECONDS);
        });
    }

    public void onTaskStart(long taskId, int stageId, int stageAttemptId) {
        this.taskMetricPeaks().put(BoxesRunTime.boxToLong((long)taskId), new AtomicLongArray(ExecutorMetricType$.MODULE$.numMetrics()));
        TCMP countAndPeaks = this.stageTCMP().compute((Tuple2<Object, Object>)new Tuple2.mcII.sp(stageId, stageAttemptId), (k, v) -> {
            if (v == null) {
                return new TCMP(this, 1L, new AtomicLongArray(ExecutorMetricType$.MODULE$.numMetrics()));
            }
            return new TCMP(this, v.count() + 1L, v.peaks());
        });
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "stageTCMP: (" + stageId + ", " + stageAttemptId + ") -> " + countAndPeaks.count());
    }

    public void onTaskCompletion(long taskId, int stageId, int stageAttemptId) {
        this.stageTCMP().computeIfPresent((Tuple2<Object, Object>)new Tuple2.mcII.sp(stageId, stageAttemptId), (stage, countAndPeaks) -> this.decrementCount$1((Tuple2)stage, (TCMP)countAndPeaks));
        this.taskMetricPeaks().remove(BoxesRunTime.boxToLong((long)taskId));
    }

    public long[] getTaskMetricPeaks(long taskId) {
        long[] metricPeaks;
        block0: {
            AtomicLongArray currentPeaks = this.taskMetricPeaks().get(BoxesRunTime.boxToLong((long)taskId));
            metricPeaks = new long[ExecutorMetricType$.MODULE$.numMetrics()];
            if (currentPeaks == null) break block0;
            ExecutorMetricType$.MODULE$.metricToOffset().foreach((Function1 & Serializable)x0$1 -> {
                ExecutorMetricsPoller.$anonfun$getTaskMetricPeaks$1(metricPeaks, currentPeaks, x0$1);
                return BoxedUnit.UNIT;
            });
        }
        return metricPeaks;
    }

    public HashMap<Tuple2<Object, Object>, ExecutorMetrics> getExecutorUpdates() {
        HashMap executorUpdates = new HashMap();
        this.stageTCMP().replaceAll((k, v) -> this.getUpdateAndResetPeaks$1((Tuple2)k, (TCMP)v, executorUpdates));
        executorUpdates.foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Tuple2 k2 = (Tuple2)tuple2._1();
                return this.stageTCMP().computeIfPresent((Tuple2<Object, Object>)k2, (k, v) -> this.removeIfInactive$1((Tuple2)k, (TCMP)v));
            }
            throw new MatchError((Object)tuple2);
        });
        return executorUpdates;
    }

    public void stop() {
        this.poller().foreach((Function1 & Serializable)exec -> BoxesRunTime.boxToBoolean((boolean)ExecutorMetricsPoller.$anonfun$stop$1(exec)));
    }

    private final void TCMP$lzycompute$1() {
        ExecutorMetricsPoller executorMetricsPoller = this;
        synchronized (executorMetricsPoller) {
            if (this.TCMP$module == null) {
                this.TCMP$module = new ExecutorMetricsPoller$TCMP$(this);
            }
        }
    }

    private static final void updatePeaks$1(AtomicLongArray metrics, long[] latestMetrics$1) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), metrics.length()).foreach((Function1)(JFunction1.mcJI.sp & Serializable)i -> metrics.getAndAccumulate(i, latestMetrics$1[i], (x, y) -> package$.MODULE$.max(x, y)));
    }

    private final TCMP decrementCount$1(Tuple2 stage, TCMP countAndPeaks) {
        long countValue = countAndPeaks.count() - 1L;
        Predef$.MODULE$.assert(countValue >= 0L, (Function0 & Serializable)() -> "task count shouldn't below 0");
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "stageTCMP: (" + stage._1$mcI$sp() + ", " + stage._2$mcI$sp() + ") -> " + countValue);
        return new TCMP(this, countValue, countAndPeaks.peaks());
    }

    public static final /* synthetic */ void $anonfun$getTaskMetricPeaks$1(long[] metricPeaks$1, AtomicLongArray currentPeaks$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            int i = tuple2._2$mcI$sp();
            metricPeaks$1[i] = currentPeaks$1.get(i);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private final TCMP getUpdateAndResetPeaks$1(Tuple2 k, TCMP v, HashMap executorUpdates$1) {
        executorUpdates$1.put((Object)k, (Object)new ExecutorMetrics(v.peaks()));
        return new TCMP(this, v.count(), new AtomicLongArray(ExecutorMetricType$.MODULE$.numMetrics()));
    }

    private final TCMP removeIfInactive$1(Tuple2 k, TCMP v) {
        if (v.count() == 0L) {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "removing (" + k._1$mcI$sp() + ", " + k._2$mcI$sp() + ") from stageTCMP");
            return null;
        }
        return v;
    }

    public static final /* synthetic */ boolean $anonfun$stop$1(ScheduledExecutorService exec) {
        exec.shutdown();
        return exec.awaitTermination(10L, TimeUnit.SECONDS);
    }

    public ExecutorMetricsPoller(MemoryManager memoryManager, long pollingInterval, Option<ExecutorMetricsSource> executorMetricsSource) {
        this.memoryManager = memoryManager;
        this.pollingInterval = pollingInterval;
        this.executorMetricsSource = executorMetricsSource;
        Logging.$init$((Logging)this);
        this.stageTCMP = new ConcurrentHashMap();
        this.taskMetricPeaks = new ConcurrentHashMap();
        this.poller = pollingInterval > 0L ? new Some((Object)ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("executor-metrics-poller")) : None$.MODULE$;
    }

    public class TCMP
    implements Product,
    Serializable {
        private final long count;
        private final AtomicLongArray peaks;
        public final /* synthetic */ ExecutorMetricsPoller $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public long count() {
            return this.count;
        }

        public AtomicLongArray peaks() {
            return this.peaks;
        }

        public TCMP copy(long count, AtomicLongArray peaks) {
            return new TCMP(this.org$apache$spark$executor$ExecutorMetricsPoller$TCMP$$$outer(), count, peaks);
        }

        public long copy$default$1() {
            return this.count();
        }

        public AtomicLongArray copy$default$2() {
            return this.peaks();
        }

        public String productPrefix() {
            return "TCMP";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this.count());
                }
                case 1: {
                    return this.peaks();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof TCMP;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "count";
                }
                case 1: {
                    return "peaks";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.count()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.peaks()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof TCMP)) return false;
            if (((TCMP)object).org$apache$spark$executor$ExecutorMetricsPoller$TCMP$$$outer() != this.org$apache$spark$executor$ExecutorMetricsPoller$TCMP$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            TCMP tCMP = (TCMP)x$1;
            if (this.count() != tCMP.count()) return false;
            AtomicLongArray atomicLongArray = this.peaks();
            AtomicLongArray atomicLongArray2 = tCMP.peaks();
            if (atomicLongArray == null) {
                if (atomicLongArray2 != null) {
                    return false;
                }
            } else if (!atomicLongArray.equals(atomicLongArray2)) return false;
            if (!tCMP.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ExecutorMetricsPoller org$apache$spark$executor$ExecutorMetricsPoller$TCMP$$$outer() {
            return this.$outer;
        }

        public TCMP(ExecutorMetricsPoller $outer, long count, AtomicLongArray peaks) {
            this.count = count;
            this.peaks = peaks;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

