/*
 * Decompiled with CFR 0.152.
 */
package io.github.retronym.java9rtexport;

import io.github.retronym.java9rtexport.Copy;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Iterator;

public class Export {
    private static final Object lock = new Object();
    private static File tempFile = null;
    public static String rtJarName = "rt-" + System.getProperty("java.version") + ".jar";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File rt() {
        try {
            Object object = lock;
            synchronized (object) {
                if (tempFile == null) {
                    Path path = Files.createTempFile("rt", ".jar", new FileAttribute[0]);
                    tempFile = path.toFile();
                    tempFile.deleteOnExit();
                    tempFile.delete();
                    FileSystem fileSystem = FileSystems.getFileSystem(URI.create("jrt:/"));
                    Path path2 = fileSystem.getPath("/modules", new String[0]);
                    URI uRI = URI.create("jar:" + path.toUri());
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("create", "true");
                    try (FileSystem fileSystem2 = FileSystems.newFileSystem(uRI, hashMap);){
                        Iterator iterator = Files.list(path2).iterator();
                        while (iterator.hasNext()) {
                            Path path3 = (Path)iterator.next();
                            Copy.copyDirectory(path3, fileSystem2.getPath("/", new String[0]));
                        }
                    }
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(-1);
        }
        return tempFile;
    }

    public static synchronized boolean rtTo(File file, boolean bl) {
        try {
            if (!file.exists()) {
                if (bl) {
                    System.out.println("Copying Java " + System.getProperty("java.version") + " runtime jar to " + file.getParentFile() + " ...");
                    System.out.flush();
                }
                file.getParentFile().mkdirs();
                Files.copy(Export.rt().toPath(), file.toPath(), new CopyOption[0]);
                return true;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(-1);
        }
        return false;
    }

    public static File rtAt(File file, boolean bl) {
        File file2 = new File(file, rtJarName);
        Export.rtTo(file2, bl);
        return file2;
    }

    public static File rtAt(File file) {
        return Export.rtAt(file, false);
    }
}

