/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.MakeTimestampExpressionBuilder$;
import org.apache.spark.sql.catalyst.plans.logical.FunctionSignature;
import scala.Function2;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@ExpressionDescription(usage="\n    _FUNC_(year, month, day, hour, min, sec[, timezone]) - Create the current timestamp with local time zone from year, month, day, hour, min, sec and timezone fields. If the configuration `spark.sql.ansi.enabled` is false, the function returns NULL on invalid inputs. Otherwise, it will throw an error instead.\n\n    _FUNC_(date[, time[, timezone]]) - Create timestamp from date and time fields.\n    ", arguments="\n    Arguments:\n      * year - the year to represent, from 1 to 9999\n      * month - the month-of-year to represent, from 1 (January) to 12 (December)\n      * day - the day-of-month to represent, from 1 to 31\n      * hour - the hour-of-day to represent, from 0 to 23\n      * min - the minute-of-hour to represent, from 0 to 59\n      * sec - the second-of-minute and its micro-fraction to represent, from\n              0 to 60. If the sec argument equals to 60, the seconds field is set\n              to 0 and 1 minute is added to the final timestamp.\n      * date - a date expression\n      * time - a time expression (optional). Default is 00:00:00.\n      * timezone - the time zone identifier (optional). For example, CET, UTC and etc.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(2014, 12, 28, 6, 30, 45.887);\n       2014-12-28 06:30:45.887\n      > SELECT _FUNC_(2014, 12, 28, 6, 30, 45.887, 'CET');\n       2014-12-27 21:30:45.887\n      > SELECT _FUNC_(DATE'2014-12-28');\n       2014-12-28 00:00:00\n      > SELECT _FUNC_(DATE'2014-12-28', TIME'6:30:45.887');\n       2014-12-28 06:30:45.887\n      > SELECT _FUNC_(DATE'2014-12-28', TIME'6:30:45.887', 'CET');\n       2014-12-27 21:30:45.887\n  ", group="datetime_funcs", since="3.0.0")
@ScalaSignature(bytes="\u0006\u0005Q;Q\u0001B\u0003\t\u0002I1Q\u0001F\u0003\t\u0002UAQAI\u0001\u0005\u0002\rBQ\u0001J\u0001\u0005B\u0015\na$T1lKRKW.Z:uC6\u0004X\t\u001f9sKN\u001c\u0018n\u001c8Ck&dG-\u001a:\u000b\u0005\u00199\u0011aC3yaJ,7o]5p]NT!\u0001C\u0005\u0002\u0011\r\fG/\u00197zgRT!AC\u0006\u0002\u0007M\fHN\u0003\u0002\r\u001b\u0005)1\u000f]1sW*\u0011abD\u0001\u0007CB\f7\r[3\u000b\u0003A\t1a\u001c:h\u0007\u0001\u0001\"aE\u0001\u000e\u0003\u0015\u0011a$T1lKRKW.Z:uC6\u0004X\t\u001f9sKN\u001c\u0018n\u001c8Ck&dG-\u001a:\u0014\u0007\u00051B\u0004\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002D\u0001\u0004B]f\u0014VM\u001a\t\u0003;\u0001j\u0011A\b\u0006\u0003?\u001d\t\u0001\"\u00198bYf\u001c\u0018n]\u0005\u0003Cy\u0011\u0011#\u0012=qe\u0016\u001c8/[8o\u0005VLG\u000eZ3s\u0003\u0019a\u0014N\\5u}Q\t!#A\u0003ck&dG\rF\u0002'SY\u0002\"aE\u0014\n\u0005!*!AC#yaJ,7o]5p]\")!f\u0001a\u0001W\u0005Aa-\u001e8d\u001d\u0006lW\r\u0005\u0002-g9\u0011Q&\r\t\u0003]ai\u0011a\f\u0006\u0003aE\ta\u0001\u0010:p_Rt\u0014B\u0001\u001a\u0019\u0003\u0019\u0001&/\u001a3fM&\u0011A'\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005IB\u0002\"\u0002\u0004\u0004\u0001\u00049\u0004c\u0001\u001d>M9\u0011\u0011h\u000f\b\u0003]iJ\u0011!G\u0005\u0003ya\tq\u0001]1dW\u0006<W-\u0003\u0002?\u007f\t\u00191+Z9\u000b\u0005qB\u0002\u0006D\u0001B\t\u0016;\u0005JS&N\u001dB\u000b\u0006CA\nC\u0013\t\u0019UAA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0003\u0019\u000b11\u0005\u0006!A\u0001\u0002sLR+O\u0007~C\u00130Z1sY\u0001jwN\u001c;iY\u0001\"\u0017-\u001f\u0017!Q>,(\u000f\f\u0011nS:d\u0003e]3d72\u0002C/[7fu>tW-X\u0015![\u0001\u001a%/Z1uK\u0002\"\b.\u001a\u0011dkJ\u0014XM\u001c;!i&lWm\u001d;b[B\u0004s/\u001b;iA1|7-\u00197!i&lW\r\t>p]\u0016\u0004cM]8nAe,\u0017M\u001d\u0017![>tG\u000f\u001b\u0017!I\u0006LH\u0006\t5pkJd\u0003%\\5oY\u0001\u001aXm\u0019\u0011b]\u0012\u0004C/[7fu>tW\r\t4jK2$7O\f\u0011JM\u0002\"\b.\u001a\u0011d_:4\u0017nZ;sCRLwN\u001c\u0011agB\f'o\u001b\u0018tc2t\u0013M\\:j]\u0015t\u0017M\u00197fI\u0002\u0004\u0013n\u001d\u0011gC2\u001cX\r\f\u0011uQ\u0016\u0004c-\u001e8di&|g\u000e\t:fiV\u0014hn\u001d\u0011O+2c\u0005e\u001c8!S:4\u0018\r\\5eA%t\u0007/\u001e;t]\u0001zE\u000f[3so&\u001cX\r\f\u0011ji\u0002:\u0018\u000e\u001c7!i\"\u0014xn\u001e\u0011b]\u0002*'O]8sA%t7\u000f^3bI:R!\u0002\t\u0011!A}3UKT\"`Q\u0011\fG/Z.-AQLW.Z.-AQLW.\u001a>p]\u0016lV,\u000b\u0011.A\r\u0013X-\u0019;fAQLW.Z:uC6\u0004\bE\u001a:p[\u0002\"\u0017\r^3!C:$\u0007\u0005^5nK\u00022\u0017.\u001a7eg:R\u0001\u0005\t\u0011!\u0003%\t'oZ;nK:$8/I\u0001J\u0003\u0015\u001d'\u0002\t\u0011!A\u0005\u0013x-^7f]R\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011zK\u0006\u0014\b%\f\u0011uQ\u0016\u0004\u00130Z1sAQ|\u0007E]3qe\u0016\u001cXM\u001c;-A\u0019\u0014x.\u001c\u00112AQ|\u0007%O\u001d:s)\u0001\u0003\u0005\t\u0011!A)\u0002Sn\u001c8uQ\u0002j\u0003\u0005\u001e5fA5|g\u000e\u001e5._\u001al\u00130Z1sAQ|\u0007E]3qe\u0016\u001cXM\u001c;-A\u0019\u0014x.\u001c\u00112A!R\u0015M\\;befL\u0003\u0005^8!cI\u0002\u0003\u0006R3dK6\u0014WM]\u0015\u000bA\u0001\u0002\u0003\u0005\t\u0011+A\u0011\f\u0017\u0010I\u0017!i\",\u0007\u0005Z1z[=4W&\\8oi\"\u0004Co\u001c\u0011sKB\u0014Xm]3oi2\u0002cM]8nAE\u0002Co\u001c\u00114c)\u0001\u0003\u0005\t\u0011!A)\u0002\u0003n\\;sA5\u0002C\u000f[3!Q>,(/L8g[\u0011\f\u0017\u0010\t;pAI,\u0007O]3tK:$H\u0006\t4s_6\u0004\u0003\u0007\t;pAI\u001a$\u0002\t\u0011!A\u0001\u0002#\u0006I7j]\u0002j\u0003\u0005\u001e5fA5Lg.\u001e;f[=4W\u0006[8ve\u0002\"x\u000e\t:faJ,7/\u001a8uY\u00012'o\\7!a\u0001\"x\u000eI\u001b:\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\u001aXm\u0019\u0011.AQDW\rI:fG>tG-L8g[5Lg.\u001e;fA\u0005tG\rI5ug\u0002j\u0017n\u0019:p[\u0019\u0014\u0018m\u0019;j_:\u0004Co\u001c\u0011sKB\u0014Xm]3oi2\u0002cM]8n\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!AA\u0002Co\u001c\u00117a9\u0002\u0013J\u001a\u0011uQ\u0016\u00043/Z2!CJ<W/\\3oi\u0002*\u0017/^1mg\u0002\"x\u000e\t\u001c1Y\u0001\"\b.\u001a\u0011tK\u000e|g\u000eZ:!M&,G\u000e\u001a\u0011jg\u0002\u001aX\r\u001e\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011u_\u0002\u0002\u0004%\u00198eAE\u0002S.\u001b8vi\u0016\u0004\u0013n\u001d\u0011bI\u0012,G\r\t;pAQDW\r\t4j]\u0006d\u0007\u0005^5nKN$\u0018-\u001c9/\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\"\u0017\r^3![\u0001\n\u0007\u0005Z1uK\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0006!A\u0001\u0002\u0003\u0005\t\u0016!i&lW\rI\u0017!C\u0002\"\u0018.\\3!Kb\u0004(/Z:tS>t\u0007\u0005K8qi&|g.\u00197*]\u0001\"UMZ1vYR\u0004\u0013n\u001d\u00111ai\u0002\u0004G\u000f\u00191])\u0001\u0003\u0005\t\u0011!A)\u0002C/[7fu>tW\rI\u0017!i\",\u0007\u0005^5nK\u0002RxN\\3!S\u0012,g\u000e^5gS\u0016\u0014\b\u0005K8qi&|g.\u00197*]\u00012uN\u001d\u0011fq\u0006l\u0007\u000f\\3-A\r+E\u000b\f\u0011V)\u000e\u0003\u0013M\u001c3!KR\u001cgF\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018%\u0001'\u0002\u0007\u007fR\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006F\r\u00192i1\u0002\u0013G\r\u0017!eab\u0003E\u000e\u0017!gAb\u0003\u0005N\u001b/qa:\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113aE\"T&\r\u001a.ea\u0002\u0003G\u000e\u001e4ai\"TG\f\u001d9o)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C#\u0007M\u00195Y\u0001\n$\u0007\f\u00113q1\u0002c\u0007\f\u00114a1\u0002C'\u000e\u00189q]b\u0003eJ\"F)\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a1cQj\u0013GM\u00173o\u0001\u0012\u0014GO\u001a1uQ*d\u0006\u000f\u001d8\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\"\u0015\tV#(eA\nD'L\u00193[IBt%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!eA\nD'L\u00193[IB\u0004\u0005\r\u0019;aAR\u0004\u0007\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)\t\u0006#Vi\n\u001a1cQj\u0013GM\u00173q\u001db\u0003\u0005V%N\u000b\u001e2$h\r\u0019;iUr\u0003\bO\u001c(SmR\u0001\u0005\t\u0011!A\u0001\u0002#\u0007M\u00195[E\u0012TF\r\u001d!aYR4\u0007\r\u001e5k9B\u0004h\u000e\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)\t\u0006#Vi\n\u001a1cQj\u0013GM\u00173q\u001db\u0003\u0005V%N\u000b\u001e2$h\r\u0019;iUr\u0003\bO\u001c(Y\u0001:3)\u0012+(SmR\u0001\u0005\t\u0011!A\u0001\u0002#\u0007M\u00195[E\u0012TFM\u001c!eER4\u0007\r\u001e5k9B\u0004h\u000e\u0006!A\u0005)qM]8va\u0006\nq*\u0001\beCR,G/[7f?\u001a,hnY:\u0002\u000bMLgnY3\"\u0003I\u000bQa\r\u00181]ABC\u0002A!E\u000b\u001eC%jS'O!F\u0003")
public final class MakeTimestampExpressionBuilder {
    public static Expression build(String funcName, Seq<Expression> expressions) {
        return MakeTimestampExpressionBuilder$.MODULE$.build(funcName, (Seq)expressions);
    }

    public static boolean supportsLambda() {
        return MakeTimestampExpressionBuilder$.MODULE$.supportsLambda();
    }

    public static Seq<Expression> rearrange(FunctionSignature expectedSignature, Seq<Expression> providedArguments, String functionName, Function2<String, String, Object> resolver) {
        return MakeTimestampExpressionBuilder$.MODULE$.rearrange(expectedSignature, providedArguments, functionName, resolver);
    }

    public static Option<FunctionSignature> functionSignature() {
        return MakeTimestampExpressionBuilder$.MODULE$.functionSignature();
    }
}

