/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.hll.Union;
import org.apache.datasketches.memory.Memory;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.HllUnionAgg$;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.catalyst.trees.BinaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(expr, allowDifferentLgConfigK) - Returns the estimated number of unique values.\n      `allowDifferentLgConfigK` (optional) Allow sketches with different lgConfigK values\n       to be unioned (defaults to false).", examples="\n    Examples:\n      > SELECT hll_sketch_estimate(_FUNC_(sketch, true)) FROM (SELECT hll_sketch_agg(col) as sketch FROM VALUES (1) tab(col) UNION ALL SELECT hll_sketch_agg(col, 20) as sketch FROM VALUES (1) tab(col));\n       1\n  ", group="agg_funcs", since="3.5.0")
@ScalaSignature(bytes="\u0006\u0005\tuf\u0001B\u001b7\u0001\u0016C\u0001\u0002\u001e\u0001\u0003\u0016\u0004%\t!\u001e\u0005\tm\u0002\u0011\t\u0012)A\u0005=\"Aq\u000f\u0001BK\u0002\u0013\u0005Q\u000f\u0003\u0005y\u0001\tE\t\u0015!\u0003_\u0011!I\bA!f\u0001\n\u0003Q\b\u0002\u0003@\u0001\u0005#\u0005\u000b\u0011B>\t\u0011}\u0004!Q3A\u0005\u0002iD\u0011\"!\u0001\u0001\u0005#\u0005\u000b\u0011B>\t\u000f\u0005\r\u0001\u0001\"\u0001\u0002\u0006!Q\u0011\u0011\u0003\u0001\t\u0006\u0004%\t!a\u0005\t\u0013\u0005m\u0001A1A\u0005\n\u0005u\u0001\u0002CA\u0013\u0001\u0001\u0006I!a\b\t\u000f\u0005\r\u0001\u0001\"\u0001\u0002(!9\u00111\u0001\u0001\u0005\u0002\u00055\u0002bBA\u0002\u0001\u0011\u0005\u00111\u0007\u0005\b\u0003s\u0001A\u0011IA\u001e\u0011\u001d\t\t\u0005\u0001C!\u0003\u0007Bq!!\u0013\u0001\t#\nY\u0005C\u0004\u0002V\u0001!\t%a\u0016\t\u000f\u0005%\u0004\u0001\"\u0011\u0002l!9\u0011q\u0010\u0001\u0005B\u0005\u0005\u0005bBAE\u0001\u0011\u0005\u00131\u0003\u0005\b\u0003\u0017\u0003A\u0011IAG\u0011\u001d\ty\t\u0001C\u0001\u0003#Cq!!(\u0001\t\u0003\ny\nC\u0004\u00022\u0002!\t%a-\t\u000f\u0005m\u0006\u0001\"\u0011\u0002>\"9\u0011q\u0019\u0001\u0005B\u0005%\u0007bBAm\u0001\u0011\u0005\u00131\u001c\u0005\n\u0003C\u0004\u0011\u0011!C\u0001\u0003GD\u0011\"!<\u0001#\u0003%\t!a<\t\u0013\t\u0015\u0001!%A\u0005\u0002\u0005=\b\"\u0003B\u0004\u0001E\u0005I\u0011\u0001B\u0005\u0011%\u0011i\u0001AI\u0001\n\u0003\u0011I\u0001C\u0005\u0003\u0010\u0001\t\t\u0011\"\u0011\u0003\u0012!A!\u0011\u0005\u0001\u0002\u0002\u0013\u0005!\u0010C\u0005\u0003$\u0001\t\t\u0011\"\u0001\u0003&!I!1\u0006\u0001\u0002\u0002\u0013\u0005#Q\u0006\u0005\n\u0005w\u0001\u0011\u0011!C\u0001\u0005{A\u0011B!\u0011\u0001\u0003\u0003%\tEa\u0011\t\u0013\t\u001d\u0003!!A\u0005B\t%s!\u0003B7m\u0005\u0005\t\u0012\u0001B8\r!)d'!A\t\u0002\tE\u0004bBA\u0002W\u0011\u0005!\u0011\u0012\u0005\n\u0005\u0017[\u0013\u0011!C#\u0005\u001bC\u0011Ba$,\u0003\u0003%\tI!%\t\u0013\tm5&%A\u0005\u0002\t%\u0001\"\u0003BOWE\u0005I\u0011\u0001B\u0005\u0011%\u0011yjKA\u0001\n\u0003\u0013\t\u000bC\u0005\u00030.\n\n\u0011\"\u0001\u0003\n!I!\u0011W\u0016\u0012\u0002\u0013\u0005!\u0011\u0002\u0005\n\u0005g[\u0013\u0011!C\u0005\u0005k\u00131\u0002\u00137m+:LwN\\!hO*\u0011q\u0007O\u0001\nC\u001e<'/Z4bi\u0016T!!\u000f\u001e\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003wq\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003{y\n1a]9m\u0015\ty\u0004)A\u0003ta\u0006\u00148N\u0003\u0002B\u0005\u00061\u0011\r]1dQ\u0016T\u0011aQ\u0001\u0004_J<7\u0001A\n\u0007\u0001\u0019C&-\u001a5\u0011\u0007\u001dC%*D\u00017\u0013\tIeG\u0001\rUsB,G-S7qKJ\fG/\u001b<f\u0003\u001e<'/Z4bi\u0016\u00042a\u0013(Q\u001b\u0005a%\"A'\u0002\u000bM\u001c\u0017\r\\1\n\u0005=c%AB(qi&|g\u000e\u0005\u0002R-6\t!K\u0003\u0002T)\u0006\u0019\u0001\u000e\u001c7\u000b\u0005U\u0003\u0015\u0001\u00043bi\u0006\u001c8.\u001a;dQ\u0016\u001c\u0018BA,S\u0005\u0015)f.[8o!\rIFLX\u0007\u00025*\u00111LO\u0001\u0006iJ,Wm]\u0005\u0003;j\u0013!BQ5oCJLH*[6f!\ty\u0006-D\u00019\u0013\t\t\u0007H\u0001\u0006FqB\u0014Xm]:j_:\u0004\"aX2\n\u0005\u0011D$!E#ya\u0016\u001cGo]%oaV$H+\u001f9fgB\u00111JZ\u0005\u0003O2\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002jc:\u0011!n\u001c\b\u0003W:l\u0011\u0001\u001c\u0006\u0003[\u0012\u000ba\u0001\u0010:p_Rt\u0014\"A'\n\u0005Ad\u0015a\u00029bG.\fw-Z\u0005\u0003eN\u0014AbU3sS\u0006d\u0017N_1cY\u0016T!\u0001\u001d'\u0002\t1,g\r^\u000b\u0002=\u0006)A.\u001a4uA\u0005)!/[4ii\u00061!/[4ii\u0002\na#\\;uC\ndW-Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r^\u000b\u0002wB\u00111\n`\u0005\u0003{2\u00131!\u00138u\u0003]iW\u000f^1cY\u0016\fum\u001a\"vM\u001a,'o\u00144gg\u0016$\b%\u0001\u000bj]B,H/Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r^\u0001\u0016S:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;!\u0003\u0019a\u0014N\\5u}QQ\u0011qAA\u0005\u0003\u0017\ti!a\u0004\u0011\u0005\u001d\u0003\u0001\"\u0002;\n\u0001\u0004q\u0006\"B<\n\u0001\u0004q\u0006bB=\n!\u0003\u0005\ra\u001f\u0005\b\u007f&\u0001\n\u00111\u0001|\u0003]\tG\u000e\\8x\t&4g-\u001a:f]RdumQ8oM&<7*\u0006\u0002\u0002\u0016A\u00191*a\u0006\n\u0007\u0005eAJA\u0004C_>dW-\u00198\u0002\u0015Q\f'oZ3u)f\u0004X-\u0006\u0002\u0002 A\u0019\u0011+!\t\n\u0007\u0005\r\"K\u0001\u0006UORDE\u000e\u001c+za\u0016\f1\u0002^1sO\u0016$H+\u001f9fAQ!\u0011qAA\u0015\u0011\u0019\tY#\u0004a\u0001=\u0006)1\r[5mIR1\u0011qAA\u0018\u0003cAa!a\u000b\u000f\u0001\u0004q\u0006BBA\t\u001d\u0001\u0007a\f\u0006\u0004\u0002\b\u0005U\u0012q\u0007\u0005\u0007\u0003Wy\u0001\u0019\u00010\t\u000f\u0005Eq\u00021\u0001\u0002\u0016\u0005ir/\u001b;i\u001d\u0016<X*\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G\u000f\u0006\u0003\u0002\b\u0005u\u0002BBA !\u0001\u000710A\roK^lU\u000f^1cY\u0016\fum\u001a\"vM\u001a,'o\u00144gg\u0016$\u0018aG<ji\"tUm^%oaV$\u0018iZ4Ck\u001a4WM](gMN,G\u000f\u0006\u0003\u0002\b\u0005\u0015\u0003BBA$#\u0001\u000710A\foK^Le\u000e];u\u0003\u001e<')\u001e4gKJ|eMZ:fi\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u0007\u0003\u000f\ti%!\u0015\t\r\u0005=#\u00031\u0001_\u0003\u001dqWm\u001e'fMRDa!a\u0015\u0013\u0001\u0004q\u0016\u0001\u00038foJKw\r\u001b;\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0006\u0002\u0002ZA!\u00111LA2\u001d\u0011\ti&a\u0018\u0011\u0005-d\u0015bAA1\u0019\u00061\u0001K]3eK\u001aLA!!\u001a\u0002h\t11\u000b\u001e:j]\u001eT1!!\u0019M\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0003\u0003[\u0002R![A8\u0003gJ1!!\u001dt\u0005\r\u0019V-\u001d\t\u0005\u0003k\nY(\u0004\u0002\u0002x)\u0019\u0011\u0011\u0010\u001f\u0002\u000bQL\b/Z:\n\t\u0005u\u0014q\u000f\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\f\u0001\u0002Z1uCRK\b/Z\u000b\u0003\u0003\u0007\u0003B!!\u001e\u0002\u0006&!\u0011qQA<\u0005!!\u0015\r^1UsB,\u0017\u0001\u00038vY2\f'\r\\3\u0002/\r\u0014X-\u0019;f\u0003\u001e<'/Z4bi&|gNQ;gM\u0016\u0014H#\u0001&\u0002!\r|W\u000e]1sK2;7i\u001c8gS\u001e\\ECBAJ\u00033\u000bY\nE\u0002L\u0003+K1!a&M\u0005\u0011)f.\u001b;\t\u000bQD\u0002\u0019A>\t\u000b]D\u0002\u0019A>\u0002\rU\u0004H-\u0019;f)\u0015Q\u0015\u0011UAS\u0011\u0019\t\u0019+\u0007a\u0001\u0015\u0006YQO\\5p]>\u0003H/[8o\u0011\u001d\t9+\u0007a\u0001\u0003S\u000bQ!\u001b8qkR\u0004B!a+\u0002.6\t!(C\u0002\u00020j\u00121\"\u00138uKJt\u0017\r\u001c*po\u0006)Q.\u001a:hKR)!*!.\u00028\"1\u00111\u0015\u000eA\u0002)Ca!!/\u001b\u0001\u0004Q\u0015aC5oaV$x\n\u001d;j_:\fA!\u001a<bYR!\u0011qXAc!\rY\u0015\u0011Y\u0005\u0004\u0003\u0007d%aA!os\"1\u00111U\u000eA\u0002)\u000b\u0011b]3sS\u0006d\u0017N_3\u0015\t\u0005-\u0017q\u001b\t\u0006\u0017\u00065\u0017\u0011[\u0005\u0004\u0003\u001fd%!B!se\u0006L\bcA&\u0002T&\u0019\u0011Q\u001b'\u0003\t\tKH/\u001a\u0005\u0007\u0003Gc\u0002\u0019\u0001&\u0002\u0017\u0011,7/\u001a:jC2L'0\u001a\u000b\u0004\u0015\u0006u\u0007bBAp;\u0001\u0007\u00111Z\u0001\u0007EV4g-\u001a:\u0002\t\r|\u0007/\u001f\u000b\u000b\u0003\u000f\t)/a:\u0002j\u0006-\bb\u0002;\u001f!\u0003\u0005\rA\u0018\u0005\boz\u0001\n\u00111\u0001_\u0011\u001dIh\u0004%AA\u0002mDqa \u0010\u0011\u0002\u0003\u000710\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005E(f\u00010\u0002t.\u0012\u0011Q\u001f\t\u0005\u0003o\u0014\t!\u0004\u0002\u0002z*!\u00111`A\u007f\u0003%)hn\u00195fG.,GMC\u0002\u0002\u00002\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\u0019!!?\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!1\u0002\u0016\u0004w\u0006M\u0018AD2paf$C-\u001a4bk2$H\u0005N\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\tM\u0001\u0003\u0002B\u000b\u0005?i!Aa\u0006\u000b\t\te!1D\u0001\u0005Y\u0006twM\u0003\u0002\u0003\u001e\u0005!!.\u0019<b\u0013\u0011\t)Ga\u0006\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011q\u0018B\u0014\u0011!\u0011I#JA\u0001\u0002\u0004Y\u0018a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u00030A1!\u0011\u0007B\u001c\u0003\u007fk!Aa\r\u000b\u0007\tUB*\u0001\u0006d_2dWm\u0019;j_:LAA!\u000f\u00034\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t)Ba\u0010\t\u0013\t%r%!AA\u0002\u0005}\u0016A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$BAa\u0005\u0003F!A!\u0011\u0006\u0015\u0002\u0002\u0003\u000710\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003+\u0011Y\u0005C\u0005\u0003*%\n\t\u00111\u0001\u0002@\"\u001a\u0002Aa\u0014\u0003V\t]#1\fB/\u0005C\u0012\u0019Ga\u001a\u0003jA\u0019qL!\u0015\n\u0007\tM\u0003HA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\te\u0013!a0\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006&\u001a=qe2\u0002\u0013\r\u001c7po\u0012KgMZ3sK:$HjZ\"p]\u001aLwmS\u0015![\u0001\u0012V\r^;s]N\u0004C\u000f[3!KN$\u0018.\\1uK\u0012\u0004c.^7cKJ\u0004sN\u001a\u0011v]&\fX/\u001a\u0011wC2,Xm\u001d\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011aC2dwn\u001e#jM\u001a,'/\u001a8u\u0019\u001e\u001cuN\u001c4jO.\u0003\u0007\u0005K8qi&|g.\u00197*A\u0005cGn\\<!g.,Go\u00195fg\u0002:\u0018\u000e\u001e5!I&4g-\u001a:f]R\u0004CnZ\"p]\u001aLwm\u0013\u0011wC2,Xm\u001d\u0006!A\u0001\u0002\u0003\u0005\t\u0011u_\u0002\u0012W\rI;oS>tW\r\u001a\u0011)I\u00164\u0017-\u001e7ug\u0002\"x\u000e\t4bYN,\u0017FL\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012!qL\u0001\u0002L*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003\u0003\u000e\u001c7`g.,Go\u00195`KN$\u0018.\\1uK\"zf)\u0016(D?\"\u001a8.\u001a;dQ2\u0002CO];fS%\u0002cIU(NA!\u001aV\tT#D)\u0002BG\u000e\\0tW\u0016$8\r[0bO\u001eD3m\u001c7*A\u0005\u001c\be]6fi\u000eD\u0007E\u0012*P\u001b\u00022\u0016\tT+F'\u0002B\u0013'\u000b\u0011uC\nD3m\u001c7*AUs\u0015j\u0014(!\u00032c\u0005eU#M\u000b\u000e#\u0006\u0005\u001b7m?N\\W\r^2i?\u0006<w\rK2pY2\u0002#\u0007M\u0015!CN\u00043o[3uG\"\u0004cIU(NAY\u000bE*V#TA!\n\u0014\u0006\t;bE\"\u001aw\u000e\\\u0015*w)\u0001\u0003\u0005\t\u0011!A\u0001\n$\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\t\u0015\u0014!C1hO~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\u0011Y'A\u00034]Ur\u0003'A\u0006IY2,f.[8o\u0003\u001e<\u0007CA$,'\u0015Y#1\u000fB@!)\u0011)Ha\u001f_=n\\\u0018qA\u0007\u0003\u0005oR1A!\u001fM\u0003\u001d\u0011XO\u001c;j[\u0016LAA! \u0003x\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001b\u0011\t\t\u0005%qQ\u0007\u0003\u0005\u0007SAA!\"\u0003\u001c\u0005\u0011\u0011n\\\u0005\u0004e\n\rEC\u0001B8\u0003!!xn\u0015;sS:<GC\u0001B\n\u0003\u0015\t\u0007\u000f\u001d7z))\t9Aa%\u0003\u0016\n]%\u0011\u0014\u0005\u0006i:\u0002\rA\u0018\u0005\u0006o:\u0002\rA\u0018\u0005\bs:\u0002\n\u00111\u0001|\u0011\u001dyh\u0006%AA\u0002m\fq\"\u00199qYf$C-\u001a4bk2$HeM\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%i\u00059QO\\1qa2LH\u0003\u0002BR\u0005W\u0003Ba\u0013(\u0003&B91Ja*_=n\\\u0018b\u0001BU\u0019\n1A+\u001e9mKRB\u0011B!,2\u0003\u0003\u0005\r!a\u0002\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\t]\u0006\u0003\u0002B\u000b\u0005sKAAa/\u0003\u0018\t1qJ\u00196fGR\u0004")
public class HllUnionAgg
extends TypedImperativeAggregate<Option<Union>>
implements BinaryLike<Expression>,
ExpectsInputTypes,
Serializable {
    private boolean allowDifferentLgConfigK;
    private final Expression left;
    private final Expression right;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private final TgtHllType targetType;
    private transient Seq<Expression> children;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static int $lessinit$greater$default$4() {
        return HllUnionAgg$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return HllUnionAgg$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple4<Expression, Expression, Object, Object>> unapply(HllUnionAgg x$0) {
        return HllUnionAgg$.MODULE$.unapply(x$0);
    }

    public static int apply$default$4() {
        return HllUnionAgg$.MODULE$.apply$default$4();
    }

    public static int apply$default$3() {
        return HllUnionAgg$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple4<Expression, Expression, Object, Object>, HllUnionAgg> tupled() {
        return HllUnionAgg$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Object, Function1<Object, HllUnionAgg>>>> curried() {
        return HllUnionAgg$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return BinaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return BinaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        HllUnionAgg hllUnionAgg = this;
        synchronized (hllUnionAgg) {
            if (!this.bitmap$trans$0) {
                this.children = BinaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    private boolean allowDifferentLgConfigK$lzycompute() {
        HllUnionAgg hllUnionAgg = this;
        synchronized (hllUnionAgg) {
            if (!this.bitmap$0) {
                this.allowDifferentLgConfigK = BoxesRunTime.unboxToBoolean((Object)this.right().eval(this.right().eval$default$1()));
                this.bitmap$0 = true;
            }
        }
        return this.allowDifferentLgConfigK;
    }

    public boolean allowDifferentLgConfigK() {
        if (!this.bitmap$0) {
            return this.allowDifferentLgConfigK$lzycompute();
        }
        return this.allowDifferentLgConfigK;
    }

    private TgtHllType targetType() {
        return this.targetType;
    }

    @Override
    public HllUnionAgg withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        int x$4 = this.copy$default$4();
        return this.copy(x$2, x$3, x$1, x$4);
    }

    @Override
    public HllUnionAgg withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$1 = newInputAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        int x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, x$1);
    }

    @Override
    public HllUnionAgg withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3(), this.copy$default$4());
    }

    @Override
    public String prettyName() {
        return "hll_union_agg";
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)BinaryType$.MODULE$, (List)new .colon.colon((Object)BooleanType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public DataType dataType() {
        return BinaryType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public Option<Union> createAggregationBuffer() {
        return None$.MODULE$;
    }

    public void compareLgConfigK(int left, int right) {
        if (!this.allowDifferentLgConfigK() && left != right) {
            throw QueryExecutionErrors$.MODULE$.hllUnionDifferentLgK(left, right, this.prettyName());
        }
    }

    @Override
    public Option<Union> update(Option<Union> unionOption, InternalRow input) {
        Object v = this.left().eval(input);
        if (v != null) {
            DataType dataType = this.left().dataType();
            if (BinaryType$.MODULE$.equals(dataType)) {
                Some some;
                try {
                    HllSketch sketch = HllSketch.wrap((Memory)Memory.wrap((byte[])((byte[])v)));
                    Union union = (Union)unionOption.getOrElse((Function0 & Serializable)() -> new Union(sketch.getLgConfigK()));
                    this.compareLgConfigK(union.getLgConfigK(), sketch.getLgConfigK());
                    union.update(sketch);
                    some = new Some((Object)union);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof SketchesArgumentException ? true : throwable2 instanceof Error) {
                        throw QueryExecutionErrors$.MODULE$.hllInvalidInputSketchBuffer(this.prettyName());
                    }
                    throw throwable;
                }
                return some;
            }
            throw QueryExecutionErrors$.MODULE$.hllInvalidInputSketchBuffer(this.prettyName());
        }
        return unionOption;
    }

    @Override
    public Option<Union> merge(Option<Union> unionOption, Option<Union> inputOption) {
        Tuple2 tuple2 = new Tuple2(unionOption, inputOption);
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                Union union = (Union)some.value();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    Union input = (Union)some2.value();
                    this.compareLgConfigK(union.getLgConfigK(), input.getLgConfigK());
                    union.update(input.getResult(this.targetType()));
                    return new Some((Object)union);
                }
            }
        }
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option3 = (Option)tuple2._2();
            if (option instanceof Some && None$.MODULE$.equals(option3)) {
                return unionOption;
            }
        }
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option4 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option) && option4 instanceof Some) {
                return inputOption;
            }
        }
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option5 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option5)) {
                return unionOption;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    @Override
    public Object eval(Option<Union> unionOption) {
        Option<Union> option = unionOption;
        if (option instanceof Some) {
            Some some = (Some)option;
            Union union = (Union)some.value();
            return union.toUpdatableByteArray();
        }
        if (None$.MODULE$.equals(option)) {
            return new Union().toUpdatableByteArray();
        }
        throw new MatchError(option);
    }

    @Override
    public byte[] serialize(Option<Union> unionOption) {
        Option<Union> option = unionOption;
        if (option instanceof Some) {
            Some some = (Some)option;
            Union union = (Union)some.value();
            return union.toUpdatableByteArray();
        }
        if (None$.MODULE$.equals(option)) {
            return new byte[0];
        }
        throw new MatchError(option);
    }

    @Override
    public Option<Union> deserialize(byte[] buffer) {
        if (buffer.length != 0) {
            return new Some((Object)Union.heapify((byte[])buffer));
        }
        return None$.MODULE$;
    }

    public HllUnionAgg copy(Expression left, Expression right, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new HllUnionAgg(left, right, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public int copy$default$3() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$4() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "HllUnionAgg";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
            }
            case 3: {
                return BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof HllUnionAgg;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
            case 2: {
                return "mutableAggBufferOffset";
            }
            case 3: {
                return "inputAggBufferOffset";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof HllUnionAgg)) return false;
        boolean bl = true;
        if (!bl) return false;
        HllUnionAgg hllUnionAgg = (HllUnionAgg)x$1;
        if (this.mutableAggBufferOffset() != hllUnionAgg.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != hllUnionAgg.inputAggBufferOffset()) return false;
        Expression expression = this.left();
        Expression expression2 = hllUnionAgg.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = hllUnionAgg.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!hllUnionAgg.canEqual(this)) return false;
        return true;
    }

    public HllUnionAgg(Expression left, Expression right, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.left = left;
        this.right = right;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        BinaryLike.$init$(this);
        ExpectsInputTypes.$init$(this);
        this.targetType = TgtHllType.HLL_8;
    }

    public HllUnionAgg(Expression child) {
        this(child, Literal$.MODULE$.apply(BoxesRunTime.boxToBoolean((boolean)false)), 0, 0);
    }

    public HllUnionAgg(Expression child, Expression allowDifferentLgConfigK) {
        this(child, allowDifferentLgConfigK, 0, 0);
    }

    public HllUnionAgg(Expression child, boolean allowDifferentLgConfigK) {
        this(child, Literal$.MODULE$.apply(BoxesRunTime.boxToBoolean((boolean)allowDifferentLgConfigK)), 0, 0);
    }
}

