/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.client.arrow;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.BaseLargeVariableWidthVector;
import org.apache.arrow.vector.BaseVariableWidthVector;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.DurationVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.IntervalYearVector;
import org.apache.arrow.vector.LargeVarBinaryVector;
import org.apache.arrow.vector.LargeVarCharVector;
import org.apache.arrow.vector.NullVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeNanoVector;
import org.apache.arrow.vector.TimeStampMicroTZVector;
import org.apache.arrow.vector.TimeStampMicroVector;
import org.apache.arrow.vector.TimeStampVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VariableWidthFieldVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.Text;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.DefinedByConstructorParams;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoder;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders;
import org.apache.spark.sql.catalyst.encoders.Codec;
import org.apache.spark.sql.catalyst.util.SparkDateTimeUtils$;
import org.apache.spark.sql.catalyst.util.SparkIntervalUtils$;
import org.apache.spark.sql.connect.client.arrow.ArrowEncoderUtils$;
import org.apache.spark.sql.connect.client.arrow.ArrowEncoderUtils$Classes$;
import org.apache.spark.sql.connect.client.arrow.ArrowSerializer;
import org.apache.spark.sql.connect.client.arrow.GeographyArrowSerDe;
import org.apache.spark.sql.connect.client.arrow.GeometryArrowSerDe;
import org.apache.spark.sql.connect.client.arrow.StructVectors$;
import org.apache.spark.sql.errors.ExecutionErrors$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.ArrowUtils$;
import org.apache.spark.sql.util.CloseableIterator;
import org.apache.spark.unsafe.types.VariantVal;
import org.sparkproject.connect.protobuf.ByteString;
import scala.;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.BufferedIterator;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.math.BigInt;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class ArrowSerializer$ {
    public static final ArrowSerializer$ MODULE$ = new ArrowSerializer$();
    private static final MethodHandles.Lookup methodLookup = MethodHandles.lookup();

    public <T> CloseableIterator<byte[]> serialize(Iterator<T> input, AgnosticEncoder<T> enc, BufferAllocator allocator, int maxRecordsPerBatch, long maxBatchSize, String timeZoneId, boolean largeVarTypes, int batchSizeCheckInterval) {
        Predef$.MODULE$.assert(maxRecordsPerBatch > 0);
        Predef$.MODULE$.assert(maxBatchSize > 0L);
        Predef$.MODULE$.assert(batchSizeCheckInterval > 0);
        return new CloseableIterator<byte[]>(enc, allocator, timeZoneId, largeVarTypes, batchSizeCheckInterval, maxBatchSize, input, maxRecordsPerBatch){
            private final ArrowSerializer<T> serializer;
            private final ByteArrayOutputStream bytes;
            private boolean hasWrittenFirstBatch;
            private final int batchSizeCheckInterval$1;
            private final long maxBatchSize$1;
            private final Iterator input$1;
            private final int maxRecordsPerBatch$1;

            public java.util.Iterator<byte[]> asJava() {
                return CloseableIterator.asJava$((CloseableIterator)this);
            }

            public <B> CloseableIterator<B> map(Function1<byte[], B> f) {
                return CloseableIterator.map$((CloseableIterator)this, f);
            }

            public final boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public final Iterator<byte[]> iterator() {
                return Iterator.iterator$((Iterator)this);
            }

            public Option<byte[]> nextOption() {
                return Iterator.nextOption$((Iterator)this);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public BufferedIterator<byte[]> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator<B> padTo(int len, B elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Tuple2<Iterator<byte[]>, Iterator<byte[]>> partition(Function1<byte[], Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, byte[], B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<byte[], B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public int indexWhere(Function1<byte[], Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public int indexWhere$default$2() {
                return Iterator.indexWhere$default$2$((Iterator)this);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public final int length() {
                return Iterator.length$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public Iterator<byte[]> filter(Function1<byte[], Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public Iterator<byte[]> filterNot(Function1<byte[], Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public Iterator<byte[]> filterImpl(Function1<byte[], Object> p, boolean isFlipped) {
                return Iterator.filterImpl$((Iterator)this, p, (boolean)isFlipped);
            }

            public Iterator<byte[]> withFilter(Function1<byte[], Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<byte[], B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public Iterator<byte[]> distinct() {
                return Iterator.distinct$((Iterator)this);
            }

            public <B> Iterator<byte[]> distinctBy(Function1<byte[], B> f) {
                return Iterator.distinctBy$((Iterator)this, f);
            }

            public <B> Iterator<B> flatMap(Function1<byte[], IterableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public <B> Iterator<B> flatten(Function1<byte[], IterableOnce<B>> ev) {
                return Iterator.flatten$((Iterator)this, ev);
            }

            public <B> Iterator<B> concat(Function0<IterableOnce<B>> xs) {
                return Iterator.concat$((Iterator)this, xs);
            }

            public final <B> Iterator<B> $plus$plus(Function0<IterableOnce<B>> xs) {
                return Iterator.$plus$plus$((Iterator)this, xs);
            }

            public Iterator<byte[]> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<byte[]> takeWhile(Function1<byte[], Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Iterator<byte[]> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<byte[]> dropWhile(Function1<byte[], Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<byte[]>, Iterator<byte[]>> span(Function1<byte[], Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<byte[]> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<byte[]> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<Tuple2<byte[], B>> zip(IterableOnce<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1, B> Iterator<Tuple2<A1, B>> zipAll(IterableOnce<B> that, A1 thisElem, B thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public Iterator<Tuple2<byte[], Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B> boolean sameElements(IterableOnce<B> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Tuple2<Iterator<byte[]>, Iterator<byte[]>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <U> Iterator<byte[]> tapEach(Function1<byte[], U> f) {
                return Iterator.tapEach$((Iterator)this, f);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public Iterator<byte[]> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public Tuple2<Iterator<byte[]>, Iterator<byte[]>> splitAt(int n) {
                return IterableOnceOps.splitAt$((IterableOnceOps)this, (int)n);
            }

            public boolean isTraversableAgain() {
                return IterableOnceOps.isTraversableAgain$((IterableOnceOps)this);
            }

            public <U> void foreach(Function1<byte[], U> f) {
                IterableOnceOps.foreach$((IterableOnceOps)this, f);
            }

            public boolean forall(Function1<byte[], Object> p) {
                return IterableOnceOps.forall$((IterableOnceOps)this, p);
            }

            public boolean exists(Function1<byte[], Object> p) {
                return IterableOnceOps.exists$((IterableOnceOps)this, p);
            }

            public int count(Function1<byte[], Object> p) {
                return IterableOnceOps.count$((IterableOnceOps)this, p);
            }

            public Option<byte[]> find(Function1<byte[], Object> p) {
                return IterableOnceOps.find$((IterableOnceOps)this, p);
            }

            public <B> B foldLeft(B z, Function2<B, byte[], B> op) {
                return (B)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
            }

            public <B> B foldRight(B z, Function2<byte[], B, B> op) {
                return (B)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
            }

            public final <B> B $div$colon(B z, Function2<B, byte[], B> op) {
                return (B)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
            }

            public final <B> B $colon$bslash(B z, Function2<byte[], B, B> op) {
                return (B)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
            }

            public <B> B reduce(Function2<B, B, B> op) {
                return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceOption(Function2<B, B, B> op) {
                return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
            }

            public <B> B reduceLeft(Function2<B, byte[], B> op) {
                return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
            }

            public <B> B reduceRight(Function2<byte[], B, B> op) {
                return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, byte[], B> op) {
                return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<byte[], B, B> op) {
                return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
            }

            public boolean nonEmpty() {
                return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
            }

            public int size() {
                return IterableOnceOps.size$((IterableOnceOps)this);
            }

            public final <B> void copyToBuffer(Buffer<B> dest) {
                IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
            }

            public <B> int copyToArray(Object dest) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)dest);
            }

            public <B> int copyToArray(Object dest, int start) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)dest, (int)start);
            }

            public <B> int copyToArray(Object dest, int start, int n) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)dest, (int)start, (int)n);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
            }

            public Object min(Ordering ord) {
                return IterableOnceOps.min$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<byte[]> minOption(Ordering<B> ord) {
                return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
            }

            public Object max(Ordering ord) {
                return IterableOnceOps.max$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<byte[]> maxOption(Ordering<B> ord) {
                return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
            }

            public Object maxBy(Function1 f, Ordering ord) {
                return IterableOnceOps.maxBy$((IterableOnceOps)this, (Function1)f, (Ordering)ord);
            }

            public <B> Option<byte[]> maxByOption(Function1<byte[], B> f, Ordering<B> ord) {
                return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, ord);
            }

            public Object minBy(Function1 f, Ordering ord) {
                return IterableOnceOps.minBy$((IterableOnceOps)this, (Function1)f, (Ordering)ord);
            }

            public <B> Option<byte[]> minByOption(Function1<byte[], B> f, Ordering<B> ord) {
                return IterableOnceOps.minByOption$((IterableOnceOps)this, f, ord);
            }

            public <B> Option<B> collectFirst(PartialFunction<byte[], B> pf) {
                return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, byte[], B> seqop, Function2<B, B, B> combop) {
                return (B)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
            }

            public <B> boolean corresponds(IterableOnce<B> that, Function2<byte[], B, Object> p) {
                return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
            }

            public final String mkString(String start, String sep, String end) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
            }

            public final String mkString(String sep) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
            }

            public final String mkString() {
                return IterableOnceOps.mkString$((IterableOnceOps)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public final StringBuilder addString(StringBuilder b, String sep) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
            }

            public final StringBuilder addString(StringBuilder b) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
            }

            public <C1> C1 to(Factory<byte[], C1> factory) {
                return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
            }

            public final Iterator<byte[]> toIterator() {
                return IterableOnceOps.toIterator$((IterableOnceOps)this);
            }

            public List<byte[]> toList() {
                return IterableOnceOps.toList$((IterableOnceOps)this);
            }

            public Vector<byte[]> toVector() {
                return IterableOnceOps.toVector$((IterableOnceOps)this);
            }

            public <K, V> scala.collection.immutable.Map<K, V> toMap(.less.colon.less<byte[], Tuple2<K, V>> ev) {
                return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
            }

            public <B> Set<B> toSet() {
                return IterableOnceOps.toSet$((IterableOnceOps)this);
            }

            public Seq<byte[]> toSeq() {
                return IterableOnceOps.toSeq$((IterableOnceOps)this);
            }

            public IndexedSeq<byte[]> toIndexedSeq() {
                return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
            }

            public final Stream<byte[]> toStream() {
                return IterableOnceOps.toStream$((IterableOnceOps)this);
            }

            public final <B> Buffer<B> toBuffer() {
                return IterableOnceOps.toBuffer$((IterableOnceOps)this);
            }

            public <B> Object toArray(ClassTag<B> evidence$2) {
                return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
            }

            public Iterable<byte[]> reversed() {
                return IterableOnceOps.reversed$((IterableOnceOps)this);
            }

            public <S extends Stepper<?>> S stepper(StepperShape<byte[], S> shape) {
                return (S)IterableOnce.stepper$((IterableOnce)this, shape);
            }

            public int knownSize() {
                return IterableOnce.knownSize$((IterableOnce)this);
            }

            private ArrowSerializer<T> serializer() {
                return this.serializer;
            }

            private ByteArrayOutputStream bytes() {
                return this.bytes;
            }

            private boolean hasWrittenFirstBatch() {
                return this.hasWrittenFirstBatch;
            }

            private void hasWrittenFirstBatch_$eq(boolean x$1) {
                this.hasWrittenFirstBatch = x$1;
            }

            private boolean sizeOk(int i) {
                if (i > 0 && i % this.batchSizeCheckInterval$1 == 0) {
                    return this.serializer().sizeInBytes() < this.maxBatchSize$1;
                }
                return true;
            }

            public boolean hasNext() {
                return (this.input$1.hasNext() || !this.hasWrittenFirstBatch()) && !this.serializer().isClosed();
            }

            public byte[] next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.serializer().reset();
                this.bytes().reset();
                for (int i = 0; i < this.maxRecordsPerBatch$1 && this.input$1.hasNext() && this.sizeOk(i); ++i) {
                    this.serializer().append(this.input$1.next());
                }
                this.serializer().writeIpcStream(this.bytes());
                this.hasWrittenFirstBatch_$eq(true);
                return this.bytes().toByteArray();
            }

            public void close() {
                this.serializer().close();
            }
            {
                this.batchSizeCheckInterval$1 = batchSizeCheckInterval$1;
                this.maxBatchSize$1 = maxBatchSize$1;
                this.input$1 = input$1;
                this.maxRecordsPerBatch$1 = maxRecordsPerBatch$1;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                Iterator.$init$((Iterator)this);
                CloseableIterator.$init$((CloseableIterator)this);
                this.serializer = new ArrowSerializer<T>(enc$1, allocator$1, timeZoneId$1, largeVarTypes$1);
                this.bytes = new ByteArrayOutputStream();
                this.hasWrittenFirstBatch = false;
            }
        };
    }

    public <T> ByteString serialize(Iterator<T> input, AgnosticEncoder<T> enc, BufferAllocator allocator, String timeZoneId, boolean largeVarTypes) {
        ByteString byteString;
        try (ArrowSerializer serializer = new ArrowSerializer(enc, allocator, timeZoneId, largeVarTypes);){
            input.foreach((Function1 & Serializable)record -> {
                serializer.append(record);
                return BoxedUnit.UNIT;
            });
            ByteString.Output output = ByteString.newOutput();
            serializer.writeIpcStream(output);
            byteString = output.toByteString();
        }
        return byteString;
    }

    public <T> int serialize$default$8() {
        return 128;
    }

    public <T> Tuple2<VectorSchemaRoot, ArrowSerializer.Serializer> serializerFor(AgnosticEncoder<T> encoder, BufferAllocator allocator, String timeZoneId, boolean largeVarTypes) {
        ArrowSerializer.Serializer serializer;
        Schema arrowSchema = ArrowUtils$.MODULE$.toArrowSchema(encoder.schema(), timeZoneId, true, largeVarTypes);
        VectorSchemaRoot root = VectorSchemaRoot.create((Schema)arrowSchema, (BufferAllocator)allocator);
        StructType structType = encoder.schema();
        DataType dataType = encoder.dataType();
        if (structType == null ? dataType != null : !structType.equals(dataType)) {
            Predef$.MODULE$.assert(root.getSchema().getFields().size() == 1);
            serializer = this.serializerFor(encoder, root.getVector(0));
        } else {
            serializer = this.serializerFor(encoder, root);
        }
        ArrowSerializer.Serializer serializer2 = serializer;
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)root), (Object)serializer2);
    }

    public <E> ArrowSerializer.Serializer serializerFor(AgnosticEncoder<E> encoder, Object v2) {
        AgnosticEncoder agnosticEncoder;
        Tuple2 tuple2 = new Tuple2(encoder, v2);
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder2 = (AgnosticEncoder)tuple2._1();
            Object v3 = tuple2._2();
            if ((AgnosticEncoders.PrimitiveBooleanEncoder$.MODULE$.equals(agnosticEncoder2) ? true : AgnosticEncoders.BoxedBooleanEncoder$.MODULE$.equals(agnosticEncoder2)) && v3 instanceof BitVector) {
                BitVector bitVector = (BitVector)v3;
                return new ArrowSerializer.FieldSerializer<Object, BitVector>(bitVector){

                    public void set(int index, boolean value) {
                        ((BitVector)this.vector()).setSafe(index, value ? 1 : 0);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder3 = (AgnosticEncoder)tuple2._1();
            Object v4 = tuple2._2();
            if ((AgnosticEncoders.PrimitiveByteEncoder$.MODULE$.equals(agnosticEncoder3) ? true : AgnosticEncoders.BoxedByteEncoder$.MODULE$.equals(agnosticEncoder3)) && v4 instanceof TinyIntVector) {
                TinyIntVector tinyIntVector = (TinyIntVector)v4;
                return new ArrowSerializer.FieldSerializer<Object, TinyIntVector>(tinyIntVector){

                    public void set(int index, byte value) {
                        ((TinyIntVector)this.vector()).setSafe(index, value);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder4 = (AgnosticEncoder)tuple2._1();
            Object v5 = tuple2._2();
            if ((AgnosticEncoders.PrimitiveShortEncoder$.MODULE$.equals(agnosticEncoder4) ? true : AgnosticEncoders.BoxedShortEncoder$.MODULE$.equals(agnosticEncoder4)) && v5 instanceof SmallIntVector) {
                SmallIntVector smallIntVector = (SmallIntVector)v5;
                return new ArrowSerializer.FieldSerializer<Object, SmallIntVector>(smallIntVector){

                    public void set(int index, short value) {
                        ((SmallIntVector)this.vector()).setSafe(index, value);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder5 = (AgnosticEncoder)tuple2._1();
            Object v6 = tuple2._2();
            if ((AgnosticEncoders.PrimitiveIntEncoder$.MODULE$.equals(agnosticEncoder5) ? true : AgnosticEncoders.BoxedIntEncoder$.MODULE$.equals(agnosticEncoder5)) && v6 instanceof IntVector) {
                IntVector intVector = (IntVector)v6;
                return new ArrowSerializer.FieldSerializer<Object, IntVector>(intVector){

                    public void set(int index, int value) {
                        ((IntVector)this.vector()).setSafe(index, value);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder6 = (AgnosticEncoder)tuple2._1();
            Object v7 = tuple2._2();
            if ((AgnosticEncoders.PrimitiveLongEncoder$.MODULE$.equals(agnosticEncoder6) ? true : AgnosticEncoders.BoxedLongEncoder$.MODULE$.equals(agnosticEncoder6)) && v7 instanceof BigIntVector) {
                BigIntVector bigIntVector = (BigIntVector)v7;
                return new ArrowSerializer.FieldSerializer<Object, BigIntVector>(bigIntVector){

                    public void set(int index, long value) {
                        ((BigIntVector)this.vector()).setSafe(index, value);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder7 = (AgnosticEncoder)tuple2._1();
            Object v8 = tuple2._2();
            if ((AgnosticEncoders.PrimitiveFloatEncoder$.MODULE$.equals(agnosticEncoder7) ? true : AgnosticEncoders.BoxedFloatEncoder$.MODULE$.equals(agnosticEncoder7)) && v8 instanceof Float4Vector) {
                Float4Vector float4Vector = (Float4Vector)v8;
                return new ArrowSerializer.FieldSerializer<Object, Float4Vector>(float4Vector){

                    public void set(int index, float value) {
                        ((Float4Vector)this.vector()).setSafe(index, value);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder8 = (AgnosticEncoder)tuple2._1();
            Object v9 = tuple2._2();
            if ((AgnosticEncoders.PrimitiveDoubleEncoder$.MODULE$.equals(agnosticEncoder8) ? true : AgnosticEncoders.BoxedDoubleEncoder$.MODULE$.equals(agnosticEncoder8)) && v9 instanceof Float8Vector) {
                Float8Vector float8Vector = (Float8Vector)v9;
                return new ArrowSerializer.FieldSerializer<Object, Float8Vector>(float8Vector){

                    public void set(int index, double value) {
                        ((Float8Vector)this.vector()).setSafe(index, value);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder9 = (AgnosticEncoder)tuple2._1();
            Object v10 = tuple2._2();
            if (AgnosticEncoders.NullEncoder$.MODULE$.equals(agnosticEncoder9) && v10 instanceof NullVector) {
                NullVector nullVector = (NullVector)v10;
                return new ArrowSerializer.FieldSerializer<BoxedUnit, NullVector>(nullVector){

                    public void set(int index, BoxedUnit value) {
                        ((NullVector)this.vector()).setNull(index);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder10 = (AgnosticEncoder)tuple2._1();
            Object v11 = tuple2._2();
            if (AgnosticEncoders.StringEncoder$.MODULE$.equals(agnosticEncoder10) && v11 instanceof VarCharVector) {
                VarCharVector varCharVector = (VarCharVector)v11;
                return new ArrowSerializer.FieldSerializer<String, VarCharVector>(varCharVector){
                    private final VarCharVector x35$1;

                    public void set(int index, String value) {
                        ArrowSerializer$.MODULE$.org$apache$spark$sql$connect$client$arrow$ArrowSerializer$$setString((VariableWidthFieldVector)this.x35$1, index, value);
                    }
                    {
                        this.x35$1 = x35$1;
                        super(x35$1);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder11 = (AgnosticEncoder)tuple2._1();
            Object v12 = tuple2._2();
            if (AgnosticEncoders.StringEncoder$.MODULE$.equals(agnosticEncoder11) && v12 instanceof LargeVarCharVector) {
                LargeVarCharVector largeVarCharVector = (LargeVarCharVector)v12;
                return new ArrowSerializer.FieldSerializer<String, LargeVarCharVector>(largeVarCharVector){
                    private final LargeVarCharVector x38$1;

                    public void set(int index, String value) {
                        ArrowSerializer$.MODULE$.org$apache$spark$sql$connect$client$arrow$ArrowSerializer$$setString((VariableWidthFieldVector)this.x38$1, index, value);
                    }
                    {
                        this.x38$1 = x38$1;
                        super(x38$1);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder12 = (AgnosticEncoder)tuple2._1();
            Object v13 = tuple2._2();
            if (agnosticEncoder12 instanceof AgnosticEncoders.JavaEnumEncoder && v13 instanceof VarCharVector) {
                VarCharVector varCharVector = (VarCharVector)v13;
                return new ArrowSerializer.FieldSerializer<Enum<?>, VarCharVector>(varCharVector){
                    private final VarCharVector x42$1;

                    public void set(int index, Enum<?> value) {
                        ArrowSerializer$.MODULE$.org$apache$spark$sql$connect$client$arrow$ArrowSerializer$$setString((VariableWidthFieldVector)this.x42$1, index, value.name());
                    }
                    {
                        this.x42$1 = x42$1;
                        super(x42$1);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder13 = (AgnosticEncoder)tuple2._1();
            Object v14 = tuple2._2();
            if (agnosticEncoder13 instanceof AgnosticEncoders.JavaEnumEncoder && v14 instanceof LargeVarCharVector) {
                LargeVarCharVector largeVarCharVector = (LargeVarCharVector)v14;
                return new ArrowSerializer.FieldSerializer<Enum<?>, LargeVarCharVector>(largeVarCharVector){
                    private final LargeVarCharVector x46$1;

                    public void set(int index, Enum<?> value) {
                        ArrowSerializer$.MODULE$.org$apache$spark$sql$connect$client$arrow$ArrowSerializer$$setString((VariableWidthFieldVector)this.x46$1, index, value.name());
                    }
                    {
                        this.x46$1 = x46$1;
                        super(x46$1);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder14 = (AgnosticEncoder)tuple2._1();
            Object v15 = tuple2._2();
            if (agnosticEncoder14 instanceof AgnosticEncoders.ScalaEnumEncoder && v15 instanceof VarCharVector) {
                VarCharVector varCharVector = (VarCharVector)v15;
                return new ArrowSerializer.FieldSerializer<Enumeration.Value, VarCharVector>(varCharVector){
                    private final VarCharVector x51$1;

                    public void set(int index, Enumeration.Value value) {
                        ArrowSerializer$.MODULE$.org$apache$spark$sql$connect$client$arrow$ArrowSerializer$$setString((VariableWidthFieldVector)this.x51$1, index, value.toString());
                    }
                    {
                        this.x51$1 = x51$1;
                        super(x51$1);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder15 = (AgnosticEncoder)tuple2._1();
            Object v16 = tuple2._2();
            if (agnosticEncoder15 instanceof AgnosticEncoders.ScalaEnumEncoder && v16 instanceof LargeVarCharVector) {
                LargeVarCharVector largeVarCharVector = (LargeVarCharVector)v16;
                return new ArrowSerializer.FieldSerializer<Enumeration.Value, LargeVarCharVector>(largeVarCharVector){
                    private final LargeVarCharVector x56$1;

                    public void set(int index, Enumeration.Value value) {
                        ArrowSerializer$.MODULE$.org$apache$spark$sql$connect$client$arrow$ArrowSerializer$$setString((VariableWidthFieldVector)this.x56$1, index, value.toString());
                    }
                    {
                        this.x56$1 = x56$1;
                        super(x56$1);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder16 = (AgnosticEncoder)tuple2._1();
            Object v17 = tuple2._2();
            if (AgnosticEncoders.BinaryEncoder$.MODULE$.equals(agnosticEncoder16) && v17 instanceof VarBinaryVector) {
                VarBinaryVector varBinaryVector = (VarBinaryVector)v17;
                return new ArrowSerializer.FieldSerializer<byte[], VarBinaryVector>(varBinaryVector){

                    public void set(int index, byte[] value) {
                        ((BaseVariableWidthVector)this.vector()).setSafe(index, value);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder17 = (AgnosticEncoder)tuple2._1();
            Object v18 = tuple2._2();
            if (AgnosticEncoders.BinaryEncoder$.MODULE$.equals(agnosticEncoder17) && v18 instanceof LargeVarBinaryVector) {
                LargeVarBinaryVector largeVarBinaryVector = (LargeVarBinaryVector)v18;
                return new ArrowSerializer.FieldSerializer<byte[], LargeVarBinaryVector>(largeVarBinaryVector){

                    public void set(int index, byte[] value) {
                        ((BaseLargeVariableWidthVector)this.vector()).setSafe(index, value);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder18 = (AgnosticEncoder)tuple2._1();
            Object v19 = tuple2._2();
            if (agnosticEncoder18 instanceof AgnosticEncoders.SparkDecimalEncoder && v19 instanceof DecimalVector) {
                DecimalVector decimalVector = (DecimalVector)v19;
                return new ArrowSerializer.FieldSerializer<Decimal, DecimalVector>(decimalVector){

                    public void set(int index, Decimal value) {
                        ArrowSerializer$.MODULE$.org$apache$spark$sql$connect$client$arrow$ArrowSerializer$$setDecimal((DecimalVector)this.vector(), index, value.toJavaBigDecimal());
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder19 = (AgnosticEncoder)tuple2._1();
            Object v20 = tuple2._2();
            if (agnosticEncoder19 instanceof AgnosticEncoders.ScalaDecimalEncoder && v20 instanceof DecimalVector) {
                DecimalVector decimalVector = (DecimalVector)v20;
                return new ArrowSerializer.FieldSerializer<scala.math.BigDecimal, DecimalVector>(decimalVector){

                    public void set(int index, scala.math.BigDecimal value) {
                        ArrowSerializer$.MODULE$.org$apache$spark$sql$connect$client$arrow$ArrowSerializer$$setDecimal((DecimalVector)this.vector(), index, value.bigDecimal());
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoders.JavaDecimalEncoder javaDecimalEncoder;
            boolean bl;
            AgnosticEncoder agnosticEncoder20 = (AgnosticEncoder)tuple2._1();
            Object v21 = tuple2._2();
            if (agnosticEncoder20 instanceof AgnosticEncoders.JavaDecimalEncoder && !(bl = (javaDecimalEncoder = (AgnosticEncoders.JavaDecimalEncoder)agnosticEncoder20).lenientSerialization()) && v21 instanceof DecimalVector) {
                DecimalVector decimalVector = (DecimalVector)v21;
                return new ArrowSerializer.FieldSerializer<BigDecimal, DecimalVector>(decimalVector){

                    public void set(int index, BigDecimal value) {
                        ArrowSerializer$.MODULE$.org$apache$spark$sql$connect$client$arrow$ArrowSerializer$$setDecimal((DecimalVector)this.vector(), index, value);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoders.JavaDecimalEncoder javaDecimalEncoder;
            boolean bl;
            AgnosticEncoder agnosticEncoder21 = (AgnosticEncoder)tuple2._1();
            Object v22 = tuple2._2();
            if (agnosticEncoder21 instanceof AgnosticEncoders.JavaDecimalEncoder && (bl = (javaDecimalEncoder = (AgnosticEncoders.JavaDecimalEncoder)agnosticEncoder21).lenientSerialization()) && v22 instanceof DecimalVector) {
                DecimalVector decimalVector = (DecimalVector)v22;
                return new ArrowSerializer.FieldSerializer<Object, DecimalVector>(decimalVector){

                    public void set(int index, Object value) {
                        BigDecimal bigDecimal;
                        Object object = value;
                        if (object instanceof BigDecimal) {
                            BigDecimal bigDecimal2;
                            bigDecimal = bigDecimal2 = (BigDecimal)object;
                        } else if (object instanceof scala.math.BigDecimal) {
                            scala.math.BigDecimal bigDecimal3 = (scala.math.BigDecimal)object;
                            bigDecimal = bigDecimal3.bigDecimal();
                        } else if (object instanceof BigInt) {
                            BigInt bigInt = (BigInt)object;
                            bigDecimal = new BigDecimal(bigInt.bigInteger());
                        } else if (object instanceof BigInteger) {
                            BigInteger bigInteger = (BigInteger)object;
                            bigDecimal = new BigDecimal(bigInteger);
                        } else if (object instanceof Decimal) {
                            Decimal decimal = (Decimal)object;
                            bigDecimal = decimal.toJavaBigDecimal();
                        } else {
                            throw new MatchError(object);
                        }
                        BigDecimal decimal = bigDecimal;
                        ArrowSerializer$.MODULE$.org$apache$spark$sql$connect$client$arrow$ArrowSerializer$$setDecimal((DecimalVector)this.vector(), index, decimal);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder22 = (AgnosticEncoder)tuple2._1();
            Object v23 = tuple2._2();
            if (AgnosticEncoders.ScalaBigIntEncoder$.MODULE$.equals(agnosticEncoder22) && v23 instanceof DecimalVector) {
                DecimalVector decimalVector = (DecimalVector)v23;
                return new ArrowSerializer.FieldSerializer<BigInt, DecimalVector>(decimalVector){

                    public void set(int index, BigInt value) {
                        ArrowSerializer$.MODULE$.org$apache$spark$sql$connect$client$arrow$ArrowSerializer$$setDecimal((DecimalVector)this.vector(), index, new BigDecimal(value.bigInteger()));
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder23 = (AgnosticEncoder)tuple2._1();
            Object v24 = tuple2._2();
            if (AgnosticEncoders.JavaBigIntEncoder$.MODULE$.equals(agnosticEncoder23) && v24 instanceof DecimalVector) {
                DecimalVector decimalVector = (DecimalVector)v24;
                return new ArrowSerializer.FieldSerializer<BigInteger, DecimalVector>(decimalVector){

                    public void set(int index, BigInteger value) {
                        ArrowSerializer$.MODULE$.org$apache$spark$sql$connect$client$arrow$ArrowSerializer$$setDecimal((DecimalVector)this.vector(), index, new BigDecimal(value));
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder24 = (AgnosticEncoder)tuple2._1();
            Object v25 = tuple2._2();
            if (AgnosticEncoders.DayTimeIntervalEncoder$.MODULE$.equals(agnosticEncoder24) && v25 instanceof DurationVector) {
                DurationVector durationVector = (DurationVector)v25;
                return new ArrowSerializer.FieldSerializer<Duration, DurationVector>(durationVector){

                    public void set(int index, Duration value) {
                        ((DurationVector)this.vector()).setSafe(index, SparkIntervalUtils$.MODULE$.durationToMicros(value));
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder25 = (AgnosticEncoder)tuple2._1();
            Object v26 = tuple2._2();
            if (AgnosticEncoders.YearMonthIntervalEncoder$.MODULE$.equals(agnosticEncoder25) && v26 instanceof IntervalYearVector) {
                IntervalYearVector intervalYearVector = (IntervalYearVector)v26;
                return new ArrowSerializer.FieldSerializer<Period, IntervalYearVector>(intervalYearVector){

                    public void set(int index, Period value) {
                        ((IntervalYearVector)this.vector()).setSafe(index, SparkIntervalUtils$.MODULE$.periodToMonths(value));
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoders.LocalDateEncoder localDateEncoder;
            boolean bl;
            AgnosticEncoders.DateEncoder dateEncoder;
            boolean bl2;
            AgnosticEncoder agnosticEncoder26 = (AgnosticEncoder)tuple2._1();
            Object v27 = tuple2._2();
            if ((agnosticEncoder26 instanceof AgnosticEncoders.DateEncoder && true == (bl2 = (dateEncoder = (AgnosticEncoders.DateEncoder)agnosticEncoder26).lenientSerialization()) ? true : agnosticEncoder26 instanceof AgnosticEncoders.LocalDateEncoder && true == (bl = (localDateEncoder = (AgnosticEncoders.LocalDateEncoder)agnosticEncoder26).lenientSerialization())) && v27 instanceof DateDayVector) {
                DateDayVector dateDayVector = (DateDayVector)v27;
                return new ArrowSerializer.FieldSerializer<Object, DateDayVector>(dateDayVector){

                    public void set(int index, Object value) {
                        ((DateDayVector)this.vector()).setSafe(index, SparkDateTimeUtils$.MODULE$.anyToDays(value));
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoders.DateEncoder dateEncoder;
            boolean bl;
            AgnosticEncoder agnosticEncoder27 = (AgnosticEncoder)tuple2._1();
            Object v28 = tuple2._2();
            if (agnosticEncoder27 instanceof AgnosticEncoders.DateEncoder && !(bl = (dateEncoder = (AgnosticEncoders.DateEncoder)agnosticEncoder27).lenientSerialization()) && v28 instanceof DateDayVector) {
                DateDayVector dateDayVector = (DateDayVector)v28;
                return new ArrowSerializer.FieldSerializer<Date, DateDayVector>(dateDayVector){

                    public void set(int index, Date value) {
                        ((DateDayVector)this.vector()).setSafe(index, SparkDateTimeUtils$.MODULE$.fromJavaDate(value));
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoders.LocalDateEncoder localDateEncoder;
            boolean bl;
            AgnosticEncoder agnosticEncoder28 = (AgnosticEncoder)tuple2._1();
            Object v29 = tuple2._2();
            if (agnosticEncoder28 instanceof AgnosticEncoders.LocalDateEncoder && !(bl = (localDateEncoder = (AgnosticEncoders.LocalDateEncoder)agnosticEncoder28).lenientSerialization()) && v29 instanceof DateDayVector) {
                DateDayVector dateDayVector = (DateDayVector)v29;
                return new ArrowSerializer.FieldSerializer<LocalDate, DateDayVector>(dateDayVector){

                    public void set(int index, LocalDate value) {
                        ((DateDayVector)this.vector()).setSafe(index, SparkDateTimeUtils$.MODULE$.localDateToDays(value));
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoders.InstantEncoder instantEncoder;
            boolean bl;
            AgnosticEncoders.TimestampEncoder timestampEncoder;
            boolean bl3;
            AgnosticEncoder agnosticEncoder29 = (AgnosticEncoder)tuple2._1();
            Object v30 = tuple2._2();
            if ((agnosticEncoder29 instanceof AgnosticEncoders.TimestampEncoder && true == (bl3 = (timestampEncoder = (AgnosticEncoders.TimestampEncoder)agnosticEncoder29).lenientSerialization()) ? true : agnosticEncoder29 instanceof AgnosticEncoders.InstantEncoder && true == (bl = (instantEncoder = (AgnosticEncoders.InstantEncoder)agnosticEncoder29).lenientSerialization())) && v30 instanceof TimeStampMicroTZVector) {
                TimeStampMicroTZVector timeStampMicroTZVector = (TimeStampMicroTZVector)v30;
                return new ArrowSerializer.FieldSerializer<Object, TimeStampMicroTZVector>(timeStampMicroTZVector){

                    public void set(int index, Object value) {
                        ((TimeStampVector)this.vector()).setSafe(index, SparkDateTimeUtils$.MODULE$.anyToMicros(value));
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoders.TimestampEncoder timestampEncoder;
            boolean bl;
            AgnosticEncoder agnosticEncoder30 = (AgnosticEncoder)tuple2._1();
            Object v31 = tuple2._2();
            if (agnosticEncoder30 instanceof AgnosticEncoders.TimestampEncoder && !(bl = (timestampEncoder = (AgnosticEncoders.TimestampEncoder)agnosticEncoder30).lenientSerialization()) && v31 instanceof TimeStampMicroTZVector) {
                TimeStampMicroTZVector timeStampMicroTZVector = (TimeStampMicroTZVector)v31;
                return new ArrowSerializer.FieldSerializer<Timestamp, TimeStampMicroTZVector>(timeStampMicroTZVector){

                    public void set(int index, Timestamp value) {
                        ((TimeStampVector)this.vector()).setSafe(index, SparkDateTimeUtils$.MODULE$.fromJavaTimestamp(value));
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoders.InstantEncoder instantEncoder;
            boolean bl;
            AgnosticEncoder agnosticEncoder31 = (AgnosticEncoder)tuple2._1();
            Object v32 = tuple2._2();
            if (agnosticEncoder31 instanceof AgnosticEncoders.InstantEncoder && !(bl = (instantEncoder = (AgnosticEncoders.InstantEncoder)agnosticEncoder31).lenientSerialization()) && v32 instanceof TimeStampMicroTZVector) {
                TimeStampMicroTZVector timeStampMicroTZVector = (TimeStampMicroTZVector)v32;
                return new ArrowSerializer.FieldSerializer<Instant, TimeStampMicroTZVector>(timeStampMicroTZVector){

                    public void set(int index, Instant value) {
                        ((TimeStampVector)this.vector()).setSafe(index, SparkDateTimeUtils$.MODULE$.instantToMicros(value));
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder32 = (AgnosticEncoder)tuple2._1();
            Object v33 = tuple2._2();
            if (AgnosticEncoders.LocalDateTimeEncoder$.MODULE$.equals(agnosticEncoder32) && v33 instanceof TimeStampMicroVector) {
                TimeStampMicroVector timeStampMicroVector = (TimeStampMicroVector)v33;
                return new ArrowSerializer.FieldSerializer<LocalDateTime, TimeStampMicroVector>(timeStampMicroVector){

                    public void set(int index, LocalDateTime value) {
                        ((TimeStampVector)this.vector()).setSafe(index, SparkDateTimeUtils$.MODULE$.localDateTimeToMicros(value));
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder33 = (AgnosticEncoder)tuple2._1();
            Object v34 = tuple2._2();
            if (AgnosticEncoders.LocalTimeEncoder$.MODULE$.equals(agnosticEncoder33) && v34 instanceof TimeNanoVector) {
                TimeNanoVector timeNanoVector = (TimeNanoVector)v34;
                return new ArrowSerializer.FieldSerializer<LocalTime, TimeNanoVector>(timeNanoVector){

                    public void set(int index, LocalTime value) {
                        ((TimeNanoVector)this.vector()).setSafe(index, SparkDateTimeUtils$.MODULE$.localTimeToNanos(value));
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder34 = (AgnosticEncoder)tuple2._1();
            Object v35 = tuple2._2();
            if (agnosticEncoder34 instanceof AgnosticEncoders.OptionEncoder) {
                AgnosticEncoders.OptionEncoder optionEncoder = (AgnosticEncoders.OptionEncoder)agnosticEncoder34;
                AgnosticEncoder value = optionEncoder.elementEncoder();
                return new ArrowSerializer.Serializer(value, v35){
                    private final ArrowSerializer.Serializer delegate;

                    public void write(int index, Object value) {
                        Object object = value;
                        if (object instanceof Some) {
                            Some some = (Some)object;
                            Object value2 = some.value();
                            this.delegate.write(index, value2);
                            return;
                        }
                        this.delegate.write(index, null);
                    }
                    {
                        this.delegate = ArrowSerializer$.MODULE$.serializerFor(value$1, v$1);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder35 = (AgnosticEncoder)tuple2._1();
            Object v36 = tuple2._2();
            if (agnosticEncoder35 instanceof AgnosticEncoders.ArrayEncoder) {
                AgnosticEncoders.ArrayEncoder arrayEncoder = (AgnosticEncoders.ArrayEncoder)agnosticEncoder35;
                AgnosticEncoder element = arrayEncoder.element();
                if (v36 instanceof ListVector) {
                    ListVector listVector = (ListVector)v36;
                    ArrowSerializer.Serializer elementSerializer = this.serializerFor(element, listVector.getDataVector());
                    Function1 & Serializable toIterator = (Function1 & Serializable)array -> ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.genericArrayOps(array));
                    return new ArrowSerializer.ArraySerializer(listVector, (Function1<Object, Iterator<Object>>)toIterator, elementSerializer);
                }
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder36 = (AgnosticEncoder)tuple2._1();
            Object v37 = tuple2._2();
            if (agnosticEncoder36 instanceof AgnosticEncoders.IterableEncoder) {
                AgnosticEncoders.IterableEncoder iterableEncoder = (AgnosticEncoders.IterableEncoder)agnosticEncoder36;
                ClassTag tag = iterableEncoder.clsTag();
                AgnosticEncoder element = iterableEncoder.element();
                boolean lenient = iterableEncoder.lenientSerialization();
                if (v37 instanceof ListVector) {
                    Function1 & Serializable intersect;
                    ListVector listVector = (ListVector)v37;
                    ArrowSerializer.Serializer elementSerializer = this.serializerFor(element, listVector.getDataVector());
                    if (lenient) {
                        intersect = (Function1 & Serializable)x0$1 -> {
                            Object object = x0$1;
                            if (object instanceof Iterable) {
                                Iterable iterable = (Iterable)object;
                                return iterable.iterator();
                            }
                            if (object instanceof java.util.List) {
                                java.util.List list = (java.util.List)object;
                                return CollectionConverters$.MODULE$.IteratorHasAsScala(list.iterator()).asScala();
                            }
                            if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
                                Object object2 = object;
                                return ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.genericArrayOps(object2));
                            }
                            throw ArrowEncoderUtils$.MODULE$.unsupportedCollectionType(object.getClass());
                        };
                    } else if (ArrowEncoderUtils$.MODULE$.isSubClass(ArrowEncoderUtils$Classes$.MODULE$.ITERABLE(), tag)) {
                        intersect = (Function1 & Serializable)v -> ((Iterable)v).iterator();
                    } else if (ArrowEncoderUtils$.MODULE$.isSubClass(ArrowEncoderUtils$Classes$.MODULE$.JLIST(), tag)) {
                        intersect = (Function1 & Serializable)v -> CollectionConverters$.MODULE$.IteratorHasAsScala(((java.util.List)v).iterator()).asScala();
                    } else {
                        throw ArrowEncoderUtils$.MODULE$.unsupportedCollectionType(tag.runtimeClass());
                    }
                    Function1 & Serializable toIterator = intersect;
                    return new ArrowSerializer.ArraySerializer(listVector, (Function1<Object, Iterator<Object>>)toIterator, elementSerializer);
                }
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder37 = (AgnosticEncoder)tuple2._1();
            Object v38 = tuple2._2();
            if (agnosticEncoder37 instanceof AgnosticEncoders.MapEncoder) {
                AgnosticEncoders.MapEncoder mapEncoder = (AgnosticEncoders.MapEncoder)agnosticEncoder37;
                ClassTag tag = mapEncoder.clsTag();
                AgnosticEncoder key = mapEncoder.keyEncoder();
                AgnosticEncoder value = mapEncoder.valueEncoder();
                if (v38 instanceof MapVector) {
                    Function1 & Serializable intersect;
                    MapVector mapVector = (MapVector)v38;
                    StructVector structVector = (StructVector)mapVector.getDataVector();
                    if (ArrowEncoderUtils$.MODULE$.isSubClass(Map.class, tag)) {
                        intersect = (Function1 & Serializable)v -> ((Map)v).iterator();
                    } else if (ArrowEncoderUtils$.MODULE$.isSubClass(java.util.Map.class, tag)) {
                        intersect = (Function1 & Serializable)v -> CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)v).asScala().iterator();
                    } else {
                        throw ArrowEncoderUtils$.MODULE$.unsupportedCollectionType(tag.runtimeClass());
                    }
                    Function1 & Serializable extractor = intersect;
                    ArrowSerializer.StructFieldSerializer structFieldSerializer = new ArrowSerializer.StructFieldSerializer((Function1<Object, Object>)(Function1 & Serializable)v -> MODULE$.extractKey(v), this.serializerFor(key, structVector.getChild("key")));
                    ArrowSerializer.StructFieldSerializer structFieldSerializer2 = new ArrowSerializer.StructFieldSerializer((Function1<Object, Object>)(Function1 & Serializable)v -> MODULE$.extractValue(v), this.serializerFor(value, structVector.getChild("value")));
                    ArrowSerializer.StructSerializer structSerializer = new ArrowSerializer.StructSerializer(structVector, (Seq<ArrowSerializer.StructFieldSerializer>)Nil$.MODULE$.$colon$colon((Object)structFieldSerializer2).$colon$colon((Object)structFieldSerializer));
                    return new ArrowSerializer.ArraySerializer((ListVector)mapVector, (Function1<Object, Iterator<Object>>)extractor, structSerializer);
                }
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder38 = (AgnosticEncoder)tuple2._1();
            Object object = tuple2._2();
            if (agnosticEncoder38 instanceof AgnosticEncoders.ProductEncoder) {
                Option<Tuple2<StructVector, Seq<FieldVector>>> option;
                AgnosticEncoders.ProductEncoder productEncoder = (AgnosticEncoders.ProductEncoder)agnosticEncoder38;
                ClassTag tag = productEncoder.clsTag();
                Seq fields = productEncoder.fields();
                if (object != null && !(option = StructVectors$.MODULE$.unapply(object)).isEmpty()) {
                    StructVector struct = (StructVector)((Tuple2)option.get())._1();
                    Seq vectors = (Seq)((Tuple2)option.get())._2();
                    if (ArrowEncoderUtils$.MODULE$.isSubClass(Product.class, tag)) {
                        return this.structSerializerFor((Seq<AgnosticEncoders.EncoderField>)fields, struct, (Seq<FieldVector>)vectors, (Function2<AgnosticEncoders.EncoderField, Object, Function1<Object, Object>>)(Function2 & Serializable)(x$4, i) -> ArrowSerializer$.$anonfun$serializerFor$9(x$4, BoxesRunTime.unboxToInt((Object)i)));
                    }
                    if (ArrowEncoderUtils$.MODULE$.isSubClass(DefinedByConstructorParams.class, tag)) {
                        return this.structSerializerFor((Seq<AgnosticEncoders.EncoderField>)fields, struct, (Seq<FieldVector>)vectors, (Function2<AgnosticEncoders.EncoderField, Object, Function1<Object, Object>>)(Function2 & Serializable)(field, x$5) -> ArrowSerializer$.$anonfun$serializerFor$11(tag, field, BoxesRunTime.unboxToInt((Object)x$5)));
                    }
                    throw ArrowEncoderUtils$.MODULE$.unsupportedCollectionType(tag.runtimeClass());
                }
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder39 = (AgnosticEncoder)tuple2._1();
            Object object = tuple2._2();
            if (agnosticEncoder39 instanceof AgnosticEncoders.RowEncoder) {
                Option<Tuple2<StructVector, Seq<FieldVector>>> option;
                AgnosticEncoders.RowEncoder rowEncoder = (AgnosticEncoders.RowEncoder)agnosticEncoder39;
                Seq fields = rowEncoder.fields();
                if (object != null && !(option = StructVectors$.MODULE$.unapply(object)).isEmpty()) {
                    StructVector struct = (StructVector)((Tuple2)option.get())._1();
                    Seq vectors = (Seq)((Tuple2)option.get())._2();
                    return this.structSerializerFor((Seq<AgnosticEncoders.EncoderField>)fields, struct, (Seq<FieldVector>)vectors, (Function2<AgnosticEncoders.EncoderField, Object, Function1<Object, Object>>)(Function2 & Serializable)(x$6, i) -> ArrowSerializer$.$anonfun$serializerFor$13(x$6, BoxesRunTime.unboxToInt((Object)i)));
                }
            }
        }
        if (tuple2 != null) {
            Option<Tuple2<StructVector, Seq<FieldVector>>> option;
            AgnosticEncoder agnosticEncoder40 = (AgnosticEncoder)tuple2._1();
            Object object = tuple2._2();
            if (AgnosticEncoders.VariantEncoder$.MODULE$.equals(agnosticEncoder40) && object != null && !(option = StructVectors$.MODULE$.unapply(object)).isEmpty()) {
                StructVector struct = (StructVector)((Tuple2)option.get())._1();
                Seq vectors = (Seq)((Tuple2)option.get())._2();
                Predef$.MODULE$.assert(vectors.exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ArrowSerializer$.$anonfun$serializerFor$15(x$7))));
                Predef$.MODULE$.assert(vectors.exists((Function1 & Serializable)field -> BoxesRunTime.boxToBoolean((boolean)ArrowSerializer$.$anonfun$serializerFor$16(field))));
                return new ArrowSerializer.StructSerializer(struct, (Seq<ArrowSerializer.StructFieldSerializer>)new .colon.colon((Object)new ArrowSerializer.StructFieldSerializer((Function1<Object, Object>)(Function1 & Serializable)v -> ((VariantVal)v).getValue(), this.serializerFor((AgnosticEncoder<E>)AgnosticEncoders.BinaryEncoder$.MODULE$, struct.getChild("value"))), (List)new .colon.colon((Object)new ArrowSerializer.StructFieldSerializer((Function1<Object, Object>)(Function1 & Serializable)v -> ((VariantVal)v).getMetadata(), this.serializerFor((AgnosticEncoder<E>)AgnosticEncoders.BinaryEncoder$.MODULE$, struct.getChild("metadata"))), (List)Nil$.MODULE$)));
            }
        }
        if (tuple2 != null) {
            Option<Tuple2<StructVector, Seq<FieldVector>>> option;
            Object object = tuple2._2();
            if (tuple2._1() instanceof AgnosticEncoders.GeographyEncoder && object != null && !(option = StructVectors$.MODULE$.unapply(object)).isEmpty()) {
                StructVector struct = (StructVector)((Tuple2)option.get())._1();
                Seq vectors = (Seq)((Tuple2)option.get())._2();
                GeographyArrowSerDe gser = new GeographyArrowSerDe();
                return gser.createSerializer(struct, (Seq<FieldVector>)vectors);
            }
        }
        if (tuple2 != null) {
            Option<Tuple2<StructVector, Seq<FieldVector>>> option;
            Object object = tuple2._2();
            if (tuple2._1() instanceof AgnosticEncoders.GeometryEncoder && object != null && !(option = StructVectors$.MODULE$.unapply(object)).isEmpty()) {
                StructVector struct = (StructVector)((Tuple2)option.get())._1();
                Seq vectors = (Seq)((Tuple2)option.get())._2();
                GeometryArrowSerDe gser = new GeometryArrowSerDe();
                return gser.createSerializer(struct, (Seq<FieldVector>)vectors);
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder41 = (AgnosticEncoder)tuple2._1();
            Object object = tuple2._2();
            if (agnosticEncoder41 instanceof AgnosticEncoders.JavaBeanEncoder) {
                Option<Tuple2<StructVector, Seq<FieldVector>>> option;
                AgnosticEncoders.JavaBeanEncoder javaBeanEncoder = (AgnosticEncoders.JavaBeanEncoder)agnosticEncoder41;
                ClassTag tag = javaBeanEncoder.clsTag();
                Seq fields = javaBeanEncoder.fields();
                if (object != null && !(option = StructVectors$.MODULE$.unapply(object)).isEmpty()) {
                    StructVector struct = (StructVector)((Tuple2)option.get())._1();
                    Seq vectors = (Seq)((Tuple2)option.get())._2();
                    return this.structSerializerFor((Seq<AgnosticEncoders.EncoderField>)fields, struct, (Seq<FieldVector>)vectors, (Function2<AgnosticEncoders.EncoderField, Object, Function1<Object, Object>>)(Function2 & Serializable)(field, x$8) -> ArrowSerializer$.$anonfun$serializerFor$19(tag, field, BoxesRunTime.unboxToInt((Object)x$8)));
                }
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder42 = (AgnosticEncoder)tuple2._1();
            Object v39 = tuple2._2();
            if (agnosticEncoder42 instanceof AgnosticEncoders.TransformingEncoder) {
                AgnosticEncoders.TransformingEncoder transformingEncoder = (AgnosticEncoders.TransformingEncoder)agnosticEncoder42;
                AgnosticEncoder encoder2 = transformingEncoder.transformed();
                Function0 provider = transformingEncoder.codecProvider();
                return new ArrowSerializer.Serializer(provider, encoder2, v39){
                    private final Codec<Object, Object> codec;
                    private final ArrowSerializer.Serializer delegate;

                    public void write(int index, Object value) {
                        this.delegate.write(index, this.codec.encode(value));
                    }
                    {
                        this.codec = (Codec)provider$1.apply();
                        this.delegate = ArrowSerializer$.MODULE$.serializerFor(encoder$1, v$2);
                    }
                };
            }
        }
        if (tuple2 != null && (AgnosticEncoders.CalendarIntervalEncoder$.MODULE$.equals(agnosticEncoder = (AgnosticEncoder)tuple2._1()) ? true : agnosticEncoder instanceof AgnosticEncoders.UDTEncoder)) {
            throw ExecutionErrors$.MODULE$.unsupportedDataTypeError(encoder.dataType());
        }
        throw new RuntimeException("Unsupported Encoder(" + encoder + ")/Vector(" + v2 + ") combination.");
    }

    private MethodHandles.Lookup methodLookup() {
        return methodLookup;
    }

    public void org$apache$spark$sql$connect$client$arrow$ArrowSerializer$$setString(VariableWidthFieldVector vector, int index, String string) {
        ByteBuffer bytes = Text.encode((String)string);
        vector.setSafe(index, bytes, 0, bytes.limit());
    }

    public void org$apache$spark$sql$connect$client$arrow$ArrowSerializer$$setDecimal(DecimalVector vector, int index, BigDecimal decimal) {
        BigDecimal scaledDecimal = vector.getScale() != decimal.scale() ? decimal.setScale(vector.getScale()) : decimal;
        vector.setSafe(index, scaledDecimal);
    }

    private Object extractKey(Object v) {
        Object key = ((Tuple2)v)._1();
        Objects.requireNonNull(key);
        return key;
    }

    private Object extractValue(Object v) {
        return ((Tuple2)v)._2();
    }

    private ArrowSerializer.StructSerializer structSerializerFor(Seq<AgnosticEncoders.EncoderField> fields, StructVector struct, Seq<FieldVector> vectors, Function2<AgnosticEncoders.EncoderField, Object, Function1<Object, Object>> createGetter) {
        Predef$.MODULE$.require(fields.size() == vectors.size());
        Seq serializers = (Seq)((IterableOps)((IterableOps)fields.zip(vectors)).zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                int i = tuple2._2$mcI$sp();
                if (tuple22 != null) {
                    AgnosticEncoders.EncoderField field = (AgnosticEncoders.EncoderField)tuple22._1();
                    FieldVector vector = (FieldVector)tuple22._2();
                    ArrowSerializer.Serializer serializer = MODULE$.serializerFor(field.enc(), vector);
                    return new ArrowSerializer.StructFieldSerializer((Function1<Object, Object>)((Function1)createGetter.apply((Object)field, (Object)BoxesRunTime.boxToInteger((int)i))), serializer);
                }
            }
            throw new MatchError((Object)tuple2);
        });
        return new ArrowSerializer.StructSerializer(struct, (Seq<ArrowSerializer.StructFieldSerializer>)serializers);
    }

    public static final /* synthetic */ Function1 $anonfun$serializerFor$9(AgnosticEncoders.EncoderField x$4, int i) {
        return (Function1 & Serializable)p -> ((Product)p).productElement(i);
    }

    public static final /* synthetic */ Function1 $anonfun$serializerFor$11(ClassTag tag$1, AgnosticEncoders.EncoderField field, int x$5) {
        MethodHandle getter = MODULE$.methodLookup().findVirtual(tag$1.runtimeClass(), field.name(), MethodType.methodType(field.enc().clsTag().runtimeClass()));
        return (Function1 & Serializable)o -> getter.invoke(o);
    }

    public static final /* synthetic */ Function1 $anonfun$serializerFor$13(AgnosticEncoders.EncoderField x$6, int i) {
        return (Function1 & Serializable)r -> ((Row)r).get(i);
    }

    public static final /* synthetic */ boolean $anonfun$serializerFor$15(FieldVector x$7) {
        String string = x$7.getName();
        String string2 = "value";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$serializerFor$16(FieldVector field) {
        String string = field.getName();
        String string2 = "metadata";
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (!field.getField().getMetadata().containsKey("variant")) return false;
        Object v = field.getField().getMetadata().get("variant");
        String string3 = "true";
        if (v == null) {
            if (string3 == null) return true;
            return false;
        } else {
            if (!v.equals(string3)) return false;
            return true;
        }
    }

    public static final /* synthetic */ Function1 $anonfun$serializerFor$19(ClassTag tag$2, AgnosticEncoders.EncoderField field, int x$8) {
        MethodHandle getter = MODULE$.methodLookup().findVirtual(tag$2.runtimeClass(), (String)field.readMethod().get(), MethodType.methodType(field.enc().clsTag().runtimeClass()));
        return (Function1 & Serializable)o -> getter.invoke(o);
    }

    private ArrowSerializer$() {
    }
}

