/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.io.PrintStream;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToUnixTimeStamp;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.io.LongWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UDFType(deterministic=true)
@Description(name="unix_timestamp", value="_FUNC_(date[, pattern]) - Converts the time to a number", extended="Converts the specified time to number of seconds since 1970-01-01. The _FUNC_(void) overload is deprecated, use current_timestamp.")
public class GenericUDFUnixTimeStamp
extends GenericUDFToUnixTimeStamp {
    private static final Logger LOG = LoggerFactory.getLogger(GenericUDFUnixTimeStamp.class);
    private LongWritable currentTimestamp;

    @Override
    protected void initializeInput(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length > 0) {
            super.initializeInput(arguments);
        } else if (this.currentTimestamp == null) {
            this.currentTimestamp = new LongWritable(0L);
            GenericUDFUnixTimeStamp.setValueFromTs(this.currentTimestamp, SessionState.get().getQueryCurrentTimestamp());
            String msg = "unix_timestamp(void) is deprecated. Use current_timestamp instead.";
            LOG.warn(msg);
            PrintStream stream = SessionState.LogHelper.getInfoStream();
            if (stream != null) {
                stream.println(msg);
            }
        }
    }

    @Override
    protected String getName() {
        return "unix_timestamp";
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        return arguments.length == 0 ? this.currentTimestamp : super.evaluate(arguments);
    }
}

