/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import java.io.Serializable;
import org.apache.spark.util.Clock;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005a2Qa\u0002\u0005\u0001\u0015AAQ\u0001\u000b\u0001\u0005\u0002%Bqa\u000b\u0001C\u0002\u0013\u0005A\u0006\u0003\u00041\u0001\u0001\u0006I!\f\u0005\u0006c\u0001!\tE\r\u0005\u0006g\u0001!\tE\r\u0005\u0006i\u0001!\t%\u000e\u0002\f'f\u001cH/Z7DY>\u001c7N\u0003\u0002\n\u0015\u0005!Q\u000f^5m\u0015\tYA\"A\u0003ta\u0006\u00148N\u0003\u0002\u000e\u001d\u00051\u0011\r]1dQ\u0016T\u0011aD\u0001\u0004_J<7\u0003\u0002\u0001\u0012/m\u0001\"AE\u000b\u000e\u0003MQ\u0011\u0001F\u0001\u0006g\u000e\fG.Y\u0005\u0003-M\u0011a!\u00118z%\u00164\u0007C\u0001\r\u001a\u001b\u0005A\u0011B\u0001\u000e\t\u0005\u0015\u0019En\\2l!\taRE\u0004\u0002\u001eG9\u0011aDI\u0007\u0002?)\u0011\u0001%I\u0001\u0007yI|w\u000e\u001e \u0004\u0001%\tA#\u0003\u0002%'\u00059\u0001/Y2lC\u001e,\u0017B\u0001\u0014(\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t!3#\u0001\u0004=S:LGO\u0010\u000b\u0002UA\u0011\u0001\u0004A\u0001\f[&t\u0007k\u001c7m)&lW-F\u0001.!\t\u0011b&\u0003\u00020'\t!Aj\u001c8h\u00031i\u0017N\u001c)pY2$\u0016.\\3!\u000359W\r\u001e+j[\u0016l\u0015\u000e\u001c7jgR\tQ&\u0001\u0005oC:|G+[7f\u000319\u0018-\u001b;US2dG+[7f)\tic\u0007C\u00038\r\u0001\u0007Q&\u0001\u0006uCJ<W\r\u001e+j[\u0016\u0004")
public class SystemClock
implements Clock,
Serializable {
    private final long minPollTime;

    public long minPollTime() {
        return this.minPollTime;
    }

    @Override
    public long getTimeMillis() {
        return System.currentTimeMillis();
    }

    @Override
    public long nanoTime() {
        return System.nanoTime();
    }

    @Override
    public long waitTillTime(long targetTime) {
        long currentTime = System.currentTimeMillis();
        long waitTime = targetTime - currentTime;
        if (waitTime <= 0L) {
            return currentTime;
        }
        long pollTime = (long)package$.MODULE$.max((double)waitTime / 10.0, (double)this.minPollTime());
        while ((waitTime = targetTime - (currentTime = System.currentTimeMillis())) > 0L) {
            long sleepTime = package$.MODULE$.min(waitTime, pollTime);
            Thread.sleep(sleepTime);
        }
        return currentTime;
    }

    public SystemClock() {
        this.minPollTime = 25L;
    }
}

