/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.client.builder;

import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;

abstract class ConstraintBuilder<T> {
    protected String dbName;
    protected String tableName;
    protected String columnName;
    protected String constraintName;
    protected int keySeq = 1;
    protected boolean enable = true;
    protected boolean validate = false;
    protected boolean rely = false;
    private T child;

    protected ConstraintBuilder() {
    }

    protected void setChild(T child) {
        this.child = child;
    }

    protected void checkBuildable(String defaultConstraintName) throws MetaException {
        if (this.dbName == null || this.tableName == null || this.columnName == null) {
            throw new MetaException("You must provide database name, table name, and column name");
        }
        if (this.constraintName == null) {
            this.constraintName = this.dbName + "_" + this.tableName + "_" + this.columnName + "_" + defaultConstraintName;
        }
    }

    public T setDbName(String dbName) {
        this.dbName = dbName;
        return this.child;
    }

    public T setTableName(String tableName) {
        this.tableName = tableName;
        return this.child;
    }

    public T setDbAndTableName(Table table) {
        this.dbName = table.getDbName();
        this.tableName = table.getTableName();
        return this.child;
    }

    public T setColumnName(String columnName) {
        this.columnName = columnName;
        return this.child;
    }

    public T setConstraintName(String constraintName) {
        this.constraintName = constraintName;
        return this.child;
    }

    public T setKeySeq(int keySeq) {
        this.keySeq = keySeq;
        return this.child;
    }

    public T setEnable(boolean enable) {
        this.enable = enable;
        return this.child;
    }

    public T setValidate(boolean validate) {
        this.validate = validate;
        return this.child;
    }

    public T setRely(boolean rely) {
        this.rely = rely;
        return this.child;
    }
}

