/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.messaging.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.messaging.AddPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.AlterIndexMessage;
import org.apache.hadoop.hive.metastore.messaging.AlterPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.AlterTableMessage;
import org.apache.hadoop.hive.metastore.messaging.CreateDatabaseMessage;
import org.apache.hadoop.hive.metastore.messaging.CreateFunctionMessage;
import org.apache.hadoop.hive.metastore.messaging.CreateIndexMessage;
import org.apache.hadoop.hive.metastore.messaging.CreateTableMessage;
import org.apache.hadoop.hive.metastore.messaging.DropDatabaseMessage;
import org.apache.hadoop.hive.metastore.messaging.DropFunctionMessage;
import org.apache.hadoop.hive.metastore.messaging.DropIndexMessage;
import org.apache.hadoop.hive.metastore.messaging.DropPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.DropTableMessage;
import org.apache.hadoop.hive.metastore.messaging.InsertMessage;
import org.apache.hadoop.hive.metastore.messaging.MessageDeserializer;
import org.apache.hadoop.hive.metastore.messaging.MessageFactory;
import org.apache.hadoop.hive.metastore.messaging.PartitionFiles;
import org.apache.hadoop.hive.metastore.messaging.json.JSONAddPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONAlterIndexMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONAlterPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONAlterTableMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONCreateDatabaseMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONCreateFunctionMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONCreateIndexMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONCreateTableMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONDropDatabaseMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONDropFunctionMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONDropIndexMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONDropPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONDropTableMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONInsertMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageDeserializer;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TJSONProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONMessageFactory
extends MessageFactory {
    private static final Logger LOG = LoggerFactory.getLogger((String)JSONMessageFactory.class.getName());
    private static JSONMessageDeserializer deserializer = new JSONMessageDeserializer();
    private static TDeserializer thriftDeSerializer;

    @Override
    public MessageDeserializer getDeserializer() {
        return deserializer;
    }

    @Override
    public String getMessageFormat() {
        return "json-0.2";
    }

    @Override
    public CreateDatabaseMessage buildCreateDatabaseMessage(Database db) {
        return new JSONCreateDatabaseMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, db.getName(), this.now());
    }

    @Override
    public DropDatabaseMessage buildDropDatabaseMessage(Database db) {
        return new JSONDropDatabaseMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, db.getName(), this.now());
    }

    @Override
    public CreateTableMessage buildCreateTableMessage(Table table, Iterator<String> fileIter) {
        return new JSONCreateTableMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, table, fileIter, (Long)this.now());
    }

    @Override
    public AlterTableMessage buildAlterTableMessage(Table before, Table after) {
        return new JSONAlterTableMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, before, after, this.now());
    }

    @Override
    public DropTableMessage buildDropTableMessage(Table table) {
        return new JSONDropTableMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, table.getDbName(), table.getTableName(), this.now());
    }

    @Override
    public AddPartitionMessage buildAddPartitionMessage(Table table, Iterator<Partition> partitionsIterator, Iterator<PartitionFiles> partitionFileIter) {
        return new JSONAddPartitionMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, table, partitionsIterator, partitionFileIter, this.now());
    }

    @Override
    public AlterPartitionMessage buildAlterPartitionMessage(Table table, Partition before, Partition after) {
        return new JSONAlterPartitionMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, table, before, after, this.now());
    }

    @Override
    public DropPartitionMessage buildDropPartitionMessage(Table table, Iterator<Partition> partitionsIterator) {
        return new JSONDropPartitionMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, table, JSONMessageFactory.getPartitionKeyValues(table, partitionsIterator), this.now());
    }

    @Override
    public CreateFunctionMessage buildCreateFunctionMessage(org.apache.hadoop.hive.metastore.api.Function fn) {
        return new JSONCreateFunctionMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, fn, this.now());
    }

    @Override
    public DropFunctionMessage buildDropFunctionMessage(org.apache.hadoop.hive.metastore.api.Function fn) {
        return new JSONDropFunctionMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, fn, this.now());
    }

    @Override
    public CreateIndexMessage buildCreateIndexMessage(Index idx) {
        return new JSONCreateIndexMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, idx, this.now());
    }

    @Override
    public DropIndexMessage buildDropIndexMessage(Index idx) {
        return new JSONDropIndexMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, idx, this.now());
    }

    @Override
    public AlterIndexMessage buildAlterIndexMessage(Index before, Index after) {
        return new JSONAlterIndexMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, before, after, this.now());
    }

    @Override
    public InsertMessage buildInsertMessage(String db, String table, Map<String, String> partKeyVals, Iterator<String> fileIter) {
        return new JSONInsertMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, db, table, partKeyVals, fileIter, this.now());
    }

    private long now() {
        return System.currentTimeMillis() / 1000L;
    }

    static Map<String, String> getPartitionKeyValues(Table table, Partition partition) {
        LinkedHashMap<String, String> partitionKeys = new LinkedHashMap<String, String>();
        for (int i = 0; i < table.getPartitionKeysSize(); ++i) {
            partitionKeys.put(table.getPartitionKeys().get(i).getName(), partition.getValues().get(i));
        }
        return partitionKeys;
    }

    static List<Map<String, String>> getPartitionKeyValues(final Table table, Iterator<Partition> iterator) {
        return Lists.newArrayList((Iterator)Iterators.transform(iterator, (Function)new Function<Partition, Map<String, String>>(){

            public Map<String, String> apply(@Nullable Partition partition) {
                return JSONMessageFactory.getPartitionKeyValues(table, partition);
            }
        }));
    }

    static String createTableObjJson(Table tableObj) throws TException {
        TSerializer serializer = new TSerializer((TProtocolFactory)new TJSONProtocol.Factory());
        return serializer.toString((TBase)tableObj);
    }

    static String createPartitionObjJson(Partition partitionObj) throws TException {
        TSerializer serializer = new TSerializer((TProtocolFactory)new TJSONProtocol.Factory());
        return serializer.toString((TBase)partitionObj);
    }

    static String createFunctionObjJson(org.apache.hadoop.hive.metastore.api.Function functionObj) throws TException {
        TSerializer serializer = new TSerializer((TProtocolFactory)new TJSONProtocol.Factory());
        return serializer.toString((TBase)functionObj);
    }

    static String createIndexObjJson(Index indexObj) throws TException {
        TSerializer serializer = new TSerializer((TProtocolFactory)new TJSONProtocol.Factory());
        return serializer.toString((TBase)indexObj);
    }

    public static ObjectNode getJsonTree(NotificationEvent event) throws Exception {
        return JSONMessageFactory.getJsonTree(event.getMessage());
    }

    public static ObjectNode getJsonTree(String eventMessage) throws Exception {
        JsonParser jsonParser = new JsonFactory().createJsonParser(eventMessage);
        ObjectMapper mapper = new ObjectMapper();
        return (ObjectNode)mapper.readValue(jsonParser, ObjectNode.class);
    }

    public static Table getTableObj(ObjectNode jsonTree) throws Exception {
        TDeserializer deSerializer = new TDeserializer((TProtocolFactory)new TJSONProtocol.Factory());
        Table tableObj = new Table();
        String tableJson = jsonTree.get("tableObjJson").asText();
        deSerializer.deserialize((TBase)tableObj, tableJson, "UTF-8");
        return tableObj;
    }

    public static TBase getTObj(String tSerialized, Class<? extends TBase> objClass) throws Exception {
        TBase obj = objClass.newInstance();
        thriftDeSerializer.deserialize(obj, tSerialized, "UTF-8");
        return obj;
    }

    public static Iterable<? extends TBase> getTObjs(Iterable<String> objRefStrs, final Class<? extends TBase> objClass) throws Exception {
        try {
            return Iterables.transform(objRefStrs, (Function)new Function<String, TBase>(){

                public TBase apply(@Nullable String objStr) {
                    try {
                        return JSONMessageFactory.getTObj(objStr, objClass);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (RuntimeException re) {
            Throwable t = re.getCause();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw re;
        }
    }

    public static Iterable<? extends TBase> getTObjs(ObjectNode jsonTree, String objRefListName, Class<? extends TBase> objClass) throws Exception {
        JsonNode jsonArrayIterator = jsonTree.get(objRefListName);
        Function<JsonNode, String> textExtractor = new Function<JsonNode, String>(){

            @Nullable
            public String apply(@Nullable JsonNode input) {
                return input.asText();
            }
        };
        return JSONMessageFactory.getTObjs(Iterables.transform((Iterable)jsonArrayIterator, (Function)textExtractor), objClass);
    }

    static {
        try {
            thriftDeSerializer = new TDeserializer((TProtocolFactory)new TJSONProtocol.Factory());
        }
        catch (TTransportException e) {
            e.printStackTrace();
        }
    }
}

