/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import org.apache.parquet.io.ColumnIOFactory;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.expressions.variant.ArrayExtraction;
import org.apache.spark.sql.catalyst.expressions.variant.ObjectExtraction;
import org.apache.spark.sql.catalyst.expressions.variant.VariantCastArgs;
import org.apache.spark.sql.catalyst.expressions.variant.VariantGet$;
import org.apache.spark.sql.catalyst.expressions.variant.VariantPathSegment;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.RowToColumnConverter;
import org.apache.spark.sql.execution.datasources.VariantMetadata;
import org.apache.spark.sql.execution.datasources.VariantMetadata$;
import org.apache.spark.sql.execution.datasources.parquet.FieldToExtract;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetVariantReader;
import org.apache.spark.sql.execution.datasources.parquet.ParquetVariantReader$;
import org.apache.spark.sql.execution.datasources.parquet.SchemaPathSegment;
import org.apache.spark.sql.execution.datasources.parquet.SparkShreddedRow;
import org.apache.spark.sql.execution.datasources.parquet.SparkShreddingUtils;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DatetimeType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.VariantType;
import org.apache.spark.sql.types.VariantType$;
import org.apache.spark.types.variant.ShreddingUtils;
import org.apache.spark.types.variant.Variant;
import org.apache.spark.types.variant.VariantSchema;
import org.apache.spark.types.variant.VariantShreddingWriter;
import org.apache.spark.types.variant.VariantUtil;
import org.apache.spark.unsafe.types.VariantVal;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

public final class SparkShreddingUtils$
implements Product,
Serializable {
    public static final SparkShreddingUtils$ MODULE$ = new SparkShreddingUtils$();
    private static final String VariantValueFieldName;
    private static final String TypedValueFieldName;
    private static final String MetadataFieldName;
    private static final String VARIANT_WRITE_SHREDDING_KEY;

    static {
        Product.$init$((Product)MODULE$);
        VariantValueFieldName = "value";
        TypedValueFieldName = "typed_value";
        MetadataFieldName = "metadata";
        VARIANT_WRITE_SHREDDING_KEY = "__VARIANT_WRITE_SHREDDING_KEY";
    }

    public String productElementName(int n) {
        return Product.productElementName$((Product)this, (int)n);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public String VariantValueFieldName() {
        return VariantValueFieldName;
    }

    public String TypedValueFieldName() {
        return TypedValueFieldName;
    }

    public String MetadataFieldName() {
        return MetadataFieldName;
    }

    public String VARIANT_WRITE_SHREDDING_KEY() {
        return VARIANT_WRITE_SHREDDING_KEY;
    }

    public VariantSchema buildVariantSchema(DataType schema) {
        DataType dataType = schema;
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            return this.buildVariantSchema(structType, true);
        }
        throw QueryCompilationErrors$.MODULE$.invalidVariantShreddingSchema(schema);
    }

    public StructType variantShreddingSchema(DataType dataType, boolean isTopLevel, boolean isObjectField) {
        .colon.colon colon2;
        DataType dataType2 = dataType;
        if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elementType = arrayType.elementType();
            ArrayType arrayShreddingSchema = new ArrayType((DataType)this.variantShreddingSchema(elementType, false, false), false);
            colon2 = new .colon.colon((Object)new StructField(this.VariantValueFieldName(), (DataType)BinaryType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField(this.TypedValueFieldName(), (DataType)arrayShreddingSchema, true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
        } else if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            StructField[] fields = structType.fields();
            StructType objectShreddingSchema = new StructType((StructField[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Function1 & Serializable)f -> {
                StructType x$1 = MODULE$.variantShreddingSchema(f.dataType(), false, true);
                boolean x$2 = false;
                String x$3 = f.copy$default$1();
                Metadata x$4 = f.copy$default$4();
                return f.copy(x$3, (DataType)x$1, false, x$4);
            }, ClassTag$.MODULE$.apply(StructField.class)));
            colon2 = new .colon.colon((Object)new StructField(this.VariantValueFieldName(), (DataType)BinaryType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField(this.TypedValueFieldName(), (DataType)objectShreddingSchema, true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
        } else if (VariantType$.MODULE$.equals(dataType2)) {
            colon2 = new .colon.colon((Object)new StructField(this.VariantValueFieldName(), (DataType)BinaryType$.MODULE$, isObjectField, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$);
        } else if (dataType2 instanceof NumericType ? true : (BooleanType$.MODULE$.equals(dataType2) ? true : (dataType2 instanceof StringType ? true : (BinaryType$.MODULE$.equals(dataType2) ? true : dataType2 instanceof DatetimeType)))) {
            colon2 = new .colon.colon((Object)new StructField(this.VariantValueFieldName(), (DataType)BinaryType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField(this.TypedValueFieldName(), dataType, true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$));
        } else {
            throw QueryCompilationErrors$.MODULE$.invalidVariantShreddingSchema(dataType);
        }
        .colon.colon fields = colon2;
        if (isTopLevel) {
            StructField structField = new StructField(this.MetadataFieldName(), (DataType)BinaryType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
            return StructType$.MODULE$.apply((Seq)fields.$plus$colon((Object)structField));
        }
        return StructType$.MODULE$.apply((Seq)fields);
    }

    public boolean variantShreddingSchema$default$2() {
        return true;
    }

    public boolean variantShreddingSchema$default$3() {
        return false;
    }

    public StructType addWriteShreddingMetadata(StructType schema) {
        StructField[] newFields = (StructField[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()), (Function1 & Serializable)f -> {
            Metadata x$1 = new MetadataBuilder().withMetadata(f.metadata()).putNull(MODULE$.VARIANT_WRITE_SHREDDING_KEY()).build();
            String x$2 = f.copy$default$1();
            DataType x$3 = f.copy$default$2();
            boolean x$4 = f.copy$default$3();
            return f.copy(x$2, x$3, x$4, x$1);
        }, ClassTag$.MODULE$.apply(StructField.class));
        return new StructType(newFields);
    }

    public boolean isVariantShreddingStruct(StructType s) {
        return s.fields().length > 0 && ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.refArrayOps((Object[])s.fields()), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SparkShreddingUtils$.$anonfun$isVariantShreddingStruct$1(x$2)));
    }

    private VariantSchema buildVariantSchema(StructType schema, boolean topLevel) {
        IntRef typedIdx = IntRef.create((int)-1);
        IntRef variantIdx = IntRef.create((int)-1);
        IntRef topLevelMetadataIdx = IntRef.create((int)-1);
        ObjectRef scalarSchema = ObjectRef.create(null);
        ObjectRef objectSchema = ObjectRef.create(null);
        ObjectRef arraySchema = ObjectRef.create(null);
        if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()))) {
            throw QueryCompilationErrors$.MODULE$.invalidVariantShreddingSchema((DataType)schema);
        }
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()))), (Function1 & Serializable)x0$1 -> {
            SparkShreddingUtils$.$anonfun$buildVariantSchema$1(typedIdx, schema, objectSchema, arraySchema, scalarSchema, variantIdx, topLevelMetadataIdx, x0$1);
            return BoxedUnit.UNIT;
        });
        if (topLevel != topLevelMetadataIdx.elem >= 0) {
            throw QueryCompilationErrors$.MODULE$.invalidVariantShreddingSchema((DataType)schema);
        }
        return new VariantSchema(typedIdx.elem, variantIdx.elem, topLevelMetadataIdx.elem, schema.fields().length, (VariantSchema.ScalarType)scalarSchema.elem, (VariantSchema.ObjectField[])objectSchema.elem, (VariantSchema)arraySchema.elem);
    }

    public DataType scalarSchemaToSparkType(VariantSchema.ScalarType scalar) {
        VariantSchema.ScalarType scalarType = scalar;
        if (scalarType instanceof VariantSchema.StringType) {
            return StringType$.MODULE$;
        }
        if (scalarType instanceof VariantSchema.IntegralType) {
            VariantSchema.IntegralType integralType = (VariantSchema.IntegralType)scalarType;
            VariantSchema.IntegralSize integralSize = integralType.size;
            if (VariantSchema.IntegralSize.BYTE.equals(integralSize)) {
                return ByteType$.MODULE$;
            }
            if (VariantSchema.IntegralSize.SHORT.equals(integralSize)) {
                return ShortType$.MODULE$;
            }
            if (VariantSchema.IntegralSize.INT.equals(integralSize)) {
                return IntegerType$.MODULE$;
            }
            if (VariantSchema.IntegralSize.LONG.equals(integralSize)) {
                return LongType$.MODULE$;
            }
            throw new MatchError((Object)integralSize);
        }
        if (scalarType instanceof VariantSchema.FloatType) {
            return FloatType$.MODULE$;
        }
        if (scalarType instanceof VariantSchema.DoubleType) {
            return DoubleType$.MODULE$;
        }
        if (scalarType instanceof VariantSchema.BooleanType) {
            return BooleanType$.MODULE$;
        }
        if (scalarType instanceof VariantSchema.BinaryType) {
            return BinaryType$.MODULE$;
        }
        if (scalarType instanceof VariantSchema.DecimalType) {
            VariantSchema.DecimalType decimalType = (VariantSchema.DecimalType)scalarType;
            return new DecimalType(decimalType.precision, decimalType.scale);
        }
        if (scalarType instanceof VariantSchema.DateType) {
            return DateType$.MODULE$;
        }
        if (scalarType instanceof VariantSchema.TimestampType) {
            return TimestampType$.MODULE$;
        }
        if (scalarType instanceof VariantSchema.TimestampNTZType) {
            return TimestampNTZType$.MODULE$;
        }
        throw new MatchError((Object)scalarType);
    }

    public DataType parquetTypeToSparkType(Type parquetType) {
        MessageType messageType = (MessageType)Types.buildMessage().addField(parquetType).named("foo");
        MessageColumnIO column = new ColumnIOFactory().getColumnIO(messageType);
        boolean x$1 = true;
        boolean x$2 = ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$1();
        boolean x$3 = ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$2();
        boolean x$4 = ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$3();
        boolean x$5 = ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$4();
        boolean x$6 = ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$6();
        ParquetToSparkSchemaConverter converter = new ParquetToSparkSchemaConverter(x$2, x$3, x$4, x$5, x$6, x$7, true);
        return converter.convertField(column.getChild(0), converter.convertField$default$2()).sparkType();
    }

    public InternalRow castShredded(Variant v, VariantSchema schema) {
        return ((SparkShreddingUtils.SparkShreddedResult)VariantShreddingWriter.castShredded((Variant)v, (VariantSchema)schema, (VariantShreddingWriter.ShreddedResultBuilder)new SparkShreddingUtils.SparkShreddedResultBuilder())).row();
    }

    public FieldToExtract[] getFieldsToExtract(DataType targetType, VariantSchema inputSchema) {
        StructType structType;
        DataType dataType = targetType;
        if (dataType instanceof VariantType) {
            return null;
        }
        if (dataType instanceof StructType && VariantMetadata$.MODULE$.isVariantStruct(structType = (StructType)dataType)) {
            return (FieldToExtract[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])structType.fields()), (Function1 & Serializable)f -> {
                VariantMetadata metadata = VariantMetadata$.MODULE$.fromMetadata(f.metadata());
                VariantPathSegment[] rawPath = metadata.parsedPath();
                SchemaPathSegment[] schemaPath = new SchemaPathSegment[rawPath.length];
                ObjectRef schema = ObjectRef.create((Object)inputSchema);
                ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.refArrayOps((Object[])rawPath)).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable)arg_0 -> SparkShreddingUtils$.$anonfun$getFieldsToExtract$2(rawPath, schema, schemaPath, arg_0)));
                ParquetVariantReader reader = ParquetVariantReader$.MODULE$.apply((VariantSchema)schema.elem, f.dataType(), new VariantCastArgs(metadata.failOnError(), (Option)new Some((Object)metadata.timeZoneId()), DateTimeUtils$.MODULE$.getZoneId(metadata.timeZoneId())), ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])schemaPath)) && inputSchema.isUnshredded());
                return new FieldToExtract(schemaPath, reader);
            }, ClassTag$.MODULE$.apply(FieldToExtract.class));
        }
        throw QueryExecutionErrors$.MODULE$.unreachableError("Invalid target type: `" + targetType.sql() + "`");
    }

    /*
     * Unable to fully structure code
     */
    private Object extractField(InternalRow inputRow, byte[] topLevelMetadata, VariantSchema inputSchema, SchemaPathSegment[] pathList, ParquetVariantReader reader) {
        pathLen = pathList.length;
        row = inputRow;
        schema = inputSchema;
        for (pathIdx = 0; pathIdx < pathLen; ++pathIdx) {
            block11: {
                path = pathList[pathIdx];
                if (path.typedIdx() >= 0) break block11;
                variantIdx = schema.variantIdx;
                if (variantIdx < 0 || row.isNullAt(variantIdx)) {
                    return null;
                }
                v = new Variant(row.getBinary(variantIdx), topLevelMetadata);
                while (pathIdx < pathLen) {
                    block13: {
                        block12: {
                            var14_15 = pathList[pathIdx].rawPath();
                            if (!(var14_15 instanceof ObjectExtraction)) break block12;
                            var15_16 = (ObjectExtraction)var14_15;
                            key = var15_16.key();
                            v0 = v.getType();
                            var17_18 = VariantUtil.Type.OBJECT;
                            if (v0 != null ? v0.equals(var17_18) == false : var17_18 != null) break block12;
                            v1 = v.getFieldByKey(key);
                            break block13;
                        }
                        if (!(var14_15 instanceof ArrayExtraction)) ** GOTO lbl-1000
                        var18_19 = (ArrayExtraction)var14_15;
                        index = var18_19.index();
                        v2 = v.getType();
                        var20_21 = VariantUtil.Type.ARRAY;
                        if (!(v2 != null ? v2.equals(var20_21) == false : var20_21 != null)) {
                            v1 = v.getElementAtIndex(index);
                        } else lbl-1000:
                        // 2 sources

                        {
                            v1 = v = null;
                        }
                    }
                    if (v == null) {
                        return null;
                    }
                    ++pathIdx;
                }
                return VariantGet$.MODULE$.cast(v, reader.targetType(), reader.castArgs());
            }
            if (row.isNullAt(path.typedIdx())) {
                return null;
            }
            if (path.isObject()) {
                obj = row.getStruct(path.typedIdx(), schema.objectSchema.length);
                if (obj.isNullAt(path.extractionIdx())) {
                    throw QueryExecutionErrors$.MODULE$.malformedVariant();
                }
                schema = schema.objectSchema[path.extractionIdx()].schema;
                row = obj.getStruct(path.extractionIdx(), schema.numFields);
                if (schema.typedIdx >= 0 && !row.isNullAt(schema.typedIdx) || schema.variantIdx >= 0 && !row.isNullAt(schema.variantIdx)) continue;
                return null;
            }
            arr = row.getArray(path.typedIdx());
            if (path.extractionIdx() >= arr.numElements()) {
                return null;
            }
            if (arr.isNullAt(path.extractionIdx())) {
                throw QueryExecutionErrors$.MODULE$.malformedVariant();
            }
            schema = schema.arraySchema;
            row = arr.getStruct(path.extractionIdx(), schema.numFields);
        }
        return reader.read(row, topLevelMetadata);
    }

    public VariantVal assembleVariant(InternalRow row, VariantSchema schema) {
        Variant v = ShreddingUtils.rebuild((ShreddingUtils.ShreddedRow)new SparkShreddedRow((SpecializedGetters)row), (VariantSchema)schema);
        return new VariantVal(v.getValue(), v.getMetadata());
    }

    public InternalRow assembleVariantStruct(InternalRow inputRow, VariantSchema schema, FieldToExtract[] fields) {
        if (inputRow.isNullAt(schema.topLevelMetadataIdx)) {
            throw QueryExecutionErrors$.MODULE$.malformedVariant();
        }
        byte[] topLevelMetadata = inputRow.getBinary(schema.topLevelMetadataIdx);
        int numFields = fields.length;
        GenericInternalRow resultRow = new GenericInternalRow(numFields);
        for (int fieldIdx = 0; fieldIdx < numFields; ++fieldIdx) {
            resultRow.update(fieldIdx, this.extractField(inputRow, topLevelMetadata, schema, fields[fieldIdx].path(), fields[fieldIdx].reader()));
        }
        return resultRow;
    }

    public void assembleVariantBatch(WritableColumnVector input, WritableColumnVector output, VariantSchema schema) {
        int numRows = input.getElementsAppended();
        output.reset();
        output.reserve(numRows);
        WritableColumnVector valueChild = output.getChild(0);
        WritableColumnVector metadataChild = output.getChild(1);
        for (int i = 0; i < numRows; ++i) {
            int n;
            if (input.isNullAt(i)) {
                n = output.appendStruct(true);
                continue;
            }
            output.appendStruct(false);
            VariantVal v = this.assembleVariant((InternalRow)input.getStruct(i), schema);
            valueChild.appendByteArray(v.getValue(), 0, v.getValue().length);
            n = metadataChild.appendByteArray(v.getMetadata(), 0, v.getMetadata().length);
        }
    }

    public void assembleVariantStructBatch(WritableColumnVector input, WritableColumnVector output, VariantSchema schema, FieldToExtract[] fields) {
        int numRows = input.getElementsAppended();
        output.reset();
        output.reserve(numRows);
        RowToColumnConverter converter = new RowToColumnConverter(new StructType((StructField[])((Object[])new StructField[]{new StructField("", output.dataType(), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
        WritableColumnVector[] converterVectors = (WritableColumnVector[])((Object[])new WritableColumnVector[]{output});
        GenericInternalRow converterRow = new GenericInternalRow(1);
        for (int i = 0; i < numRows; ++i) {
            if (input.isNullAt(i)) {
                converterRow.update(0, null);
            } else {
                converterRow.update(0, (Object)this.assembleVariantStruct((InternalRow)input.getStruct(i), schema, fields));
            }
            converter.convert((InternalRow)converterRow, converterVectors);
        }
    }

    public String productPrefix() {
        return "SparkShreddingUtils";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SparkShreddingUtils$;
    }

    public int hashCode() {
        return -303246380;
    }

    public String toString() {
        return "SparkShreddingUtils";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SparkShreddingUtils$.class);
    }

    public static final /* synthetic */ boolean $anonfun$isVariantShreddingStruct$1(StructField x$2) {
        return x$2.metadata().contains(MODULE$.VARIANT_WRITE_SHREDDING_KEY());
    }

    public static final /* synthetic */ void $anonfun$buildVariantSchema$3(ObjectRef objectSchema$1, StructType schema$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            StructField field = (StructField)tuple2._1();
            int fieldIdx = tuple2._2$mcI$sp();
            DataType dataType = field.dataType();
            if (!(dataType instanceof StructType)) {
                throw QueryCompilationErrors$.MODULE$.invalidVariantShreddingSchema((DataType)schema$1);
            }
            StructType structType = (StructType)dataType;
            VariantSchema fieldSchema = MODULE$.buildVariantSchema(structType, false);
            ((VariantSchema.ObjectField[])objectSchema$1.elem)[fieldIdx] = new VariantSchema.ObjectField(field.name(), fieldSchema);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$buildVariantSchema$1(IntRef typedIdx$1, StructType schema$1, ObjectRef objectSchema$1, ObjectRef arraySchema$1, ObjectRef scalarSchema$1, IntRef variantIdx$1, IntRef topLevelMetadataIdx$1, Tuple2 x0$1) {
        Tuple2 tuple2;
        block39: {
            block41: {
                block45: {
                    int i;
                    block47: {
                        block46: {
                            String string;
                            StructField f;
                            block42: {
                                block44: {
                                    block43: {
                                        block40: {
                                            tuple2 = x0$1;
                                            if (tuple2 == null) break block39;
                                            f = (StructField)tuple2._1();
                                            i = tuple2._2$mcI$sp();
                                            string = f.name();
                                            String string2 = MODULE$.TypedValueFieldName();
                                            String string3 = string;
                                            if (string2 != null ? !string2.equals(string3) : string3 != null) break block40;
                                            if (typedIdx$1.elem != -1) {
                                                throw QueryCompilationErrors$.MODULE$.invalidVariantShreddingSchema((DataType)schema$1);
                                            }
                                            typedIdx$1.elem = i;
                                            DataType dataType = f.dataType();
                                            if (dataType instanceof StructType) {
                                                StructType structType = (StructType)dataType;
                                                StructField[] fields = structType.fields();
                                                if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])fields)) || ((String[])ArrayOps$.MODULE$.distinct$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Function1 & Serializable)x$3 -> x$3.name(), ClassTag$.MODULE$.apply(String.class))))).length != fields.length) {
                                                    throw QueryCompilationErrors$.MODULE$.invalidVariantShreddingSchema((DataType)schema$1);
                                                }
                                                objectSchema$1.elem = new VariantSchema.ObjectField[fields.length];
                                                ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])fields))), (Function1 & Serializable)x0$2 -> {
                                                    SparkShreddingUtils$.$anonfun$buildVariantSchema$3(objectSchema$1, schema$1, x0$2);
                                                    return BoxedUnit.UNIT;
                                                });
                                            } else if (dataType instanceof ArrayType) {
                                                ArrayType arrayType = (ArrayType)dataType;
                                                DataType elementType = arrayType.elementType();
                                                DataType dataType2 = elementType;
                                                if (!(dataType2 instanceof StructType)) {
                                                    throw QueryCompilationErrors$.MODULE$.invalidVariantShreddingSchema((DataType)schema$1);
                                                }
                                                StructType structType = (StructType)dataType2;
                                                arraySchema$1.elem = MODULE$.buildVariantSchema(structType, false);
                                            } else {
                                                VariantSchema.BooleanType booleanType;
                                                DataType dataType3 = dataType;
                                                if (BooleanType$.MODULE$.equals(dataType3)) {
                                                    booleanType = new VariantSchema.BooleanType();
                                                } else if (ByteType$.MODULE$.equals(dataType3)) {
                                                    booleanType = new VariantSchema.IntegralType(VariantSchema.IntegralSize.BYTE);
                                                } else if (ShortType$.MODULE$.equals(dataType3)) {
                                                    booleanType = new VariantSchema.IntegralType(VariantSchema.IntegralSize.SHORT);
                                                } else if (IntegerType$.MODULE$.equals(dataType3)) {
                                                    booleanType = new VariantSchema.IntegralType(VariantSchema.IntegralSize.INT);
                                                } else if (LongType$.MODULE$.equals(dataType3)) {
                                                    booleanType = new VariantSchema.IntegralType(VariantSchema.IntegralSize.LONG);
                                                } else if (FloatType$.MODULE$.equals(dataType3)) {
                                                    booleanType = new VariantSchema.FloatType();
                                                } else if (DoubleType$.MODULE$.equals(dataType3)) {
                                                    booleanType = new VariantSchema.DoubleType();
                                                } else if (StringType$.MODULE$.equals(dataType3)) {
                                                    booleanType = new VariantSchema.StringType();
                                                } else if (BinaryType$.MODULE$.equals(dataType3)) {
                                                    booleanType = new VariantSchema.BinaryType();
                                                } else if (DateType$.MODULE$.equals(dataType3)) {
                                                    booleanType = new VariantSchema.DateType();
                                                } else if (TimestampType$.MODULE$.equals(dataType3)) {
                                                    booleanType = new VariantSchema.TimestampType();
                                                } else if (TimestampNTZType$.MODULE$.equals(dataType3)) {
                                                    booleanType = new VariantSchema.TimestampNTZType();
                                                } else if (dataType3 instanceof DecimalType) {
                                                    DecimalType decimalType = (DecimalType)dataType3;
                                                    booleanType = new VariantSchema.DecimalType(decimalType.precision(), decimalType.scale());
                                                } else {
                                                    throw QueryCompilationErrors$.MODULE$.invalidVariantShreddingSchema((DataType)schema$1);
                                                }
                                                scalarSchema$1.elem = booleanType;
                                            }
                                            break block41;
                                        }
                                        String string4 = MODULE$.VariantValueFieldName();
                                        String string5 = string;
                                        if (string4 != null ? !string4.equals(string5) : string5 != null) break block42;
                                        if (variantIdx$1.elem != -1) break block43;
                                        DataType dataType = f.dataType();
                                        BinaryType$ binaryType$ = BinaryType$.MODULE$;
                                        if (!(dataType == null ? binaryType$ != null : !dataType.equals(binaryType$))) break block44;
                                    }
                                    throw QueryCompilationErrors$.MODULE$.invalidVariantShreddingSchema((DataType)schema$1);
                                }
                                variantIdx$1.elem = i;
                                break block41;
                            }
                            String string6 = MODULE$.MetadataFieldName();
                            String string7 = string;
                            if (string6 != null ? !string6.equals(string7) : string7 != null) break block45;
                            if (topLevelMetadataIdx$1.elem != -1) break block46;
                            DataType dataType = f.dataType();
                            BinaryType$ binaryType$ = BinaryType$.MODULE$;
                            if (!(dataType == null ? binaryType$ != null : !dataType.equals(binaryType$))) break block47;
                        }
                        throw QueryCompilationErrors$.MODULE$.invalidVariantShreddingSchema((DataType)schema$1);
                    }
                    topLevelMetadataIdx$1.elem = i;
                    break block41;
                }
                throw QueryCompilationErrors$.MODULE$.invalidVariantShreddingSchema((DataType)schema$1);
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$getFieldsToExtract$2(VariantPathSegment[] rawPath$1, ObjectRef schema$2, SchemaPathSegment[] schemaPath$1, int i) {
        block5: {
            block4: {
                isObject = rawPath$1[i] instanceof ObjectExtraction;
                typedIdx = -1;
                extractionIdx = -1;
                var8_7 = rawPath$1[i];
                if (!(var8_7 instanceof ObjectExtraction)) break block4;
                var9_8 = (ObjectExtraction)var8_7;
                key = var9_8.key();
                if ((VariantSchema)schema$2.elem == null || ((VariantSchema)schema$2.elem).objectSchema == null) break block4;
                fieldIdx = (Integer)((VariantSchema)schema$2.elem).objectSchemaMap.get(key);
                if (fieldIdx != null) {
                    typedIdx = ((VariantSchema)schema$2.elem).typedIdx;
                    extractionIdx = Predef$.MODULE$.Integer2int(fieldIdx);
                    schema$2.elem = ((VariantSchema)schema$2.elem).objectSchema[Predef$.MODULE$.Integer2int((Integer)fieldIdx)].schema;
                } else {
                    schema$2.elem = null;
                }
                break block5;
            }
            if (!(var8_7 instanceof ArrayExtraction)) ** GOTO lbl-1000
            var12_11 = (ArrayExtraction)var8_7;
            index = var12_11.index();
            if ((VariantSchema)schema$2.elem != null && ((VariantSchema)schema$2.elem).arraySchema != null) {
                typedIdx = ((VariantSchema)schema$2.elem).typedIdx;
                extractionIdx = index;
                schema$2.elem = ((VariantSchema)schema$2.elem).arraySchema;
            } else lbl-1000:
            // 2 sources

            {
                schema$2.elem = null;
            }
        }
        schemaPath$1[i] = new SchemaPathSegment(rawPath$1[i], isObject, typedIdx, extractionIdx);
    }

    private SparkShreddingUtils$() {
    }
}

