/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Logger;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JplLogger
implements Logger {
    private static final System.Logger logger = System.getLogger(JSch.class.getName());

    @Override
    public boolean isEnabled(int level) {
        return logger.isLoggable(JplLogger.getLevel(level));
    }

    @Override
    public void log(int level, String message) {
        logger.log(JplLogger.getLevel(level), message);
    }

    @Override
    public void log(int level, String message, Throwable cause) {
        if (cause == null) {
            logger.log(JplLogger.getLevel(level), message);
            return;
        }
        logger.log(JplLogger.getLevel(level), message, cause);
    }

    private static System.Logger.Level getLevel(int level) {
        switch (level) {
            case 0: {
                return System.Logger.Level.DEBUG;
            }
            case 1: {
                return System.Logger.Level.INFO;
            }
            case 2: {
                return System.Logger.Level.WARNING;
            }
            case 3: 
            case 4: {
                return System.Logger.Level.ERROR;
            }
        }
        return System.Logger.Level.TRACE;
    }
}

